package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddBaaSAntChainBizChain invokes the lto.AddBaaSAntChainBizChain API synchronously
func (client *Client) AddBaaSAntChainBizChain(request *AddBaaSAntChainBizChainRequest) (response *AddBaaSAntChainBizChainResponse, err error) {
	response = CreateAddBaaSAntChainBizChainResponse()
	err = client.DoAction(request, response)
	return
}

// AddBaaSAntChainBizChainWithChan invokes the lto.AddBaaSAntChainBizChain API asynchronously
func (client *Client) AddBaaSAntChainBizChainWithChan(request *AddBaaSAntChainBizChainRequest) (<-chan *AddBaaSAntChainBizChainResponse, <-chan error) {
	responseChan := make(chan *AddBaaSAntChainBizChainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddBaaSAntChainBizChain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddBaaSAntChainBizChainWithCallback invokes the lto.AddBaaSAntChainBizChain API asynchronously
func (client *Client) AddBaaSAntChainBizChainWithCallback(request *AddBaaSAntChainBizChainRequest, callback func(response *AddBaaSAntChainBizChainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddBaaSAntChainBizChainResponse
		var err error
		defer close(result)
		response, err = client.AddBaaSAntChainBizChain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddBaaSAntChainBizChainRequest is the request struct for api AddBaaSAntChainBizChain
type AddBaaSAntChainBizChainRequest struct {
	*requests.RpcRequest
	CaCertPassword           string `position:"Query" name:"CaCertPassword"`
	NodeNameList             string `position:"Query" name:"NodeNameList"`
	Remark                   string `position:"Query" name:"Remark"`
	UserKey                  string `position:"Query" name:"UserKey"`
	ClientCert               string `position:"Query" name:"ClientCert"`
	BaaSAntChainConsortiumId string `position:"Query" name:"BaaSAntChainConsortiumId"`
	UserKeyPassword          string `position:"Query" name:"UserKeyPassword"`
	BaaSAntChainChainId      string `position:"Query" name:"BaaSAntChainChainId"`
	ClientKey                string `position:"Query" name:"ClientKey"`
	CaCert                   string `position:"Query" name:"CaCert"`
	Name                     string `position:"Query" name:"Name"`
	ClientKeyPassword        string `position:"Query" name:"ClientKeyPassword"`
	ContractTemplateIdList   string `position:"Query" name:"ContractTemplateIdList"`
	UserName                 string `position:"Query" name:"UserName"`
}

// AddBaaSAntChainBizChainResponse is the response struct for api AddBaaSAntChainBizChain
type AddBaaSAntChainBizChainResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateAddBaaSAntChainBizChainRequest creates a request to invoke AddBaaSAntChainBizChain API
func CreateAddBaaSAntChainBizChainRequest() (request *AddBaaSAntChainBizChainRequest) {
	request = &AddBaaSAntChainBizChainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "AddBaaSAntChainBizChain", "", "")
	request.Method = requests.POST
	return
}

// CreateAddBaaSAntChainBizChainResponse creates a response to parse from AddBaaSAntChainBizChain response
func CreateAddBaaSAntChainBizChainResponse() (response *AddBaaSAntChainBizChainResponse) {
	response = &AddBaaSAntChainBizChainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
