package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableDevice invokes the lto.EnableDevice API synchronously
func (client *Client) EnableDevice(request *EnableDeviceRequest) (response *EnableDeviceResponse, err error) {
	response = CreateEnableDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// EnableDeviceWithChan invokes the lto.EnableDevice API asynchronously
func (client *Client) EnableDeviceWithChan(request *EnableDeviceRequest) (<-chan *EnableDeviceResponse, <-chan error) {
	responseChan := make(chan *EnableDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableDeviceWithCallback invokes the lto.EnableDevice API asynchronously
func (client *Client) EnableDeviceWithCallback(request *EnableDeviceRequest, callback func(response *EnableDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableDeviceResponse
		var err error
		defer close(result)
		response, err = client.EnableDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableDeviceRequest is the request struct for api EnableDevice
type EnableDeviceRequest struct {
	*requests.RpcRequest
	DeviceId string `position:"Query" name:"DeviceId"`
}

// EnableDeviceResponse is the response struct for api EnableDevice
type EnableDeviceResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateEnableDeviceRequest creates a request to invoke EnableDevice API
func CreateEnableDeviceRequest() (request *EnableDeviceRequest) {
	request = &EnableDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "EnableDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateEnableDeviceResponse creates a response to parse from EnableDevice response
func CreateEnableDeviceResponse() (response *EnableDeviceResponse) {
	response = &EnableDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
