package market

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AutoRenewInstance invokes the market.AutoRenewInstance API synchronously
func (client *Client) AutoRenewInstance(request *AutoRenewInstanceRequest) (response *AutoRenewInstanceResponse, err error) {
	response = CreateAutoRenewInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// AutoRenewInstanceWithChan invokes the market.AutoRenewInstance API asynchronously
func (client *Client) AutoRenewInstanceWithChan(request *AutoRenewInstanceRequest) (<-chan *AutoRenewInstanceResponse, <-chan error) {
	responseChan := make(chan *AutoRenewInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AutoRenewInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AutoRenewInstanceWithCallback invokes the market.AutoRenewInstance API asynchronously
func (client *Client) AutoRenewInstanceWithCallback(request *AutoRenewInstanceRequest, callback func(response *AutoRenewInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AutoRenewInstanceResponse
		var err error
		defer close(result)
		response, err = client.AutoRenewInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AutoRenewInstanceRequest is the request struct for api AutoRenewInstance
type AutoRenewInstanceRequest struct {
	*requests.RpcRequest
	Type              string           `position:"Body" name:"Type"`
	OwnerId           requests.Integer `position:"Body" name:"OwnerId"`
	AutoRenewDuration requests.Integer `position:"Body" name:"AutoRenewDuration"`
	AutoRenewCycle    string           `position:"Body" name:"AutoRenewCycle"`
	OrderBizId        requests.Integer `position:"Body" name:"OrderBizId"`
}

// AutoRenewInstanceResponse is the response struct for api AutoRenewInstance
type AutoRenewInstanceResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      bool   `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAutoRenewInstanceRequest creates a request to invoke AutoRenewInstance API
func CreateAutoRenewInstanceRequest() (request *AutoRenewInstanceRequest) {
	request = &AutoRenewInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Market", "2015-11-01", "AutoRenewInstance", "yunmarket", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAutoRenewInstanceResponse creates a response to parse from AutoRenewInstance response
func CreateAutoRenewInstanceResponse() (response *AutoRenewInstanceResponse) {
	response = &AutoRenewInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
