package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMcubeNebulaResource invokes the mpaas.CreateMcubeNebulaResource API synchronously
func (client *Client) CreateMcubeNebulaResource(request *CreateMcubeNebulaResourceRequest) (response *CreateMcubeNebulaResourceResponse, err error) {
	response = CreateCreateMcubeNebulaResourceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMcubeNebulaResourceWithChan invokes the mpaas.CreateMcubeNebulaResource API asynchronously
func (client *Client) CreateMcubeNebulaResourceWithChan(request *CreateMcubeNebulaResourceRequest) (<-chan *CreateMcubeNebulaResourceResponse, <-chan error) {
	responseChan := make(chan *CreateMcubeNebulaResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMcubeNebulaResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMcubeNebulaResourceWithCallback invokes the mpaas.CreateMcubeNebulaResource API asynchronously
func (client *Client) CreateMcubeNebulaResourceWithCallback(request *CreateMcubeNebulaResourceRequest, callback func(response *CreateMcubeNebulaResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMcubeNebulaResourceResponse
		var err error
		defer close(result)
		response, err = client.CreateMcubeNebulaResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMcubeNebulaResourceRequest is the request struct for api CreateMcubeNebulaResource
type CreateMcubeNebulaResourceRequest struct {
	*requests.RpcRequest
	AutoInstall      requests.Integer `position:"Body" name:"AutoInstall"`
	InstallType      requests.Integer `position:"Body" name:"InstallType"`
	OnexFlag         requests.Boolean `position:"Body" name:"OnexFlag"`
	H5Version        string           `position:"Body" name:"H5Version"`
	H5Name           string           `position:"Body" name:"H5Name"`
	Platform         string           `position:"Body" name:"Platform"`
	RepeatNebula     requests.Integer `position:"Body" name:"RepeatNebula"`
	H5Id             string           `position:"Body" name:"H5Id"`
	TenantId         string           `position:"Body" name:"TenantId"`
	ExtendInfo       string           `position:"Body" name:"ExtendInfo"`
	MainUrl          string           `position:"Body" name:"MainUrl"`
	ClientVersionMin string           `position:"Body" name:"ClientVersionMin"`
	ResourceType     requests.Integer `position:"Body" name:"ResourceType"`
	Vhost            string           `position:"Body" name:"Vhost"`
	SubUrl           string           `position:"Body" name:"SubUrl"`
	ClientVersionMax string           `position:"Body" name:"ClientVersionMax"`
	AppId            string           `position:"Body" name:"AppId"`
	FileUrl          string           `position:"Body" name:"FileUrl"`
	CustomDomainName string           `position:"Body" name:"CustomDomainName"`
	WorkspaceId      string           `position:"Body" name:"WorkspaceId"`
}

// CreateMcubeNebulaResourceResponse is the response struct for api CreateMcubeNebulaResource
type CreateMcubeNebulaResourceResponse struct {
	*responses.BaseResponse
	ResultMessage                    string                           `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode                       string                           `json:"ResultCode" xml:"ResultCode"`
	RequestId                        string                           `json:"RequestId" xml:"RequestId"`
	CreateMcubeNebulaResourceReslult CreateMcubeNebulaResourceReslult `json:"CreateMcubeNebulaResourceReslult" xml:"CreateMcubeNebulaResourceReslult"`
}

// CreateCreateMcubeNebulaResourceRequest creates a request to invoke CreateMcubeNebulaResource API
func CreateCreateMcubeNebulaResourceRequest() (request *CreateMcubeNebulaResourceRequest) {
	request = &CreateMcubeNebulaResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CreateMcubeNebulaResource", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMcubeNebulaResourceResponse creates a response to parse from CreateMcubeNebulaResource response
func CreateCreateMcubeNebulaResourceResponse() (response *CreateMcubeNebulaResourceResponse) {
	response = &CreateMcubeNebulaResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
