package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddSecurityGroupRule invokes the mse.AddSecurityGroupRule API synchronously
func (client *Client) AddSecurityGroupRule(request *AddSecurityGroupRuleRequest) (response *AddSecurityGroupRuleResponse, err error) {
	response = CreateAddSecurityGroupRuleResponse()
	err = client.DoAction(request, response)
	return
}

// AddSecurityGroupRuleWithChan invokes the mse.AddSecurityGroupRule API asynchronously
func (client *Client) AddSecurityGroupRuleWithChan(request *AddSecurityGroupRuleRequest) (<-chan *AddSecurityGroupRuleResponse, <-chan error) {
	responseChan := make(chan *AddSecurityGroupRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddSecurityGroupRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddSecurityGroupRuleWithCallback invokes the mse.AddSecurityGroupRule API asynchronously
func (client *Client) AddSecurityGroupRuleWithCallback(request *AddSecurityGroupRuleRequest, callback func(response *AddSecurityGroupRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddSecurityGroupRuleResponse
		var err error
		defer close(result)
		response, err = client.AddSecurityGroupRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddSecurityGroupRuleRequest is the request struct for api AddSecurityGroupRule
type AddSecurityGroupRuleRequest struct {
	*requests.RpcRequest
	MseSessionId    string `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string `position:"Query" name:"GatewayUniqueId"`
	SecurityGroupId string `position:"Query" name:"SecurityGroupId"`
	Description     string `position:"Query" name:"Description"`
	PortRange       string `position:"Query" name:"PortRange"`
	AcceptLanguage  string `position:"Query" name:"AcceptLanguage"`
}

// AddSecurityGroupRuleResponse is the response struct for api AddSecurityGroupRule
type AddSecurityGroupRuleResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           string `json:"Data" xml:"Data"`
}

// CreateAddSecurityGroupRuleRequest creates a request to invoke AddSecurityGroupRule API
func CreateAddSecurityGroupRuleRequest() (request *AddSecurityGroupRuleRequest) {
	request = &AddSecurityGroupRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "AddSecurityGroupRule", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddSecurityGroupRuleResponse creates a response to parse from AddSecurityGroupRule response
func CreateAddSecurityGroupRuleResponse() (response *AddSecurityGroupRuleResponse) {
	response = &AddSecurityGroupRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
