package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveAuthPolicy invokes the mse.RemoveAuthPolicy API synchronously
func (client *Client) RemoveAuthPolicy(request *RemoveAuthPolicyRequest) (response *RemoveAuthPolicyResponse, err error) {
	response = CreateRemoveAuthPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveAuthPolicyWithChan invokes the mse.RemoveAuthPolicy API asynchronously
func (client *Client) RemoveAuthPolicyWithChan(request *RemoveAuthPolicyRequest) (<-chan *RemoveAuthPolicyResponse, <-chan error) {
	responseChan := make(chan *RemoveAuthPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveAuthPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveAuthPolicyWithCallback invokes the mse.RemoveAuthPolicy API asynchronously
func (client *Client) RemoveAuthPolicyWithCallback(request *RemoveAuthPolicyRequest, callback func(response *RemoveAuthPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveAuthPolicyResponse
		var err error
		defer close(result)
		response, err = client.RemoveAuthPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveAuthPolicyRequest is the request struct for api RemoveAuthPolicy
type RemoveAuthPolicyRequest struct {
	*requests.RpcRequest
	MseSessionId   string `position:"Query" name:"MseSessionId"`
	PolicyId       string `position:"Query" name:"PolicyId"`
	AcceptLanguage string `position:"Query" name:"AcceptLanguage"`
}

// RemoveAuthPolicyResponse is the response struct for api RemoveAuthPolicy
type RemoveAuthPolicyResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Message        string `json:"Message" xml:"Message"`
	Data           string `json:"Data" xml:"Data"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateRemoveAuthPolicyRequest creates a request to invoke RemoveAuthPolicy API
func CreateRemoveAuthPolicyRequest() (request *RemoveAuthPolicyRequest) {
	request = &RemoveAuthPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "RemoveAuthPolicy", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveAuthPolicyResponse creates a response to parse from RemoveAuthPolicy response
func CreateRemoveAuthPolicyResponse() (response *RemoveAuthPolicyResponse) {
	response = &RemoveAuthPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
