package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateGatewayServiceCheck invokes the mse.UpdateGatewayServiceCheck API synchronously
func (client *Client) UpdateGatewayServiceCheck(request *UpdateGatewayServiceCheckRequest) (response *UpdateGatewayServiceCheckResponse, err error) {
	response = CreateUpdateGatewayServiceCheckResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateGatewayServiceCheckWithChan invokes the mse.UpdateGatewayServiceCheck API asynchronously
func (client *Client) UpdateGatewayServiceCheckWithChan(request *UpdateGatewayServiceCheckRequest) (<-chan *UpdateGatewayServiceCheckResponse, <-chan error) {
	responseChan := make(chan *UpdateGatewayServiceCheckResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateGatewayServiceCheck(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateGatewayServiceCheckWithCallback invokes the mse.UpdateGatewayServiceCheck API asynchronously
func (client *Client) UpdateGatewayServiceCheckWithCallback(request *UpdateGatewayServiceCheckRequest, callback func(response *UpdateGatewayServiceCheckResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateGatewayServiceCheckResponse
		var err error
		defer close(result)
		response, err = client.UpdateGatewayServiceCheck(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateGatewayServiceCheckRequest is the request struct for api UpdateGatewayServiceCheck
type UpdateGatewayServiceCheckRequest struct {
	*requests.RpcRequest
	MseSessionId       string           `position:"Query" name:"MseSessionId"`
	Protocol           string           `position:"Query" name:"Protocol"`
	ExpectedStatuses   *[]string        `position:"Query" name:"ExpectedStatuses"  type:"Json"`
	HttpHost           string           `position:"Query" name:"HttpHost"`
	Check              requests.Boolean `position:"Query" name:"Check"`
	HttpPath           string           `position:"Query" name:"HttpPath"`
	Interval           requests.Integer `position:"Query" name:"Interval"`
	GatewayUniqueId    string           `position:"Query" name:"GatewayUniqueId"`
	UnhealthyThreshold requests.Integer `position:"Query" name:"UnhealthyThreshold"`
	HealthyThreshold   requests.Integer `position:"Query" name:"HealthyThreshold"`
	Timeout            requests.Integer `position:"Query" name:"Timeout"`
	AcceptLanguage     string           `position:"Query" name:"AcceptLanguage"`
	ServiceId          string           `position:"Query" name:"ServiceId"`
}

// UpdateGatewayServiceCheckResponse is the response struct for api UpdateGatewayServiceCheck
type UpdateGatewayServiceCheckResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           int64  `json:"Data" xml:"Data"`
}

// CreateUpdateGatewayServiceCheckRequest creates a request to invoke UpdateGatewayServiceCheck API
func CreateUpdateGatewayServiceCheckRequest() (request *UpdateGatewayServiceCheckRequest) {
	request = &UpdateGatewayServiceCheckRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "UpdateGatewayServiceCheck", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateGatewayServiceCheckResponse creates a response to parse from UpdateGatewayServiceCheck response
func CreateUpdateGatewayServiceCheckResponse() (response *UpdateGatewayServiceCheckResponse) {
	response = &UpdateGatewayServiceCheckResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
