package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteProtocolService invokes the nas.DeleteProtocolService API synchronously
func (client *Client) DeleteProtocolService(request *DeleteProtocolServiceRequest) (response *DeleteProtocolServiceResponse, err error) {
	response = CreateDeleteProtocolServiceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteProtocolServiceWithChan invokes the nas.DeleteProtocolService API asynchronously
func (client *Client) DeleteProtocolServiceWithChan(request *DeleteProtocolServiceRequest) (<-chan *DeleteProtocolServiceResponse, <-chan error) {
	responseChan := make(chan *DeleteProtocolServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteProtocolService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteProtocolServiceWithCallback invokes the nas.DeleteProtocolService API asynchronously
func (client *Client) DeleteProtocolServiceWithCallback(request *DeleteProtocolServiceRequest, callback func(response *DeleteProtocolServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteProtocolServiceResponse
		var err error
		defer close(result)
		response, err = client.DeleteProtocolService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteProtocolServiceRequest is the request struct for api DeleteProtocolService
type DeleteProtocolServiceRequest struct {
	*requests.RpcRequest
	ProtocolServiceId string           `position:"Query" name:"ProtocolServiceId"`
	ClientToken       string           `position:"Query" name:"ClientToken"`
	FileSystemId      string           `position:"Query" name:"FileSystemId"`
	DryRun            requests.Boolean `position:"Query" name:"DryRun"`
}

// DeleteProtocolServiceResponse is the response struct for api DeleteProtocolService
type DeleteProtocolServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteProtocolServiceRequest creates a request to invoke DeleteProtocolService API
func CreateDeleteProtocolServiceRequest() (request *DeleteProtocolServiceRequest) {
	request = &DeleteProtocolServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "DeleteProtocolService", "nas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteProtocolServiceResponse creates a response to parse from DeleteProtocolService response
func CreateDeleteProtocolServiceResponse() (response *DeleteProtocolServiceResponse) {
	response = &DeleteProtocolServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
