package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceTags invokes the oceanbasepro.DescribeInstanceTags API synchronously
func (client *Client) DescribeInstanceTags(request *DescribeInstanceTagsRequest) (response *DescribeInstanceTagsResponse, err error) {
	response = CreateDescribeInstanceTagsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceTagsWithChan invokes the oceanbasepro.DescribeInstanceTags API asynchronously
func (client *Client) DescribeInstanceTagsWithChan(request *DescribeInstanceTagsRequest) (<-chan *DescribeInstanceTagsResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceTagsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceTags(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceTagsWithCallback invokes the oceanbasepro.DescribeInstanceTags API asynchronously
func (client *Client) DescribeInstanceTagsWithCallback(request *DescribeInstanceTagsRequest, callback func(response *DescribeInstanceTagsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceTagsResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceTags(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceTagsRequest is the request struct for api DescribeInstanceTags
type DescribeInstanceTagsRequest struct {
	*requests.RpcRequest
	Tags        string `position:"Body" name:"Tags"`
	InstanceIds string `position:"Body" name:"InstanceIds"`
}

// DescribeInstanceTagsResponse is the response struct for api DescribeInstanceTags
type DescribeInstanceTagsResponse struct {
	*responses.BaseResponse
	RequestId    string             `json:"RequestId" xml:"RequestId"`
	TagResources []TagResourcesItem `json:"TagResources" xml:"TagResources"`
}

// CreateDescribeInstanceTagsRequest creates a request to invoke DescribeInstanceTags API
func CreateDescribeInstanceTagsRequest() (request *DescribeInstanceTagsRequest) {
	request = &DescribeInstanceTagsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeInstanceTags", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceTagsResponse creates a response to parse from DescribeInstanceTags response
func CreateDescribeInstanceTagsResponse() (response *DescribeInstanceTagsResponse) {
	response = &DescribeInstanceTagsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
