package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTenantUserStatus invokes the oceanbasepro.ModifyTenantUserStatus API synchronously
func (client *Client) ModifyTenantUserStatus(request *ModifyTenantUserStatusRequest) (response *ModifyTenantUserStatusResponse, err error) {
	response = CreateModifyTenantUserStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTenantUserStatusWithChan invokes the oceanbasepro.ModifyTenantUserStatus API asynchronously
func (client *Client) ModifyTenantUserStatusWithChan(request *ModifyTenantUserStatusRequest) (<-chan *ModifyTenantUserStatusResponse, <-chan error) {
	responseChan := make(chan *ModifyTenantUserStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTenantUserStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTenantUserStatusWithCallback invokes the oceanbasepro.ModifyTenantUserStatus API asynchronously
func (client *Client) ModifyTenantUserStatusWithCallback(request *ModifyTenantUserStatusRequest, callback func(response *ModifyTenantUserStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTenantUserStatusResponse
		var err error
		defer close(result)
		response, err = client.ModifyTenantUserStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTenantUserStatusRequest is the request struct for api ModifyTenantUserStatus
type ModifyTenantUserStatusRequest struct {
	*requests.RpcRequest
	UserStatus string `position:"Body" name:"UserStatus"`
	InstanceId string `position:"Body" name:"InstanceId"`
	TenantId   string `position:"Body" name:"TenantId"`
	UserName   string `position:"Body" name:"UserName"`
}

// ModifyTenantUserStatusResponse is the response struct for api ModifyTenantUserStatus
type ModifyTenantUserStatusResponse struct {
	*responses.BaseResponse
	RequestId  string           `json:"RequestId" xml:"RequestId"`
	TenantUser []TenantUserItem `json:"TenantUser" xml:"TenantUser"`
}

// CreateModifyTenantUserStatusRequest creates a request to invoke ModifyTenantUserStatus API
func CreateModifyTenantUserStatusRequest() (request *ModifyTenantUserStatusRequest) {
	request = &ModifyTenantUserStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "ModifyTenantUserStatus", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyTenantUserStatusResponse creates a response to parse from ModifyTenantUserStatus response
func CreateModifyTenantUserStatusResponse() (response *ModifyTenantUserStatusResponse) {
	response = &ModifyTenantUserStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
