package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetApplicationGroup invokes the oos.GetApplicationGroup API synchronously
func (client *Client) GetApplicationGroup(request *GetApplicationGroupRequest) (response *GetApplicationGroupResponse, err error) {
	response = CreateGetApplicationGroupResponse()
	err = client.DoAction(request, response)
	return
}

// GetApplicationGroupWithChan invokes the oos.GetApplicationGroup API asynchronously
func (client *Client) GetApplicationGroupWithChan(request *GetApplicationGroupRequest) (<-chan *GetApplicationGroupResponse, <-chan error) {
	responseChan := make(chan *GetApplicationGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetApplicationGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetApplicationGroupWithCallback invokes the oos.GetApplicationGroup API asynchronously
func (client *Client) GetApplicationGroupWithCallback(request *GetApplicationGroupRequest, callback func(response *GetApplicationGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetApplicationGroupResponse
		var err error
		defer close(result)
		response, err = client.GetApplicationGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetApplicationGroupRequest is the request struct for api GetApplicationGroup
type GetApplicationGroupRequest struct {
	*requests.RpcRequest
	ApplicationName string `position:"Query" name:"ApplicationName"`
	Name            string `position:"Query" name:"Name"`
}

// GetApplicationGroupResponse is the response struct for api GetApplicationGroup
type GetApplicationGroupResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	ApplicationGroup ApplicationGroup `json:"ApplicationGroup" xml:"ApplicationGroup"`
}

// CreateGetApplicationGroupRequest creates a request to invoke GetApplicationGroup API
func CreateGetApplicationGroupRequest() (request *GetApplicationGroupRequest) {
	request = &GetApplicationGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "GetApplicationGroup", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetApplicationGroupResponse creates a response to parse from GetApplicationGroup response
func CreateGetApplicationGroupResponse() (response *GetApplicationGroupResponse) {
	response = &GetApplicationGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
