package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFunctionInstance invokes the opensearch.CreateFunctionInstance API synchronously
func (client *Client) CreateFunctionInstance(request *CreateFunctionInstanceRequest) (response *CreateFunctionInstanceResponse, err error) {
	response = CreateCreateFunctionInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFunctionInstanceWithChan invokes the opensearch.CreateFunctionInstance API asynchronously
func (client *Client) CreateFunctionInstanceWithChan(request *CreateFunctionInstanceRequest) (<-chan *CreateFunctionInstanceResponse, <-chan error) {
	responseChan := make(chan *CreateFunctionInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFunctionInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFunctionInstanceWithCallback invokes the opensearch.CreateFunctionInstance API asynchronously
func (client *Client) CreateFunctionInstanceWithCallback(request *CreateFunctionInstanceRequest, callback func(response *CreateFunctionInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFunctionInstanceResponse
		var err error
		defer close(result)
		response, err = client.CreateFunctionInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFunctionInstanceRequest is the request struct for api CreateFunctionInstance
type CreateFunctionInstanceRequest struct {
	*requests.RoaRequest
	FunctionName     string `position:"Path" name:"functionName"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// CreateFunctionInstanceResponse is the response struct for api CreateFunctionInstance
type CreateFunctionInstanceResponse struct {
	*responses.BaseResponse
	Status    string `json:"Status" xml:"Status"`
	HttpCode  int64  `json:"HttpCode" xml:"HttpCode"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Latency   int64  `json:"Latency" xml:"Latency"`
}

// CreateCreateFunctionInstanceRequest creates a request to invoke CreateFunctionInstance API
func CreateCreateFunctionInstanceRequest() (request *CreateFunctionInstanceRequest) {
	request = &CreateFunctionInstanceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "CreateFunctionInstance", "/v4/openapi/app-groups/[appGroupIdentity]/functions/[functionName]/instances", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateFunctionInstanceResponse creates a response to parse from CreateFunctionInstance response
func CreateCreateFunctionInstanceResponse() (response *CreateFunctionInstanceResponse) {
	response = &CreateFunctionInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
