package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFirstRank invokes the opensearch.DescribeFirstRank API synchronously
func (client *Client) DescribeFirstRank(request *DescribeFirstRankRequest) (response *DescribeFirstRankResponse, err error) {
	response = CreateDescribeFirstRankResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFirstRankWithChan invokes the opensearch.DescribeFirstRank API asynchronously
func (client *Client) DescribeFirstRankWithChan(request *DescribeFirstRankRequest) (<-chan *DescribeFirstRankResponse, <-chan error) {
	responseChan := make(chan *DescribeFirstRankResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFirstRank(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFirstRankWithCallback invokes the opensearch.DescribeFirstRank API asynchronously
func (client *Client) DescribeFirstRankWithCallback(request *DescribeFirstRankRequest, callback func(response *DescribeFirstRankResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFirstRankResponse
		var err error
		defer close(result)
		response, err = client.DescribeFirstRank(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFirstRankRequest is the request struct for api DescribeFirstRank
type DescribeFirstRankRequest struct {
	*requests.RoaRequest
	AppId            requests.Integer `position:"Path" name:"appId"`
	Name             string           `position:"Path" name:"name"`
	AppGroupIdentity string           `position:"Path" name:"appGroupIdentity"`
}

// DescribeFirstRankResponse is the response struct for api DescribeFirstRank
type DescribeFirstRankResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    Result `json:"result" xml:"result"`
}

// CreateDescribeFirstRankRequest creates a request to invoke DescribeFirstRank API
func CreateDescribeFirstRankRequest() (request *DescribeFirstRankRequest) {
	request = &DescribeFirstRankRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "DescribeFirstRank", "/v4/openapi/app-groups/[appGroupIdentity]/apps/[appId]/first-ranks/[name]", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeFirstRankResponse creates a response to parse from DescribeFirstRank response
func CreateDescribeFirstRankResponse() (response *DescribeFirstRankResponse) {
	response = &DescribeFirstRankResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
