package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateABMetricGroup invokes the pairecservice.CreateABMetricGroup API synchronously
func (client *Client) CreateABMetricGroup(request *CreateABMetricGroupRequest) (response *CreateABMetricGroupResponse, err error) {
	response = CreateCreateABMetricGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateABMetricGroupWithChan invokes the pairecservice.CreateABMetricGroup API asynchronously
func (client *Client) CreateABMetricGroupWithChan(request *CreateABMetricGroupRequest) (<-chan *CreateABMetricGroupResponse, <-chan error) {
	responseChan := make(chan *CreateABMetricGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateABMetricGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateABMetricGroupWithCallback invokes the pairecservice.CreateABMetricGroup API asynchronously
func (client *Client) CreateABMetricGroupWithCallback(request *CreateABMetricGroupRequest, callback func(response *CreateABMetricGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateABMetricGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateABMetricGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateABMetricGroupRequest is the request struct for api CreateABMetricGroup
type CreateABMetricGroupRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// CreateABMetricGroupResponse is the response struct for api CreateABMetricGroup
type CreateABMetricGroupResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	ABMetricGroupId string `json:"ABMetricGroupId" xml:"ABMetricGroupId"`
}

// CreateCreateABMetricGroupRequest creates a request to invoke CreateABMetricGroup API
func CreateCreateABMetricGroupRequest() (request *CreateABMetricGroupRequest) {
	request = &CreateABMetricGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "CreateABMetricGroup", "/api/v1/abmetricgroups", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateABMetricGroupResponse creates a response to parse from CreateABMetricGroup response
func CreateCreateABMetricGroupResponse() (response *CreateABMetricGroupResponse) {
	response = &CreateABMetricGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
