package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteResourceRule invokes the pairecservice.DeleteResourceRule API synchronously
func (client *Client) DeleteResourceRule(request *DeleteResourceRuleRequest) (response *DeleteResourceRuleResponse, err error) {
	response = CreateDeleteResourceRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteResourceRuleWithChan invokes the pairecservice.DeleteResourceRule API asynchronously
func (client *Client) DeleteResourceRuleWithChan(request *DeleteResourceRuleRequest) (<-chan *DeleteResourceRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteResourceRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteResourceRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteResourceRuleWithCallback invokes the pairecservice.DeleteResourceRule API asynchronously
func (client *Client) DeleteResourceRuleWithCallback(request *DeleteResourceRuleRequest, callback func(response *DeleteResourceRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteResourceRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteResourceRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteResourceRuleRequest is the request struct for api DeleteResourceRule
type DeleteResourceRuleRequest struct {
	*requests.RoaRequest
	ResourceRuleId string `position:"Path" name:"ResourceRuleId"`
	InstanceId     string `position:"Query" name:"InstanceId"`
}

// DeleteResourceRuleResponse is the response struct for api DeleteResourceRule
type DeleteResourceRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteResourceRuleRequest creates a request to invoke DeleteResourceRule API
func CreateDeleteResourceRuleRequest() (request *DeleteResourceRuleRequest) {
	request = &DeleteResourceRuleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "DeleteResourceRule", "/api/v1/resourcerules/[ResourceRuleId]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteResourceRuleResponse creates a response to parse from DeleteResourceRule response
func CreateDeleteResourceRuleResponse() (response *DeleteResourceRuleResponse) {
	response = &DeleteResourceRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
