package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFeatureConsistencyCheckJobConfigs invokes the pairecservice.ListFeatureConsistencyCheckJobConfigs API synchronously
func (client *Client) ListFeatureConsistencyCheckJobConfigs(request *ListFeatureConsistencyCheckJobConfigsRequest) (response *ListFeatureConsistencyCheckJobConfigsResponse, err error) {
	response = CreateListFeatureConsistencyCheckJobConfigsResponse()
	err = client.DoAction(request, response)
	return
}

// ListFeatureConsistencyCheckJobConfigsWithChan invokes the pairecservice.ListFeatureConsistencyCheckJobConfigs API asynchronously
func (client *Client) ListFeatureConsistencyCheckJobConfigsWithChan(request *ListFeatureConsistencyCheckJobConfigsRequest) (<-chan *ListFeatureConsistencyCheckJobConfigsResponse, <-chan error) {
	responseChan := make(chan *ListFeatureConsistencyCheckJobConfigsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFeatureConsistencyCheckJobConfigs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFeatureConsistencyCheckJobConfigsWithCallback invokes the pairecservice.ListFeatureConsistencyCheckJobConfigs API asynchronously
func (client *Client) ListFeatureConsistencyCheckJobConfigsWithCallback(request *ListFeatureConsistencyCheckJobConfigsRequest, callback func(response *ListFeatureConsistencyCheckJobConfigsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFeatureConsistencyCheckJobConfigsResponse
		var err error
		defer close(result)
		response, err = client.ListFeatureConsistencyCheckJobConfigs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFeatureConsistencyCheckJobConfigsRequest is the request struct for api ListFeatureConsistencyCheckJobConfigs
type ListFeatureConsistencyCheckJobConfigsRequest struct {
	*requests.RoaRequest
	PageNumber string `position:"Query" name:"PageNumber"`
	InstanceId string `position:"Query" name:"InstanceId"`
	PageSize   string `position:"Query" name:"PageSize"`
	SortBy     string `position:"Query" name:"SortBy"`
	Order      string `position:"Query" name:"Order"`
}

// ListFeatureConsistencyCheckJobConfigsResponse is the response struct for api ListFeatureConsistencyCheckJobConfigs
type ListFeatureConsistencyCheckJobConfigsResponse struct {
	*responses.BaseResponse
	RequestId                      string                               `json:"RequestId" xml:"RequestId"`
	TotalCount                     int64                                `json:"TotalCount" xml:"TotalCount"`
	FeatureConsistencyCheckConfigs []FeatureConsistencyCheckConfigsItem `json:"FeatureConsistencyCheckConfigs" xml:"FeatureConsistencyCheckConfigs"`
}

// CreateListFeatureConsistencyCheckJobConfigsRequest creates a request to invoke ListFeatureConsistencyCheckJobConfigs API
func CreateListFeatureConsistencyCheckJobConfigsRequest() (request *ListFeatureConsistencyCheckJobConfigsRequest) {
	request = &ListFeatureConsistencyCheckJobConfigsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "ListFeatureConsistencyCheckJobConfigs", "/api/v1/featureconsistencycheck/jobconfigs", "", "")
	request.Method = requests.GET
	return
}

// CreateListFeatureConsistencyCheckJobConfigsResponse creates a response to parse from ListFeatureConsistencyCheckJobConfigs response
func CreateListFeatureConsistencyCheckJobConfigsResponse() (response *ListFeatureConsistencyCheckJobConfigsResponse) {
	response = &ListFeatureConsistencyCheckJobConfigsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
