package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLaboratories invokes the pairecservice.ListLaboratories API synchronously
func (client *Client) ListLaboratories(request *ListLaboratoriesRequest) (response *ListLaboratoriesResponse, err error) {
	response = CreateListLaboratoriesResponse()
	err = client.DoAction(request, response)
	return
}

// ListLaboratoriesWithChan invokes the pairecservice.ListLaboratories API asynchronously
func (client *Client) ListLaboratoriesWithChan(request *ListLaboratoriesRequest) (<-chan *ListLaboratoriesResponse, <-chan error) {
	responseChan := make(chan *ListLaboratoriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLaboratories(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLaboratoriesWithCallback invokes the pairecservice.ListLaboratories API asynchronously
func (client *Client) ListLaboratoriesWithCallback(request *ListLaboratoriesRequest, callback func(response *ListLaboratoriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLaboratoriesResponse
		var err error
		defer close(result)
		response, err = client.ListLaboratories(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLaboratoriesRequest is the request struct for api ListLaboratories
type ListLaboratoriesRequest struct {
	*requests.RoaRequest
	Environment string `position:"Query" name:"Environment"`
	InstanceId  string `position:"Query" name:"InstanceId"`
	SceneId     string `position:"Query" name:"SceneId"`
	Status      string `position:"Query" name:"Status"`
}

// ListLaboratoriesResponse is the response struct for api ListLaboratories
type ListLaboratoriesResponse struct {
	*responses.BaseResponse
	RequestId    string             `json:"RequestId" xml:"RequestId"`
	TotalCount   int64              `json:"TotalCount" xml:"TotalCount"`
	Laboratories []LaboratoriesItem `json:"Laboratories" xml:"Laboratories"`
}

// CreateListLaboratoriesRequest creates a request to invoke ListLaboratories API
func CreateListLaboratoriesRequest() (request *ListLaboratoriesRequest) {
	request = &ListLaboratoriesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "ListLaboratories", "/api/v1/laboratories", "", "")
	request.Method = requests.GET
	return
}

// CreateListLaboratoriesResponse creates a response to parse from ListLaboratories response
func CreateListLaboratoriesResponse() (response *ListLaboratoriesResponse) {
	response = &ListLaboratoriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
