package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDBEndpointAddress invokes the polardb.CreateDBEndpointAddress API synchronously
func (client *Client) CreateDBEndpointAddress(request *CreateDBEndpointAddressRequest) (response *CreateDBEndpointAddressResponse, err error) {
	response = CreateCreateDBEndpointAddressResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDBEndpointAddressWithChan invokes the polardb.CreateDBEndpointAddress API asynchronously
func (client *Client) CreateDBEndpointAddressWithChan(request *CreateDBEndpointAddressRequest) (<-chan *CreateDBEndpointAddressResponse, <-chan error) {
	responseChan := make(chan *CreateDBEndpointAddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDBEndpointAddress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDBEndpointAddressWithCallback invokes the polardb.CreateDBEndpointAddress API asynchronously
func (client *Client) CreateDBEndpointAddressWithCallback(request *CreateDBEndpointAddressRequest, callback func(response *CreateDBEndpointAddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDBEndpointAddressResponse
		var err error
		defer close(result)
		response, err = client.CreateDBEndpointAddress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDBEndpointAddressRequest is the request struct for api CreateDBEndpointAddress
type CreateDBEndpointAddressRequest struct {
	*requests.RpcRequest
	ResourceOwnerId        requests.Integer                   `position:"Query" name:"ResourceOwnerId"`
	ConnectionStringPrefix string                             `position:"Query" name:"ConnectionStringPrefix"`
	ZoneInfo               *[]CreateDBEndpointAddressZoneInfo `position:"Query" name:"ZoneInfo"  type:"Repeated"`
	SecurityGroupId        string                             `position:"Query" name:"SecurityGroupId"`
	DBEndpointId           string                             `position:"Query" name:"DBEndpointId"`
	ResourceOwnerAccount   string                             `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId            string                             `position:"Query" name:"DBClusterId"`
	OwnerAccount           string                             `position:"Query" name:"OwnerAccount"`
	OwnerId                requests.Integer                   `position:"Query" name:"OwnerId"`
	NetType                string                             `position:"Query" name:"NetType"`
	VPCId                  string                             `position:"Query" name:"VPCId"`
}

// CreateDBEndpointAddressZoneInfo is a repeated param struct in CreateDBEndpointAddressRequest
type CreateDBEndpointAddressZoneInfo struct {
	VSwitchId string `name:"VSwitchId"`
	ZoneId    string `name:"ZoneId"`
}

// CreateDBEndpointAddressResponse is the response struct for api CreateDBEndpointAddress
type CreateDBEndpointAddressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateDBEndpointAddressRequest creates a request to invoke CreateDBEndpointAddress API
func CreateCreateDBEndpointAddressRequest() (request *CreateDBEndpointAddressRequest) {
	request = &CreateDBEndpointAddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "CreateDBEndpointAddress", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDBEndpointAddressResponse creates a response to parse from CreateDBEndpointAddress response
func CreateCreateDBEndpointAddressResponse() (response *CreateDBEndpointAddressResponse) {
	response = &CreateDBEndpointAddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
