package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ManuallyStartDBCluster invokes the polardb.ManuallyStartDBCluster API synchronously
func (client *Client) ManuallyStartDBCluster(request *ManuallyStartDBClusterRequest) (response *ManuallyStartDBClusterResponse, err error) {
	response = CreateManuallyStartDBClusterResponse()
	err = client.DoAction(request, response)
	return
}

// ManuallyStartDBClusterWithChan invokes the polardb.ManuallyStartDBCluster API asynchronously
func (client *Client) ManuallyStartDBClusterWithChan(request *ManuallyStartDBClusterRequest) (<-chan *ManuallyStartDBClusterResponse, <-chan error) {
	responseChan := make(chan *ManuallyStartDBClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ManuallyStartDBCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ManuallyStartDBClusterWithCallback invokes the polardb.ManuallyStartDBCluster API asynchronously
func (client *Client) ManuallyStartDBClusterWithCallback(request *ManuallyStartDBClusterRequest, callback func(response *ManuallyStartDBClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ManuallyStartDBClusterResponse
		var err error
		defer close(result)
		response, err = client.ManuallyStartDBCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ManuallyStartDBClusterRequest is the request struct for api ManuallyStartDBCluster
type ManuallyStartDBClusterRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ManuallyStartDBClusterResponse is the response struct for api ManuallyStartDBCluster
type ManuallyStartDBClusterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateManuallyStartDBClusterRequest creates a request to invoke ManuallyStartDBCluster API
func CreateManuallyStartDBClusterRequest() (request *ManuallyStartDBClusterRequest) {
	request = &ManuallyStartDBClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "ManuallyStartDBCluster", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateManuallyStartDBClusterResponse creates a response to parse from ManuallyStartDBCluster response
func CreateManuallyStartDBClusterResponse() (response *ManuallyStartDBClusterResponse) {
	response = &ManuallyStartDBClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
