package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeArchiveTableList invokes the polardbx.DescribeArchiveTableList API synchronously
func (client *Client) DescribeArchiveTableList(request *DescribeArchiveTableListRequest) (response *DescribeArchiveTableListResponse, err error) {
	response = CreateDescribeArchiveTableListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeArchiveTableListWithChan invokes the polardbx.DescribeArchiveTableList API asynchronously
func (client *Client) DescribeArchiveTableListWithChan(request *DescribeArchiveTableListRequest) (<-chan *DescribeArchiveTableListResponse, <-chan error) {
	responseChan := make(chan *DescribeArchiveTableListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeArchiveTableList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeArchiveTableListWithCallback invokes the polardbx.DescribeArchiveTableList API asynchronously
func (client *Client) DescribeArchiveTableListWithCallback(request *DescribeArchiveTableListRequest, callback func(response *DescribeArchiveTableListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeArchiveTableListResponse
		var err error
		defer close(result)
		response, err = client.DescribeArchiveTableList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeArchiveTableListRequest is the request struct for api DescribeArchiveTableList
type DescribeArchiveTableListRequest struct {
	*requests.RpcRequest
	DBInstanceName string           `position:"Query" name:"DBInstanceName"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	PageIndex      requests.Integer `position:"Query" name:"PageIndex"`
	TableName      string           `position:"Query" name:"TableName"`
	SchemaName     string           `position:"Query" name:"SchemaName"`
	Status         string           `position:"Query" name:"Status"`
}

// DescribeArchiveTableListResponse is the response struct for api DescribeArchiveTableList
type DescribeArchiveTableListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeArchiveTableListRequest creates a request to invoke DescribeArchiveTableList API
func CreateDescribeArchiveTableListRequest() (request *DescribeArchiveTableListRequest) {
	request = &DescribeArchiveTableListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "DescribeArchiveTableList", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeArchiveTableListResponse creates a response to parse from DescribeArchiveTableList response
func CreateDescribeArchiveTableListResponse() (response *DescribeArchiveTableListResponse) {
	response = &DescribeArchiveTableListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
