package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBInstanceConfig invokes the polardbx.DescribeDBInstanceConfig API synchronously
func (client *Client) DescribeDBInstanceConfig(request *DescribeDBInstanceConfigRequest) (response *DescribeDBInstanceConfigResponse, err error) {
	response = CreateDescribeDBInstanceConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBInstanceConfigWithChan invokes the polardbx.DescribeDBInstanceConfig API asynchronously
func (client *Client) DescribeDBInstanceConfigWithChan(request *DescribeDBInstanceConfigRequest) (<-chan *DescribeDBInstanceConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeDBInstanceConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBInstanceConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBInstanceConfigWithCallback invokes the polardbx.DescribeDBInstanceConfig API asynchronously
func (client *Client) DescribeDBInstanceConfigWithCallback(request *DescribeDBInstanceConfigRequest, callback func(response *DescribeDBInstanceConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBInstanceConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBInstanceConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBInstanceConfigRequest is the request struct for api DescribeDBInstanceConfig
type DescribeDBInstanceConfigRequest struct {
	*requests.RpcRequest
	DBInstanceName string `position:"Query" name:"DBInstanceName"`
	ConfigName     string `position:"Query" name:"ConfigName"`
}

// DescribeDBInstanceConfigResponse is the response struct for api DescribeDBInstanceConfig
type DescribeDBInstanceConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeDBInstanceConfigRequest creates a request to invoke DescribeDBInstanceConfig API
func CreateDescribeDBInstanceConfigRequest() (request *DescribeDBInstanceConfigRequest) {
	request = &DescribeDBInstanceConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "DescribeDBInstanceConfig", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBInstanceConfigResponse creates a response to parse from DescribeDBInstanceConfig response
func CreateDescribeDBInstanceConfigResponse() (response *DescribeDBInstanceConfigResponse) {
	response = &DescribeDBInstanceConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
