package qianzhou

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetWebshellToken invokes the qianzhou.GetWebshellToken API synchronously
func (client *Client) GetWebshellToken(request *GetWebshellTokenRequest) (response *GetWebshellTokenResponse, err error) {
	response = CreateGetWebshellTokenResponse()
	err = client.DoAction(request, response)
	return
}

// GetWebshellTokenWithChan invokes the qianzhou.GetWebshellToken API asynchronously
func (client *Client) GetWebshellTokenWithChan(request *GetWebshellTokenRequest) (<-chan *GetWebshellTokenResponse, <-chan error) {
	responseChan := make(chan *GetWebshellTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetWebshellToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetWebshellTokenWithCallback invokes the qianzhou.GetWebshellToken API asynchronously
func (client *Client) GetWebshellTokenWithCallback(request *GetWebshellTokenRequest, callback func(response *GetWebshellTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetWebshellTokenResponse
		var err error
		defer close(result)
		response, err = client.GetWebshellToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetWebshellTokenRequest is the request struct for api GetWebshellToken
type GetWebshellTokenRequest struct {
	*requests.RoaRequest
}

// GetWebshellTokenResponse is the response struct for api GetWebshellToken
type GetWebshellTokenResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateGetWebshellTokenRequest creates a request to invoke GetWebshellToken API
func CreateGetWebshellTokenRequest() (request *GetWebshellTokenRequest) {
	request = &GetWebshellTokenRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("qianzhou", "2021-11-11", "GetWebshellToken", "/popapi/getChorusToken", "", "")
	request.Method = requests.GET
	return
}

// CreateGetWebshellTokenResponse creates a response to parse from GetWebshellToken response
func CreateGetWebshellTokenResponse() (response *GetWebshellTokenResponse) {
	response = &GetWebshellTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
