package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDataSourceConnectionInfo invokes the quickbi_public.GetDataSourceConnectionInfo API synchronously
func (client *Client) GetDataSourceConnectionInfo(request *GetDataSourceConnectionInfoRequest) (response *GetDataSourceConnectionInfoResponse, err error) {
	response = CreateGetDataSourceConnectionInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetDataSourceConnectionInfoWithChan invokes the quickbi_public.GetDataSourceConnectionInfo API asynchronously
func (client *Client) GetDataSourceConnectionInfoWithChan(request *GetDataSourceConnectionInfoRequest) (<-chan *GetDataSourceConnectionInfoResponse, <-chan error) {
	responseChan := make(chan *GetDataSourceConnectionInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDataSourceConnectionInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDataSourceConnectionInfoWithCallback invokes the quickbi_public.GetDataSourceConnectionInfo API asynchronously
func (client *Client) GetDataSourceConnectionInfoWithCallback(request *GetDataSourceConnectionInfoRequest, callback func(response *GetDataSourceConnectionInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDataSourceConnectionInfoResponse
		var err error
		defer close(result)
		response, err = client.GetDataSourceConnectionInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDataSourceConnectionInfoRequest is the request struct for api GetDataSourceConnectionInfo
type GetDataSourceConnectionInfoRequest struct {
	*requests.RpcRequest
	DsId        string `position:"Query" name:"DsId"`
	AccessPoint string `position:"Query" name:"AccessPoint"`
	SignType    string `position:"Query" name:"SignType"`
}

// GetDataSourceConnectionInfoResponse is the response struct for api GetDataSourceConnectionInfo
type GetDataSourceConnectionInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateGetDataSourceConnectionInfoRequest creates a request to invoke GetDataSourceConnectionInfo API
func CreateGetDataSourceConnectionInfoRequest() (request *GetDataSourceConnectionInfoRequest) {
	request = &GetDataSourceConnectionInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "GetDataSourceConnectionInfo", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDataSourceConnectionInfoResponse creates a response to parse from GetDataSourceConnectionInfo response
func CreateGetDataSourceConnectionInfoResponse() (response *GetDataSourceConnectionInfoResponse) {
	response = &GetDataSourceConnectionInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
