package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryOrganizationRoleConfig invokes the quickbi_public.QueryOrganizationRoleConfig API synchronously
func (client *Client) QueryOrganizationRoleConfig(request *QueryOrganizationRoleConfigRequest) (response *QueryOrganizationRoleConfigResponse, err error) {
	response = CreateQueryOrganizationRoleConfigResponse()
	err = client.DoAction(request, response)
	return
}

// QueryOrganizationRoleConfigWithChan invokes the quickbi_public.QueryOrganizationRoleConfig API asynchronously
func (client *Client) QueryOrganizationRoleConfigWithChan(request *QueryOrganizationRoleConfigRequest) (<-chan *QueryOrganizationRoleConfigResponse, <-chan error) {
	responseChan := make(chan *QueryOrganizationRoleConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryOrganizationRoleConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryOrganizationRoleConfigWithCallback invokes the quickbi_public.QueryOrganizationRoleConfig API asynchronously
func (client *Client) QueryOrganizationRoleConfigWithCallback(request *QueryOrganizationRoleConfigRequest, callback func(response *QueryOrganizationRoleConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryOrganizationRoleConfigResponse
		var err error
		defer close(result)
		response, err = client.QueryOrganizationRoleConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryOrganizationRoleConfigRequest is the request struct for api QueryOrganizationRoleConfig
type QueryOrganizationRoleConfigRequest struct {
	*requests.RpcRequest
	RoleId      requests.Integer `position:"Query" name:"RoleId"`
	AccessPoint string           `position:"Query" name:"AccessPoint"`
	SignType    string           `position:"Query" name:"SignType"`
}

// QueryOrganizationRoleConfigResponse is the response struct for api QueryOrganizationRoleConfig
type QueryOrganizationRoleConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateQueryOrganizationRoleConfigRequest creates a request to invoke QueryOrganizationRoleConfig API
func CreateQueryOrganizationRoleConfigRequest() (request *QueryOrganizationRoleConfigRequest) {
	request = &QueryOrganizationRoleConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "QueryOrganizationRoleConfig", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryOrganizationRoleConfigResponse creates a response to parse from QueryOrganizationRoleConfig response
func CreateQueryOrganizationRoleConfigResponse() (response *QueryOrganizationRoleConfigResponse) {
	response = &QueryOrganizationRoleConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
