package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryWorkspaceRoleConfig invokes the quickbi_public.QueryWorkspaceRoleConfig API synchronously
func (client *Client) QueryWorkspaceRoleConfig(request *QueryWorkspaceRoleConfigRequest) (response *QueryWorkspaceRoleConfigResponse, err error) {
	response = CreateQueryWorkspaceRoleConfigResponse()
	err = client.DoAction(request, response)
	return
}

// QueryWorkspaceRoleConfigWithChan invokes the quickbi_public.QueryWorkspaceRoleConfig API asynchronously
func (client *Client) QueryWorkspaceRoleConfigWithChan(request *QueryWorkspaceRoleConfigRequest) (<-chan *QueryWorkspaceRoleConfigResponse, <-chan error) {
	responseChan := make(chan *QueryWorkspaceRoleConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryWorkspaceRoleConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryWorkspaceRoleConfigWithCallback invokes the quickbi_public.QueryWorkspaceRoleConfig API asynchronously
func (client *Client) QueryWorkspaceRoleConfigWithCallback(request *QueryWorkspaceRoleConfigRequest, callback func(response *QueryWorkspaceRoleConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryWorkspaceRoleConfigResponse
		var err error
		defer close(result)
		response, err = client.QueryWorkspaceRoleConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryWorkspaceRoleConfigRequest is the request struct for api QueryWorkspaceRoleConfig
type QueryWorkspaceRoleConfigRequest struct {
	*requests.RpcRequest
	RoleId      requests.Integer `position:"Query" name:"RoleId"`
	AccessPoint string           `position:"Query" name:"AccessPoint"`
	SignType    string           `position:"Query" name:"SignType"`
}

// QueryWorkspaceRoleConfigResponse is the response struct for api QueryWorkspaceRoleConfig
type QueryWorkspaceRoleConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateQueryWorkspaceRoleConfigRequest creates a request to invoke QueryWorkspaceRoleConfig API
func CreateQueryWorkspaceRoleConfigRequest() (request *QueryWorkspaceRoleConfigRequest) {
	request = &QueryWorkspaceRoleConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "QueryWorkspaceRoleConfig", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryWorkspaceRoleConfigResponse creates a response to parse from QueryWorkspaceRoleConfig response
func CreateQueryWorkspaceRoleConfigResponse() (response *QueryWorkspaceRoleConfigResponse) {
	response = &QueryWorkspaceRoleConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
