package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateReadOnlyDBInstance invokes the rds.CreateReadOnlyDBInstance API synchronously
func (client *Client) CreateReadOnlyDBInstance(request *CreateReadOnlyDBInstanceRequest) (response *CreateReadOnlyDBInstanceResponse, err error) {
	response = CreateCreateReadOnlyDBInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateReadOnlyDBInstanceWithChan invokes the rds.CreateReadOnlyDBInstance API asynchronously
func (client *Client) CreateReadOnlyDBInstanceWithChan(request *CreateReadOnlyDBInstanceRequest) (<-chan *CreateReadOnlyDBInstanceResponse, <-chan error) {
	responseChan := make(chan *CreateReadOnlyDBInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateReadOnlyDBInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateReadOnlyDBInstanceWithCallback invokes the rds.CreateReadOnlyDBInstance API asynchronously
func (client *Client) CreateReadOnlyDBInstanceWithCallback(request *CreateReadOnlyDBInstanceRequest, callback func(response *CreateReadOnlyDBInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateReadOnlyDBInstanceResponse
		var err error
		defer close(result)
		response, err = client.CreateReadOnlyDBInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateReadOnlyDBInstanceRequest is the request struct for api CreateReadOnlyDBInstance
type CreateReadOnlyDBInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DBInstanceStorage              requests.Integer `position:"Query" name:"DBInstanceStorage"`
	AutoCreateProxy                requests.Boolean `position:"Query" name:"AutoCreateProxy"`
	EngineVersion                  string           `position:"Query" name:"EngineVersion"`
	DeletionProtection             requests.Boolean `position:"Query" name:"DeletionProtection"`
	ResourceGroupId                string           `position:"Query" name:"ResourceGroupId"`
	TargetDedicatedHostIdForMaster string           `position:"Query" name:"TargetDedicatedHostIdForMaster"`
	DBInstanceDescription          string           `position:"Query" name:"DBInstanceDescription"`
	GdnInstanceName                string           `position:"Query" name:"GdnInstanceName"`
	TddlBizType                    string           `position:"Query" name:"TddlBizType"`
	Period                         string           `position:"Query" name:"Period"`
	OwnerId                        requests.Integer `position:"Query" name:"OwnerId"`
	DBInstanceClass                string           `position:"Query" name:"DBInstanceClass"`
	VSwitchId                      string           `position:"Query" name:"VSwitchId"`
	PrivateIpAddress               string           `position:"Query" name:"PrivateIpAddress"`
	AutoRenew                      string           `position:"Query" name:"AutoRenew"`
	Port                           string           `position:"Query" name:"Port"`
	ZoneId                         string           `position:"Query" name:"ZoneId"`
	InstanceNetworkType            string           `position:"Query" name:"InstanceNetworkType"`
	ClientToken                    string           `position:"Query" name:"ClientToken"`
	InstructionSetArch             string           `position:"Query" name:"InstructionSetArch"`
	IoAccelerationEnabled          string           `position:"Query" name:"IoAccelerationEnabled"`
	TddlRegionConfig               string           `position:"Query" name:"TddlRegionConfig"`
	DBInstanceId                   string           `position:"Query" name:"DBInstanceId"`
	DBInstanceStorageType          string           `position:"Query" name:"DBInstanceStorageType"`
	DedicatedHostGroupId           string           `position:"Query" name:"DedicatedHostGroupId"`
	AutoPay                        requests.Boolean `position:"Query" name:"AutoPay"`
	ResourceOwnerAccount           string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                   string           `position:"Query" name:"OwnerAccount"`
	UsedTime                       string           `position:"Query" name:"UsedTime"`
	BurstingEnabled                requests.Boolean `position:"Query" name:"BurstingEnabled"`
	VPCId                          string           `position:"Query" name:"VPCId"`
	Category                       string           `position:"Query" name:"Category"`
	PayType                        string           `position:"Query" name:"PayType"`
	BpeEnabled                     string           `position:"Query" name:"BpeEnabled"`
}

// CreateReadOnlyDBInstanceResponse is the response struct for api CreateReadOnlyDBInstance
type CreateReadOnlyDBInstanceResponse struct {
	*responses.BaseResponse
	DBInstanceId     string `json:"DBInstanceId" xml:"DBInstanceId"`
	RequestId        string `json:"RequestId" xml:"RequestId"`
	Port             string `json:"Port" xml:"Port"`
	ConnectionString string `json:"ConnectionString" xml:"ConnectionString"`
	OrderId          string `json:"OrderId" xml:"OrderId"`
}

// CreateCreateReadOnlyDBInstanceRequest creates a request to invoke CreateReadOnlyDBInstance API
func CreateCreateReadOnlyDBInstanceRequest() (request *CreateReadOnlyDBInstanceRequest) {
	request = &CreateReadOnlyDBInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "CreateReadOnlyDBInstance", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateReadOnlyDBInstanceResponse creates a response to parse from CreateReadOnlyDBInstance response
func CreateCreateReadOnlyDBInstanceResponse() (response *CreateReadOnlyDBInstanceResponse) {
	response = &CreateReadOnlyDBInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
