package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopDBInstance invokes the rds.StopDBInstance API synchronously
func (client *Client) StopDBInstance(request *StopDBInstanceRequest) (response *StopDBInstanceResponse, err error) {
	response = CreateStopDBInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// StopDBInstanceWithChan invokes the rds.StopDBInstance API asynchronously
func (client *Client) StopDBInstanceWithChan(request *StopDBInstanceRequest) (<-chan *StopDBInstanceResponse, <-chan error) {
	responseChan := make(chan *StopDBInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopDBInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopDBInstanceWithCallback invokes the rds.StopDBInstance API asynchronously
func (client *Client) StopDBInstanceWithCallback(request *StopDBInstanceRequest, callback func(response *StopDBInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopDBInstanceResponse
		var err error
		defer close(result)
		response, err = client.StopDBInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopDBInstanceRequest is the request struct for api StopDBInstance
type StopDBInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
}

// StopDBInstanceResponse is the response struct for api StopDBInstance
type StopDBInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopDBInstanceRequest creates a request to invoke StopDBInstance API
func CreateStopDBInstanceRequest() (request *StopDBInstanceRequest) {
	request = &StopDBInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "StopDBInstance", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopDBInstanceResponse creates a response to parse from StopDBInstance response
func CreateStopDBInstanceResponse() (response *StopDBInstanceResponse) {
	response = &StopDBInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
