package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableAssociatedTransfer invokes the resourcemanager.DisableAssociatedTransfer API synchronously
func (client *Client) DisableAssociatedTransfer(request *DisableAssociatedTransferRequest) (response *DisableAssociatedTransferResponse, err error) {
	response = CreateDisableAssociatedTransferResponse()
	err = client.DoAction(request, response)
	return
}

// DisableAssociatedTransferWithChan invokes the resourcemanager.DisableAssociatedTransfer API asynchronously
func (client *Client) DisableAssociatedTransferWithChan(request *DisableAssociatedTransferRequest) (<-chan *DisableAssociatedTransferResponse, <-chan error) {
	responseChan := make(chan *DisableAssociatedTransferResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableAssociatedTransfer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableAssociatedTransferWithCallback invokes the resourcemanager.DisableAssociatedTransfer API asynchronously
func (client *Client) DisableAssociatedTransferWithCallback(request *DisableAssociatedTransferRequest, callback func(response *DisableAssociatedTransferResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableAssociatedTransferResponse
		var err error
		defer close(result)
		response, err = client.DisableAssociatedTransfer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableAssociatedTransferRequest is the request struct for api DisableAssociatedTransfer
type DisableAssociatedTransferRequest struct {
	*requests.RpcRequest
}

// DisableAssociatedTransferResponse is the response struct for api DisableAssociatedTransfer
type DisableAssociatedTransferResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableAssociatedTransferRequest creates a request to invoke DisableAssociatedTransfer API
func CreateDisableAssociatedTransferRequest() (request *DisableAssociatedTransferRequest) {
	request = &DisableAssociatedTransferRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "DisableAssociatedTransfer", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableAssociatedTransferResponse creates a response to parse from DisableAssociatedTransfer response
func CreateDisableAssociatedTransferResponse() (response *DisableAssociatedTransferResponse) {
	response = &DisableAssociatedTransferResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
