package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeConcernNecessity invokes the sas.DescribeConcernNecessity API synchronously
func (client *Client) DescribeConcernNecessity(request *DescribeConcernNecessityRequest) (response *DescribeConcernNecessityResponse, err error) {
	response = CreateDescribeConcernNecessityResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeConcernNecessityWithChan invokes the sas.DescribeConcernNecessity API asynchronously
func (client *Client) DescribeConcernNecessityWithChan(request *DescribeConcernNecessityRequest) (<-chan *DescribeConcernNecessityResponse, <-chan error) {
	responseChan := make(chan *DescribeConcernNecessityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeConcernNecessity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeConcernNecessityWithCallback invokes the sas.DescribeConcernNecessity API asynchronously
func (client *Client) DescribeConcernNecessityWithCallback(request *DescribeConcernNecessityRequest, callback func(response *DescribeConcernNecessityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeConcernNecessityResponse
		var err error
		defer close(result)
		response, err = client.DescribeConcernNecessity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeConcernNecessityRequest is the request struct for api DescribeConcernNecessity
type DescribeConcernNecessityRequest struct {
	*requests.RpcRequest
	SourceIp                   string `position:"Query" name:"SourceIp"`
	Lang                       string `position:"Query" name:"Lang"`
	ResourceDirectoryAccountId string `position:"Query" name:"ResourceDirectoryAccountId"`
}

// DescribeConcernNecessityResponse is the response struct for api DescribeConcernNecessity
type DescribeConcernNecessityResponse struct {
	*responses.BaseResponse
	RequestId        string   `json:"RequestId" xml:"RequestId"`
	ConcernNecessity []string `json:"ConcernNecessity" xml:"ConcernNecessity"`
}

// CreateDescribeConcernNecessityRequest creates a request to invoke DescribeConcernNecessity API
func CreateDescribeConcernNecessityRequest() (request *DescribeConcernNecessityRequest) {
	request = &DescribeConcernNecessityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeConcernNecessity", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeConcernNecessityResponse creates a response to parse from DescribeConcernNecessity response
func CreateDescribeConcernNecessityResponse() (response *DescribeConcernNecessityResponse) {
	response = &DescribeConcernNecessityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
