package schedulerx3

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OperateExecuteJob invokes the schedulerx3.OperateExecuteJob API synchronously
func (client *Client) OperateExecuteJob(request *OperateExecuteJobRequest) (response *OperateExecuteJobResponse, err error) {
	response = CreateOperateExecuteJobResponse()
	err = client.DoAction(request, response)
	return
}

// OperateExecuteJobWithChan invokes the schedulerx3.OperateExecuteJob API asynchronously
func (client *Client) OperateExecuteJobWithChan(request *OperateExecuteJobRequest) (<-chan *OperateExecuteJobResponse, <-chan error) {
	responseChan := make(chan *OperateExecuteJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OperateExecuteJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OperateExecuteJobWithCallback invokes the schedulerx3.OperateExecuteJob API asynchronously
func (client *Client) OperateExecuteJobWithCallback(request *OperateExecuteJobRequest, callback func(response *OperateExecuteJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OperateExecuteJobResponse
		var err error
		defer close(result)
		response, err = client.OperateExecuteJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OperateExecuteJobRequest is the request struct for api OperateExecuteJob
type OperateExecuteJobRequest struct {
	*requests.RpcRequest
	MseSessionId       string           `position:"Query" name:"MseSessionId"`
	JobId              requests.Integer `position:"Body" name:"JobId"`
	AppName            string           `position:"Body" name:"AppName"`
	Worker             string           `position:"Body" name:"Worker"`
	InstanceParameters string           `position:"Body" name:"InstanceParameters"`
	ClusterId          string           `position:"Body" name:"ClusterId"`
	Label              string           `position:"Body" name:"Label"`
}

// OperateExecuteJobResponse is the response struct for api OperateExecuteJob
type OperateExecuteJobResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateOperateExecuteJobRequest creates a request to invoke OperateExecuteJob API
func CreateOperateExecuteJobRequest() (request *OperateExecuteJobRequest) {
	request = &OperateExecuteJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SchedulerX3", "2024-06-24", "OperateExecuteJob", "", "")
	request.Method = requests.POST
	return
}

// CreateOperateExecuteJobResponse creates a response to parse from OperateExecuteJob response
func CreateOperateExecuteJobResponse() (response *OperateExecuteJobResponse) {
	response = &OperateExecuteJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
