package selectdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RestartDBCluster invokes the selectdb.RestartDBCluster API synchronously
func (client *Client) RestartDBCluster(request *RestartDBClusterRequest) (response *RestartDBClusterResponse, err error) {
	response = CreateRestartDBClusterResponse()
	err = client.DoAction(request, response)
	return
}

// RestartDBClusterWithChan invokes the selectdb.RestartDBCluster API asynchronously
func (client *Client) RestartDBClusterWithChan(request *RestartDBClusterRequest) (<-chan *RestartDBClusterResponse, <-chan error) {
	responseChan := make(chan *RestartDBClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RestartDBCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RestartDBClusterWithCallback invokes the selectdb.RestartDBCluster API asynchronously
func (client *Client) RestartDBClusterWithCallback(request *RestartDBClusterRequest, callback func(response *RestartDBClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RestartDBClusterResponse
		var err error
		defer close(result)
		response, err = client.RestartDBCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RestartDBClusterRequest is the request struct for api RestartDBCluster
type RestartDBClusterRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DBClusterId     string           `position:"Query" name:"DBClusterId"`
	ResourceGroupId string           `position:"Body" name:"ResourceGroupId"`
	DBInstanceId    string           `position:"Body" name:"DBInstanceId"`
}

// RestartDBClusterResponse is the response struct for api RestartDBCluster
type RestartDBClusterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRestartDBClusterRequest creates a request to invoke RestartDBCluster API
func CreateRestartDBClusterRequest() (request *RestartDBClusterRequest) {
	request = &RestartDBClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("selectdb", "2023-05-22", "RestartDBCluster", "", "")
	request.Method = requests.POST
	return
}

// CreateRestartDBClusterResponse creates a response to parse from RestartDBCluster response
func CreateRestartDBClusterResponse() (response *RestartDBClusterResponse) {
	response = &RestartDBClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
