package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGatewayActions invokes the sgw.DescribeGatewayActions API synchronously
func (client *Client) DescribeGatewayActions(request *DescribeGatewayActionsRequest) (response *DescribeGatewayActionsResponse, err error) {
	response = CreateDescribeGatewayActionsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGatewayActionsWithChan invokes the sgw.DescribeGatewayActions API asynchronously
func (client *Client) DescribeGatewayActionsWithChan(request *DescribeGatewayActionsRequest) (<-chan *DescribeGatewayActionsResponse, <-chan error) {
	responseChan := make(chan *DescribeGatewayActionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGatewayActions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGatewayActionsWithCallback invokes the sgw.DescribeGatewayActions API asynchronously
func (client *Client) DescribeGatewayActionsWithCallback(request *DescribeGatewayActionsRequest, callback func(response *DescribeGatewayActionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGatewayActionsResponse
		var err error
		defer close(result)
		response, err = client.DescribeGatewayActions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGatewayActionsRequest is the request struct for api DescribeGatewayActions
type DescribeGatewayActionsRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// DescribeGatewayActionsResponse is the response struct for api DescribeGatewayActions
type DescribeGatewayActionsResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Success   bool    `json:"Success" xml:"Success"`
	Code      string  `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	Actions   Actions `json:"Actions" xml:"Actions"`
}

// CreateDescribeGatewayActionsRequest creates a request to invoke DescribeGatewayActions API
func CreateDescribeGatewayActionsRequest() (request *DescribeGatewayActionsRequest) {
	request = &DescribeGatewayActionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeGatewayActions", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGatewayActionsResponse creates a response to parse from DescribeGatewayActions response
func CreateDescribeGatewayActionsResponse() (response *DescribeGatewayActionsResponse) {
	response = &DescribeGatewayActionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
