package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeKmsKey invokes the sgw.DescribeKmsKey API synchronously
func (client *Client) DescribeKmsKey(request *DescribeKmsKeyRequest) (response *DescribeKmsKeyResponse, err error) {
	response = CreateDescribeKmsKeyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeKmsKeyWithChan invokes the sgw.DescribeKmsKey API asynchronously
func (client *Client) DescribeKmsKeyWithChan(request *DescribeKmsKeyRequest) (<-chan *DescribeKmsKeyResponse, <-chan error) {
	responseChan := make(chan *DescribeKmsKeyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeKmsKey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeKmsKeyWithCallback invokes the sgw.DescribeKmsKey API asynchronously
func (client *Client) DescribeKmsKeyWithCallback(request *DescribeKmsKeyRequest, callback func(response *DescribeKmsKeyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeKmsKeyResponse
		var err error
		defer close(result)
		response, err = client.DescribeKmsKey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeKmsKeyRequest is the request struct for api DescribeKmsKey
type DescribeKmsKeyRequest struct {
	*requests.RpcRequest
	KmsKey        string `position:"Query" name:"KmsKey"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// DescribeKmsKeyResponse is the response struct for api DescribeKmsKey
type DescribeKmsKeyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	IsValid   bool   `json:"IsValid" xml:"IsValid"`
}

// CreateDescribeKmsKeyRequest creates a request to invoke DescribeKmsKey API
func CreateDescribeKmsKeyRequest() (request *DescribeKmsKeyRequest) {
	request = &DescribeKmsKeyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeKmsKey", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeKmsKeyResponse creates a response to parse from DescribeKmsKey response
func CreateDescribeKmsKeyResponse() (response *DescribeKmsKeyResponse) {
	response = &DescribeKmsKeyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
