package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSmartAccessGatewayUseLimit invokes the smartag.GetSmartAccessGatewayUseLimit API synchronously
func (client *Client) GetSmartAccessGatewayUseLimit(request *GetSmartAccessGatewayUseLimitRequest) (response *GetSmartAccessGatewayUseLimitResponse, err error) {
	response = CreateGetSmartAccessGatewayUseLimitResponse()
	err = client.DoAction(request, response)
	return
}

// GetSmartAccessGatewayUseLimitWithChan invokes the smartag.GetSmartAccessGatewayUseLimit API asynchronously
func (client *Client) GetSmartAccessGatewayUseLimitWithChan(request *GetSmartAccessGatewayUseLimitRequest) (<-chan *GetSmartAccessGatewayUseLimitResponse, <-chan error) {
	responseChan := make(chan *GetSmartAccessGatewayUseLimitResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSmartAccessGatewayUseLimit(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSmartAccessGatewayUseLimitWithCallback invokes the smartag.GetSmartAccessGatewayUseLimit API asynchronously
func (client *Client) GetSmartAccessGatewayUseLimitWithCallback(request *GetSmartAccessGatewayUseLimitRequest, callback func(response *GetSmartAccessGatewayUseLimitResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSmartAccessGatewayUseLimitResponse
		var err error
		defer close(result)
		response, err = client.GetSmartAccessGatewayUseLimit(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSmartAccessGatewayUseLimitRequest is the request struct for api GetSmartAccessGatewayUseLimit
type GetSmartAccessGatewayUseLimitRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// GetSmartAccessGatewayUseLimitResponse is the response struct for api GetSmartAccessGatewayUseLimit
type GetSmartAccessGatewayUseLimitResponse struct {
	*responses.BaseResponse
	UsedAmount  int    `json:"UsedAmount" xml:"UsedAmount"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
	TotalAmount int    `json:"TotalAmount" xml:"TotalAmount"`
}

// CreateGetSmartAccessGatewayUseLimitRequest creates a request to invoke GetSmartAccessGatewayUseLimit API
func CreateGetSmartAccessGatewayUseLimitRequest() (request *GetSmartAccessGatewayUseLimitRequest) {
	request = &GetSmartAccessGatewayUseLimitRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "GetSmartAccessGatewayUseLimit", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetSmartAccessGatewayUseLimitResponse creates a response to parse from GetSmartAccessGatewayUseLimit response
func CreateGetSmartAccessGatewayUseLimitResponse() (response *GetSmartAccessGatewayUseLimitResponse) {
	response = &GetSmartAccessGatewayUseLimitResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
