package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFirewallRule invokes the swas_open.CreateFirewallRule API synchronously
func (client *Client) CreateFirewallRule(request *CreateFirewallRuleRequest) (response *CreateFirewallRuleResponse, err error) {
	response = CreateCreateFirewallRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFirewallRuleWithChan invokes the swas_open.CreateFirewallRule API asynchronously
func (client *Client) CreateFirewallRuleWithChan(request *CreateFirewallRuleRequest) (<-chan *CreateFirewallRuleResponse, <-chan error) {
	responseChan := make(chan *CreateFirewallRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFirewallRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFirewallRuleWithCallback invokes the swas_open.CreateFirewallRule API asynchronously
func (client *Client) CreateFirewallRuleWithCallback(request *CreateFirewallRuleRequest, callback func(response *CreateFirewallRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFirewallRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateFirewallRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFirewallRuleRequest is the request struct for api CreateFirewallRule
type CreateFirewallRuleRequest struct {
	*requests.RpcRequest
	ClientToken  string `position:"Query" name:"ClientToken"`
	Remark       string `position:"Query" name:"Remark"`
	InstanceId   string `position:"Query" name:"InstanceId"`
	RuleProtocol string `position:"Query" name:"RuleProtocol"`
	Port         string `position:"Query" name:"Port"`
}

// CreateFirewallRuleResponse is the response struct for api CreateFirewallRule
type CreateFirewallRuleResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	FirewallId string `json:"FirewallId" xml:"FirewallId"`
}

// CreateCreateFirewallRuleRequest creates a request to invoke CreateFirewallRule API
func CreateCreateFirewallRuleRequest() (request *CreateFirewallRuleRequest) {
	request = &CreateFirewallRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "CreateFirewallRule", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateFirewallRuleResponse creates a response to parse from CreateFirewallRule response
func CreateCreateFirewallRuleResponse() (response *CreateFirewallRuleResponse) {
	response = &CreateFirewallRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
