package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTrademarkMonitorRules invokes the trademark.QueryTrademarkMonitorRules API synchronously
// api document: https://help.aliyun.com/api/trademark/querytrademarkmonitorrules.html
func (client *Client) QueryTrademarkMonitorRules(request *QueryTrademarkMonitorRulesRequest) (response *QueryTrademarkMonitorRulesResponse, err error) {
	response = CreateQueryTrademarkMonitorRulesResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTrademarkMonitorRulesWithChan invokes the trademark.QueryTrademarkMonitorRules API asynchronously
// api document: https://help.aliyun.com/api/trademark/querytrademarkmonitorrules.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTrademarkMonitorRulesWithChan(request *QueryTrademarkMonitorRulesRequest) (<-chan *QueryTrademarkMonitorRulesResponse, <-chan error) {
	responseChan := make(chan *QueryTrademarkMonitorRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTrademarkMonitorRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTrademarkMonitorRulesWithCallback invokes the trademark.QueryTrademarkMonitorRules API asynchronously
// api document: https://help.aliyun.com/api/trademark/querytrademarkmonitorrules.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTrademarkMonitorRulesWithCallback(request *QueryTrademarkMonitorRulesRequest, callback func(response *QueryTrademarkMonitorRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTrademarkMonitorRulesResponse
		var err error
		defer close(result)
		response, err = client.QueryTrademarkMonitorRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTrademarkMonitorRulesRequest is the request struct for api QueryTrademarkMonitorRules
type QueryTrademarkMonitorRulesRequest struct {
	*requests.RpcRequest
	NotifyUpdate requests.Integer `position:"Query" name:"NotifyUpdate"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	RuleName     string           `position:"Query" name:"RuleName"`
	Id           string           `position:"Query" name:"Id"`
	PageNum      requests.Integer `position:"Query" name:"PageNum"`
}

// QueryTrademarkMonitorRulesResponse is the response struct for api QueryTrademarkMonitorRules
type QueryTrademarkMonitorRulesResponse struct {
	*responses.BaseResponse
	RequestId      string                           `json:"RequestId" xml:"RequestId"`
	TotalItemNum   int                              `json:"TotalItemNum" xml:"TotalItemNum"`
	CurrentPageNum int                              `json:"CurrentPageNum" xml:"CurrentPageNum"`
	PageSize       int                              `json:"PageSize" xml:"PageSize"`
	TotalPageNum   int                              `json:"TotalPageNum" xml:"TotalPageNum"`
	PrePage        bool                             `json:"PrePage" xml:"PrePage"`
	NextPage       bool                             `json:"NextPage" xml:"NextPage"`
	Data           DataInQueryTrademarkMonitorRules `json:"Data" xml:"Data"`
}

// CreateQueryTrademarkMonitorRulesRequest creates a request to invoke QueryTrademarkMonitorRules API
func CreateQueryTrademarkMonitorRulesRequest() (request *QueryTrademarkMonitorRulesRequest) {
	request = &QueryTrademarkMonitorRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "QueryTrademarkMonitorRules", "trademark", "openAPI")
	return
}

// CreateQueryTrademarkMonitorRulesResponse creates a response to parse from QueryTrademarkMonitorRules response
func CreateQueryTrademarkMonitorRulesResponse() (response *QueryTrademarkMonitorRulesResponse) {
	response = &QueryTrademarkMonitorRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
