package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUdfArtifact invokes the ververica.GetUdfArtifact API synchronously
func (client *Client) GetUdfArtifact(request *GetUdfArtifactRequest) (response *GetUdfArtifactResponse, err error) {
	response = CreateGetUdfArtifactResponse()
	err = client.DoAction(request, response)
	return
}

// GetUdfArtifactWithChan invokes the ververica.GetUdfArtifact API asynchronously
func (client *Client) GetUdfArtifactWithChan(request *GetUdfArtifactRequest) (<-chan *GetUdfArtifactResponse, <-chan error) {
	responseChan := make(chan *GetUdfArtifactResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUdfArtifact(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUdfArtifactWithCallback invokes the ververica.GetUdfArtifact API asynchronously
func (client *Client) GetUdfArtifactWithCallback(request *GetUdfArtifactRequest, callback func(response *GetUdfArtifactResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUdfArtifactResponse
		var err error
		defer close(result)
		response, err = client.GetUdfArtifact(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUdfArtifactRequest is the request struct for api GetUdfArtifact
type GetUdfArtifactRequest struct {
	*requests.RoaRequest
	Workspace            string           `position:"Path" name:"workspace"`
	RequireFunctionNames requests.Boolean `position:"Query" name:"requireFunctionNames"`
	Namespace            string           `position:"Path" name:"namespace"`
	UdfArtifactName      string           `position:"Path" name:"udfArtifactName"`
}

// GetUdfArtifactResponse is the response struct for api GetUdfArtifact
type GetUdfArtifactResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	Data      string `json:"data" xml:"data"`
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateGetUdfArtifactRequest creates a request to invoke GetUdfArtifact API
func CreateGetUdfArtifactRequest() (request *GetUdfArtifactRequest) {
	request = &GetUdfArtifactRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "GetUdfArtifact", "/pop/workspaces/[workspace]/sql/v1beta1/namespaces/[namespace]/udfartifacts/[udfArtifactName]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetUdfArtifactResponse creates a response to parse from GetUdfArtifact response
func CreateGetUdfArtifactResponse() (response *GetUdfArtifactResponse) {
	response = &GetUdfArtifactResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
