package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDataReflowData invokes the viapi_regen.DeleteDataReflowData API synchronously
func (client *Client) DeleteDataReflowData(request *DeleteDataReflowDataRequest) (response *DeleteDataReflowDataResponse, err error) {
	response = CreateDeleteDataReflowDataResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDataReflowDataWithChan invokes the viapi_regen.DeleteDataReflowData API asynchronously
func (client *Client) DeleteDataReflowDataWithChan(request *DeleteDataReflowDataRequest) (<-chan *DeleteDataReflowDataResponse, <-chan error) {
	responseChan := make(chan *DeleteDataReflowDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDataReflowData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDataReflowDataWithCallback invokes the viapi_regen.DeleteDataReflowData API asynchronously
func (client *Client) DeleteDataReflowDataWithCallback(request *DeleteDataReflowDataRequest, callback func(response *DeleteDataReflowDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDataReflowDataResponse
		var err error
		defer close(result)
		response, err = client.DeleteDataReflowData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDataReflowDataRequest is the request struct for api DeleteDataReflowData
type DeleteDataReflowDataRequest struct {
	*requests.RpcRequest
	Id        requests.Integer `position:"Body" name:"Id"`
	ServiceId requests.Integer `position:"Body" name:"ServiceId"`
}

// DeleteDataReflowDataResponse is the response struct for api DeleteDataReflowData
type DeleteDataReflowDataResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDeleteDataReflowDataRequest creates a request to invoke DeleteDataReflowData API
func CreateDeleteDataReflowDataRequest() (request *DeleteDataReflowDataRequest) {
	request = &DeleteDataReflowDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "DeleteDataReflowData", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDataReflowDataResponse creates a response to parse from DeleteDataReflowData response
func CreateDeleteDataReflowDataResponse() (response *DeleteDataReflowDataResponse) {
	response = &DeleteDataReflowDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
