package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetDatasetUserOssPath invokes the viapi_regen.SetDatasetUserOssPath API synchronously
func (client *Client) SetDatasetUserOssPath(request *SetDatasetUserOssPathRequest) (response *SetDatasetUserOssPathResponse, err error) {
	response = CreateSetDatasetUserOssPathResponse()
	err = client.DoAction(request, response)
	return
}

// SetDatasetUserOssPathWithChan invokes the viapi_regen.SetDatasetUserOssPath API asynchronously
func (client *Client) SetDatasetUserOssPathWithChan(request *SetDatasetUserOssPathRequest) (<-chan *SetDatasetUserOssPathResponse, <-chan error) {
	responseChan := make(chan *SetDatasetUserOssPathResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetDatasetUserOssPath(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetDatasetUserOssPathWithCallback invokes the viapi_regen.SetDatasetUserOssPath API asynchronously
func (client *Client) SetDatasetUserOssPathWithCallback(request *SetDatasetUserOssPathRequest, callback func(response *SetDatasetUserOssPathResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetDatasetUserOssPathResponse
		var err error
		defer close(result)
		response, err = client.SetDatasetUserOssPath(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetDatasetUserOssPathRequest is the request struct for api SetDatasetUserOssPath
type SetDatasetUserOssPathRequest struct {
	*requests.RpcRequest
	UserOssUrl string           `position:"Body" name:"UserOssUrl"`
	DatasetId  requests.Integer `position:"Body" name:"DatasetId"`
}

// SetDatasetUserOssPathResponse is the response struct for api SetDatasetUserOssPath
type SetDatasetUserOssPathResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSetDatasetUserOssPathRequest creates a request to invoke SetDatasetUserOssPath API
func CreateSetDatasetUserOssPathRequest() (request *SetDatasetUserOssPathRequest) {
	request = &SetDatasetUserOssPathRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "SetDatasetUserOssPath", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetDatasetUserOssPathResponse creates a response to parse from SetDatasetUserOssPath response
func CreateSetDatasetUserOssPathResponse() (response *SetDatasetUserOssPathResponse) {
	response = &SetDatasetUserOssPathResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
