package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteVsPullStreamInfoConfig invokes the vs.DeleteVsPullStreamInfoConfig API synchronously
func (client *Client) DeleteVsPullStreamInfoConfig(request *DeleteVsPullStreamInfoConfigRequest) (response *DeleteVsPullStreamInfoConfigResponse, err error) {
	response = CreateDeleteVsPullStreamInfoConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteVsPullStreamInfoConfigWithChan invokes the vs.DeleteVsPullStreamInfoConfig API asynchronously
func (client *Client) DeleteVsPullStreamInfoConfigWithChan(request *DeleteVsPullStreamInfoConfigRequest) (<-chan *DeleteVsPullStreamInfoConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteVsPullStreamInfoConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteVsPullStreamInfoConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteVsPullStreamInfoConfigWithCallback invokes the vs.DeleteVsPullStreamInfoConfig API asynchronously
func (client *Client) DeleteVsPullStreamInfoConfigWithCallback(request *DeleteVsPullStreamInfoConfigRequest, callback func(response *DeleteVsPullStreamInfoConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteVsPullStreamInfoConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteVsPullStreamInfoConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteVsPullStreamInfoConfigRequest is the request struct for api DeleteVsPullStreamInfoConfig
type DeleteVsPullStreamInfoConfigRequest struct {
	*requests.RpcRequest
	AppName    string           `position:"Query" name:"AppName"`
	StreamName string           `position:"Query" name:"StreamName"`
	ShowLog    string           `position:"Query" name:"ShowLog"`
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteVsPullStreamInfoConfigResponse is the response struct for api DeleteVsPullStreamInfoConfig
type DeleteVsPullStreamInfoConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteVsPullStreamInfoConfigRequest creates a request to invoke DeleteVsPullStreamInfoConfig API
func CreateDeleteVsPullStreamInfoConfigRequest() (request *DeleteVsPullStreamInfoConfigRequest) {
	request = &DeleteVsPullStreamInfoConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DeleteVsPullStreamInfoConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteVsPullStreamInfoConfigResponse creates a response to parse from DeleteVsPullStreamInfoConfig response
func CreateDeleteVsPullStreamInfoConfigResponse() (response *DeleteVsPullStreamInfoConfigResponse) {
	response = &DeleteVsPullStreamInfoConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
