package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpgradeRenderingDevicesHostOS invokes the vs.UpgradeRenderingDevicesHostOS API synchronously
func (client *Client) UpgradeRenderingDevicesHostOS(request *UpgradeRenderingDevicesHostOSRequest) (response *UpgradeRenderingDevicesHostOSResponse, err error) {
	response = CreateUpgradeRenderingDevicesHostOSResponse()
	err = client.DoAction(request, response)
	return
}

// UpgradeRenderingDevicesHostOSWithChan invokes the vs.UpgradeRenderingDevicesHostOS API asynchronously
func (client *Client) UpgradeRenderingDevicesHostOSWithChan(request *UpgradeRenderingDevicesHostOSRequest) (<-chan *UpgradeRenderingDevicesHostOSResponse, <-chan error) {
	responseChan := make(chan *UpgradeRenderingDevicesHostOSResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpgradeRenderingDevicesHostOS(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpgradeRenderingDevicesHostOSWithCallback invokes the vs.UpgradeRenderingDevicesHostOS API asynchronously
func (client *Client) UpgradeRenderingDevicesHostOSWithCallback(request *UpgradeRenderingDevicesHostOSRequest, callback func(response *UpgradeRenderingDevicesHostOSResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpgradeRenderingDevicesHostOSResponse
		var err error
		defer close(result)
		response, err = client.UpgradeRenderingDevicesHostOS(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpgradeRenderingDevicesHostOSRequest is the request struct for api UpgradeRenderingDevicesHostOS
type UpgradeRenderingDevicesHostOSRequest struct {
	*requests.RpcRequest
	ImageId     string           `position:"Query" name:"ImageId"`
	RomPath     string           `position:"Query" name:"RomPath"`
	ShowLog     string           `position:"Query" name:"ShowLog"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	InstanceIds string           `position:"Query" name:"InstanceIds"`
	RomName     string           `position:"Query" name:"RomName"`
	RomVersion  string           `position:"Query" name:"RomVersion"`
}

// UpgradeRenderingDevicesHostOSResponse is the response struct for api UpgradeRenderingDevicesHostOS
type UpgradeRenderingDevicesHostOSResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpgradeRenderingDevicesHostOSRequest creates a request to invoke UpgradeRenderingDevicesHostOS API
func CreateUpgradeRenderingDevicesHostOSRequest() (request *UpgradeRenderingDevicesHostOSRequest) {
	request = &UpgradeRenderingDevicesHostOSRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "UpgradeRenderingDevicesHostOS", "", "")
	request.Method = requests.POST
	return
}

// CreateUpgradeRenderingDevicesHostOSResponse creates a response to parse from UpgradeRenderingDevicesHostOS response
func CreateUpgradeRenderingDevicesHostOSResponse() (response *UpgradeRenderingDevicesHostOSResponse) {
	response = &UpgradeRenderingDevicesHostOSResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
