package waf_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceInfo invokes the waf_openapi.DescribeInstanceInfo API synchronously
func (client *Client) DescribeInstanceInfo(request *DescribeInstanceInfoRequest) (response *DescribeInstanceInfoResponse, err error) {
	response = CreateDescribeInstanceInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceInfoWithChan invokes the waf_openapi.DescribeInstanceInfo API asynchronously
func (client *Client) DescribeInstanceInfoWithChan(request *DescribeInstanceInfoRequest) (<-chan *DescribeInstanceInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceInfoWithCallback invokes the waf_openapi.DescribeInstanceInfo API asynchronously
func (client *Client) DescribeInstanceInfoWithCallback(request *DescribeInstanceInfoRequest, callback func(response *DescribeInstanceInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceInfoRequest is the request struct for api DescribeInstanceInfo
type DescribeInstanceInfoRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	InstanceSource  string `position:"Query" name:"InstanceSource"`
	Lang            string `position:"Query" name:"Lang"`
	InstanceId      string `position:"Query" name:"InstanceId"`
}

// DescribeInstanceInfoResponse is the response struct for api DescribeInstanceInfo
type DescribeInstanceInfoResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	InstanceInfo InstanceInfo `json:"InstanceInfo" xml:"InstanceInfo"`
}

// CreateDescribeInstanceInfoRequest creates a request to invoke DescribeInstanceInfo API
func CreateDescribeInstanceInfoRequest() (request *DescribeInstanceInfoRequest) {
	request = &DescribeInstanceInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("waf-openapi", "2019-09-10", "DescribeInstanceInfo", "waf", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceInfoResponse creates a response to parse from DescribeInstanceInfo response
func CreateDescribeInstanceInfoResponse() (response *DescribeInstanceInfoResponse) {
	response = &DescribeInstanceInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
