package planner_test


import "csv"
import "testing"
import "planner"

inData =
    "
#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double
#group,false,false,false,false,false,true,true,true,true,false
#default,_result,,,,,,,,,
,result,table,_time,_start,_stop,_measurement,_field,t0,t1,_value
,,0,2019-11-25T00:00:00Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-0,1.0
,,0,2019-11-25T00:00:10Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-0,2.0
,,0,2019-11-25T00:00:20Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-0,3.0
,,0,2019-11-25T00:00:30Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-0,4.0
,,0,2019-11-25T00:00:40Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-0,1.0
,,0,2019-11-25T00:00:50Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-0,2.0
,,0,2019-11-25T00:01:00Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-0,3.0
,,0,2019-11-25T00:01:10Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-0,4.0
,,0,2019-11-25T00:01:20Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-0,1.0
,,0,2019-11-25T00:01:30Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-0,2.0
,,0,2019-11-25T00:01:40Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-0,3.0
,,0,2019-11-25T00:01:50Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-0,4.0

,,1,2019-11-25T00:00:00Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-1,5.0
,,1,2019-11-25T00:00:10Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-1,6.0
,,1,2019-11-25T00:00:20Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-1,7.0
,,1,2019-11-25T00:00:30Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-1,8.0
,,1,2019-11-25T00:00:40Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-1,5.0
,,1,2019-11-25T00:00:50Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-1,6.0
,,1,2019-11-25T00:01:00Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-1,7.0
,,1,2019-11-25T00:01:10Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-1,8.0
,,1,2019-11-25T00:01:20Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-1,5.0
,,1,2019-11-25T00:01:30Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-1,6.0
,,1,2019-11-25T00:01:40Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-1,7.0
,,1,2019-11-25T00:01:50Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-0,b-1,8.0

,,2,2019-11-25T00:00:00Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-0,1.0
,,2,2019-11-25T00:00:10Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-0,2.0
,,2,2019-11-25T00:00:20Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-0,3.0
,,2,2019-11-25T00:00:30Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-0,4.0
,,2,2019-11-25T00:00:40Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-0,1.0
,,2,2019-11-25T00:00:50Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-0,2.0
,,2,2019-11-25T00:01:00Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-0,3.0
,,2,2019-11-25T00:01:10Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-0,4.0
,,2,2019-11-25T00:01:20Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-0,1.0
,,2,2019-11-25T00:01:30Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-0,2.0
,,2,2019-11-25T00:01:40Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-0,3.0
,,2,2019-11-25T00:01:50Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-0,4.0

,,3,2019-11-25T00:00:00Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-1,5.0
,,3,2019-11-25T00:00:10Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-1,6.0
,,3,2019-11-25T00:00:20Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-1,7.0
,,3,2019-11-25T00:00:30Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-1,8.0
,,3,2019-11-25T00:00:40Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-1,5.0
,,3,2019-11-25T00:00:50Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-1,6.0
,,3,2019-11-25T00:01:00Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-1,7.0
,,3,2019-11-25T00:01:10Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-1,8.0
,,3,2019-11-25T00:01:20Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-1,5.0
,,3,2019-11-25T00:01:30Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-1,6.0
,,3,2019-11-25T00:01:40Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-1,7.0
,,3,2019-11-25T00:01:50Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-1,b-1,8.0

,,4,2019-11-25T00:00:00Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-0,1.0
,,4,2019-11-25T00:00:10Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-0,2.0
,,4,2019-11-25T00:00:20Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-0,3.0
,,4,2019-11-25T00:00:30Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-0,4.0
,,4,2019-11-25T00:00:40Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-0,1.0
,,4,2019-11-25T00:00:50Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-0,2.0
,,4,2019-11-25T00:01:00Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-0,3.0
,,4,2019-11-25T00:01:10Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-0,4.0
,,4,2019-11-25T00:01:20Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-0,1.0
,,4,2019-11-25T00:01:30Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-0,2.0
,,4,2019-11-25T00:01:40Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-0,3.0
,,4,2019-11-25T00:01:50Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-0,4.0

,,5,2019-11-25T00:00:00Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-1,5.0
,,5,2019-11-25T00:00:10Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-1,6.0
,,5,2019-11-25T00:00:20Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-1,7.0
,,5,2019-11-25T00:00:30Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-1,8.0
,,5,2019-11-25T00:00:40Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-1,5.0
,,5,2019-11-25T00:00:50Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-1,6.0
,,5,2019-11-25T00:01:00Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-1,7.0
,,5,2019-11-25T00:01:10Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-1,8.0
,,5,2019-11-25T00:01:20Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-1,5.0
,,5,2019-11-25T00:01:30Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-1,6.0
,,5,2019-11-25T00:01:40Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-1,7.0
,,5,2019-11-25T00:01:50Z,2019-11-25T00:00:00Z,2030-01-01T00:00:00Z,m0,f0,a-2,b-1,8.0
"

testcase group_min_table {
    result =
        csv.from(csv: inData)
            |> testing.load()
            |> range(start: 2019-11-25T00:00:00Z, stop: 2030-01-01T00:00:00Z)
            |> group(columns: ["t0"])
            |> min()
            |> drop(columns: ["_start", "_stop"])
    out_min_table =
        "
#datatype,string,long,dateTime:RFC3339,string,string,string,string,double
#group,false,false,false,false,false,true,false,false
#default,_result,,,,,,,
,result,table,_time,_measurement,_field,t0,t1,_value
,,0,2019-11-25T00:00:00Z,m0,f0,a-0,b-0,1.0
,,1,2019-11-25T00:00:00Z,m0,f0,a-1,b-0,1.0
,,2,2019-11-25T00:00:00Z,m0,f0,a-2,b-0,1.0
"

    testing.diff(got: result, want: csv.from(csv: out_min_table)) |> yield()
}
testcase group_max_table {
    result =
        csv.from(csv: inData)
            |> testing.load()
            |> range(start: 2019-11-25T00:00:00Z, stop: 2030-01-01T00:00:00Z)
            |> group(columns: ["t0"])
            |> max()
            |> drop(columns: ["_start", "_stop"])
    out_max_table =
        "
#datatype,string,long,dateTime:RFC3339,string,string,string,string,double
#group,false,false,false,false,false,true,false,false
#default,_result,,,,,,,
,result,table,_time,_measurement,_field,t0,t1,_value
,,0,2019-11-25T00:00:30Z,m0,f0,a-0,b-1,8.0
,,1,2019-11-25T00:00:30Z,m0,f0,a-1,b-1,8.0
,,2,2019-11-25T00:00:30Z,m0,f0,a-2,b-1,8.0
"

    testing.diff(got: result, want: csv.from(csv: out_max_table)) |> yield()
}
testcase group_no_agg_table {
    result =
        csv.from(csv: inData)
            |> testing.load()
            |> range(start: 2019-11-25T00:00:00Z, stop: 2030-01-01T00:00:00Z)
            |> group(columns: ["t0"])
            |> drop(columns: ["_start", "_stop"])
            |> sort(columns: ["t1", "_time"])
    out_no_agg_table =
        "
#datatype,string,long,dateTime:RFC3339,string,string,string,string,double
#group,false,false,false,false,false,true,false,false
#default,_result,,,,,,,
,result,table,_time,_measurement,_field,t0,t1,_value
,,0,2019-11-25T00:00:00Z,m0,f0,a-0,b-0,1.0
,,0,2019-11-25T00:00:10Z,m0,f0,a-0,b-0,2.0
,,0,2019-11-25T00:00:20Z,m0,f0,a-0,b-0,3.0
,,0,2019-11-25T00:00:30Z,m0,f0,a-0,b-0,4.0
,,0,2019-11-25T00:00:40Z,m0,f0,a-0,b-0,1.0
,,0,2019-11-25T00:00:50Z,m0,f0,a-0,b-0,2.0
,,0,2019-11-25T00:01:00Z,m0,f0,a-0,b-0,3.0
,,0,2019-11-25T00:01:10Z,m0,f0,a-0,b-0,4.0
,,0,2019-11-25T00:01:20Z,m0,f0,a-0,b-0,1.0
,,0,2019-11-25T00:01:30Z,m0,f0,a-0,b-0,2.0
,,0,2019-11-25T00:01:40Z,m0,f0,a-0,b-0,3.0
,,0,2019-11-25T00:01:50Z,m0,f0,a-0,b-0,4.0
,,0,2019-11-25T00:00:00Z,m0,f0,a-0,b-1,5.0
,,0,2019-11-25T00:00:10Z,m0,f0,a-0,b-1,6.0
,,0,2019-11-25T00:00:20Z,m0,f0,a-0,b-1,7.0
,,0,2019-11-25T00:00:30Z,m0,f0,a-0,b-1,8.0
,,0,2019-11-25T00:00:40Z,m0,f0,a-0,b-1,5.0
,,0,2019-11-25T00:00:50Z,m0,f0,a-0,b-1,6.0
,,0,2019-11-25T00:01:00Z,m0,f0,a-0,b-1,7.0
,,0,2019-11-25T00:01:10Z,m0,f0,a-0,b-1,8.0
,,0,2019-11-25T00:01:20Z,m0,f0,a-0,b-1,5.0
,,0,2019-11-25T00:01:30Z,m0,f0,a-0,b-1,6.0
,,0,2019-11-25T00:01:40Z,m0,f0,a-0,b-1,7.0
,,0,2019-11-25T00:01:50Z,m0,f0,a-0,b-1,8.0
,,1,2019-11-25T00:00:00Z,m0,f0,a-1,b-0,1.0
,,1,2019-11-25T00:00:10Z,m0,f0,a-1,b-0,2.0
,,1,2019-11-25T00:00:20Z,m0,f0,a-1,b-0,3.0
,,1,2019-11-25T00:00:30Z,m0,f0,a-1,b-0,4.0
,,1,2019-11-25T00:00:40Z,m0,f0,a-1,b-0,1.0
,,1,2019-11-25T00:00:50Z,m0,f0,a-1,b-0,2.0
,,1,2019-11-25T00:01:00Z,m0,f0,a-1,b-0,3.0
,,1,2019-11-25T00:01:10Z,m0,f0,a-1,b-0,4.0
,,1,2019-11-25T00:01:20Z,m0,f0,a-1,b-0,1.0
,,1,2019-11-25T00:01:30Z,m0,f0,a-1,b-0,2.0
,,1,2019-11-25T00:01:40Z,m0,f0,a-1,b-0,3.0
,,1,2019-11-25T00:01:50Z,m0,f0,a-1,b-0,4.0
,,1,2019-11-25T00:00:00Z,m0,f0,a-1,b-1,5.0
,,1,2019-11-25T00:00:10Z,m0,f0,a-1,b-1,6.0
,,1,2019-11-25T00:00:20Z,m0,f0,a-1,b-1,7.0
,,1,2019-11-25T00:00:30Z,m0,f0,a-1,b-1,8.0
,,1,2019-11-25T00:00:40Z,m0,f0,a-1,b-1,5.0
,,1,2019-11-25T00:00:50Z,m0,f0,a-1,b-1,6.0
,,1,2019-11-25T00:01:00Z,m0,f0,a-1,b-1,7.0
,,1,2019-11-25T00:01:10Z,m0,f0,a-1,b-1,8.0
,,1,2019-11-25T00:01:20Z,m0,f0,a-1,b-1,5.0
,,1,2019-11-25T00:01:30Z,m0,f0,a-1,b-1,6.0
,,1,2019-11-25T00:01:40Z,m0,f0,a-1,b-1,7.0
,,1,2019-11-25T00:01:50Z,m0,f0,a-1,b-1,8.0
,,2,2019-11-25T00:00:00Z,m0,f0,a-2,b-0,1.0
,,2,2019-11-25T00:00:10Z,m0,f0,a-2,b-0,2.0
,,2,2019-11-25T00:00:20Z,m0,f0,a-2,b-0,3.0
,,2,2019-11-25T00:00:30Z,m0,f0,a-2,b-0,4.0
,,2,2019-11-25T00:00:40Z,m0,f0,a-2,b-0,1.0
,,2,2019-11-25T00:00:50Z,m0,f0,a-2,b-0,2.0
,,2,2019-11-25T00:01:00Z,m0,f0,a-2,b-0,3.0
,,2,2019-11-25T00:01:10Z,m0,f0,a-2,b-0,4.0
,,2,2019-11-25T00:01:20Z,m0,f0,a-2,b-0,1.0
,,2,2019-11-25T00:01:30Z,m0,f0,a-2,b-0,2.0
,,2,2019-11-25T00:01:40Z,m0,f0,a-2,b-0,3.0
,,2,2019-11-25T00:01:50Z,m0,f0,a-2,b-0,4.0
,,2,2019-11-25T00:00:00Z,m0,f0,a-2,b-1,5.0
,,2,2019-11-25T00:00:10Z,m0,f0,a-2,b-1,6.0
,,2,2019-11-25T00:00:20Z,m0,f0,a-2,b-1,7.0
,,2,2019-11-25T00:00:30Z,m0,f0,a-2,b-1,8.0
,,2,2019-11-25T00:00:40Z,m0,f0,a-2,b-1,5.0
,,2,2019-11-25T00:00:50Z,m0,f0,a-2,b-1,6.0
,,2,2019-11-25T00:01:00Z,m0,f0,a-2,b-1,7.0
,,2,2019-11-25T00:01:10Z,m0,f0,a-2,b-1,8.0
,,2,2019-11-25T00:01:20Z,m0,f0,a-2,b-1,5.0
,,2,2019-11-25T00:01:30Z,m0,f0,a-2,b-1,6.0
,,2,2019-11-25T00:01:40Z,m0,f0,a-2,b-1,7.0
,,2,2019-11-25T00:01:50Z,m0,f0,a-2,b-1,8.0
"

    testing.diff(got: result, want: csv.from(csv: out_no_agg_table)) |> yield()
}
