// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.9
// source: google/devtools/testing/v1/test_execution.proto

package testing

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies how to execute the test.
type OrchestratorOption int32

const (
	// Default value: the server will choose the mode. Currently implies that
	// the test will run without the orchestrator. In the future,
	// all instrumentation tests will be run with the orchestrator.
	// Using the orchestrator is highly encouraged because of all the benefits it
	// offers.
	OrchestratorOption_ORCHESTRATOR_OPTION_UNSPECIFIED OrchestratorOption = 0
	// Run test using orchestrator.
	// ** Only compatible with AndroidJUnitRunner version 1.1 or higher! **
	// Recommended.
	OrchestratorOption_USE_ORCHESTRATOR OrchestratorOption = 1
	// Run test without using orchestrator.
	OrchestratorOption_DO_NOT_USE_ORCHESTRATOR OrchestratorOption = 2
)

// Enum value maps for OrchestratorOption.
var (
	OrchestratorOption_name = map[int32]string{
		0: "ORCHESTRATOR_OPTION_UNSPECIFIED",
		1: "USE_ORCHESTRATOR",
		2: "DO_NOT_USE_ORCHESTRATOR",
	}
	OrchestratorOption_value = map[string]int32{
		"ORCHESTRATOR_OPTION_UNSPECIFIED": 0,
		"USE_ORCHESTRATOR":                1,
		"DO_NOT_USE_ORCHESTRATOR":         2,
	}
)

func (x OrchestratorOption) Enum() *OrchestratorOption {
	p := new(OrchestratorOption)
	*p = x
	return p
}

func (x OrchestratorOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OrchestratorOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_testing_v1_test_execution_proto_enumTypes[0].Descriptor()
}

func (OrchestratorOption) Type() protoreflect.EnumType {
	return &file_google_devtools_testing_v1_test_execution_proto_enumTypes[0]
}

func (x OrchestratorOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OrchestratorOption.Descriptor instead.
func (OrchestratorOption) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{0}
}

// The mode in which Robo should run.
type RoboMode int32

const (
	// This means that the server should choose the mode.
	// Recommended.
	RoboMode_ROBO_MODE_UNSPECIFIED RoboMode = 0
	// Runs Robo in UIAutomator-only mode without app resigning
	RoboMode_ROBO_VERSION_1 RoboMode = 1
	// Runs Robo in standard Espresso with UIAutomator fallback
	RoboMode_ROBO_VERSION_2 RoboMode = 2
)

// Enum value maps for RoboMode.
var (
	RoboMode_name = map[int32]string{
		0: "ROBO_MODE_UNSPECIFIED",
		1: "ROBO_VERSION_1",
		2: "ROBO_VERSION_2",
	}
	RoboMode_value = map[string]int32{
		"ROBO_MODE_UNSPECIFIED": 0,
		"ROBO_VERSION_1":        1,
		"ROBO_VERSION_2":        2,
	}
)

func (x RoboMode) Enum() *RoboMode {
	p := new(RoboMode)
	*p = x
	return p
}

func (x RoboMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RoboMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_testing_v1_test_execution_proto_enumTypes[1].Descriptor()
}

func (RoboMode) Type() protoreflect.EnumType {
	return &file_google_devtools_testing_v1_test_execution_proto_enumTypes[1]
}

func (x RoboMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RoboMode.Descriptor instead.
func (RoboMode) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{1}
}

// Actions which Robo can perform on UI elements.
type RoboActionType int32

const (
	// DO NOT USE. For proto versioning only.
	RoboActionType_ACTION_TYPE_UNSPECIFIED RoboActionType = 0
	// Direct Robo to click on the specified element. No-op if specified element
	// is not clickable.
	RoboActionType_SINGLE_CLICK RoboActionType = 1
	// Direct Robo to enter text on the specified element. No-op if specified
	// element is not enabled or does not allow text entry.
	RoboActionType_ENTER_TEXT RoboActionType = 2
	// Direct Robo to ignore interactions with a specific element.
	RoboActionType_IGNORE RoboActionType = 3
)

// Enum value maps for RoboActionType.
var (
	RoboActionType_name = map[int32]string{
		0: "ACTION_TYPE_UNSPECIFIED",
		1: "SINGLE_CLICK",
		2: "ENTER_TEXT",
		3: "IGNORE",
	}
	RoboActionType_value = map[string]int32{
		"ACTION_TYPE_UNSPECIFIED": 0,
		"SINGLE_CLICK":            1,
		"ENTER_TEXT":              2,
		"IGNORE":                  3,
	}
)

func (x RoboActionType) Enum() *RoboActionType {
	p := new(RoboActionType)
	*p = x
	return p
}

func (x RoboActionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RoboActionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_testing_v1_test_execution_proto_enumTypes[2].Descriptor()
}

func (RoboActionType) Type() protoreflect.EnumType {
	return &file_google_devtools_testing_v1_test_execution_proto_enumTypes[2]
}

func (x RoboActionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RoboActionType.Descriptor instead.
func (RoboActionType) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{2}
}

// The detailed reason that a Matrix was deemed INVALID.
type InvalidMatrixDetails int32

const (
	// Do not use. For proto versioning only.
	InvalidMatrixDetails_INVALID_MATRIX_DETAILS_UNSPECIFIED InvalidMatrixDetails = 0
	// The matrix is INVALID, but there are no further details available.
	InvalidMatrixDetails_DETAILS_UNAVAILABLE InvalidMatrixDetails = 1
	// The input app APK could not be parsed.
	InvalidMatrixDetails_MALFORMED_APK InvalidMatrixDetails = 2
	// The input test APK could not be parsed.
	InvalidMatrixDetails_MALFORMED_TEST_APK InvalidMatrixDetails = 3
	// The AndroidManifest.xml could not be found.
	InvalidMatrixDetails_NO_MANIFEST InvalidMatrixDetails = 4
	// The APK manifest does not declare a package name.
	InvalidMatrixDetails_NO_PACKAGE_NAME InvalidMatrixDetails = 5
	// The APK application ID (aka package name) is invalid.
	// See also
	// https://developer.android.com/studio/build/application-id
	InvalidMatrixDetails_INVALID_PACKAGE_NAME InvalidMatrixDetails = 31
	// The test package and app package are the same.
	InvalidMatrixDetails_TEST_SAME_AS_APP InvalidMatrixDetails = 6
	// The test apk does not declare an instrumentation.
	InvalidMatrixDetails_NO_INSTRUMENTATION InvalidMatrixDetails = 7
	// The input app apk does not have a signature.
	InvalidMatrixDetails_NO_SIGNATURE InvalidMatrixDetails = 20
	// The test runner class specified by user or in the test APK's manifest file
	// is not compatible with Android Test Orchestrator.
	// Orchestrator is only compatible with AndroidJUnitRunner version 1.1 or
	// higher.
	// Orchestrator can be disabled by using DO_NOT_USE_ORCHESTRATOR
	// OrchestratorOption.
	InvalidMatrixDetails_INSTRUMENTATION_ORCHESTRATOR_INCOMPATIBLE InvalidMatrixDetails = 18
	// The test APK does not contain the test runner class specified by user or in
	// the manifest file.
	// This can be caused by either of the following reasons:
	// - the user provided a runner class name that's incorrect, or
	// - the test runner isn't built into the test APK (might be in the app APK
	// instead).
	InvalidMatrixDetails_NO_TEST_RUNNER_CLASS InvalidMatrixDetails = 19
	// A main launcher activity could not be found.
	InvalidMatrixDetails_NO_LAUNCHER_ACTIVITY InvalidMatrixDetails = 8
	// The app declares one or more permissions that are not allowed.
	InvalidMatrixDetails_FORBIDDEN_PERMISSIONS InvalidMatrixDetails = 9
	// There is a conflict in the provided robo_directives.
	InvalidMatrixDetails_INVALID_ROBO_DIRECTIVES InvalidMatrixDetails = 10
	// There is at least one invalid resource name in the provided
	// robo directives
	InvalidMatrixDetails_INVALID_RESOURCE_NAME InvalidMatrixDetails = 33
	// Invalid definition of action in the robo directives
	// (e.g. a click or ignore action includes an input text field)
	InvalidMatrixDetails_INVALID_DIRECTIVE_ACTION InvalidMatrixDetails = 34
	// There is no test loop intent filter, or the one that is given is
	// not formatted correctly.
	InvalidMatrixDetails_TEST_LOOP_INTENT_FILTER_NOT_FOUND InvalidMatrixDetails = 12
	// The request contains a scenario label that was not declared in the
	// manifest.
	InvalidMatrixDetails_SCENARIO_LABEL_NOT_DECLARED InvalidMatrixDetails = 13
	// There was an error when parsing a label's value.
	InvalidMatrixDetails_SCENARIO_LABEL_MALFORMED InvalidMatrixDetails = 14
	// The request contains a scenario number that was not declared in the
	// manifest.
	InvalidMatrixDetails_SCENARIO_NOT_DECLARED InvalidMatrixDetails = 15
	// Device administrator applications are not allowed.
	InvalidMatrixDetails_DEVICE_ADMIN_RECEIVER InvalidMatrixDetails = 17
	// The zipped XCTest was malformed. The zip did not contain a single
	// .xctestrun file and the contents of the DerivedData/Build/Products
	// directory.
	InvalidMatrixDetails_MALFORMED_XC_TEST_ZIP InvalidMatrixDetails = 11
	// The zipped XCTest was built for the iOS simulator rather than for a
	// physical device.
	InvalidMatrixDetails_BUILT_FOR_IOS_SIMULATOR InvalidMatrixDetails = 24
	// The .xctestrun file did not specify any test targets.
	InvalidMatrixDetails_NO_TESTS_IN_XC_TEST_ZIP InvalidMatrixDetails = 25
	// One or more of the test targets defined in the .xctestrun file specifies
	// "UseDestinationArtifacts", which is disallowed.
	InvalidMatrixDetails_USE_DESTINATION_ARTIFACTS InvalidMatrixDetails = 26
	// XC tests which run on physical devices must have
	// "IsAppHostedTestBundle" == "true" in the xctestrun file.
	InvalidMatrixDetails_TEST_NOT_APP_HOSTED InvalidMatrixDetails = 28
	// An Info.plist file in the XCTest zip could not be parsed.
	InvalidMatrixDetails_PLIST_CANNOT_BE_PARSED InvalidMatrixDetails = 30
	// The APK is marked as "testOnly".
	// Deprecated and not currently used.
	//
	// Deprecated: Do not use.
	InvalidMatrixDetails_TEST_ONLY_APK InvalidMatrixDetails = 21
	// The input IPA could not be parsed.
	InvalidMatrixDetails_MALFORMED_IPA InvalidMatrixDetails = 22
	// The application doesn't register the game loop URL scheme.
	InvalidMatrixDetails_MISSING_URL_SCHEME InvalidMatrixDetails = 35
	// The iOS application bundle (.app) couldn't be processed.
	InvalidMatrixDetails_MALFORMED_APP_BUNDLE InvalidMatrixDetails = 36
	// APK contains no code.
	// See also
	// https://developer.android.com/guide/topics/manifest/application-element.html#code
	InvalidMatrixDetails_NO_CODE_APK InvalidMatrixDetails = 23
	// Either the provided input APK path was malformed,
	// the APK file does not exist, or the user does not have permission to
	// access the APK file.
	InvalidMatrixDetails_INVALID_INPUT_APK InvalidMatrixDetails = 27
	// APK is built for a preview SDK which is unsupported
	InvalidMatrixDetails_INVALID_APK_PREVIEW_SDK InvalidMatrixDetails = 29
	// The matrix expanded to contain too many executions.
	InvalidMatrixDetails_MATRIX_TOO_LARGE InvalidMatrixDetails = 37
	// Not enough test quota to run the executions in this matrix.
	InvalidMatrixDetails_TEST_QUOTA_EXCEEDED InvalidMatrixDetails = 39
	// A required cloud service api is not activated.
	// See:
	// https://firebase.google.com/docs/test-lab/android/continuous#requirements
	InvalidMatrixDetails_SERVICE_NOT_ACTIVATED InvalidMatrixDetails = 40
	// There was an unknown permission issue running this test.
	InvalidMatrixDetails_UNKNOWN_PERMISSION_ERROR InvalidMatrixDetails = 41
)

// Enum value maps for InvalidMatrixDetails.
var (
	InvalidMatrixDetails_name = map[int32]string{
		0:  "INVALID_MATRIX_DETAILS_UNSPECIFIED",
		1:  "DETAILS_UNAVAILABLE",
		2:  "MALFORMED_APK",
		3:  "MALFORMED_TEST_APK",
		4:  "NO_MANIFEST",
		5:  "NO_PACKAGE_NAME",
		31: "INVALID_PACKAGE_NAME",
		6:  "TEST_SAME_AS_APP",
		7:  "NO_INSTRUMENTATION",
		20: "NO_SIGNATURE",
		18: "INSTRUMENTATION_ORCHESTRATOR_INCOMPATIBLE",
		19: "NO_TEST_RUNNER_CLASS",
		8:  "NO_LAUNCHER_ACTIVITY",
		9:  "FORBIDDEN_PERMISSIONS",
		10: "INVALID_ROBO_DIRECTIVES",
		33: "INVALID_RESOURCE_NAME",
		34: "INVALID_DIRECTIVE_ACTION",
		12: "TEST_LOOP_INTENT_FILTER_NOT_FOUND",
		13: "SCENARIO_LABEL_NOT_DECLARED",
		14: "SCENARIO_LABEL_MALFORMED",
		15: "SCENARIO_NOT_DECLARED",
		17: "DEVICE_ADMIN_RECEIVER",
		11: "MALFORMED_XC_TEST_ZIP",
		24: "BUILT_FOR_IOS_SIMULATOR",
		25: "NO_TESTS_IN_XC_TEST_ZIP",
		26: "USE_DESTINATION_ARTIFACTS",
		28: "TEST_NOT_APP_HOSTED",
		30: "PLIST_CANNOT_BE_PARSED",
		21: "TEST_ONLY_APK",
		22: "MALFORMED_IPA",
		35: "MISSING_URL_SCHEME",
		36: "MALFORMED_APP_BUNDLE",
		23: "NO_CODE_APK",
		27: "INVALID_INPUT_APK",
		29: "INVALID_APK_PREVIEW_SDK",
		37: "MATRIX_TOO_LARGE",
		39: "TEST_QUOTA_EXCEEDED",
		40: "SERVICE_NOT_ACTIVATED",
		41: "UNKNOWN_PERMISSION_ERROR",
	}
	InvalidMatrixDetails_value = map[string]int32{
		"INVALID_MATRIX_DETAILS_UNSPECIFIED":        0,
		"DETAILS_UNAVAILABLE":                       1,
		"MALFORMED_APK":                             2,
		"MALFORMED_TEST_APK":                        3,
		"NO_MANIFEST":                               4,
		"NO_PACKAGE_NAME":                           5,
		"INVALID_PACKAGE_NAME":                      31,
		"TEST_SAME_AS_APP":                          6,
		"NO_INSTRUMENTATION":                        7,
		"NO_SIGNATURE":                              20,
		"INSTRUMENTATION_ORCHESTRATOR_INCOMPATIBLE": 18,
		"NO_TEST_RUNNER_CLASS":                      19,
		"NO_LAUNCHER_ACTIVITY":                      8,
		"FORBIDDEN_PERMISSIONS":                     9,
		"INVALID_ROBO_DIRECTIVES":                   10,
		"INVALID_RESOURCE_NAME":                     33,
		"INVALID_DIRECTIVE_ACTION":                  34,
		"TEST_LOOP_INTENT_FILTER_NOT_FOUND":         12,
		"SCENARIO_LABEL_NOT_DECLARED":               13,
		"SCENARIO_LABEL_MALFORMED":                  14,
		"SCENARIO_NOT_DECLARED":                     15,
		"DEVICE_ADMIN_RECEIVER":                     17,
		"MALFORMED_XC_TEST_ZIP":                     11,
		"BUILT_FOR_IOS_SIMULATOR":                   24,
		"NO_TESTS_IN_XC_TEST_ZIP":                   25,
		"USE_DESTINATION_ARTIFACTS":                 26,
		"TEST_NOT_APP_HOSTED":                       28,
		"PLIST_CANNOT_BE_PARSED":                    30,
		"TEST_ONLY_APK":                             21,
		"MALFORMED_IPA":                             22,
		"MISSING_URL_SCHEME":                        35,
		"MALFORMED_APP_BUNDLE":                      36,
		"NO_CODE_APK":                               23,
		"INVALID_INPUT_APK":                         27,
		"INVALID_APK_PREVIEW_SDK":                   29,
		"MATRIX_TOO_LARGE":                          37,
		"TEST_QUOTA_EXCEEDED":                       39,
		"SERVICE_NOT_ACTIVATED":                     40,
		"UNKNOWN_PERMISSION_ERROR":                  41,
	}
)

func (x InvalidMatrixDetails) Enum() *InvalidMatrixDetails {
	p := new(InvalidMatrixDetails)
	*p = x
	return p
}

func (x InvalidMatrixDetails) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InvalidMatrixDetails) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_testing_v1_test_execution_proto_enumTypes[3].Descriptor()
}

func (InvalidMatrixDetails) Type() protoreflect.EnumType {
	return &file_google_devtools_testing_v1_test_execution_proto_enumTypes[3]
}

func (x InvalidMatrixDetails) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InvalidMatrixDetails.Descriptor instead.
func (InvalidMatrixDetails) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{3}
}

// The state (i.e., progress) of a test execution or matrix.
type TestState int32

const (
	// Do not use.  For proto versioning only.
	TestState_TEST_STATE_UNSPECIFIED TestState = 0
	// The execution or matrix is being validated.
	TestState_VALIDATING TestState = 8
	// The execution or matrix is waiting for resources to become available.
	TestState_PENDING TestState = 1
	// The execution is currently being processed.
	//
	// Can only be set on an execution.
	TestState_RUNNING TestState = 2
	// The execution or matrix has terminated normally.
	//
	// On a matrix this means that the matrix level processing completed normally,
	// but individual executions may be in an ERROR state.
	TestState_FINISHED TestState = 3
	// The execution or matrix has stopped because it encountered an
	// infrastructure failure.
	TestState_ERROR TestState = 4
	// The execution was not run because it corresponds to a unsupported
	// environment.
	//
	// Can only be set on an execution.
	TestState_UNSUPPORTED_ENVIRONMENT TestState = 5
	// The execution was not run because the provided inputs are incompatible with
	// the requested environment.
	//
	// Example: requested AndroidVersion is lower than APK's minSdkVersion
	//
	// Can only be set on an execution.
	TestState_INCOMPATIBLE_ENVIRONMENT TestState = 9
	// The execution was not run because the provided inputs are incompatible with
	// the requested architecture.
	//
	// Example: requested device does not support running the native code in
	// the supplied APK
	//
	// Can only be set on an execution.
	TestState_INCOMPATIBLE_ARCHITECTURE TestState = 10
	// The user cancelled the execution.
	//
	// Can only be set on an execution.
	TestState_CANCELLED TestState = 6
	// The execution or matrix was not run because the provided inputs are not
	// valid.
	//
	// Examples: input file is not of the expected type, is malformed/corrupt, or
	// was flagged as malware
	TestState_INVALID TestState = 7
)

// Enum value maps for TestState.
var (
	TestState_name = map[int32]string{
		0:  "TEST_STATE_UNSPECIFIED",
		8:  "VALIDATING",
		1:  "PENDING",
		2:  "RUNNING",
		3:  "FINISHED",
		4:  "ERROR",
		5:  "UNSUPPORTED_ENVIRONMENT",
		9:  "INCOMPATIBLE_ENVIRONMENT",
		10: "INCOMPATIBLE_ARCHITECTURE",
		6:  "CANCELLED",
		7:  "INVALID",
	}
	TestState_value = map[string]int32{
		"TEST_STATE_UNSPECIFIED":    0,
		"VALIDATING":                8,
		"PENDING":                   1,
		"RUNNING":                   2,
		"FINISHED":                  3,
		"ERROR":                     4,
		"UNSUPPORTED_ENVIRONMENT":   5,
		"INCOMPATIBLE_ENVIRONMENT":  9,
		"INCOMPATIBLE_ARCHITECTURE": 10,
		"CANCELLED":                 6,
		"INVALID":                   7,
	}
)

func (x TestState) Enum() *TestState {
	p := new(TestState)
	*p = x
	return p
}

func (x TestState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TestState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_testing_v1_test_execution_proto_enumTypes[4].Descriptor()
}

func (TestState) Type() protoreflect.EnumType {
	return &file_google_devtools_testing_v1_test_execution_proto_enumTypes[4]
}

func (x TestState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TestState.Descriptor instead.
func (TestState) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{4}
}

// Outcome summary for a finished test matrix.
type OutcomeSummary int32

const (
	// Do not use. For proto versioning only.
	OutcomeSummary_OUTCOME_SUMMARY_UNSPECIFIED OutcomeSummary = 0
	// The test matrix run was successful, for instance:
	// - All the test cases passed.
	// - Robo did not detect a crash of the application under test.
	OutcomeSummary_SUCCESS OutcomeSummary = 1
	// A run failed, for instance:
	// - One or more test case failed.
	// - A test timed out.
	// - The application under test crashed.
	OutcomeSummary_FAILURE OutcomeSummary = 2
	// Something unexpected happened. The run should still be considered
	// unsuccessful but this is likely a transient problem and re-running the
	// test might be successful.
	OutcomeSummary_INCONCLUSIVE OutcomeSummary = 3
	// All tests were skipped, for instance:
	// - All device configurations were incompatible.
	OutcomeSummary_SKIPPED OutcomeSummary = 4
)

// Enum value maps for OutcomeSummary.
var (
	OutcomeSummary_name = map[int32]string{
		0: "OUTCOME_SUMMARY_UNSPECIFIED",
		1: "SUCCESS",
		2: "FAILURE",
		3: "INCONCLUSIVE",
		4: "SKIPPED",
	}
	OutcomeSummary_value = map[string]int32{
		"OUTCOME_SUMMARY_UNSPECIFIED": 0,
		"SUCCESS":                     1,
		"FAILURE":                     2,
		"INCONCLUSIVE":                3,
		"SKIPPED":                     4,
	}
)

func (x OutcomeSummary) Enum() *OutcomeSummary {
	p := new(OutcomeSummary)
	*p = x
	return p
}

func (x OutcomeSummary) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OutcomeSummary) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_testing_v1_test_execution_proto_enumTypes[5].Descriptor()
}

func (OutcomeSummary) Type() protoreflect.EnumType {
	return &file_google_devtools_testing_v1_test_execution_proto_enumTypes[5]
}

func (x OutcomeSummary) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OutcomeSummary.Descriptor instead.
func (OutcomeSummary) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{5}
}

// Possible invalid request reasons.
type InvalidRequestDetail_Reason int32

const (
	// No reason has been specified - the default.
	InvalidRequestDetail_REASON_UNSPECIFIED InvalidRequestDetail_Reason = 0
	// The request is not valid.
	InvalidRequestDetail_REQUEST_INVALID InvalidRequestDetail_Reason = 1
	// One or more of the resources specified in the request is too large.
	InvalidRequestDetail_RESOURCE_TOO_BIG InvalidRequestDetail_Reason = 2
	// One or more resources specified in the request cannot be found.
	InvalidRequestDetail_RESOURCE_NOT_FOUND InvalidRequestDetail_Reason = 3
	// This request is not (currently) supported.
	InvalidRequestDetail_UNSUPPORTED InvalidRequestDetail_Reason = 4
	// This request is not currently implemented.
	InvalidRequestDetail_NOT_IMPLEMENTED InvalidRequestDetail_Reason = 5
)

// Enum value maps for InvalidRequestDetail_Reason.
var (
	InvalidRequestDetail_Reason_name = map[int32]string{
		0: "REASON_UNSPECIFIED",
		1: "REQUEST_INVALID",
		2: "RESOURCE_TOO_BIG",
		3: "RESOURCE_NOT_FOUND",
		4: "UNSUPPORTED",
		5: "NOT_IMPLEMENTED",
	}
	InvalidRequestDetail_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED": 0,
		"REQUEST_INVALID":    1,
		"RESOURCE_TOO_BIG":   2,
		"RESOURCE_NOT_FOUND": 3,
		"UNSUPPORTED":        4,
		"NOT_IMPLEMENTED":    5,
	}
)

func (x InvalidRequestDetail_Reason) Enum() *InvalidRequestDetail_Reason {
	p := new(InvalidRequestDetail_Reason)
	*p = x
	return p
}

func (x InvalidRequestDetail_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InvalidRequestDetail_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_testing_v1_test_execution_proto_enumTypes[6].Descriptor()
}

func (InvalidRequestDetail_Reason) Type() protoreflect.EnumType {
	return &file_google_devtools_testing_v1_test_execution_proto_enumTypes[6]
}

func (x InvalidRequestDetail_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InvalidRequestDetail_Reason.Descriptor instead.
func (InvalidRequestDetail_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{40, 0}
}

// TestMatrix captures all details about a test. It contains the environment
// configuration, test specification, test executions and overall state and
// outcome.
type TestMatrix struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Unique id set by the service.
	TestMatrixId string `protobuf:"bytes,1,opt,name=test_matrix_id,json=testMatrixId,proto3" json:"test_matrix_id,omitempty"`
	// The cloud project that owns the test matrix.
	ProjectId string `protobuf:"bytes,7,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Information about the client which invoked the test.
	ClientInfo *ClientInfo `protobuf:"bytes,10,opt,name=client_info,json=clientInfo,proto3" json:"client_info,omitempty"`
	// Required. How to run the test.
	TestSpecification *TestSpecification `protobuf:"bytes,3,opt,name=test_specification,json=testSpecification,proto3" json:"test_specification,omitempty"`
	// Required. The devices the tests are being executed on.
	EnvironmentMatrix *EnvironmentMatrix `protobuf:"bytes,4,opt,name=environment_matrix,json=environmentMatrix,proto3" json:"environment_matrix,omitempty"`
	// Output only. The list of test executions that the service creates for
	// this matrix.
	TestExecutions []*TestExecution `protobuf:"bytes,5,rep,name=test_executions,json=testExecutions,proto3" json:"test_executions,omitempty"`
	// Required. Where the results for the matrix are written.
	ResultStorage *ResultStorage `protobuf:"bytes,6,opt,name=result_storage,json=resultStorage,proto3" json:"result_storage,omitempty"`
	// Output only. Indicates the current progress of the test matrix.
	State TestState `protobuf:"varint,8,opt,name=state,proto3,enum=google.devtools.testing.v1.TestState" json:"state,omitempty"`
	// Output only. The time this test matrix was initially created.
	Timestamp *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Output only. Describes why the matrix is considered invalid.
	// Only useful for matrices in the INVALID state.
	InvalidMatrixDetails InvalidMatrixDetails `protobuf:"varint,11,opt,name=invalid_matrix_details,json=invalidMatrixDetails,proto3,enum=google.devtools.testing.v1.InvalidMatrixDetails" json:"invalid_matrix_details,omitempty"`
	// The number of times a TestExecution should be re-attempted if one or more
	// of its test cases fail for any reason.
	// The maximum number of reruns allowed is 10.
	//
	// Default is 0, which implies no reruns.
	FlakyTestAttempts int32 `protobuf:"varint,13,opt,name=flaky_test_attempts,json=flakyTestAttempts,proto3" json:"flaky_test_attempts,omitempty"`
	// Output Only. The overall outcome of the test.
	// Only set when the test matrix state is FINISHED.
	OutcomeSummary OutcomeSummary `protobuf:"varint,14,opt,name=outcome_summary,json=outcomeSummary,proto3,enum=google.devtools.testing.v1.OutcomeSummary" json:"outcome_summary,omitempty"`
	// If true, only a single attempt at most will be made to run each
	// execution/shard in the matrix. Flaky test attempts are not affected.
	//
	// Normally, 2 or more attempts are made if a potential infrastructure issue
	// is detected.
	//
	// This feature is for latency sensitive workloads. The incidence of
	// execution failures may be significantly greater for fail-fast matrices
	// and support is more limited because of that expectation.
	FailFast bool `protobuf:"varint,17,opt,name=fail_fast,json=failFast,proto3" json:"fail_fast,omitempty"`
}

func (x *TestMatrix) Reset() {
	*x = TestMatrix{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestMatrix) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestMatrix) ProtoMessage() {}

func (x *TestMatrix) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestMatrix.ProtoReflect.Descriptor instead.
func (*TestMatrix) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{0}
}

func (x *TestMatrix) GetTestMatrixId() string {
	if x != nil {
		return x.TestMatrixId
	}
	return ""
}

func (x *TestMatrix) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *TestMatrix) GetClientInfo() *ClientInfo {
	if x != nil {
		return x.ClientInfo
	}
	return nil
}

func (x *TestMatrix) GetTestSpecification() *TestSpecification {
	if x != nil {
		return x.TestSpecification
	}
	return nil
}

func (x *TestMatrix) GetEnvironmentMatrix() *EnvironmentMatrix {
	if x != nil {
		return x.EnvironmentMatrix
	}
	return nil
}

func (x *TestMatrix) GetTestExecutions() []*TestExecution {
	if x != nil {
		return x.TestExecutions
	}
	return nil
}

func (x *TestMatrix) GetResultStorage() *ResultStorage {
	if x != nil {
		return x.ResultStorage
	}
	return nil
}

func (x *TestMatrix) GetState() TestState {
	if x != nil {
		return x.State
	}
	return TestState_TEST_STATE_UNSPECIFIED
}

func (x *TestMatrix) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (x *TestMatrix) GetInvalidMatrixDetails() InvalidMatrixDetails {
	if x != nil {
		return x.InvalidMatrixDetails
	}
	return InvalidMatrixDetails_INVALID_MATRIX_DETAILS_UNSPECIFIED
}

func (x *TestMatrix) GetFlakyTestAttempts() int32 {
	if x != nil {
		return x.FlakyTestAttempts
	}
	return 0
}

func (x *TestMatrix) GetOutcomeSummary() OutcomeSummary {
	if x != nil {
		return x.OutcomeSummary
	}
	return OutcomeSummary_OUTCOME_SUMMARY_UNSPECIFIED
}

func (x *TestMatrix) GetFailFast() bool {
	if x != nil {
		return x.FailFast
	}
	return false
}

// A single test executed in a single environment.
type TestExecution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Unique id set by the service.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. Id of the containing TestMatrix.
	MatrixId string `protobuf:"bytes,9,opt,name=matrix_id,json=matrixId,proto3" json:"matrix_id,omitempty"`
	// Output only. The cloud project that owns the test execution.
	ProjectId string `protobuf:"bytes,10,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Output only. How to run the test.
	TestSpecification *TestSpecification `protobuf:"bytes,3,opt,name=test_specification,json=testSpecification,proto3" json:"test_specification,omitempty"`
	// Output only. Details about the shard.
	Shard *Shard `protobuf:"bytes,12,opt,name=shard,proto3" json:"shard,omitempty"`
	// Output only. How the host machine(s) are configured.
	Environment *Environment `protobuf:"bytes,4,opt,name=environment,proto3" json:"environment,omitempty"`
	// Output only. Indicates the current progress of the test execution
	// (e.g., FINISHED).
	State TestState `protobuf:"varint,5,opt,name=state,proto3,enum=google.devtools.testing.v1.TestState" json:"state,omitempty"`
	// Output only. Where the results for this execution are written.
	ToolResultsStep *ToolResultsStep `protobuf:"bytes,11,opt,name=tool_results_step,json=toolResultsStep,proto3" json:"tool_results_step,omitempty"`
	// Output only. The time this test execution was initially created.
	Timestamp *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Output only. Additional details about the running test.
	TestDetails *TestDetails `protobuf:"bytes,8,opt,name=test_details,json=testDetails,proto3" json:"test_details,omitempty"`
}

func (x *TestExecution) Reset() {
	*x = TestExecution{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestExecution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestExecution) ProtoMessage() {}

func (x *TestExecution) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestExecution.ProtoReflect.Descriptor instead.
func (*TestExecution) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{1}
}

func (x *TestExecution) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *TestExecution) GetMatrixId() string {
	if x != nil {
		return x.MatrixId
	}
	return ""
}

func (x *TestExecution) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *TestExecution) GetTestSpecification() *TestSpecification {
	if x != nil {
		return x.TestSpecification
	}
	return nil
}

func (x *TestExecution) GetShard() *Shard {
	if x != nil {
		return x.Shard
	}
	return nil
}

func (x *TestExecution) GetEnvironment() *Environment {
	if x != nil {
		return x.Environment
	}
	return nil
}

func (x *TestExecution) GetState() TestState {
	if x != nil {
		return x.State
	}
	return TestState_TEST_STATE_UNSPECIFIED
}

func (x *TestExecution) GetToolResultsStep() *ToolResultsStep {
	if x != nil {
		return x.ToolResultsStep
	}
	return nil
}

func (x *TestExecution) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (x *TestExecution) GetTestDetails() *TestDetails {
	if x != nil {
		return x.TestDetails
	}
	return nil
}

// A description of how to run the test.
type TestSpecification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Max time a test execution is allowed to run before it is
	// automatically cancelled.
	// The default value is 5 min.
	TestTimeout *durationpb.Duration `protobuf:"bytes,1,opt,name=test_timeout,json=testTimeout,proto3" json:"test_timeout,omitempty"`
	// Test setup requirements.
	//
	// Types that are assignable to Setup:
	//
	//	*TestSpecification_TestSetup
	//	*TestSpecification_IosTestSetup
	Setup isTestSpecification_Setup `protobuf_oneof:"setup"`
	// Required. The type of test to run.
	//
	// Types that are assignable to Test:
	//
	//	*TestSpecification_AndroidInstrumentationTest
	//	*TestSpecification_AndroidRoboTest
	//	*TestSpecification_AndroidTestLoop
	//	*TestSpecification_IosXcTest
	//	*TestSpecification_IosTestLoop
	Test isTestSpecification_Test `protobuf_oneof:"test"`
	// Disables video recording. May reduce test latency.
	DisableVideoRecording bool `protobuf:"varint,10,opt,name=disable_video_recording,json=disableVideoRecording,proto3" json:"disable_video_recording,omitempty"`
	// Disables performance metrics recording. May reduce test latency.
	DisablePerformanceMetrics bool `protobuf:"varint,11,opt,name=disable_performance_metrics,json=disablePerformanceMetrics,proto3" json:"disable_performance_metrics,omitempty"`
}

func (x *TestSpecification) Reset() {
	*x = TestSpecification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestSpecification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestSpecification) ProtoMessage() {}

func (x *TestSpecification) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestSpecification.ProtoReflect.Descriptor instead.
func (*TestSpecification) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{2}
}

func (x *TestSpecification) GetTestTimeout() *durationpb.Duration {
	if x != nil {
		return x.TestTimeout
	}
	return nil
}

func (m *TestSpecification) GetSetup() isTestSpecification_Setup {
	if m != nil {
		return m.Setup
	}
	return nil
}

func (x *TestSpecification) GetTestSetup() *TestSetup {
	if x, ok := x.GetSetup().(*TestSpecification_TestSetup); ok {
		return x.TestSetup
	}
	return nil
}

func (x *TestSpecification) GetIosTestSetup() *IosTestSetup {
	if x, ok := x.GetSetup().(*TestSpecification_IosTestSetup); ok {
		return x.IosTestSetup
	}
	return nil
}

func (m *TestSpecification) GetTest() isTestSpecification_Test {
	if m != nil {
		return m.Test
	}
	return nil
}

func (x *TestSpecification) GetAndroidInstrumentationTest() *AndroidInstrumentationTest {
	if x, ok := x.GetTest().(*TestSpecification_AndroidInstrumentationTest); ok {
		return x.AndroidInstrumentationTest
	}
	return nil
}

func (x *TestSpecification) GetAndroidRoboTest() *AndroidRoboTest {
	if x, ok := x.GetTest().(*TestSpecification_AndroidRoboTest); ok {
		return x.AndroidRoboTest
	}
	return nil
}

func (x *TestSpecification) GetAndroidTestLoop() *AndroidTestLoop {
	if x, ok := x.GetTest().(*TestSpecification_AndroidTestLoop); ok {
		return x.AndroidTestLoop
	}
	return nil
}

func (x *TestSpecification) GetIosXcTest() *IosXcTest {
	if x, ok := x.GetTest().(*TestSpecification_IosXcTest); ok {
		return x.IosXcTest
	}
	return nil
}

func (x *TestSpecification) GetIosTestLoop() *IosTestLoop {
	if x, ok := x.GetTest().(*TestSpecification_IosTestLoop); ok {
		return x.IosTestLoop
	}
	return nil
}

func (x *TestSpecification) GetDisableVideoRecording() bool {
	if x != nil {
		return x.DisableVideoRecording
	}
	return false
}

func (x *TestSpecification) GetDisablePerformanceMetrics() bool {
	if x != nil {
		return x.DisablePerformanceMetrics
	}
	return false
}

type isTestSpecification_Setup interface {
	isTestSpecification_Setup()
}

type TestSpecification_TestSetup struct {
	// Test setup requirements for Android e.g. files to install, bootstrap
	// scripts.
	TestSetup *TestSetup `protobuf:"bytes,6,opt,name=test_setup,json=testSetup,proto3,oneof"`
}

type TestSpecification_IosTestSetup struct {
	// Test setup requirements for iOS.
	IosTestSetup *IosTestSetup `protobuf:"bytes,14,opt,name=ios_test_setup,json=iosTestSetup,proto3,oneof"`
}

func (*TestSpecification_TestSetup) isTestSpecification_Setup() {}

func (*TestSpecification_IosTestSetup) isTestSpecification_Setup() {}

type isTestSpecification_Test interface {
	isTestSpecification_Test()
}

type TestSpecification_AndroidInstrumentationTest struct {
	// An Android instrumentation test.
	AndroidInstrumentationTest *AndroidInstrumentationTest `protobuf:"bytes,2,opt,name=android_instrumentation_test,json=androidInstrumentationTest,proto3,oneof"`
}

type TestSpecification_AndroidRoboTest struct {
	// An Android robo test.
	AndroidRoboTest *AndroidRoboTest `protobuf:"bytes,3,opt,name=android_robo_test,json=androidRoboTest,proto3,oneof"`
}

type TestSpecification_AndroidTestLoop struct {
	// An Android Application with a Test Loop.
	AndroidTestLoop *AndroidTestLoop `protobuf:"bytes,9,opt,name=android_test_loop,json=androidTestLoop,proto3,oneof"`
}

type TestSpecification_IosXcTest struct {
	// An iOS XCTest, via an .xctestrun file.
	IosXcTest *IosXcTest `protobuf:"bytes,13,opt,name=ios_xc_test,json=iosXcTest,proto3,oneof"`
}

type TestSpecification_IosTestLoop struct {
	// An iOS application with a test loop.
	IosTestLoop *IosTestLoop `protobuf:"bytes,15,opt,name=ios_test_loop,json=iosTestLoop,proto3,oneof"`
}

func (*TestSpecification_AndroidInstrumentationTest) isTestSpecification_Test() {}

func (*TestSpecification_AndroidRoboTest) isTestSpecification_Test() {}

func (*TestSpecification_AndroidTestLoop) isTestSpecification_Test() {}

func (*TestSpecification_IosXcTest) isTestSpecification_Test() {}

func (*TestSpecification_IosTestLoop) isTestSpecification_Test() {}

type SystraceSetup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Systrace duration in seconds.
	// Should be between 1 and 30 seconds. 0 disables systrace.
	DurationSeconds int32 `protobuf:"varint,1,opt,name=duration_seconds,json=durationSeconds,proto3" json:"duration_seconds,omitempty"`
}

func (x *SystraceSetup) Reset() {
	*x = SystraceSetup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SystraceSetup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SystraceSetup) ProtoMessage() {}

func (x *SystraceSetup) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SystraceSetup.ProtoReflect.Descriptor instead.
func (*SystraceSetup) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{3}
}

func (x *SystraceSetup) GetDurationSeconds() int32 {
	if x != nil {
		return x.DurationSeconds
	}
	return 0
}

// A description of how to set up the Android device prior to running the test.
type TestSetup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of files to push to the device before starting the test.
	FilesToPush []*DeviceFile `protobuf:"bytes,1,rep,name=files_to_push,json=filesToPush,proto3" json:"files_to_push,omitempty"`
	// List of directories on the device to upload to GCS at the end of the test;
	// they must be absolute paths under /sdcard, /storage or /data/local/tmp.
	// Path names are restricted to characters a-z A-Z 0-9 _ - . + and /
	//
	// Note: The paths /sdcard and /data will be made available and treated as
	// implicit path substitutions. E.g. if /sdcard on a particular device does
	// not map to external storage, the system will replace it with the external
	// storage path prefix for that device.
	DirectoriesToPull []string `protobuf:"bytes,2,rep,name=directories_to_pull,json=directoriesToPull,proto3" json:"directories_to_pull,omitempty"`
	// APKs to install in addition to those being directly tested.
	// Currently capped at 100.
	AdditionalApks []*Apk `protobuf:"bytes,3,rep,name=additional_apks,json=additionalApks,proto3" json:"additional_apks,omitempty"`
	// The device will be logged in on this account for the duration of the test.
	Account *Account `protobuf:"bytes,4,opt,name=account,proto3" json:"account,omitempty"`
	// The network traffic profile used for running the test.
	// Available network profiles can be queried by using the
	// NETWORK_CONFIGURATION environment type when calling
	// TestEnvironmentDiscoveryService.GetTestEnvironmentCatalog.
	NetworkProfile string `protobuf:"bytes,5,opt,name=network_profile,json=networkProfile,proto3" json:"network_profile,omitempty"`
	// Environment variables to set for the test (only applicable for
	// instrumentation tests).
	EnvironmentVariables []*EnvironmentVariable `protobuf:"bytes,6,rep,name=environment_variables,json=environmentVariables,proto3" json:"environment_variables,omitempty"`
	// Deprecated: Systrace uses Python 2 which has been sunset 2020-01-01.
	// Support of Systrace may stop at any time, at which point no Systrace file
	// will be provided in the results.
	//
	// Systrace configuration for the run.
	// If set a systrace will be taken, starting on test start and lasting for the
	// configured duration. The systrace file thus obtained is put in the results
	// bucket together with the other artifacts from the run.
	//
	// Deprecated: Do not use.
	Systrace *SystraceSetup `protobuf:"bytes,9,opt,name=systrace,proto3" json:"systrace,omitempty"`
	// Whether to prevent all runtime permissions to be granted at app install
	DontAutograntPermissions bool `protobuf:"varint,23,opt,name=dont_autogrant_permissions,json=dontAutograntPermissions,proto3" json:"dont_autogrant_permissions,omitempty"`
}

func (x *TestSetup) Reset() {
	*x = TestSetup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestSetup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestSetup) ProtoMessage() {}

func (x *TestSetup) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestSetup.ProtoReflect.Descriptor instead.
func (*TestSetup) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{4}
}

func (x *TestSetup) GetFilesToPush() []*DeviceFile {
	if x != nil {
		return x.FilesToPush
	}
	return nil
}

func (x *TestSetup) GetDirectoriesToPull() []string {
	if x != nil {
		return x.DirectoriesToPull
	}
	return nil
}

func (x *TestSetup) GetAdditionalApks() []*Apk {
	if x != nil {
		return x.AdditionalApks
	}
	return nil
}

func (x *TestSetup) GetAccount() *Account {
	if x != nil {
		return x.Account
	}
	return nil
}

func (x *TestSetup) GetNetworkProfile() string {
	if x != nil {
		return x.NetworkProfile
	}
	return ""
}

func (x *TestSetup) GetEnvironmentVariables() []*EnvironmentVariable {
	if x != nil {
		return x.EnvironmentVariables
	}
	return nil
}

// Deprecated: Do not use.
func (x *TestSetup) GetSystrace() *SystraceSetup {
	if x != nil {
		return x.Systrace
	}
	return nil
}

func (x *TestSetup) GetDontAutograntPermissions() bool {
	if x != nil {
		return x.DontAutograntPermissions
	}
	return false
}

// A description of how to set up an iOS device prior to running the test.
type IosTestSetup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The network traffic profile used for running the test.
	// Available network profiles can be queried by using the
	// NETWORK_CONFIGURATION environment type when calling
	// TestEnvironmentDiscoveryService.GetTestEnvironmentCatalog.
	NetworkProfile string `protobuf:"bytes,1,opt,name=network_profile,json=networkProfile,proto3" json:"network_profile,omitempty"`
	// iOS apps to install in addition to those being directly tested.
	AdditionalIpas []*FileReference `protobuf:"bytes,2,rep,name=additional_ipas,json=additionalIpas,proto3" json:"additional_ipas,omitempty"`
	// List of files to push to the device before starting the test.
	PushFiles []*IosDeviceFile `protobuf:"bytes,3,rep,name=push_files,json=pushFiles,proto3" json:"push_files,omitempty"`
	// List of directories on the device to upload to Cloud Storage at the end of
	// the test.
	//
	// Directories should either be in a shared directory (such as
	// /private/var/mobile/Media) or within an accessible directory inside the
	// app's filesystem (such as /Documents) by specifying the bundle ID.
	PullDirectories []*IosDeviceFile `protobuf:"bytes,4,rep,name=pull_directories,json=pullDirectories,proto3" json:"pull_directories,omitempty"`
}

func (x *IosTestSetup) Reset() {
	*x = IosTestSetup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IosTestSetup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IosTestSetup) ProtoMessage() {}

func (x *IosTestSetup) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IosTestSetup.ProtoReflect.Descriptor instead.
func (*IosTestSetup) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{5}
}

func (x *IosTestSetup) GetNetworkProfile() string {
	if x != nil {
		return x.NetworkProfile
	}
	return ""
}

func (x *IosTestSetup) GetAdditionalIpas() []*FileReference {
	if x != nil {
		return x.AdditionalIpas
	}
	return nil
}

func (x *IosTestSetup) GetPushFiles() []*IosDeviceFile {
	if x != nil {
		return x.PushFiles
	}
	return nil
}

func (x *IosTestSetup) GetPullDirectories() []*IosDeviceFile {
	if x != nil {
		return x.PullDirectories
	}
	return nil
}

// A key-value pair passed as an environment variable to the test.
type EnvironmentVariable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key for the environment variable.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Value for the environment variable.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *EnvironmentVariable) Reset() {
	*x = EnvironmentVariable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnvironmentVariable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvironmentVariable) ProtoMessage() {}

func (x *EnvironmentVariable) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvironmentVariable.ProtoReflect.Descriptor instead.
func (*EnvironmentVariable) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{6}
}

func (x *EnvironmentVariable) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *EnvironmentVariable) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// Identifies an account and how to log into it.
type Account struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The type of account, based what it's for (e.g. Google) and what
	// its login mechanism is (e.g. username and password).
	//
	// Types that are assignable to AccountType:
	//
	//	*Account_GoogleAuto
	AccountType isAccount_AccountType `protobuf_oneof:"account_type"`
}

func (x *Account) Reset() {
	*x = Account{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Account) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Account) ProtoMessage() {}

func (x *Account) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Account.ProtoReflect.Descriptor instead.
func (*Account) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{7}
}

func (m *Account) GetAccountType() isAccount_AccountType {
	if m != nil {
		return m.AccountType
	}
	return nil
}

func (x *Account) GetGoogleAuto() *GoogleAuto {
	if x, ok := x.GetAccountType().(*Account_GoogleAuto); ok {
		return x.GoogleAuto
	}
	return nil
}

type isAccount_AccountType interface {
	isAccount_AccountType()
}

type Account_GoogleAuto struct {
	// An automatic google login account.
	GoogleAuto *GoogleAuto `protobuf:"bytes,1,opt,name=google_auto,json=googleAuto,proto3,oneof"`
}

func (*Account_GoogleAuto) isAccount_AccountType() {}

// Enables automatic Google account login.
// If set, the service automatically generates a Google test account and adds
// it to the device, before executing the test. Note that test accounts might be
// reused.
// Many applications show their full set of functionalities when an account is
// present on the device. Logging into the device with these generated accounts
// allows testing more functionalities.
type GoogleAuto struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GoogleAuto) Reset() {
	*x = GoogleAuto{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GoogleAuto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoogleAuto) ProtoMessage() {}

func (x *GoogleAuto) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoogleAuto.ProtoReflect.Descriptor instead.
func (*GoogleAuto) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{8}
}

// An Android package file to install.
type Apk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The path to an APK to be installed on the device before the test begins.
	Location *FileReference `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// The java package for the APK to be installed.
	// Value is determined by examining the application's manifest.
	PackageName string `protobuf:"bytes,2,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
}

func (x *Apk) Reset() {
	*x = Apk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Apk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Apk) ProtoMessage() {}

func (x *Apk) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Apk.ProtoReflect.Descriptor instead.
func (*Apk) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{9}
}

func (x *Apk) GetLocation() *FileReference {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *Apk) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

// An Android App Bundle file format, containing a BundleConfig.pb file,
// a base module directory, zero or more dynamic feature module directories.
// <p>See https://developer.android.com/guide/app-bundle/build for guidance on
// building App Bundles.
type AppBundle struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Bundle location information.
	//
	// Types that are assignable to Bundle:
	//
	//	*AppBundle_BundleLocation
	Bundle isAppBundle_Bundle `protobuf_oneof:"bundle"`
}

func (x *AppBundle) Reset() {
	*x = AppBundle{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppBundle) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppBundle) ProtoMessage() {}

func (x *AppBundle) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppBundle.ProtoReflect.Descriptor instead.
func (*AppBundle) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{10}
}

func (m *AppBundle) GetBundle() isAppBundle_Bundle {
	if m != nil {
		return m.Bundle
	}
	return nil
}

func (x *AppBundle) GetBundleLocation() *FileReference {
	if x, ok := x.GetBundle().(*AppBundle_BundleLocation); ok {
		return x.BundleLocation
	}
	return nil
}

type isAppBundle_Bundle interface {
	isAppBundle_Bundle()
}

type AppBundle_BundleLocation struct {
	// .aab file representing the app bundle under test.
	BundleLocation *FileReference `protobuf:"bytes,1,opt,name=bundle_location,json=bundleLocation,proto3,oneof"`
}

func (*AppBundle_BundleLocation) isAppBundle_Bundle() {}

// A single device file description.
type DeviceFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	//
	// Types that are assignable to DeviceFile:
	//
	//	*DeviceFile_ObbFile
	//	*DeviceFile_RegularFile
	DeviceFile isDeviceFile_DeviceFile `protobuf_oneof:"device_file"`
}

func (x *DeviceFile) Reset() {
	*x = DeviceFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeviceFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceFile) ProtoMessage() {}

func (x *DeviceFile) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceFile.ProtoReflect.Descriptor instead.
func (*DeviceFile) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{11}
}

func (m *DeviceFile) GetDeviceFile() isDeviceFile_DeviceFile {
	if m != nil {
		return m.DeviceFile
	}
	return nil
}

func (x *DeviceFile) GetObbFile() *ObbFile {
	if x, ok := x.GetDeviceFile().(*DeviceFile_ObbFile); ok {
		return x.ObbFile
	}
	return nil
}

func (x *DeviceFile) GetRegularFile() *RegularFile {
	if x, ok := x.GetDeviceFile().(*DeviceFile_RegularFile); ok {
		return x.RegularFile
	}
	return nil
}

type isDeviceFile_DeviceFile interface {
	isDeviceFile_DeviceFile()
}

type DeviceFile_ObbFile struct {
	// A reference to an opaque binary blob file.
	ObbFile *ObbFile `protobuf:"bytes,1,opt,name=obb_file,json=obbFile,proto3,oneof"`
}

type DeviceFile_RegularFile struct {
	// A reference to a regular file.
	RegularFile *RegularFile `protobuf:"bytes,2,opt,name=regular_file,json=regularFile,proto3,oneof"`
}

func (*DeviceFile_ObbFile) isDeviceFile_DeviceFile() {}

func (*DeviceFile_RegularFile) isDeviceFile_DeviceFile() {}

// An opaque binary blob file to install on the device before the test starts.
type ObbFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. OBB file name which must conform to the format as specified by
	// Android
	// e.g. [main|patch].0300110.com.example.android.obb
	// which will be installed into
	//
	//	\<shared-storage\>/Android/obb/\<package-name\>/
	//
	// on the device.
	ObbFileName string `protobuf:"bytes,1,opt,name=obb_file_name,json=obbFileName,proto3" json:"obb_file_name,omitempty"`
	// Required. Opaque Binary Blob (OBB) file(s) to install on the device.
	Obb *FileReference `protobuf:"bytes,2,opt,name=obb,proto3" json:"obb,omitempty"`
}

func (x *ObbFile) Reset() {
	*x = ObbFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObbFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObbFile) ProtoMessage() {}

func (x *ObbFile) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObbFile.ProtoReflect.Descriptor instead.
func (*ObbFile) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{12}
}

func (x *ObbFile) GetObbFileName() string {
	if x != nil {
		return x.ObbFileName
	}
	return ""
}

func (x *ObbFile) GetObb() *FileReference {
	if x != nil {
		return x.Obb
	}
	return nil
}

// A file or directory to install on the device before the test starts.
type RegularFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The source file.
	Content *FileReference `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// Required. Where to put the content on the device. Must be an absolute,
	// allowlisted path. If the file exists, it will be replaced.
	// The following device-side directories and any of their subdirectories are
	// allowlisted:
	// <p>${EXTERNAL_STORAGE}, /sdcard, or /storage</p>
	// <p>${ANDROID_DATA}/local/tmp, or /data/local/tmp</p>
	// <p>Specifying a path outside of these directory trees is invalid.
	//
	// <p> The paths /sdcard and /data will be made available and treated as
	// implicit path substitutions. E.g. if /sdcard on a particular device does
	// not map to external storage, the system will replace it with the external
	// storage path prefix for that device and copy the file there.
	//
	// <p> It is strongly advised to use the <a href=
	// "http://developer.android.com/reference/android/os/Environment.html">
	// Environment API</a> in app and test code to access files on the device in a
	// portable way.
	DevicePath string `protobuf:"bytes,2,opt,name=device_path,json=devicePath,proto3" json:"device_path,omitempty"`
}

func (x *RegularFile) Reset() {
	*x = RegularFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegularFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegularFile) ProtoMessage() {}

func (x *RegularFile) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegularFile.ProtoReflect.Descriptor instead.
func (*RegularFile) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{13}
}

func (x *RegularFile) GetContent() *FileReference {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *RegularFile) GetDevicePath() string {
	if x != nil {
		return x.DevicePath
	}
	return ""
}

// A file or directory to install on the device before the test starts.
type IosDeviceFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source file
	Content *FileReference `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// The bundle id of the app where this file lives.
	//
	// iOS apps sandbox their own filesystem, so app files must specify which app
	// installed on the device.
	BundleId string `protobuf:"bytes,2,opt,name=bundle_id,json=bundleId,proto3" json:"bundle_id,omitempty"`
	// Location of the file on the device, inside the app's sandboxed filesystem
	DevicePath string `protobuf:"bytes,3,opt,name=device_path,json=devicePath,proto3" json:"device_path,omitempty"`
}

func (x *IosDeviceFile) Reset() {
	*x = IosDeviceFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IosDeviceFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IosDeviceFile) ProtoMessage() {}

func (x *IosDeviceFile) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IosDeviceFile.ProtoReflect.Descriptor instead.
func (*IosDeviceFile) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{14}
}

func (x *IosDeviceFile) GetContent() *FileReference {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *IosDeviceFile) GetBundleId() string {
	if x != nil {
		return x.BundleId
	}
	return ""
}

func (x *IosDeviceFile) GetDevicePath() string {
	if x != nil {
		return x.DevicePath
	}
	return ""
}

// A test of an Android Application with a Test Loop.
// The intent \<intent-name\> will be implicitly added, since Games is the only
// user of this api, for the time being.
type AndroidTestLoop struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Android package to test.
	//
	// Types that are assignable to AppUnderTest:
	//
	//	*AndroidTestLoop_AppApk
	//	*AndroidTestLoop_AppBundle
	AppUnderTest isAndroidTestLoop_AppUnderTest `protobuf_oneof:"app_under_test"`
	// The java package for the application under test.
	// The default is determined by examining the application's manifest.
	AppPackageId string `protobuf:"bytes,2,opt,name=app_package_id,json=appPackageId,proto3" json:"app_package_id,omitempty"`
	// The list of scenarios that should be run during the test.
	// The default is all test loops, derived from the application's
	// manifest.
	Scenarios []int32 `protobuf:"varint,3,rep,packed,name=scenarios,proto3" json:"scenarios,omitempty"`
	// The list of scenario labels that should be run during the test.
	// The scenario labels should map to labels defined in the application's
	// manifest. For example, player_experience and
	// com.google.test.loops.player_experience add all of the loops labeled in the
	// manifest with the com.google.test.loops.player_experience name to the
	// execution.
	// Scenarios can also be specified in the scenarios field.
	ScenarioLabels []string `protobuf:"bytes,4,rep,name=scenario_labels,json=scenarioLabels,proto3" json:"scenario_labels,omitempty"`
}

func (x *AndroidTestLoop) Reset() {
	*x = AndroidTestLoop{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AndroidTestLoop) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AndroidTestLoop) ProtoMessage() {}

func (x *AndroidTestLoop) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AndroidTestLoop.ProtoReflect.Descriptor instead.
func (*AndroidTestLoop) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{15}
}

func (m *AndroidTestLoop) GetAppUnderTest() isAndroidTestLoop_AppUnderTest {
	if m != nil {
		return m.AppUnderTest
	}
	return nil
}

func (x *AndroidTestLoop) GetAppApk() *FileReference {
	if x, ok := x.GetAppUnderTest().(*AndroidTestLoop_AppApk); ok {
		return x.AppApk
	}
	return nil
}

func (x *AndroidTestLoop) GetAppBundle() *AppBundle {
	if x, ok := x.GetAppUnderTest().(*AndroidTestLoop_AppBundle); ok {
		return x.AppBundle
	}
	return nil
}

func (x *AndroidTestLoop) GetAppPackageId() string {
	if x != nil {
		return x.AppPackageId
	}
	return ""
}

func (x *AndroidTestLoop) GetScenarios() []int32 {
	if x != nil {
		return x.Scenarios
	}
	return nil
}

func (x *AndroidTestLoop) GetScenarioLabels() []string {
	if x != nil {
		return x.ScenarioLabels
	}
	return nil
}

type isAndroidTestLoop_AppUnderTest interface {
	isAndroidTestLoop_AppUnderTest()
}

type AndroidTestLoop_AppApk struct {
	// The APK for the application under test.
	AppApk *FileReference `protobuf:"bytes,1,opt,name=app_apk,json=appApk,proto3,oneof"`
}

type AndroidTestLoop_AppBundle struct {
	// A multi-apk app bundle for the application under test.
	AppBundle *AppBundle `protobuf:"bytes,5,opt,name=app_bundle,json=appBundle,proto3,oneof"`
}

func (*AndroidTestLoop_AppApk) isAndroidTestLoop_AppUnderTest() {}

func (*AndroidTestLoop_AppBundle) isAndroidTestLoop_AppUnderTest() {}

// A test of an iOS application that uses the XCTest framework.
// Xcode supports the option to "build for testing", which generates an
// .xctestrun file that contains a test specification (arguments, test methods,
// etc). This test type accepts a zip file containing the .xctestrun file and
// the corresponding contents of the Build/Products directory that contains all
// the binaries needed to run the tests.
type IosXcTest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The .zip containing the .xctestrun file and the contents of the
	// DerivedData/Build/Products directory.
	// The .xctestrun file in this zip is ignored if the xctestrun field is
	// specified.
	TestsZip *FileReference `protobuf:"bytes,1,opt,name=tests_zip,json=testsZip,proto3" json:"tests_zip,omitempty"`
	// An .xctestrun file that will override the .xctestrun file in the
	// tests zip. Because the .xctestrun file contains environment variables along
	// with test methods to run and/or ignore, this can be useful for sharding
	// tests. Default is taken from the tests zip.
	Xctestrun *FileReference `protobuf:"bytes,2,opt,name=xctestrun,proto3" json:"xctestrun,omitempty"`
	// The Xcode version that should be used for the test.
	// Use the TestEnvironmentDiscoveryService to get supported options.
	// Defaults to the latest Xcode version Firebase Test Lab supports.
	XcodeVersion string `protobuf:"bytes,3,opt,name=xcode_version,json=xcodeVersion,proto3" json:"xcode_version,omitempty"`
	// Output only. The bundle id for the application under test.
	AppBundleId string `protobuf:"bytes,4,opt,name=app_bundle_id,json=appBundleId,proto3" json:"app_bundle_id,omitempty"`
	// The option to test special app entitlements. Setting this would re-sign the
	// app having special entitlements with an explicit application-identifier.
	// Currently supports testing aps-environment entitlement.
	TestSpecialEntitlements bool `protobuf:"varint,6,opt,name=test_special_entitlements,json=testSpecialEntitlements,proto3" json:"test_special_entitlements,omitempty"`
}

func (x *IosXcTest) Reset() {
	*x = IosXcTest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IosXcTest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IosXcTest) ProtoMessage() {}

func (x *IosXcTest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IosXcTest.ProtoReflect.Descriptor instead.
func (*IosXcTest) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{16}
}

func (x *IosXcTest) GetTestsZip() *FileReference {
	if x != nil {
		return x.TestsZip
	}
	return nil
}

func (x *IosXcTest) GetXctestrun() *FileReference {
	if x != nil {
		return x.Xctestrun
	}
	return nil
}

func (x *IosXcTest) GetXcodeVersion() string {
	if x != nil {
		return x.XcodeVersion
	}
	return ""
}

func (x *IosXcTest) GetAppBundleId() string {
	if x != nil {
		return x.AppBundleId
	}
	return ""
}

func (x *IosXcTest) GetTestSpecialEntitlements() bool {
	if x != nil {
		return x.TestSpecialEntitlements
	}
	return false
}

// A test of an iOS application that implements one or more game loop scenarios.
// This test type accepts an archived application (.ipa file) and a list of
// integer scenarios that will be executed on the app sequentially.
type IosTestLoop struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The .ipa of the application to test.
	AppIpa *FileReference `protobuf:"bytes,1,opt,name=app_ipa,json=appIpa,proto3" json:"app_ipa,omitempty"`
	// The list of scenarios that should be run during the test. Defaults to the
	// single scenario 0 if unspecified.
	Scenarios []int32 `protobuf:"varint,2,rep,packed,name=scenarios,proto3" json:"scenarios,omitempty"`
	// Output only. The bundle id for the application under test.
	AppBundleId string `protobuf:"bytes,3,opt,name=app_bundle_id,json=appBundleId,proto3" json:"app_bundle_id,omitempty"`
}

func (x *IosTestLoop) Reset() {
	*x = IosTestLoop{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IosTestLoop) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IosTestLoop) ProtoMessage() {}

func (x *IosTestLoop) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IosTestLoop.ProtoReflect.Descriptor instead.
func (*IosTestLoop) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{17}
}

func (x *IosTestLoop) GetAppIpa() *FileReference {
	if x != nil {
		return x.AppIpa
	}
	return nil
}

func (x *IosTestLoop) GetScenarios() []int32 {
	if x != nil {
		return x.Scenarios
	}
	return nil
}

func (x *IosTestLoop) GetAppBundleId() string {
	if x != nil {
		return x.AppBundleId
	}
	return ""
}

// A test of an Android application that can control an Android component
// independently of its normal lifecycle.
// Android instrumentation tests run an application APK and test APK inside the
// same process on a virtual or physical AndroidDevice.  They also specify
// a test runner class, such as com.google.GoogleTestRunner, which can vary
// on the specific instrumentation framework chosen.
//
// See <https://developer.android.com/training/testing/fundamentals> for
// more information on types of Android tests.
type AndroidInstrumentationTest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	//
	// Types that are assignable to AppUnderTest:
	//
	//	*AndroidInstrumentationTest_AppApk
	//	*AndroidInstrumentationTest_AppBundle
	AppUnderTest isAndroidInstrumentationTest_AppUnderTest `protobuf_oneof:"app_under_test"`
	// Required. The APK containing the test code to be executed.
	TestApk *FileReference `protobuf:"bytes,2,opt,name=test_apk,json=testApk,proto3" json:"test_apk,omitempty"`
	// The java package for the application under test.
	// The default value is determined by examining the application's manifest.
	AppPackageId string `protobuf:"bytes,3,opt,name=app_package_id,json=appPackageId,proto3" json:"app_package_id,omitempty"`
	// The java package for the test to be executed.
	// The default value is determined by examining the application's manifest.
	TestPackageId string `protobuf:"bytes,4,opt,name=test_package_id,json=testPackageId,proto3" json:"test_package_id,omitempty"`
	// The InstrumentationTestRunner class.
	// The default value is determined by examining the application's manifest.
	TestRunnerClass string `protobuf:"bytes,5,opt,name=test_runner_class,json=testRunnerClass,proto3" json:"test_runner_class,omitempty"`
	// Each target must be fully qualified with the package name or class name,
	// in one of these formats:
	//   - "package package_name"
	//   - "class package_name.class_name"
	//   - "class package_name.class_name#method_name"
	//
	// If empty, all targets in the module will be run.
	TestTargets []string `protobuf:"bytes,6,rep,name=test_targets,json=testTargets,proto3" json:"test_targets,omitempty"`
	// The option of whether running each test within its own invocation of
	// instrumentation with Android Test Orchestrator or not.
	// ** Orchestrator is only compatible with AndroidJUnitRunner version 1.1 or
	// higher! **
	// Orchestrator offers the following benefits:
	//   - No shared state
	//   - Crashes are isolated
	//   - Logs are scoped per test
	//
	// See
	// <https://developer.android.com/training/testing/junit-runner.html#using-android-test-orchestrator>
	// for more information about Android Test Orchestrator.
	//
	// If not set, the test will be run without the orchestrator.
	OrchestratorOption OrchestratorOption `protobuf:"varint,7,opt,name=orchestrator_option,json=orchestratorOption,proto3,enum=google.devtools.testing.v1.OrchestratorOption" json:"orchestrator_option,omitempty"`
	// The option to run tests in multiple shards in parallel.
	ShardingOption *ShardingOption `protobuf:"bytes,9,opt,name=sharding_option,json=shardingOption,proto3" json:"sharding_option,omitempty"`
}

func (x *AndroidInstrumentationTest) Reset() {
	*x = AndroidInstrumentationTest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AndroidInstrumentationTest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AndroidInstrumentationTest) ProtoMessage() {}

func (x *AndroidInstrumentationTest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AndroidInstrumentationTest.ProtoReflect.Descriptor instead.
func (*AndroidInstrumentationTest) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{18}
}

func (m *AndroidInstrumentationTest) GetAppUnderTest() isAndroidInstrumentationTest_AppUnderTest {
	if m != nil {
		return m.AppUnderTest
	}
	return nil
}

func (x *AndroidInstrumentationTest) GetAppApk() *FileReference {
	if x, ok := x.GetAppUnderTest().(*AndroidInstrumentationTest_AppApk); ok {
		return x.AppApk
	}
	return nil
}

func (x *AndroidInstrumentationTest) GetAppBundle() *AppBundle {
	if x, ok := x.GetAppUnderTest().(*AndroidInstrumentationTest_AppBundle); ok {
		return x.AppBundle
	}
	return nil
}

func (x *AndroidInstrumentationTest) GetTestApk() *FileReference {
	if x != nil {
		return x.TestApk
	}
	return nil
}

func (x *AndroidInstrumentationTest) GetAppPackageId() string {
	if x != nil {
		return x.AppPackageId
	}
	return ""
}

func (x *AndroidInstrumentationTest) GetTestPackageId() string {
	if x != nil {
		return x.TestPackageId
	}
	return ""
}

func (x *AndroidInstrumentationTest) GetTestRunnerClass() string {
	if x != nil {
		return x.TestRunnerClass
	}
	return ""
}

func (x *AndroidInstrumentationTest) GetTestTargets() []string {
	if x != nil {
		return x.TestTargets
	}
	return nil
}

func (x *AndroidInstrumentationTest) GetOrchestratorOption() OrchestratorOption {
	if x != nil {
		return x.OrchestratorOption
	}
	return OrchestratorOption_ORCHESTRATOR_OPTION_UNSPECIFIED
}

func (x *AndroidInstrumentationTest) GetShardingOption() *ShardingOption {
	if x != nil {
		return x.ShardingOption
	}
	return nil
}

type isAndroidInstrumentationTest_AppUnderTest interface {
	isAndroidInstrumentationTest_AppUnderTest()
}

type AndroidInstrumentationTest_AppApk struct {
	// The APK for the application under test.
	AppApk *FileReference `protobuf:"bytes,1,opt,name=app_apk,json=appApk,proto3,oneof"`
}

type AndroidInstrumentationTest_AppBundle struct {
	// A multi-apk app bundle for the application under test.
	AppBundle *AppBundle `protobuf:"bytes,8,opt,name=app_bundle,json=appBundle,proto3,oneof"`
}

func (*AndroidInstrumentationTest_AppApk) isAndroidInstrumentationTest_AppUnderTest() {}

func (*AndroidInstrumentationTest_AppBundle) isAndroidInstrumentationTest_AppUnderTest() {}

// A test of an android application that explores the application on a virtual
// or physical Android Device, finding culprits and crashes as it goes.
type AndroidRoboTest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	//
	// Types that are assignable to AppUnderTest:
	//
	//	*AndroidRoboTest_AppApk
	//	*AndroidRoboTest_AppBundle
	AppUnderTest isAndroidRoboTest_AppUnderTest `protobuf_oneof:"app_under_test"`
	// The java package for the application under test.
	// The default value is determined by examining the application's manifest.
	AppPackageId string `protobuf:"bytes,2,opt,name=app_package_id,json=appPackageId,proto3" json:"app_package_id,omitempty"`
	// The initial activity that should be used to start the app.
	AppInitialActivity string `protobuf:"bytes,3,opt,name=app_initial_activity,json=appInitialActivity,proto3" json:"app_initial_activity,omitempty"`
	// The max depth of the traversal stack Robo can explore. Needs to be at least
	// 2 to make Robo explore the app beyond the first activity.
	// Default is 50.
	//
	// Deprecated: Do not use.
	MaxDepth int32 `protobuf:"varint,7,opt,name=max_depth,json=maxDepth,proto3" json:"max_depth,omitempty"`
	// The max number of steps Robo can execute.
	// Default is no limit.
	//
	// Deprecated: Do not use.
	MaxSteps int32 `protobuf:"varint,8,opt,name=max_steps,json=maxSteps,proto3" json:"max_steps,omitempty"`
	// A set of directives Robo should apply during the crawl.
	// This allows users to customize the crawl. For example, the username and
	// password for a test account can be provided.
	RoboDirectives []*RoboDirective `protobuf:"bytes,11,rep,name=robo_directives,json=roboDirectives,proto3" json:"robo_directives,omitempty"`
	// The mode in which Robo should run. Most clients should allow the server to
	// populate this field automatically.
	RoboMode RoboMode `protobuf:"varint,14,opt,name=robo_mode,json=roboMode,proto3,enum=google.devtools.testing.v1.RoboMode" json:"robo_mode,omitempty"`
	// A JSON file with a sequence of actions Robo should perform as a prologue
	// for the crawl.
	RoboScript *FileReference `protobuf:"bytes,13,opt,name=robo_script,json=roboScript,proto3" json:"robo_script,omitempty"`
	// The intents used to launch the app for the crawl.
	// If none are provided, then the main launcher activity is launched.
	// If some are provided, then only those provided are launched (the main
	// launcher activity must be provided explicitly).
	StartingIntents []*RoboStartingIntent `protobuf:"bytes,15,rep,name=starting_intents,json=startingIntents,proto3" json:"starting_intents,omitempty"`
}

func (x *AndroidRoboTest) Reset() {
	*x = AndroidRoboTest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AndroidRoboTest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AndroidRoboTest) ProtoMessage() {}

func (x *AndroidRoboTest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AndroidRoboTest.ProtoReflect.Descriptor instead.
func (*AndroidRoboTest) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{19}
}

func (m *AndroidRoboTest) GetAppUnderTest() isAndroidRoboTest_AppUnderTest {
	if m != nil {
		return m.AppUnderTest
	}
	return nil
}

func (x *AndroidRoboTest) GetAppApk() *FileReference {
	if x, ok := x.GetAppUnderTest().(*AndroidRoboTest_AppApk); ok {
		return x.AppApk
	}
	return nil
}

func (x *AndroidRoboTest) GetAppBundle() *AppBundle {
	if x, ok := x.GetAppUnderTest().(*AndroidRoboTest_AppBundle); ok {
		return x.AppBundle
	}
	return nil
}

func (x *AndroidRoboTest) GetAppPackageId() string {
	if x != nil {
		return x.AppPackageId
	}
	return ""
}

func (x *AndroidRoboTest) GetAppInitialActivity() string {
	if x != nil {
		return x.AppInitialActivity
	}
	return ""
}

// Deprecated: Do not use.
func (x *AndroidRoboTest) GetMaxDepth() int32 {
	if x != nil {
		return x.MaxDepth
	}
	return 0
}

// Deprecated: Do not use.
func (x *AndroidRoboTest) GetMaxSteps() int32 {
	if x != nil {
		return x.MaxSteps
	}
	return 0
}

func (x *AndroidRoboTest) GetRoboDirectives() []*RoboDirective {
	if x != nil {
		return x.RoboDirectives
	}
	return nil
}

func (x *AndroidRoboTest) GetRoboMode() RoboMode {
	if x != nil {
		return x.RoboMode
	}
	return RoboMode_ROBO_MODE_UNSPECIFIED
}

func (x *AndroidRoboTest) GetRoboScript() *FileReference {
	if x != nil {
		return x.RoboScript
	}
	return nil
}

func (x *AndroidRoboTest) GetStartingIntents() []*RoboStartingIntent {
	if x != nil {
		return x.StartingIntents
	}
	return nil
}

type isAndroidRoboTest_AppUnderTest interface {
	isAndroidRoboTest_AppUnderTest()
}

type AndroidRoboTest_AppApk struct {
	// The APK for the application under test.
	AppApk *FileReference `protobuf:"bytes,1,opt,name=app_apk,json=appApk,proto3,oneof"`
}

type AndroidRoboTest_AppBundle struct {
	// A multi-apk app bundle for the application under test.
	AppBundle *AppBundle `protobuf:"bytes,16,opt,name=app_bundle,json=appBundle,proto3,oneof"`
}

func (*AndroidRoboTest_AppApk) isAndroidRoboTest_AppUnderTest() {}

func (*AndroidRoboTest_AppBundle) isAndroidRoboTest_AppUnderTest() {}

// Directs Robo to interact with a specific UI element if it is encountered
// during the crawl. Currently, Robo can perform text entry or element click.
type RoboDirective struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The android resource name of the target UI element.
	// For example,
	//
	//	in Java: R.string.foo
	//	in xml: @string/foo
	//
	// Only the "foo" part is needed.
	// Reference doc:
	// https://developer.android.com/guide/topics/resources/accessing-resources.html
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The text that Robo is directed to set. If left empty, the directive will be
	// treated as a CLICK on the element matching the resource_name.
	InputText string `protobuf:"bytes,2,opt,name=input_text,json=inputText,proto3" json:"input_text,omitempty"`
	// Required. The type of action that Robo should perform on the specified
	// element.
	ActionType RoboActionType `protobuf:"varint,3,opt,name=action_type,json=actionType,proto3,enum=google.devtools.testing.v1.RoboActionType" json:"action_type,omitempty"`
}

func (x *RoboDirective) Reset() {
	*x = RoboDirective{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RoboDirective) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoboDirective) ProtoMessage() {}

func (x *RoboDirective) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoboDirective.ProtoReflect.Descriptor instead.
func (*RoboDirective) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{20}
}

func (x *RoboDirective) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *RoboDirective) GetInputText() string {
	if x != nil {
		return x.InputText
	}
	return ""
}

func (x *RoboDirective) GetActionType() RoboActionType {
	if x != nil {
		return x.ActionType
	}
	return RoboActionType_ACTION_TYPE_UNSPECIFIED
}

// Message for specifying the start activities to crawl.
type RoboStartingIntent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Intent details to start an activity.
	//
	// Types that are assignable to StartingIntent:
	//
	//	*RoboStartingIntent_LauncherActivity
	//	*RoboStartingIntent_StartActivity
	StartingIntent isRoboStartingIntent_StartingIntent `protobuf_oneof:"starting_intent"`
	// Timeout in seconds for each intent.
	Timeout *durationpb.Duration `protobuf:"bytes,3,opt,name=timeout,proto3" json:"timeout,omitempty"`
}

func (x *RoboStartingIntent) Reset() {
	*x = RoboStartingIntent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RoboStartingIntent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoboStartingIntent) ProtoMessage() {}

func (x *RoboStartingIntent) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoboStartingIntent.ProtoReflect.Descriptor instead.
func (*RoboStartingIntent) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{21}
}

func (m *RoboStartingIntent) GetStartingIntent() isRoboStartingIntent_StartingIntent {
	if m != nil {
		return m.StartingIntent
	}
	return nil
}

func (x *RoboStartingIntent) GetLauncherActivity() *LauncherActivityIntent {
	if x, ok := x.GetStartingIntent().(*RoboStartingIntent_LauncherActivity); ok {
		return x.LauncherActivity
	}
	return nil
}

func (x *RoboStartingIntent) GetStartActivity() *StartActivityIntent {
	if x, ok := x.GetStartingIntent().(*RoboStartingIntent_StartActivity); ok {
		return x.StartActivity
	}
	return nil
}

func (x *RoboStartingIntent) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

type isRoboStartingIntent_StartingIntent interface {
	isRoboStartingIntent_StartingIntent()
}

type RoboStartingIntent_LauncherActivity struct {
	// An intent that starts the main launcher activity.
	LauncherActivity *LauncherActivityIntent `protobuf:"bytes,1,opt,name=launcher_activity,json=launcherActivity,proto3,oneof"`
}

type RoboStartingIntent_StartActivity struct {
	// An intent that starts an activity with specific details.
	StartActivity *StartActivityIntent `protobuf:"bytes,2,opt,name=start_activity,json=startActivity,proto3,oneof"`
}

func (*RoboStartingIntent_LauncherActivity) isRoboStartingIntent_StartingIntent() {}

func (*RoboStartingIntent_StartActivity) isRoboStartingIntent_StartingIntent() {}

// Specifies an intent that starts the main launcher activity.
type LauncherActivityIntent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *LauncherActivityIntent) Reset() {
	*x = LauncherActivityIntent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LauncherActivityIntent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LauncherActivityIntent) ProtoMessage() {}

func (x *LauncherActivityIntent) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LauncherActivityIntent.ProtoReflect.Descriptor instead.
func (*LauncherActivityIntent) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{22}
}

// A starting intent specified by an action, uri, and categories.
type StartActivityIntent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Action name.
	// Required for START_ACTIVITY.
	Action string `protobuf:"bytes,2,opt,name=action,proto3" json:"action,omitempty"`
	// URI for the action.
	Uri string `protobuf:"bytes,3,opt,name=uri,proto3" json:"uri,omitempty"`
	// Intent categories to set on the intent.
	Categories []string `protobuf:"bytes,4,rep,name=categories,proto3" json:"categories,omitempty"`
}

func (x *StartActivityIntent) Reset() {
	*x = StartActivityIntent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartActivityIntent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartActivityIntent) ProtoMessage() {}

func (x *StartActivityIntent) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartActivityIntent.ProtoReflect.Descriptor instead.
func (*StartActivityIntent) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{23}
}

func (x *StartActivityIntent) GetAction() string {
	if x != nil {
		return x.Action
	}
	return ""
}

func (x *StartActivityIntent) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *StartActivityIntent) GetCategories() []string {
	if x != nil {
		return x.Categories
	}
	return nil
}

// The matrix of environments in which the test is to be executed.
type EnvironmentMatrix struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The environment matrix.
	//
	// Types that are assignable to EnvironmentMatrix:
	//
	//	*EnvironmentMatrix_AndroidMatrix
	//	*EnvironmentMatrix_AndroidDeviceList
	//	*EnvironmentMatrix_IosDeviceList
	EnvironmentMatrix isEnvironmentMatrix_EnvironmentMatrix `protobuf_oneof:"environment_matrix"`
}

func (x *EnvironmentMatrix) Reset() {
	*x = EnvironmentMatrix{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnvironmentMatrix) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvironmentMatrix) ProtoMessage() {}

func (x *EnvironmentMatrix) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvironmentMatrix.ProtoReflect.Descriptor instead.
func (*EnvironmentMatrix) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{24}
}

func (m *EnvironmentMatrix) GetEnvironmentMatrix() isEnvironmentMatrix_EnvironmentMatrix {
	if m != nil {
		return m.EnvironmentMatrix
	}
	return nil
}

func (x *EnvironmentMatrix) GetAndroidMatrix() *AndroidMatrix {
	if x, ok := x.GetEnvironmentMatrix().(*EnvironmentMatrix_AndroidMatrix); ok {
		return x.AndroidMatrix
	}
	return nil
}

func (x *EnvironmentMatrix) GetAndroidDeviceList() *AndroidDeviceList {
	if x, ok := x.GetEnvironmentMatrix().(*EnvironmentMatrix_AndroidDeviceList); ok {
		return x.AndroidDeviceList
	}
	return nil
}

func (x *EnvironmentMatrix) GetIosDeviceList() *IosDeviceList {
	if x, ok := x.GetEnvironmentMatrix().(*EnvironmentMatrix_IosDeviceList); ok {
		return x.IosDeviceList
	}
	return nil
}

type isEnvironmentMatrix_EnvironmentMatrix interface {
	isEnvironmentMatrix_EnvironmentMatrix()
}

type EnvironmentMatrix_AndroidMatrix struct {
	// A matrix of Android devices.
	AndroidMatrix *AndroidMatrix `protobuf:"bytes,1,opt,name=android_matrix,json=androidMatrix,proto3,oneof"`
}

type EnvironmentMatrix_AndroidDeviceList struct {
	// A list of Android devices; the test will be run only on the specified
	// devices.
	AndroidDeviceList *AndroidDeviceList `protobuf:"bytes,2,opt,name=android_device_list,json=androidDeviceList,proto3,oneof"`
}

type EnvironmentMatrix_IosDeviceList struct {
	// A list of iOS devices.
	IosDeviceList *IosDeviceList `protobuf:"bytes,3,opt,name=ios_device_list,json=iosDeviceList,proto3,oneof"`
}

func (*EnvironmentMatrix_AndroidMatrix) isEnvironmentMatrix_EnvironmentMatrix() {}

func (*EnvironmentMatrix_AndroidDeviceList) isEnvironmentMatrix_EnvironmentMatrix() {}

func (*EnvironmentMatrix_IosDeviceList) isEnvironmentMatrix_EnvironmentMatrix() {}

// A list of Android device configurations in which the test is to be executed.
type AndroidDeviceList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of Android devices.
	AndroidDevices []*AndroidDevice `protobuf:"bytes,1,rep,name=android_devices,json=androidDevices,proto3" json:"android_devices,omitempty"`
}

func (x *AndroidDeviceList) Reset() {
	*x = AndroidDeviceList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AndroidDeviceList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AndroidDeviceList) ProtoMessage() {}

func (x *AndroidDeviceList) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AndroidDeviceList.ProtoReflect.Descriptor instead.
func (*AndroidDeviceList) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{25}
}

func (x *AndroidDeviceList) GetAndroidDevices() []*AndroidDevice {
	if x != nil {
		return x.AndroidDevices
	}
	return nil
}

// A list of iOS device configurations in which the test is to be executed.
type IosDeviceList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of iOS devices.
	IosDevices []*IosDevice `protobuf:"bytes,1,rep,name=ios_devices,json=iosDevices,proto3" json:"ios_devices,omitempty"`
}

func (x *IosDeviceList) Reset() {
	*x = IosDeviceList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IosDeviceList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IosDeviceList) ProtoMessage() {}

func (x *IosDeviceList) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IosDeviceList.ProtoReflect.Descriptor instead.
func (*IosDeviceList) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{26}
}

func (x *IosDeviceList) GetIosDevices() []*IosDevice {
	if x != nil {
		return x.IosDevices
	}
	return nil
}

// A set of Android device configuration permutations is defined by the
// the cross-product of the given axes. Internally, the given AndroidMatrix
// will be expanded into a set of AndroidDevices.
//
// Only supported permutations will be instantiated.  Invalid permutations
// (e.g., incompatible models/versions) are ignored.
type AndroidMatrix struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ids of the set of Android device to be used.
	// Use the TestEnvironmentDiscoveryService to get supported options.
	AndroidModelIds []string `protobuf:"bytes,1,rep,name=android_model_ids,json=androidModelIds,proto3" json:"android_model_ids,omitempty"`
	// Required. The ids of the set of Android OS version to be used.
	// Use the TestEnvironmentDiscoveryService to get supported options.
	AndroidVersionIds []string `protobuf:"bytes,2,rep,name=android_version_ids,json=androidVersionIds,proto3" json:"android_version_ids,omitempty"`
	// Required. The set of locales the test device will enable for testing.
	// Use the TestEnvironmentDiscoveryService to get supported options.
	Locales []string `protobuf:"bytes,3,rep,name=locales,proto3" json:"locales,omitempty"`
	// Required. The set of orientations to test with.
	// Use the TestEnvironmentDiscoveryService to get supported options.
	Orientations []string `protobuf:"bytes,4,rep,name=orientations,proto3" json:"orientations,omitempty"`
}

func (x *AndroidMatrix) Reset() {
	*x = AndroidMatrix{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AndroidMatrix) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AndroidMatrix) ProtoMessage() {}

func (x *AndroidMatrix) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AndroidMatrix.ProtoReflect.Descriptor instead.
func (*AndroidMatrix) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{27}
}

func (x *AndroidMatrix) GetAndroidModelIds() []string {
	if x != nil {
		return x.AndroidModelIds
	}
	return nil
}

func (x *AndroidMatrix) GetAndroidVersionIds() []string {
	if x != nil {
		return x.AndroidVersionIds
	}
	return nil
}

func (x *AndroidMatrix) GetLocales() []string {
	if x != nil {
		return x.Locales
	}
	return nil
}

func (x *AndroidMatrix) GetOrientations() []string {
	if x != nil {
		return x.Orientations
	}
	return nil
}

// Information about the client which invoked the test.
type ClientInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Client name, such as gcloud.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The list of detailed information about client.
	ClientInfoDetails []*ClientInfoDetail `protobuf:"bytes,2,rep,name=client_info_details,json=clientInfoDetails,proto3" json:"client_info_details,omitempty"`
}

func (x *ClientInfo) Reset() {
	*x = ClientInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientInfo) ProtoMessage() {}

func (x *ClientInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientInfo.ProtoReflect.Descriptor instead.
func (*ClientInfo) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{28}
}

func (x *ClientInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ClientInfo) GetClientInfoDetails() []*ClientInfoDetail {
	if x != nil {
		return x.ClientInfoDetails
	}
	return nil
}

// Key-value pair of detailed information about the client which invoked the
// test. Examples: {'Version', '1.0'}, {'Release Track', 'BETA'}.
type ClientInfoDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The key of detailed client information.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Required. The value of detailed client information.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *ClientInfoDetail) Reset() {
	*x = ClientInfoDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientInfoDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientInfoDetail) ProtoMessage() {}

func (x *ClientInfoDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientInfoDetail.ProtoReflect.Descriptor instead.
func (*ClientInfoDetail) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{29}
}

func (x *ClientInfoDetail) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *ClientInfoDetail) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// Locations where the results of running the test are stored.
type ResultStorage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	GoogleCloudStorage *GoogleCloudStorage `protobuf:"bytes,1,opt,name=google_cloud_storage,json=googleCloudStorage,proto3" json:"google_cloud_storage,omitempty"`
	// The tool results history that contains the tool results execution that
	// results are written to.
	//
	// If not provided, the service will choose an appropriate value.
	ToolResultsHistory *ToolResultsHistory `protobuf:"bytes,5,opt,name=tool_results_history,json=toolResultsHistory,proto3" json:"tool_results_history,omitempty"`
	// Output only. The tool results execution that results are written to.
	ToolResultsExecution *ToolResultsExecution `protobuf:"bytes,6,opt,name=tool_results_execution,json=toolResultsExecution,proto3" json:"tool_results_execution,omitempty"`
	// Output only. URL to the results in the Firebase Web Console.
	ResultsUrl string `protobuf:"bytes,7,opt,name=results_url,json=resultsUrl,proto3" json:"results_url,omitempty"`
}

func (x *ResultStorage) Reset() {
	*x = ResultStorage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResultStorage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResultStorage) ProtoMessage() {}

func (x *ResultStorage) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResultStorage.ProtoReflect.Descriptor instead.
func (*ResultStorage) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{30}
}

func (x *ResultStorage) GetGoogleCloudStorage() *GoogleCloudStorage {
	if x != nil {
		return x.GoogleCloudStorage
	}
	return nil
}

func (x *ResultStorage) GetToolResultsHistory() *ToolResultsHistory {
	if x != nil {
		return x.ToolResultsHistory
	}
	return nil
}

func (x *ResultStorage) GetToolResultsExecution() *ToolResultsExecution {
	if x != nil {
		return x.ToolResultsExecution
	}
	return nil
}

func (x *ResultStorage) GetResultsUrl() string {
	if x != nil {
		return x.ResultsUrl
	}
	return ""
}

// Represents a tool results history resource.
type ToolResultsHistory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The cloud project that owns the tool results history.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. A tool results history ID.
	HistoryId string `protobuf:"bytes,2,opt,name=history_id,json=historyId,proto3" json:"history_id,omitempty"`
}

func (x *ToolResultsHistory) Reset() {
	*x = ToolResultsHistory{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ToolResultsHistory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolResultsHistory) ProtoMessage() {}

func (x *ToolResultsHistory) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolResultsHistory.ProtoReflect.Descriptor instead.
func (*ToolResultsHistory) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{31}
}

func (x *ToolResultsHistory) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ToolResultsHistory) GetHistoryId() string {
	if x != nil {
		return x.HistoryId
	}
	return ""
}

// Represents a tool results execution resource.
//
// This has the results of a TestMatrix.
type ToolResultsExecution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The cloud project that owns the tool results execution.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Output only. A tool results history ID.
	HistoryId string `protobuf:"bytes,2,opt,name=history_id,json=historyId,proto3" json:"history_id,omitempty"`
	// Output only. A tool results execution ID.
	ExecutionId string `protobuf:"bytes,3,opt,name=execution_id,json=executionId,proto3" json:"execution_id,omitempty"`
}

func (x *ToolResultsExecution) Reset() {
	*x = ToolResultsExecution{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ToolResultsExecution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolResultsExecution) ProtoMessage() {}

func (x *ToolResultsExecution) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolResultsExecution.ProtoReflect.Descriptor instead.
func (*ToolResultsExecution) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{32}
}

func (x *ToolResultsExecution) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ToolResultsExecution) GetHistoryId() string {
	if x != nil {
		return x.HistoryId
	}
	return ""
}

func (x *ToolResultsExecution) GetExecutionId() string {
	if x != nil {
		return x.ExecutionId
	}
	return ""
}

// Represents a tool results step resource.
//
// This has the results of a TestExecution.
type ToolResultsStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The cloud project that owns the tool results step.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Output only. A tool results history ID.
	HistoryId string `protobuf:"bytes,2,opt,name=history_id,json=historyId,proto3" json:"history_id,omitempty"`
	// Output only. A tool results execution ID.
	ExecutionId string `protobuf:"bytes,3,opt,name=execution_id,json=executionId,proto3" json:"execution_id,omitempty"`
	// Output only. A tool results step ID.
	StepId string `protobuf:"bytes,4,opt,name=step_id,json=stepId,proto3" json:"step_id,omitempty"`
}

func (x *ToolResultsStep) Reset() {
	*x = ToolResultsStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ToolResultsStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolResultsStep) ProtoMessage() {}

func (x *ToolResultsStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolResultsStep.ProtoReflect.Descriptor instead.
func (*ToolResultsStep) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{33}
}

func (x *ToolResultsStep) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ToolResultsStep) GetHistoryId() string {
	if x != nil {
		return x.HistoryId
	}
	return ""
}

func (x *ToolResultsStep) GetExecutionId() string {
	if x != nil {
		return x.ExecutionId
	}
	return ""
}

func (x *ToolResultsStep) GetStepId() string {
	if x != nil {
		return x.StepId
	}
	return ""
}

// A storage location within Google cloud storage (GCS).
type GoogleCloudStorage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The path to a directory in GCS that will
	// eventually contain the results for this test.
	// The requesting user must have write access on the bucket in the supplied
	// path.
	GcsPath string `protobuf:"bytes,1,opt,name=gcs_path,json=gcsPath,proto3" json:"gcs_path,omitempty"`
}

func (x *GoogleCloudStorage) Reset() {
	*x = GoogleCloudStorage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GoogleCloudStorage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoogleCloudStorage) ProtoMessage() {}

func (x *GoogleCloudStorage) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoogleCloudStorage.ProtoReflect.Descriptor instead.
func (*GoogleCloudStorage) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{34}
}

func (x *GoogleCloudStorage) GetGcsPath() string {
	if x != nil {
		return x.GcsPath
	}
	return ""
}

// A reference to a file, used for user inputs.
type FileReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The file reference.
	//
	// Types that are assignable to File:
	//
	//	*FileReference_GcsPath
	File isFileReference_File `protobuf_oneof:"file"`
}

func (x *FileReference) Reset() {
	*x = FileReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileReference) ProtoMessage() {}

func (x *FileReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileReference.ProtoReflect.Descriptor instead.
func (*FileReference) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{35}
}

func (m *FileReference) GetFile() isFileReference_File {
	if m != nil {
		return m.File
	}
	return nil
}

func (x *FileReference) GetGcsPath() string {
	if x, ok := x.GetFile().(*FileReference_GcsPath); ok {
		return x.GcsPath
	}
	return ""
}

type isFileReference_File interface {
	isFileReference_File()
}

type FileReference_GcsPath struct {
	// A path to a file in Google Cloud Storage.
	// Example: gs://build-app-1414623860166/app%40debug-unaligned.apk
	// These paths are expected to be url encoded (percent encoding)
	GcsPath string `protobuf:"bytes,1,opt,name=gcs_path,json=gcsPath,proto3,oneof"`
}

func (*FileReference_GcsPath) isFileReference_File() {}

// The environment in which the test is run.
type Environment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The environment.
	//
	// Types that are assignable to Environment:
	//
	//	*Environment_AndroidDevice
	//	*Environment_IosDevice
	Environment isEnvironment_Environment `protobuf_oneof:"environment"`
}

func (x *Environment) Reset() {
	*x = Environment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Environment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Environment) ProtoMessage() {}

func (x *Environment) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Environment.ProtoReflect.Descriptor instead.
func (*Environment) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{36}
}

func (m *Environment) GetEnvironment() isEnvironment_Environment {
	if m != nil {
		return m.Environment
	}
	return nil
}

func (x *Environment) GetAndroidDevice() *AndroidDevice {
	if x, ok := x.GetEnvironment().(*Environment_AndroidDevice); ok {
		return x.AndroidDevice
	}
	return nil
}

func (x *Environment) GetIosDevice() *IosDevice {
	if x, ok := x.GetEnvironment().(*Environment_IosDevice); ok {
		return x.IosDevice
	}
	return nil
}

type isEnvironment_Environment interface {
	isEnvironment_Environment()
}

type Environment_AndroidDevice struct {
	// An Android device which must be used with an Android test.
	AndroidDevice *AndroidDevice `protobuf:"bytes,1,opt,name=android_device,json=androidDevice,proto3,oneof"`
}

type Environment_IosDevice struct {
	// An iOS device which must be used with an iOS test.
	IosDevice *IosDevice `protobuf:"bytes,2,opt,name=ios_device,json=iosDevice,proto3,oneof"`
}

func (*Environment_AndroidDevice) isEnvironment_Environment() {}

func (*Environment_IosDevice) isEnvironment_Environment() {}

// A single Android device.
type AndroidDevice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The id of the Android device to be used.
	// Use the TestEnvironmentDiscoveryService to get supported options.
	AndroidModelId string `protobuf:"bytes,1,opt,name=android_model_id,json=androidModelId,proto3" json:"android_model_id,omitempty"`
	// Required. The id of the Android OS version to be used.
	// Use the TestEnvironmentDiscoveryService to get supported options.
	AndroidVersionId string `protobuf:"bytes,2,opt,name=android_version_id,json=androidVersionId,proto3" json:"android_version_id,omitempty"`
	// Required. The locale the test device used for testing.
	// Use the TestEnvironmentDiscoveryService to get supported options.
	Locale string `protobuf:"bytes,3,opt,name=locale,proto3" json:"locale,omitempty"`
	// Required. How the device is oriented during the test.
	// Use the TestEnvironmentDiscoveryService to get supported options.
	Orientation string `protobuf:"bytes,4,opt,name=orientation,proto3" json:"orientation,omitempty"`
}

func (x *AndroidDevice) Reset() {
	*x = AndroidDevice{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AndroidDevice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AndroidDevice) ProtoMessage() {}

func (x *AndroidDevice) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AndroidDevice.ProtoReflect.Descriptor instead.
func (*AndroidDevice) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{37}
}

func (x *AndroidDevice) GetAndroidModelId() string {
	if x != nil {
		return x.AndroidModelId
	}
	return ""
}

func (x *AndroidDevice) GetAndroidVersionId() string {
	if x != nil {
		return x.AndroidVersionId
	}
	return ""
}

func (x *AndroidDevice) GetLocale() string {
	if x != nil {
		return x.Locale
	}
	return ""
}

func (x *AndroidDevice) GetOrientation() string {
	if x != nil {
		return x.Orientation
	}
	return ""
}

// A single iOS device.
type IosDevice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The id of the iOS device to be used.
	// Use the TestEnvironmentDiscoveryService to get supported options.
	IosModelId string `protobuf:"bytes,1,opt,name=ios_model_id,json=iosModelId,proto3" json:"ios_model_id,omitempty"`
	// Required. The id of the iOS major software version to be used.
	// Use the TestEnvironmentDiscoveryService to get supported options.
	IosVersionId string `protobuf:"bytes,2,opt,name=ios_version_id,json=iosVersionId,proto3" json:"ios_version_id,omitempty"`
	// Required. The locale the test device used for testing.
	// Use the TestEnvironmentDiscoveryService to get supported options.
	Locale string `protobuf:"bytes,3,opt,name=locale,proto3" json:"locale,omitempty"`
	// Required. How the device is oriented during the test.
	// Use the TestEnvironmentDiscoveryService to get supported options.
	Orientation string `protobuf:"bytes,4,opt,name=orientation,proto3" json:"orientation,omitempty"`
}

func (x *IosDevice) Reset() {
	*x = IosDevice{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IosDevice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IosDevice) ProtoMessage() {}

func (x *IosDevice) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IosDevice.ProtoReflect.Descriptor instead.
func (*IosDevice) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{38}
}

func (x *IosDevice) GetIosModelId() string {
	if x != nil {
		return x.IosModelId
	}
	return ""
}

func (x *IosDevice) GetIosVersionId() string {
	if x != nil {
		return x.IosVersionId
	}
	return ""
}

func (x *IosDevice) GetLocale() string {
	if x != nil {
		return x.Locale
	}
	return ""
}

func (x *IosDevice) GetOrientation() string {
	if x != nil {
		return x.Orientation
	}
	return ""
}

// Additional details about the progress of the running test.
type TestDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Human-readable, detailed descriptions of the test's progress.
	// For example: "Provisioning a device", "Starting Test".
	//
	// During the course of execution new data may be appended
	// to the end of progress_messages.
	ProgressMessages []string `protobuf:"bytes,3,rep,name=progress_messages,json=progressMessages,proto3" json:"progress_messages,omitempty"`
	// Output only. If the TestState is ERROR, then this string will contain
	// human-readable details about the error.
	ErrorMessage string `protobuf:"bytes,4,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
}

func (x *TestDetails) Reset() {
	*x = TestDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestDetails) ProtoMessage() {}

func (x *TestDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestDetails.ProtoReflect.Descriptor instead.
func (*TestDetails) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{39}
}

func (x *TestDetails) GetProgressMessages() []string {
	if x != nil {
		return x.ProgressMessages
	}
	return nil
}

func (x *TestDetails) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

// Details behind an invalid request.
type InvalidRequestDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The reason behind the error.
	Reason InvalidRequestDetail_Reason `protobuf:"varint,1,opt,name=reason,proto3,enum=google.devtools.testing.v1.InvalidRequestDetail_Reason" json:"reason,omitempty"`
}

func (x *InvalidRequestDetail) Reset() {
	*x = InvalidRequestDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InvalidRequestDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InvalidRequestDetail) ProtoMessage() {}

func (x *InvalidRequestDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InvalidRequestDetail.ProtoReflect.Descriptor instead.
func (*InvalidRequestDetail) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{40}
}

func (x *InvalidRequestDetail) GetReason() InvalidRequestDetail_Reason {
	if x != nil {
		return x.Reason
	}
	return InvalidRequestDetail_REASON_UNSPECIFIED
}

// Options for enabling sharding.
type ShardingOption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Option:
	//
	//	*ShardingOption_UniformSharding
	//	*ShardingOption_ManualSharding
	Option isShardingOption_Option `protobuf_oneof:"option"`
}

func (x *ShardingOption) Reset() {
	*x = ShardingOption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShardingOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShardingOption) ProtoMessage() {}

func (x *ShardingOption) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShardingOption.ProtoReflect.Descriptor instead.
func (*ShardingOption) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{41}
}

func (m *ShardingOption) GetOption() isShardingOption_Option {
	if m != nil {
		return m.Option
	}
	return nil
}

func (x *ShardingOption) GetUniformSharding() *UniformSharding {
	if x, ok := x.GetOption().(*ShardingOption_UniformSharding); ok {
		return x.UniformSharding
	}
	return nil
}

func (x *ShardingOption) GetManualSharding() *ManualSharding {
	if x, ok := x.GetOption().(*ShardingOption_ManualSharding); ok {
		return x.ManualSharding
	}
	return nil
}

type isShardingOption_Option interface {
	isShardingOption_Option()
}

type ShardingOption_UniformSharding struct {
	// Uniformly shards test cases given a total number of shards.
	UniformSharding *UniformSharding `protobuf:"bytes,1,opt,name=uniform_sharding,json=uniformSharding,proto3,oneof"`
}

type ShardingOption_ManualSharding struct {
	// Shards test cases into the specified groups of packages, classes, and/or
	// methods.
	ManualSharding *ManualSharding `protobuf:"bytes,2,opt,name=manual_sharding,json=manualSharding,proto3,oneof"`
}

func (*ShardingOption_UniformSharding) isShardingOption_Option() {}

func (*ShardingOption_ManualSharding) isShardingOption_Option() {}

// Uniformly shards test cases given a total number of shards.
//
// For instrumentation tests, it will be translated to "-e numShard" and "-e
// shardIndex" AndroidJUnitRunner arguments. With uniform sharding enabled,
// specifying either of these sharding arguments via `environment_variables` is
// invalid.
//
// Based on the sharding mechanism AndroidJUnitRunner uses, there is no
// guarantee that test cases will be distributed uniformly across all shards.
type UniformSharding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The total number of shards to create. This must always be a
	// positive number that is no greater than the total number of test cases.
	// When you select one or more physical devices, the number of shards must be
	// <= 50. When you select one or more ARM virtual devices, it must be <= 100.
	// When you select only x86 virtual devices, it must be <= 500.
	NumShards int32 `protobuf:"varint,1,opt,name=num_shards,json=numShards,proto3" json:"num_shards,omitempty"`
}

func (x *UniformSharding) Reset() {
	*x = UniformSharding{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UniformSharding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UniformSharding) ProtoMessage() {}

func (x *UniformSharding) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UniformSharding.ProtoReflect.Descriptor instead.
func (*UniformSharding) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{42}
}

func (x *UniformSharding) GetNumShards() int32 {
	if x != nil {
		return x.NumShards
	}
	return 0
}

// Shards test cases into the specified groups of packages, classes, and/or
// methods.
//
// With manual sharding enabled, specifying test targets via
// environment_variables or in InstrumentationTest is invalid.
type ManualSharding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Group of packages, classes, and/or test methods to be run for
	// each manually-created shard. You must specify at least one shard if this
	// field is present. When you select one or more physical devices, the number
	// of repeated test_targets_for_shard must be <= 50. When you select one or
	// more ARM virtual devices, it must be <= 100. When you select only x86
	// virtual devices, it must be <= 500.
	TestTargetsForShard []*TestTargetsForShard `protobuf:"bytes,1,rep,name=test_targets_for_shard,json=testTargetsForShard,proto3" json:"test_targets_for_shard,omitempty"`
}

func (x *ManualSharding) Reset() {
	*x = ManualSharding{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManualSharding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManualSharding) ProtoMessage() {}

func (x *ManualSharding) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManualSharding.ProtoReflect.Descriptor instead.
func (*ManualSharding) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{43}
}

func (x *ManualSharding) GetTestTargetsForShard() []*TestTargetsForShard {
	if x != nil {
		return x.TestTargetsForShard
	}
	return nil
}

// Test targets for a shard.
type TestTargetsForShard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Group of packages, classes, and/or test methods to be run for each shard.
	// The targets need to be specified in AndroidJUnitRunner argument format. For
	// example, "package com.my.packages" "class com.my.package.MyClass".
	//
	// The number of test_targets must be greater than 0.
	TestTargets []string `protobuf:"bytes,1,rep,name=test_targets,json=testTargets,proto3" json:"test_targets,omitempty"`
}

func (x *TestTargetsForShard) Reset() {
	*x = TestTargetsForShard{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestTargetsForShard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestTargetsForShard) ProtoMessage() {}

func (x *TestTargetsForShard) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestTargetsForShard.ProtoReflect.Descriptor instead.
func (*TestTargetsForShard) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{44}
}

func (x *TestTargetsForShard) GetTestTargets() []string {
	if x != nil {
		return x.TestTargets
	}
	return nil
}

// Output only. Details about the shard.
type Shard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The index of the shard among all the shards.
	ShardIndex int32 `protobuf:"varint,1,opt,name=shard_index,json=shardIndex,proto3" json:"shard_index,omitempty"`
	// Output only. The total number of shards.
	NumShards int32 `protobuf:"varint,2,opt,name=num_shards,json=numShards,proto3" json:"num_shards,omitempty"`
	// Output only. Test targets for each shard. Only set for manual sharding.
	TestTargetsForShard *TestTargetsForShard `protobuf:"bytes,3,opt,name=test_targets_for_shard,json=testTargetsForShard,proto3" json:"test_targets_for_shard,omitempty"`
}

func (x *Shard) Reset() {
	*x = Shard{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Shard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Shard) ProtoMessage() {}

func (x *Shard) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Shard.ProtoReflect.Descriptor instead.
func (*Shard) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{45}
}

func (x *Shard) GetShardIndex() int32 {
	if x != nil {
		return x.ShardIndex
	}
	return 0
}

func (x *Shard) GetNumShards() int32 {
	if x != nil {
		return x.NumShards
	}
	return 0
}

func (x *Shard) GetTestTargetsForShard() *TestTargetsForShard {
	if x != nil {
		return x.TestTargetsForShard
	}
	return nil
}

// Request to submit a matrix of tests for execution.
type CreateTestMatrixRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The GCE project under which this job will run.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The matrix of tests that the user wants to run.
	TestMatrix *TestMatrix `protobuf:"bytes,2,opt,name=test_matrix,json=testMatrix,proto3" json:"test_matrix,omitempty"`
	// A string id used to detect duplicated requests.
	// Ids are automatically scoped to a project, so
	// users should ensure the ID is unique per-project.
	// A UUID is recommended.
	//
	// Optional, but strongly recommended.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateTestMatrixRequest) Reset() {
	*x = CreateTestMatrixRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTestMatrixRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTestMatrixRequest) ProtoMessage() {}

func (x *CreateTestMatrixRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTestMatrixRequest.ProtoReflect.Descriptor instead.
func (*CreateTestMatrixRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{46}
}

func (x *CreateTestMatrixRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *CreateTestMatrixRequest) GetTestMatrix() *TestMatrix {
	if x != nil {
		return x.TestMatrix
	}
	return nil
}

func (x *CreateTestMatrixRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request to get the Test Matrix with the given id.
type GetTestMatrixRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud project that owns the test matrix.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Unique test matrix id which was assigned by the service.
	TestMatrixId string `protobuf:"bytes,2,opt,name=test_matrix_id,json=testMatrixId,proto3" json:"test_matrix_id,omitempty"`
}

func (x *GetTestMatrixRequest) Reset() {
	*x = GetTestMatrixRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTestMatrixRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTestMatrixRequest) ProtoMessage() {}

func (x *GetTestMatrixRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTestMatrixRequest.ProtoReflect.Descriptor instead.
func (*GetTestMatrixRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{47}
}

func (x *GetTestMatrixRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *GetTestMatrixRequest) GetTestMatrixId() string {
	if x != nil {
		return x.TestMatrixId
	}
	return ""
}

// Request to stop running all of the tests in the specified matrix.
type CancelTestMatrixRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud project that owns the test.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Test matrix that will be canceled.
	TestMatrixId string `protobuf:"bytes,2,opt,name=test_matrix_id,json=testMatrixId,proto3" json:"test_matrix_id,omitempty"`
}

func (x *CancelTestMatrixRequest) Reset() {
	*x = CancelTestMatrixRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelTestMatrixRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelTestMatrixRequest) ProtoMessage() {}

func (x *CancelTestMatrixRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelTestMatrixRequest.ProtoReflect.Descriptor instead.
func (*CancelTestMatrixRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{48}
}

func (x *CancelTestMatrixRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *CancelTestMatrixRequest) GetTestMatrixId() string {
	if x != nil {
		return x.TestMatrixId
	}
	return ""
}

// Response containing the current state of the specified test matrix.
type CancelTestMatrixResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current rolled-up state of the test matrix.
	// If this state is already final, then the cancelation request will
	// have no effect.
	TestState TestState `protobuf:"varint,1,opt,name=test_state,json=testState,proto3,enum=google.devtools.testing.v1.TestState" json:"test_state,omitempty"`
}

func (x *CancelTestMatrixResponse) Reset() {
	*x = CancelTestMatrixResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelTestMatrixResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelTestMatrixResponse) ProtoMessage() {}

func (x *CancelTestMatrixResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_execution_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelTestMatrixResponse.ProtoReflect.Descriptor instead.
func (*CancelTestMatrixResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP(), []int{49}
}

func (x *CancelTestMatrixResponse) GetTestState() TestState {
	if x != nil {
		return x.TestState
	}
	return TestState_TEST_STATE_UNSPECIFIED
}

var File_google_devtools_testing_v1_test_execution_proto protoreflect.FileDescriptor

var file_google_devtools_testing_v1_test_execution_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x65, 0x73,
	0x74, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfd, 0x06, 0x0a, 0x0a, 0x54, 0x65, 0x73, 0x74, 0x4d,
	0x61, 0x74, 0x72, 0x69, 0x78, 0x12, 0x24, 0x0a, 0x0e, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x61,
	0x74, 0x72, 0x69, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x74,
	0x65, 0x73, 0x74, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x47, 0x0a, 0x0b, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x5c, 0x0a, 0x12, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73,
	0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11,
	0x74, 0x65, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x5c, 0x0a, 0x12, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x6d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x52, 0x11, 0x65, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x12,
	0x52, 0x0a, 0x0f, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x74, 0x65, 0x73, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x50, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0x3b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x38, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x66, 0x0a, 0x16,
	0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x6d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x5f, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x14,
	0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x66, 0x6c, 0x61, 0x6b, 0x79, 0x5f, 0x74, 0x65,
	0x73, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x11, 0x66, 0x6c, 0x61, 0x6b, 0x79, 0x54, 0x65, 0x73, 0x74, 0x41, 0x74, 0x74, 0x65,
	0x6d, 0x70, 0x74, 0x73, 0x12, 0x53, 0x0a, 0x0f, 0x6f, 0x75, 0x74, 0x63, 0x6f, 0x6d, 0x65, 0x5f,
	0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x63, 0x6f,
	0x6d, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x0e, 0x6f, 0x75, 0x74, 0x63, 0x6f,
	0x6d, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x61, 0x69,
	0x6c, 0x5f, 0x66, 0x61, 0x73, 0x74, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x66, 0x61,
	0x69, 0x6c, 0x46, 0x61, 0x73, 0x74, 0x22, 0xd9, 0x04, 0x0a, 0x0d, 0x54, 0x65, 0x73, 0x74, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x61, 0x74, 0x72,
	0x69, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x61, 0x74,
	0x72, 0x69, 0x78, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x12, 0x5c, 0x0a, 0x12, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65,
	0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x11, 0x74, 0x65, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x05, 0x73, 0x68, 0x61, 0x72, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x68, 0x61, 0x72, 0x64, 0x52, 0x05, 0x73, 0x68, 0x61, 0x72, 0x64, 0x12, 0x49, 0x0a, 0x0b, 0x65,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x57, 0x0a, 0x11, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x53, 0x74, 0x65, 0x70, 0x52, 0x0f, 0x74, 0x6f, 0x6f,
	0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x53, 0x74, 0x65, 0x70, 0x12, 0x38, 0x0a, 0x09,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x4a, 0x0a, 0x0c, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x0b, 0x74, 0x65, 0x73, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x22, 0xbe, 0x06, 0x0a, 0x11, 0x54, 0x65, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a, 0x0c, 0x74, 0x65, 0x73, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x74, 0x65, 0x73, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x46, 0x0a, 0x0a, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x73,
	0x65, 0x74, 0x75, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x53, 0x65, 0x74, 0x75,
	0x70, 0x48, 0x00, 0x52, 0x09, 0x74, 0x65, 0x73, 0x74, 0x53, 0x65, 0x74, 0x75, 0x70, 0x12, 0x50,
	0x0a, 0x0e, 0x69, 0x6f, 0x73, 0x5f, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x75, 0x70,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6f, 0x73, 0x54, 0x65, 0x73, 0x74, 0x53, 0x65, 0x74, 0x75, 0x70,
	0x48, 0x00, 0x52, 0x0c, 0x69, 0x6f, 0x73, 0x54, 0x65, 0x73, 0x74, 0x53, 0x65, 0x74, 0x75, 0x70,
	0x12, 0x7a, 0x0a, 0x1c, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74,
	0x72, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x65, 0x73, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x73, 0x74, 0x48, 0x01,
	0x52, 0x1a, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x73, 0x74, 0x12, 0x59, 0x0a, 0x11,
	0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x72, 0x6f, 0x62, 0x6f, 0x5f, 0x74, 0x65, 0x73,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x52, 0x6f, 0x62, 0x6f,
	0x54, 0x65, 0x73, 0x74, 0x48, 0x01, 0x52, 0x0f, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x52,
	0x6f, 0x62, 0x6f, 0x54, 0x65, 0x73, 0x74, 0x12, 0x59, 0x0a, 0x11, 0x61, 0x6e, 0x64, 0x72, 0x6f,
	0x69, 0x64, 0x5f, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6c, 0x6f, 0x6f, 0x70, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x54, 0x65, 0x73, 0x74, 0x4c, 0x6f, 0x6f, 0x70, 0x48,
	0x01, 0x52, 0x0f, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x54, 0x65, 0x73, 0x74, 0x4c, 0x6f,
	0x6f, 0x70, 0x12, 0x47, 0x0a, 0x0b, 0x69, 0x6f, 0x73, 0x5f, 0x78, 0x63, 0x5f, 0x74, 0x65, 0x73,
	0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6f, 0x73, 0x58, 0x63, 0x54, 0x65, 0x73, 0x74, 0x48, 0x01,
	0x52, 0x09, 0x69, 0x6f, 0x73, 0x58, 0x63, 0x54, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x0d, 0x69,
	0x6f, 0x73, 0x5f, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6c, 0x6f, 0x6f, 0x70, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6f, 0x73, 0x54, 0x65, 0x73, 0x74, 0x4c, 0x6f, 0x6f, 0x70, 0x48, 0x01, 0x52, 0x0b, 0x69,
	0x6f, 0x73, 0x54, 0x65, 0x73, 0x74, 0x4c, 0x6f, 0x6f, 0x70, 0x12, 0x36, 0x0a, 0x17, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x72, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69,
	0x6e, 0x67, 0x12, 0x3e, 0x0a, 0x1b, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x65,
	0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x42, 0x07, 0x0a, 0x05, 0x73, 0x65, 0x74, 0x75, 0x70, 0x42, 0x06, 0x0a, 0x04, 0x74,
	0x65, 0x73, 0x74, 0x22, 0x3a, 0x0a, 0x0d, 0x53, 0x79, 0x73, 0x74, 0x72, 0x61, 0x63, 0x65, 0x53,
	0x65, 0x74, 0x75, 0x70, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x22,
	0xa8, 0x04, 0x0a, 0x09, 0x54, 0x65, 0x73, 0x74, 0x53, 0x65, 0x74, 0x75, 0x70, 0x12, 0x4a, 0x0a,
	0x0d, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x70, 0x75, 0x73, 0x68, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x0b, 0x66, 0x69,
	0x6c, 0x65, 0x73, 0x54, 0x6f, 0x50, 0x75, 0x73, 0x68, 0x12, 0x2e, 0x0a, 0x13, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x70, 0x75, 0x6c, 0x6c,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x54, 0x6f, 0x50, 0x75, 0x6c, 0x6c, 0x12, 0x48, 0x0a, 0x0f, 0x61, 0x64, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x70, 0x6b, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x70, 0x6b, 0x52, 0x0e, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x41,
	0x70, 0x6b, 0x73, 0x12, 0x3d, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x64, 0x0a, 0x15, 0x65,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61,
	0x62, 0x6c, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x14, 0x65, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65,
	0x73, 0x12, 0x49, 0x0a, 0x08, 0x73, 0x79, 0x73, 0x74, 0x72, 0x61, 0x63, 0x65, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x79, 0x73, 0x74, 0x72, 0x61, 0x63, 0x65, 0x53, 0x65, 0x74, 0x75, 0x70, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x08, 0x73, 0x79, 0x73, 0x74, 0x72, 0x61, 0x63, 0x65, 0x12, 0x3c, 0x0a, 0x1a,
	0x64, 0x6f, 0x6e, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x5f, 0x70,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x17, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x18, 0x64, 0x6f, 0x6e, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x50,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xab, 0x02, 0x0a, 0x0c, 0x49,
	0x6f, 0x73, 0x54, 0x65, 0x73, 0x74, 0x53, 0x65, 0x74, 0x75, 0x70, 0x12, 0x27, 0x0a, 0x0f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x12, 0x52, 0x0a, 0x0f, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x5f, 0x69, 0x70, 0x61, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0e, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x61, 0x73, 0x12, 0x48, 0x0a, 0x0a, 0x70, 0x75, 0x73, 0x68,
	0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6f, 0x73, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x09, 0x70, 0x75, 0x73, 0x68, 0x46, 0x69, 0x6c,
	0x65, 0x73, 0x12, 0x54, 0x0a, 0x10, 0x70, 0x75, 0x6c, 0x6c, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6f, 0x73, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x0f, 0x70, 0x75, 0x6c, 0x6c, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x22, 0x3d, 0x0a, 0x13, 0x45, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x64, 0x0a, 0x07, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x49, 0x0a, 0x0b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x75, 0x74,
	0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x48,
	0x00, 0x52, 0x0a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x42, 0x0e, 0x0a,
	0x0c, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x0c, 0x0a,
	0x0a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x22, 0x6f, 0x0a, 0x03, 0x41,
	0x70, 0x6b, 0x12, 0x45, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x6b, 0x0a, 0x09,
	0x41, 0x70, 0x70, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x54, 0x0a, 0x0f, 0x62, 0x75, 0x6e,
	0x64, 0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52,
	0x0e, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x08, 0x0a, 0x06, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x22, 0xab, 0x01, 0x0a, 0x0a, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x40, 0x0a, 0x08, 0x6f, 0x62, 0x62, 0x5f,
	0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x62, 0x46, 0x69, 0x6c, 0x65, 0x48,
	0x00, 0x52, 0x07, 0x6f, 0x62, 0x62, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x4c, 0x0a, 0x0c, 0x72, 0x65,
	0x67, 0x75, 0x6c, 0x61, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x67, 0x75, 0x6c, 0x61, 0x72, 0x46, 0x69, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x72, 0x65, 0x67,
	0x75, 0x6c, 0x61, 0x72, 0x46, 0x69, 0x6c, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x22, 0x6a, 0x0a, 0x07, 0x4f, 0x62, 0x62, 0x46, 0x69,
	0x6c, 0x65, 0x12, 0x22, 0x0a, 0x0d, 0x6f, 0x62, 0x62, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x62, 0x62, 0x46, 0x69,
	0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x03, 0x6f, 0x62, 0x62, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x03,
	0x6f, 0x62, 0x62, 0x22, 0x73, 0x0a, 0x0b, 0x52, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x46, 0x69,
	0x6c, 0x65, 0x12, 0x43, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x07,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x50, 0x61, 0x74, 0x68, 0x22, 0x92, 0x01, 0x0a, 0x0d, 0x49, 0x6f, 0x73,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x43, 0x0a, 0x07, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x50, 0x61, 0x74, 0x68, 0x22, 0x9e, 0x02,
	0x0a, 0x0f, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x54, 0x65, 0x73, 0x74, 0x4c, 0x6f, 0x6f,
	0x70, 0x12, 0x44, 0x0a, 0x07, 0x61, 0x70, 0x70, 0x5f, 0x61, 0x70, 0x6b, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52,
	0x06, 0x61, 0x70, 0x70, 0x41, 0x70, 0x6b, 0x12, 0x46, 0x0a, 0x0a, 0x61, 0x70, 0x70, 0x5f, 0x62,
	0x75, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x42, 0x75, 0x6e, 0x64,
	0x6c, 0x65, 0x48, 0x00, 0x52, 0x09, 0x61, 0x70, 0x70, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x12,
	0x24, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x70, 0x70, 0x50, 0x61, 0x63, 0x6b,
	0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x63, 0x65, 0x6e, 0x61, 0x72, 0x69,
	0x6f, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x05, 0x52, 0x09, 0x73, 0x63, 0x65, 0x6e, 0x61, 0x72,
	0x69, 0x6f, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x63, 0x65, 0x6e, 0x61, 0x72, 0x69, 0x6f, 0x5f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x63,
	0x65, 0x6e, 0x61, 0x72, 0x69, 0x6f, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x42, 0x10, 0x0a, 0x0e,
	0x61, 0x70, 0x70, 0x5f, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x74, 0x65, 0x73, 0x74, 0x22, 0xa1,
	0x02, 0x0a, 0x09, 0x49, 0x6f, 0x73, 0x58, 0x63, 0x54, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x09,
	0x74, 0x65, 0x73, 0x74, 0x73, 0x5f, 0x7a, 0x69, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c,
	0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x74, 0x65, 0x73, 0x74,
	0x73, 0x5a, 0x69, 0x70, 0x12, 0x47, 0x0a, 0x09, 0x78, 0x63, 0x74, 0x65, 0x73, 0x74, 0x72, 0x75,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x09, 0x78, 0x63, 0x74, 0x65, 0x73, 0x74, 0x72, 0x75, 0x6e, 0x12, 0x23, 0x0a,
	0x0d, 0x78, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x78, 0x63, 0x6f, 0x64, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0d, 0x61, 0x70, 0x70, 0x5f, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x70, 0x70, 0x42, 0x75,
	0x6e, 0x64, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x3a, 0x0a, 0x19, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x74, 0x65, 0x73, 0x74, 0x53,
	0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x22, 0x93, 0x01, 0x0a, 0x0b, 0x49, 0x6f, 0x73, 0x54, 0x65, 0x73, 0x74, 0x4c, 0x6f,
	0x6f, 0x70, 0x12, 0x42, 0x0a, 0x07, 0x61, 0x70, 0x70, 0x5f, 0x69, 0x70, 0x61, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x06,
	0x61, 0x70, 0x70, 0x49, 0x70, 0x61, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x63, 0x65, 0x6e, 0x61, 0x72,
	0x69, 0x6f, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x05, 0x52, 0x09, 0x73, 0x63, 0x65, 0x6e, 0x61,
	0x72, 0x69, 0x6f, 0x73, 0x12, 0x22, 0x0a, 0x0d, 0x61, 0x70, 0x70, 0x5f, 0x62, 0x75, 0x6e, 0x64,
	0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x70, 0x70,
	0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x49, 0x64, 0x22, 0xd5, 0x04, 0x0a, 0x1a, 0x41, 0x6e, 0x64,
	0x72, 0x6f, 0x69, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x07, 0x61, 0x70, 0x70, 0x5f, 0x61,
	0x70, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x06, 0x61, 0x70, 0x70, 0x41, 0x70, 0x6b, 0x12, 0x46, 0x0a,
	0x0a, 0x61, 0x70, 0x70, 0x5f, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x70, 0x70, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x09, 0x61, 0x70, 0x70, 0x42,
	0x75, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x44, 0x0a, 0x08, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x61, 0x70,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x07, 0x74, 0x65, 0x73, 0x74, 0x41, 0x70, 0x6b, 0x12, 0x24, 0x0a, 0x0e, 0x61,
	0x70, 0x70, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x70, 0x70, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x49,
	0x64, 0x12, 0x26, 0x0a, 0x0f, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x74, 0x65, 0x73, 0x74,
	0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x11, 0x74, 0x65, 0x73,
	0x74, 0x5f, 0x72, 0x75, 0x6e, 0x6e, 0x65, 0x72, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x74, 0x65, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x6e, 0x65, 0x72,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x74, 0x65, 0x73,
	0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x12, 0x5f, 0x0a, 0x13, 0x6f, 0x72, 0x63, 0x68,
	0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x0f, 0x73, 0x68, 0x61,
	0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e,
	0x73, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x10,
	0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x74, 0x65, 0x73, 0x74,
	0x22, 0x89, 0x05, 0x0a, 0x0f, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x52, 0x6f, 0x62, 0x6f,
	0x54, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x07, 0x61, 0x70, 0x70, 0x5f, 0x61, 0x70, 0x6b, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x48, 0x00, 0x52, 0x06, 0x61, 0x70, 0x70, 0x41, 0x70, 0x6b, 0x12, 0x46, 0x0a, 0x0a, 0x61, 0x70,
	0x70, 0x5f, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x42,
	0x75, 0x6e, 0x64, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x09, 0x61, 0x70, 0x70, 0x42, 0x75, 0x6e, 0x64,
	0x6c, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x70, 0x70, 0x50,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x14, 0x61, 0x70, 0x70, 0x5f,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x70, 0x70, 0x49, 0x6e, 0x69, 0x74, 0x69,
	0x61, 0x6c, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x12, 0x1f, 0x0a, 0x09, 0x6d, 0x61,
	0x78, 0x5f, 0x64, 0x65, 0x70, 0x74, 0x68, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x44, 0x65, 0x70, 0x74, 0x68, 0x12, 0x1f, 0x0a, 0x09, 0x6d,
	0x61, 0x78, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x53, 0x74, 0x65, 0x70, 0x73, 0x12, 0x52, 0x0a, 0x0f,
	0x72, 0x6f, 0x62, 0x6f, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x73, 0x18,
	0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x6f, 0x62, 0x6f, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x52, 0x0e, 0x72, 0x6f, 0x62, 0x6f, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x73,
	0x12, 0x41, 0x0a, 0x09, 0x72, 0x6f, 0x62, 0x6f, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x6f, 0x62, 0x6f, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x08, 0x72, 0x6f, 0x62, 0x6f, 0x4d,
	0x6f, 0x64, 0x65, 0x12, 0x4a, 0x0a, 0x0b, 0x72, 0x6f, 0x62, 0x6f, 0x5f, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x52, 0x0a, 0x72, 0x6f, 0x62, 0x6f, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12,
	0x59, 0x0a, 0x10, 0x73, 0x74, 0x61, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x62, 0x6f, 0x53, 0x74, 0x61, 0x72, 0x74,
	0x69, 0x6e, 0x67, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x69, 0x6e, 0x67, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x42, 0x10, 0x0a, 0x0e, 0x61, 0x70,
	0x70, 0x5f, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x74, 0x65, 0x73, 0x74, 0x22, 0xa0, 0x01, 0x0a,
	0x0d, 0x52, 0x6f, 0x62, 0x6f, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x23,
	0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x54, 0x65,
	0x78, 0x74, 0x12, 0x4b, 0x0a, 0x0b, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x62, 0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0a, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x22,
	0x99, 0x02, 0x0a, 0x12, 0x52, 0x6f, 0x62, 0x6f, 0x53, 0x74, 0x61, 0x72, 0x74, 0x69, 0x6e, 0x67,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x61, 0x0a, 0x11, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68,
	0x65, 0x72, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x61, 0x75, 0x6e, 0x63, 0x68, 0x65, 0x72, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x10, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x65,
	0x72, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x12, 0x58, 0x0a, 0x0e, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x61, 0x72, 0x74, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x72, 0x74, 0x41, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x12, 0x33, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x42, 0x11, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x18, 0x0a, 0x16, 0x4c,
	0x61, 0x75, 0x6e, 0x63, 0x68, 0x65, 0x72, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x5f, 0x0a, 0x13, 0x53, 0x74, 0x61, 0x72, 0x74, 0x41, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f,
	0x72, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x22, 0xb3, 0x02, 0x0a, 0x11, 0x45, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x12, 0x52, 0x0a, 0x0e,
	0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x6d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x48,
	0x00, 0x52, 0x0d, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78,
	0x12, 0x5f, 0x0a, 0x13, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f,
	0x69, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x11,
	0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x69, 0x73,
	0x74, 0x12, 0x53, 0x0a, 0x0f, 0x69, 0x6f, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x6c, 0x69, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6f, 0x73, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0d, 0x69, 0x6f, 0x73, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x14, 0x0a, 0x12, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x22, 0x67, 0x0a, 0x11,
	0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x69, 0x73,
	0x74, 0x12, 0x52, 0x0a, 0x0f, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x0e, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x22, 0x57, 0x0a, 0x0d, 0x49, 0x6f, 0x73, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x0b, 0x69, 0x6f, 0x73, 0x5f, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6f, 0x73, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x52, 0x0a, 0x69, 0x6f, 0x73, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x22, 0xa9,
	0x01, 0x0a, 0x0d, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78,
	0x12, 0x2a, 0x0a, 0x11, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x6e, 0x64,
	0x72, 0x6f, 0x69, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x64, 0x73, 0x12, 0x2e, 0x0a, 0x13,
	0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x61, 0x6e, 0x64, 0x72, 0x6f,
	0x69, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x18, 0x0a, 0x07,
	0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x6c,
	0x6f, 0x63, 0x61, 0x6c, 0x65, 0x73, 0x12, 0x22, 0x0a, 0x0c, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x6f, 0x72,
	0x69, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x7e, 0x0a, 0x0a, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5c, 0x0a, 0x13,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66,
	0x6f, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x11, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49,
	0x6e, 0x66, 0x6f, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x3a, 0x0a, 0x10, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xdc, 0x02, 0x0a, 0x0d, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0x60, 0x0a, 0x14, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x52, 0x12, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0x60, 0x0a, 0x14, 0x74, 0x6f,
	0x6f, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x5f, 0x68, 0x69, 0x73, 0x74, 0x6f,
	0x72, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x12, 0x74, 0x6f, 0x6f, 0x6c, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x66, 0x0a, 0x16,
	0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x5f, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14,
	0x74, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x5f,
	0x75, 0x72, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x55, 0x72, 0x6c, 0x22, 0x52, 0x0a, 0x12, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x68, 0x69,
	0x73, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x22, 0x77, 0x0a, 0x14, 0x54, 0x6f, 0x6f,
	0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64,
	0x12, 0x1d, 0x0a, 0x0a, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x12,
	0x21, 0x0a, 0x0c, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x22, 0x8b, 0x01, 0x0a, 0x0f, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x53, 0x74, 0x65, 0x70, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x68, 0x69, 0x73, 0x74, 0x6f,
	0x72, 0x79, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x73, 0x74, 0x65, 0x70, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x74, 0x65, 0x70, 0x49, 0x64,
	0x22, 0x2f, 0x0a, 0x12, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x67, 0x63, 0x73, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x63, 0x73, 0x50, 0x61, 0x74,
	0x68, 0x22, 0x34, 0x0a, 0x0d, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x12, 0x1b, 0x0a, 0x08, 0x67, 0x63, 0x73, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x67, 0x63, 0x73, 0x50, 0x61, 0x74, 0x68, 0x42,
	0x06, 0x0a, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x22, 0xb8, 0x01, 0x0a, 0x0b, 0x45, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x52, 0x0a, 0x0e, 0x61, 0x6e, 0x64, 0x72, 0x6f,
	0x69, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x64,
	0x72, 0x6f, 0x69, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x61, 0x6e,
	0x64, 0x72, 0x6f, 0x69, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x46, 0x0a, 0x0a, 0x69,
	0x6f, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6f, 0x73,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x69, 0x6f, 0x73, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x22, 0xa1, 0x01, 0x0a, 0x0d, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e,
	0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x2c,
	0x0a, 0x12, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x61, 0x6e, 0x64, 0x72,
	0x6f, 0x69, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06,
	0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6c, 0x6f,
	0x63, 0x61, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x72, 0x69, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8d, 0x01, 0x0a, 0x09, 0x49, 0x6f, 0x73, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x69, 0x6f, 0x73, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6f, 0x73, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x69, 0x6f, 0x73, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x69, 0x6f, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06,
	0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6c, 0x6f,
	0x63, 0x61, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x72, 0x69, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x5f, 0x0a, 0x0b, 0x54, 0x65, 0x73, 0x74, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x10, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xf3, 0x01, 0x0a, 0x14, 0x49, 0x6e, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x12, 0x4f, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x22, 0x89, 0x01, 0x0a, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12,
	0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f,
	0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x45, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x4f, 0x4f, 0x5f, 0x42, 0x49, 0x47, 0x10, 0x02, 0x12,
	0x16, 0x0a, 0x12, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f,
	0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x55, 0x50,
	0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x04, 0x12, 0x13, 0x0a, 0x0f, 0x4e, 0x4f, 0x54, 0x5f,
	0x49, 0x4d, 0x50, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x45, 0x44, 0x10, 0x05, 0x22, 0xcb, 0x01,
	0x0a, 0x0e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x58, 0x0a, 0x10, 0x75, 0x6e, 0x69, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x73, 0x68, 0x61, 0x72,
	0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x69, 0x66, 0x6f, 0x72, 0x6d, 0x53,
	0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x48, 0x00, 0x52, 0x0f, 0x75, 0x6e, 0x69, 0x66, 0x6f,
	0x72, 0x6d, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x55, 0x0a, 0x0f, 0x6d, 0x61,
	0x6e, 0x75, 0x61, 0x6c, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x48,
	0x00, 0x52, 0x0e, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e,
	0x67, 0x42, 0x08, 0x0a, 0x06, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x30, 0x0a, 0x0f, 0x55,
	0x6e, 0x69, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x1d,
	0x0a, 0x0a, 0x6e, 0x75, 0x6d, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x09, 0x6e, 0x75, 0x6d, 0x53, 0x68, 0x61, 0x72, 0x64, 0x73, 0x22, 0x76, 0x0a,
	0x0e, 0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x12,
	0x64, 0x0a, 0x16, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x5f,
	0x66, 0x6f, 0x72, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73,
	0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x46, 0x6f, 0x72, 0x53, 0x68, 0x61, 0x72, 0x64,
	0x52, 0x13, 0x74, 0x65, 0x73, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x46, 0x6f, 0x72,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x22, 0x38, 0x0a, 0x13, 0x54, 0x65, 0x73, 0x74, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x73, 0x46, 0x6f, 0x72, 0x53, 0x68, 0x61, 0x72, 0x64, 0x12, 0x21, 0x0a, 0x0c,
	0x74, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x74, 0x65, 0x73, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x22,
	0xad, 0x01, 0x0a, 0x05, 0x53, 0x68, 0x61, 0x72, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x68, 0x61,
	0x72, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a,
	0x73, 0x68, 0x61, 0x72, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x75,
	0x6d, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09,
	0x6e, 0x75, 0x6d, 0x53, 0x68, 0x61, 0x72, 0x64, 0x73, 0x12, 0x64, 0x0a, 0x16, 0x74, 0x65, 0x73,
	0x74, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x5f, 0x66, 0x6f, 0x72, 0x5f, 0x73, 0x68,
	0x61, 0x72, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x73, 0x46, 0x6f, 0x72, 0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x13, 0x74, 0x65, 0x73, 0x74,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x46, 0x6f, 0x72, 0x53, 0x68, 0x61, 0x72, 0x64, 0x22,
	0xa0, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x73, 0x74, 0x4d, 0x61,
	0x74, 0x72, 0x69, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x47, 0x0a, 0x0b, 0x74, 0x65,
	0x73, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73,
	0x74, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x52, 0x0a, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x61, 0x74,
	0x72, 0x69, 0x78, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x22, 0x5b, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x54, 0x65, 0x73, 0x74, 0x4d, 0x61, 0x74,
	0x72, 0x69, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x74, 0x65, 0x73,
	0x74, 0x5f, 0x6d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x49, 0x64, 0x22,
	0x5e, 0x0a, 0x17, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x54, 0x65, 0x73, 0x74, 0x4d, 0x61, 0x74,
	0x72, 0x69, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x74, 0x65, 0x73,
	0x74, 0x5f, 0x6d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x49, 0x64, 0x22,
	0x60, 0x0a, 0x18, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x54, 0x65, 0x73, 0x74, 0x4d, 0x61, 0x74,
	0x72, 0x69, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x0a, 0x74,
	0x65, 0x73, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73,
	0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x09, 0x74, 0x65, 0x73, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x2a, 0x6c, 0x0a, 0x12, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x1f, 0x4f, 0x52, 0x43, 0x48, 0x45,
	0x53, 0x54, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10,
	0x55, 0x53, 0x45, 0x5f, 0x4f, 0x52, 0x43, 0x48, 0x45, 0x53, 0x54, 0x52, 0x41, 0x54, 0x4f, 0x52,
	0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x4f, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x55, 0x53, 0x45,
	0x5f, 0x4f, 0x52, 0x43, 0x48, 0x45, 0x53, 0x54, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x10, 0x02, 0x2a,
	0x4d, 0x0a, 0x08, 0x52, 0x6f, 0x62, 0x6f, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x52,
	0x4f, 0x42, 0x4f, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x4f, 0x42, 0x4f, 0x5f, 0x56,
	0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x31, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x4f,
	0x42, 0x4f, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x32, 0x10, 0x02, 0x2a, 0x5b,
	0x0a, 0x0e, 0x52, 0x6f, 0x62, 0x6f, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1b, 0x0a, 0x17, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a,
	0x0c, 0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x5f, 0x43, 0x4c, 0x49, 0x43, 0x4b, 0x10, 0x01, 0x12,
	0x0e, 0x0a, 0x0a, 0x45, 0x4e, 0x54, 0x45, 0x52, 0x5f, 0x54, 0x45, 0x58, 0x54, 0x10, 0x02, 0x12,
	0x0a, 0x0a, 0x06, 0x49, 0x47, 0x4e, 0x4f, 0x52, 0x45, 0x10, 0x03, 0x2a, 0xa4, 0x08, 0x0a, 0x14,
	0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x22, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f,
	0x4d, 0x41, 0x54, 0x52, 0x49, 0x58, 0x5f, 0x44, 0x45, 0x54, 0x41, 0x49, 0x4c, 0x53, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13,
	0x44, 0x45, 0x54, 0x41, 0x49, 0x4c, 0x53, 0x5f, 0x55, 0x4e, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41,
	0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x4d, 0x41, 0x4c, 0x46, 0x4f, 0x52, 0x4d,
	0x45, 0x44, 0x5f, 0x41, 0x50, 0x4b, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x4d, 0x41, 0x4c, 0x46,
	0x4f, 0x52, 0x4d, 0x45, 0x44, 0x5f, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x41, 0x50, 0x4b, 0x10, 0x03,
	0x12, 0x0f, 0x0a, 0x0b, 0x4e, 0x4f, 0x5f, 0x4d, 0x41, 0x4e, 0x49, 0x46, 0x45, 0x53, 0x54, 0x10,
	0x04, 0x12, 0x13, 0x0a, 0x0f, 0x4e, 0x4f, 0x5f, 0x50, 0x41, 0x43, 0x4b, 0x41, 0x47, 0x45, 0x5f,
	0x4e, 0x41, 0x4d, 0x45, 0x10, 0x05, 0x12, 0x18, 0x0a, 0x14, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49,
	0x44, 0x5f, 0x50, 0x41, 0x43, 0x4b, 0x41, 0x47, 0x45, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x10, 0x1f,
	0x12, 0x14, 0x0a, 0x10, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x53, 0x41, 0x4d, 0x45, 0x5f, 0x41, 0x53,
	0x5f, 0x41, 0x50, 0x50, 0x10, 0x06, 0x12, 0x16, 0x0a, 0x12, 0x4e, 0x4f, 0x5f, 0x49, 0x4e, 0x53,
	0x54, 0x52, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x07, 0x12, 0x10,
	0x0a, 0x0c, 0x4e, 0x4f, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x41, 0x54, 0x55, 0x52, 0x45, 0x10, 0x14,
	0x12, 0x2d, 0x0a, 0x29, 0x49, 0x4e, 0x53, 0x54, 0x52, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x4f, 0x52, 0x43, 0x48, 0x45, 0x53, 0x54, 0x52, 0x41, 0x54, 0x4f, 0x52,
	0x5f, 0x49, 0x4e, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x54, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x12, 0x12,
	0x18, 0x0a, 0x14, 0x4e, 0x4f, 0x5f, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x45,
	0x52, 0x5f, 0x43, 0x4c, 0x41, 0x53, 0x53, 0x10, 0x13, 0x12, 0x18, 0x0a, 0x14, 0x4e, 0x4f, 0x5f,
	0x4c, 0x41, 0x55, 0x4e, 0x43, 0x48, 0x45, 0x52, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x49, 0x54,
	0x59, 0x10, 0x08, 0x12, 0x19, 0x0a, 0x15, 0x46, 0x4f, 0x52, 0x42, 0x49, 0x44, 0x44, 0x45, 0x4e,
	0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x09, 0x12, 0x1b,
	0x0a, 0x17, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x52, 0x4f, 0x42, 0x4f, 0x5f, 0x44,
	0x49, 0x52, 0x45, 0x43, 0x54, 0x49, 0x56, 0x45, 0x53, 0x10, 0x0a, 0x12, 0x19, 0x0a, 0x15, 0x49,
	0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f,
	0x4e, 0x41, 0x4d, 0x45, 0x10, 0x21, 0x12, 0x1c, 0x0a, 0x18, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49,
	0x44, 0x5f, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x41, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x22, 0x12, 0x25, 0x0a, 0x21, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x4c, 0x4f, 0x4f,
	0x50, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f,
	0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x0c, 0x12, 0x1f, 0x0a, 0x1b, 0x53,
	0x43, 0x45, 0x4e, 0x41, 0x52, 0x49, 0x4f, 0x5f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f, 0x4e, 0x4f,
	0x54, 0x5f, 0x44, 0x45, 0x43, 0x4c, 0x41, 0x52, 0x45, 0x44, 0x10, 0x0d, 0x12, 0x1c, 0x0a, 0x18,
	0x53, 0x43, 0x45, 0x4e, 0x41, 0x52, 0x49, 0x4f, 0x5f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f, 0x4d,
	0x41, 0x4c, 0x46, 0x4f, 0x52, 0x4d, 0x45, 0x44, 0x10, 0x0e, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x43,
	0x45, 0x4e, 0x41, 0x52, 0x49, 0x4f, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x44, 0x45, 0x43, 0x4c, 0x41,
	0x52, 0x45, 0x44, 0x10, 0x0f, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f,
	0x41, 0x44, 0x4d, 0x49, 0x4e, 0x5f, 0x52, 0x45, 0x43, 0x45, 0x49, 0x56, 0x45, 0x52, 0x10, 0x11,
	0x12, 0x19, 0x0a, 0x15, 0x4d, 0x41, 0x4c, 0x46, 0x4f, 0x52, 0x4d, 0x45, 0x44, 0x5f, 0x58, 0x43,
	0x5f, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x5a, 0x49, 0x50, 0x10, 0x0b, 0x12, 0x1b, 0x0a, 0x17, 0x42,
	0x55, 0x49, 0x4c, 0x54, 0x5f, 0x46, 0x4f, 0x52, 0x5f, 0x49, 0x4f, 0x53, 0x5f, 0x53, 0x49, 0x4d,
	0x55, 0x4c, 0x41, 0x54, 0x4f, 0x52, 0x10, 0x18, 0x12, 0x1b, 0x0a, 0x17, 0x4e, 0x4f, 0x5f, 0x54,
	0x45, 0x53, 0x54, 0x53, 0x5f, 0x49, 0x4e, 0x5f, 0x58, 0x43, 0x5f, 0x54, 0x45, 0x53, 0x54, 0x5f,
	0x5a, 0x49, 0x50, 0x10, 0x19, 0x12, 0x1d, 0x0a, 0x19, 0x55, 0x53, 0x45, 0x5f, 0x44, 0x45, 0x53,
	0x54, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x52, 0x54, 0x49, 0x46, 0x41, 0x43,
	0x54, 0x53, 0x10, 0x1a, 0x12, 0x17, 0x0a, 0x13, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x4e, 0x4f, 0x54,
	0x5f, 0x41, 0x50, 0x50, 0x5f, 0x48, 0x4f, 0x53, 0x54, 0x45, 0x44, 0x10, 0x1c, 0x12, 0x1a, 0x0a,
	0x16, 0x50, 0x4c, 0x49, 0x53, 0x54, 0x5f, 0x43, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x5f, 0x42, 0x45,
	0x5f, 0x50, 0x41, 0x52, 0x53, 0x45, 0x44, 0x10, 0x1e, 0x12, 0x15, 0x0a, 0x0d, 0x54, 0x45, 0x53,
	0x54, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x5f, 0x41, 0x50, 0x4b, 0x10, 0x15, 0x1a, 0x02, 0x08, 0x01,
	0x12, 0x11, 0x0a, 0x0d, 0x4d, 0x41, 0x4c, 0x46, 0x4f, 0x52, 0x4d, 0x45, 0x44, 0x5f, 0x49, 0x50,
	0x41, 0x10, 0x16, 0x12, 0x16, 0x0a, 0x12, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x5f, 0x55,
	0x52, 0x4c, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x45, 0x10, 0x23, 0x12, 0x18, 0x0a, 0x14, 0x4d,
	0x41, 0x4c, 0x46, 0x4f, 0x52, 0x4d, 0x45, 0x44, 0x5f, 0x41, 0x50, 0x50, 0x5f, 0x42, 0x55, 0x4e,
	0x44, 0x4c, 0x45, 0x10, 0x24, 0x12, 0x0f, 0x0a, 0x0b, 0x4e, 0x4f, 0x5f, 0x43, 0x4f, 0x44, 0x45,
	0x5f, 0x41, 0x50, 0x4b, 0x10, 0x17, 0x12, 0x15, 0x0a, 0x11, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49,
	0x44, 0x5f, 0x49, 0x4e, 0x50, 0x55, 0x54, 0x5f, 0x41, 0x50, 0x4b, 0x10, 0x1b, 0x12, 0x1b, 0x0a,
	0x17, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x41, 0x50, 0x4b, 0x5f, 0x50, 0x52, 0x45,
	0x56, 0x49, 0x45, 0x57, 0x5f, 0x53, 0x44, 0x4b, 0x10, 0x1d, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x41,
	0x54, 0x52, 0x49, 0x58, 0x5f, 0x54, 0x4f, 0x4f, 0x5f, 0x4c, 0x41, 0x52, 0x47, 0x45, 0x10, 0x25,
	0x12, 0x17, 0x0a, 0x13, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x51, 0x55, 0x4f, 0x54, 0x41, 0x5f, 0x45,
	0x58, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x27, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x45, 0x52,
	0x56, 0x49, 0x43, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x41, 0x54,
	0x45, 0x44, 0x10, 0x28, 0x12, 0x1c, 0x0a, 0x18, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f,
	0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x10, 0x29, 0x2a, 0xe0, 0x01, 0x0a, 0x09, 0x54, 0x65, 0x73, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x1a, 0x0a, 0x16, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a,
	0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x08, 0x12, 0x0b, 0x0a, 0x07,
	0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e,
	0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x49, 0x4e, 0x49, 0x53, 0x48,
	0x45, 0x44, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x04, 0x12,
	0x1b, 0x0a, 0x17, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x45,
	0x4e, 0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x05, 0x12, 0x1c, 0x0a, 0x18,
	0x49, 0x4e, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x54, 0x49, 0x42, 0x4c, 0x45, 0x5f, 0x45, 0x4e, 0x56,
	0x49, 0x52, 0x4f, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x09, 0x12, 0x1d, 0x0a, 0x19, 0x49, 0x4e,
	0x43, 0x4f, 0x4d, 0x50, 0x41, 0x54, 0x49, 0x42, 0x4c, 0x45, 0x5f, 0x41, 0x52, 0x43, 0x48, 0x49,
	0x54, 0x45, 0x43, 0x54, 0x55, 0x52, 0x45, 0x10, 0x0a, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e,
	0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x56, 0x41,
	0x4c, 0x49, 0x44, 0x10, 0x07, 0x2a, 0x6a, 0x0a, 0x0e, 0x4f, 0x75, 0x74, 0x63, 0x6f, 0x6d, 0x65,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x1f, 0x0a, 0x1b, 0x4f, 0x55, 0x54, 0x43, 0x4f,
	0x4d, 0x45, 0x5f, 0x53, 0x55, 0x4d, 0x4d, 0x41, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x55, 0x43, 0x43,
	0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45,
	0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x49, 0x4e, 0x43, 0x4f, 0x4e, 0x43, 0x4c, 0x55, 0x53, 0x49,
	0x56, 0x45, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x4b, 0x49, 0x50, 0x50, 0x45, 0x44, 0x10,
	0x04, 0x32, 0xc0, 0x05, 0x0a, 0x14, 0x54, 0x65, 0x73, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xac, 0x01, 0x0a, 0x10, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x73, 0x74, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x12,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x65, 0x73, 0x74, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x22, 0x3b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x35, 0x22, 0x26, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f,
	0x74, 0x65, 0x73, 0x74, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x63, 0x65, 0x73, 0x3a, 0x0b, 0x74, 0x65,
	0x73, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x12, 0xaa, 0x01, 0x0a, 0x0d, 0x47, 0x65,
	0x74, 0x54, 0x65, 0x73, 0x74, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x12, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x65, 0x73, 0x74,
	0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x4d,
	0x61, 0x74, 0x72, 0x69, 0x78, 0x22, 0x3f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12, 0x37, 0x2f,
	0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x61, 0x74,
	0x72, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x72,
	0x69, 0x78, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0xc5, 0x01, 0x0a, 0x10, 0x43, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x54, 0x65, 0x73, 0x74, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x12, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x54,
	0x65, 0x73, 0x74, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x54, 0x65, 0x73, 0x74, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x46, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x22, 0x3e,
	0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x61,
	0x74, 0x72, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x61, 0x74,
	0x72, 0x69, 0x78, 0x5f, 0x69, 0x64, 0x7d, 0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x1a, 0x83,
	0x01, 0xca, 0x41, 0x16, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x67, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x2d,
	0x6f, 0x6e, 0x6c, 0x79, 0x42, 0x79, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x42, 0x12, 0x54, 0x65, 0x73, 0x74, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x41, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
	0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x74, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x3b, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_devtools_testing_v1_test_execution_proto_rawDescOnce sync.Once
	file_google_devtools_testing_v1_test_execution_proto_rawDescData = file_google_devtools_testing_v1_test_execution_proto_rawDesc
)

func file_google_devtools_testing_v1_test_execution_proto_rawDescGZIP() []byte {
	file_google_devtools_testing_v1_test_execution_proto_rawDescOnce.Do(func() {
		file_google_devtools_testing_v1_test_execution_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_testing_v1_test_execution_proto_rawDescData)
	})
	return file_google_devtools_testing_v1_test_execution_proto_rawDescData
}

var file_google_devtools_testing_v1_test_execution_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_google_devtools_testing_v1_test_execution_proto_msgTypes = make([]protoimpl.MessageInfo, 50)
var file_google_devtools_testing_v1_test_execution_proto_goTypes = []interface{}{
	(OrchestratorOption)(0),            // 0: google.devtools.testing.v1.OrchestratorOption
	(RoboMode)(0),                      // 1: google.devtools.testing.v1.RoboMode
	(RoboActionType)(0),                // 2: google.devtools.testing.v1.RoboActionType
	(InvalidMatrixDetails)(0),          // 3: google.devtools.testing.v1.InvalidMatrixDetails
	(TestState)(0),                     // 4: google.devtools.testing.v1.TestState
	(OutcomeSummary)(0),                // 5: google.devtools.testing.v1.OutcomeSummary
	(InvalidRequestDetail_Reason)(0),   // 6: google.devtools.testing.v1.InvalidRequestDetail.Reason
	(*TestMatrix)(nil),                 // 7: google.devtools.testing.v1.TestMatrix
	(*TestExecution)(nil),              // 8: google.devtools.testing.v1.TestExecution
	(*TestSpecification)(nil),          // 9: google.devtools.testing.v1.TestSpecification
	(*SystraceSetup)(nil),              // 10: google.devtools.testing.v1.SystraceSetup
	(*TestSetup)(nil),                  // 11: google.devtools.testing.v1.TestSetup
	(*IosTestSetup)(nil),               // 12: google.devtools.testing.v1.IosTestSetup
	(*EnvironmentVariable)(nil),        // 13: google.devtools.testing.v1.EnvironmentVariable
	(*Account)(nil),                    // 14: google.devtools.testing.v1.Account
	(*GoogleAuto)(nil),                 // 15: google.devtools.testing.v1.GoogleAuto
	(*Apk)(nil),                        // 16: google.devtools.testing.v1.Apk
	(*AppBundle)(nil),                  // 17: google.devtools.testing.v1.AppBundle
	(*DeviceFile)(nil),                 // 18: google.devtools.testing.v1.DeviceFile
	(*ObbFile)(nil),                    // 19: google.devtools.testing.v1.ObbFile
	(*RegularFile)(nil),                // 20: google.devtools.testing.v1.RegularFile
	(*IosDeviceFile)(nil),              // 21: google.devtools.testing.v1.IosDeviceFile
	(*AndroidTestLoop)(nil),            // 22: google.devtools.testing.v1.AndroidTestLoop
	(*IosXcTest)(nil),                  // 23: google.devtools.testing.v1.IosXcTest
	(*IosTestLoop)(nil),                // 24: google.devtools.testing.v1.IosTestLoop
	(*AndroidInstrumentationTest)(nil), // 25: google.devtools.testing.v1.AndroidInstrumentationTest
	(*AndroidRoboTest)(nil),            // 26: google.devtools.testing.v1.AndroidRoboTest
	(*RoboDirective)(nil),              // 27: google.devtools.testing.v1.RoboDirective
	(*RoboStartingIntent)(nil),         // 28: google.devtools.testing.v1.RoboStartingIntent
	(*LauncherActivityIntent)(nil),     // 29: google.devtools.testing.v1.LauncherActivityIntent
	(*StartActivityIntent)(nil),        // 30: google.devtools.testing.v1.StartActivityIntent
	(*EnvironmentMatrix)(nil),          // 31: google.devtools.testing.v1.EnvironmentMatrix
	(*AndroidDeviceList)(nil),          // 32: google.devtools.testing.v1.AndroidDeviceList
	(*IosDeviceList)(nil),              // 33: google.devtools.testing.v1.IosDeviceList
	(*AndroidMatrix)(nil),              // 34: google.devtools.testing.v1.AndroidMatrix
	(*ClientInfo)(nil),                 // 35: google.devtools.testing.v1.ClientInfo
	(*ClientInfoDetail)(nil),           // 36: google.devtools.testing.v1.ClientInfoDetail
	(*ResultStorage)(nil),              // 37: google.devtools.testing.v1.ResultStorage
	(*ToolResultsHistory)(nil),         // 38: google.devtools.testing.v1.ToolResultsHistory
	(*ToolResultsExecution)(nil),       // 39: google.devtools.testing.v1.ToolResultsExecution
	(*ToolResultsStep)(nil),            // 40: google.devtools.testing.v1.ToolResultsStep
	(*GoogleCloudStorage)(nil),         // 41: google.devtools.testing.v1.GoogleCloudStorage
	(*FileReference)(nil),              // 42: google.devtools.testing.v1.FileReference
	(*Environment)(nil),                // 43: google.devtools.testing.v1.Environment
	(*AndroidDevice)(nil),              // 44: google.devtools.testing.v1.AndroidDevice
	(*IosDevice)(nil),                  // 45: google.devtools.testing.v1.IosDevice
	(*TestDetails)(nil),                // 46: google.devtools.testing.v1.TestDetails
	(*InvalidRequestDetail)(nil),       // 47: google.devtools.testing.v1.InvalidRequestDetail
	(*ShardingOption)(nil),             // 48: google.devtools.testing.v1.ShardingOption
	(*UniformSharding)(nil),            // 49: google.devtools.testing.v1.UniformSharding
	(*ManualSharding)(nil),             // 50: google.devtools.testing.v1.ManualSharding
	(*TestTargetsForShard)(nil),        // 51: google.devtools.testing.v1.TestTargetsForShard
	(*Shard)(nil),                      // 52: google.devtools.testing.v1.Shard
	(*CreateTestMatrixRequest)(nil),    // 53: google.devtools.testing.v1.CreateTestMatrixRequest
	(*GetTestMatrixRequest)(nil),       // 54: google.devtools.testing.v1.GetTestMatrixRequest
	(*CancelTestMatrixRequest)(nil),    // 55: google.devtools.testing.v1.CancelTestMatrixRequest
	(*CancelTestMatrixResponse)(nil),   // 56: google.devtools.testing.v1.CancelTestMatrixResponse
	(*timestamppb.Timestamp)(nil),      // 57: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),        // 58: google.protobuf.Duration
}
var file_google_devtools_testing_v1_test_execution_proto_depIdxs = []int32{
	35, // 0: google.devtools.testing.v1.TestMatrix.client_info:type_name -> google.devtools.testing.v1.ClientInfo
	9,  // 1: google.devtools.testing.v1.TestMatrix.test_specification:type_name -> google.devtools.testing.v1.TestSpecification
	31, // 2: google.devtools.testing.v1.TestMatrix.environment_matrix:type_name -> google.devtools.testing.v1.EnvironmentMatrix
	8,  // 3: google.devtools.testing.v1.TestMatrix.test_executions:type_name -> google.devtools.testing.v1.TestExecution
	37, // 4: google.devtools.testing.v1.TestMatrix.result_storage:type_name -> google.devtools.testing.v1.ResultStorage
	4,  // 5: google.devtools.testing.v1.TestMatrix.state:type_name -> google.devtools.testing.v1.TestState
	57, // 6: google.devtools.testing.v1.TestMatrix.timestamp:type_name -> google.protobuf.Timestamp
	3,  // 7: google.devtools.testing.v1.TestMatrix.invalid_matrix_details:type_name -> google.devtools.testing.v1.InvalidMatrixDetails
	5,  // 8: google.devtools.testing.v1.TestMatrix.outcome_summary:type_name -> google.devtools.testing.v1.OutcomeSummary
	9,  // 9: google.devtools.testing.v1.TestExecution.test_specification:type_name -> google.devtools.testing.v1.TestSpecification
	52, // 10: google.devtools.testing.v1.TestExecution.shard:type_name -> google.devtools.testing.v1.Shard
	43, // 11: google.devtools.testing.v1.TestExecution.environment:type_name -> google.devtools.testing.v1.Environment
	4,  // 12: google.devtools.testing.v1.TestExecution.state:type_name -> google.devtools.testing.v1.TestState
	40, // 13: google.devtools.testing.v1.TestExecution.tool_results_step:type_name -> google.devtools.testing.v1.ToolResultsStep
	57, // 14: google.devtools.testing.v1.TestExecution.timestamp:type_name -> google.protobuf.Timestamp
	46, // 15: google.devtools.testing.v1.TestExecution.test_details:type_name -> google.devtools.testing.v1.TestDetails
	58, // 16: google.devtools.testing.v1.TestSpecification.test_timeout:type_name -> google.protobuf.Duration
	11, // 17: google.devtools.testing.v1.TestSpecification.test_setup:type_name -> google.devtools.testing.v1.TestSetup
	12, // 18: google.devtools.testing.v1.TestSpecification.ios_test_setup:type_name -> google.devtools.testing.v1.IosTestSetup
	25, // 19: google.devtools.testing.v1.TestSpecification.android_instrumentation_test:type_name -> google.devtools.testing.v1.AndroidInstrumentationTest
	26, // 20: google.devtools.testing.v1.TestSpecification.android_robo_test:type_name -> google.devtools.testing.v1.AndroidRoboTest
	22, // 21: google.devtools.testing.v1.TestSpecification.android_test_loop:type_name -> google.devtools.testing.v1.AndroidTestLoop
	23, // 22: google.devtools.testing.v1.TestSpecification.ios_xc_test:type_name -> google.devtools.testing.v1.IosXcTest
	24, // 23: google.devtools.testing.v1.TestSpecification.ios_test_loop:type_name -> google.devtools.testing.v1.IosTestLoop
	18, // 24: google.devtools.testing.v1.TestSetup.files_to_push:type_name -> google.devtools.testing.v1.DeviceFile
	16, // 25: google.devtools.testing.v1.TestSetup.additional_apks:type_name -> google.devtools.testing.v1.Apk
	14, // 26: google.devtools.testing.v1.TestSetup.account:type_name -> google.devtools.testing.v1.Account
	13, // 27: google.devtools.testing.v1.TestSetup.environment_variables:type_name -> google.devtools.testing.v1.EnvironmentVariable
	10, // 28: google.devtools.testing.v1.TestSetup.systrace:type_name -> google.devtools.testing.v1.SystraceSetup
	42, // 29: google.devtools.testing.v1.IosTestSetup.additional_ipas:type_name -> google.devtools.testing.v1.FileReference
	21, // 30: google.devtools.testing.v1.IosTestSetup.push_files:type_name -> google.devtools.testing.v1.IosDeviceFile
	21, // 31: google.devtools.testing.v1.IosTestSetup.pull_directories:type_name -> google.devtools.testing.v1.IosDeviceFile
	15, // 32: google.devtools.testing.v1.Account.google_auto:type_name -> google.devtools.testing.v1.GoogleAuto
	42, // 33: google.devtools.testing.v1.Apk.location:type_name -> google.devtools.testing.v1.FileReference
	42, // 34: google.devtools.testing.v1.AppBundle.bundle_location:type_name -> google.devtools.testing.v1.FileReference
	19, // 35: google.devtools.testing.v1.DeviceFile.obb_file:type_name -> google.devtools.testing.v1.ObbFile
	20, // 36: google.devtools.testing.v1.DeviceFile.regular_file:type_name -> google.devtools.testing.v1.RegularFile
	42, // 37: google.devtools.testing.v1.ObbFile.obb:type_name -> google.devtools.testing.v1.FileReference
	42, // 38: google.devtools.testing.v1.RegularFile.content:type_name -> google.devtools.testing.v1.FileReference
	42, // 39: google.devtools.testing.v1.IosDeviceFile.content:type_name -> google.devtools.testing.v1.FileReference
	42, // 40: google.devtools.testing.v1.AndroidTestLoop.app_apk:type_name -> google.devtools.testing.v1.FileReference
	17, // 41: google.devtools.testing.v1.AndroidTestLoop.app_bundle:type_name -> google.devtools.testing.v1.AppBundle
	42, // 42: google.devtools.testing.v1.IosXcTest.tests_zip:type_name -> google.devtools.testing.v1.FileReference
	42, // 43: google.devtools.testing.v1.IosXcTest.xctestrun:type_name -> google.devtools.testing.v1.FileReference
	42, // 44: google.devtools.testing.v1.IosTestLoop.app_ipa:type_name -> google.devtools.testing.v1.FileReference
	42, // 45: google.devtools.testing.v1.AndroidInstrumentationTest.app_apk:type_name -> google.devtools.testing.v1.FileReference
	17, // 46: google.devtools.testing.v1.AndroidInstrumentationTest.app_bundle:type_name -> google.devtools.testing.v1.AppBundle
	42, // 47: google.devtools.testing.v1.AndroidInstrumentationTest.test_apk:type_name -> google.devtools.testing.v1.FileReference
	0,  // 48: google.devtools.testing.v1.AndroidInstrumentationTest.orchestrator_option:type_name -> google.devtools.testing.v1.OrchestratorOption
	48, // 49: google.devtools.testing.v1.AndroidInstrumentationTest.sharding_option:type_name -> google.devtools.testing.v1.ShardingOption
	42, // 50: google.devtools.testing.v1.AndroidRoboTest.app_apk:type_name -> google.devtools.testing.v1.FileReference
	17, // 51: google.devtools.testing.v1.AndroidRoboTest.app_bundle:type_name -> google.devtools.testing.v1.AppBundle
	27, // 52: google.devtools.testing.v1.AndroidRoboTest.robo_directives:type_name -> google.devtools.testing.v1.RoboDirective
	1,  // 53: google.devtools.testing.v1.AndroidRoboTest.robo_mode:type_name -> google.devtools.testing.v1.RoboMode
	42, // 54: google.devtools.testing.v1.AndroidRoboTest.robo_script:type_name -> google.devtools.testing.v1.FileReference
	28, // 55: google.devtools.testing.v1.AndroidRoboTest.starting_intents:type_name -> google.devtools.testing.v1.RoboStartingIntent
	2,  // 56: google.devtools.testing.v1.RoboDirective.action_type:type_name -> google.devtools.testing.v1.RoboActionType
	29, // 57: google.devtools.testing.v1.RoboStartingIntent.launcher_activity:type_name -> google.devtools.testing.v1.LauncherActivityIntent
	30, // 58: google.devtools.testing.v1.RoboStartingIntent.start_activity:type_name -> google.devtools.testing.v1.StartActivityIntent
	58, // 59: google.devtools.testing.v1.RoboStartingIntent.timeout:type_name -> google.protobuf.Duration
	34, // 60: google.devtools.testing.v1.EnvironmentMatrix.android_matrix:type_name -> google.devtools.testing.v1.AndroidMatrix
	32, // 61: google.devtools.testing.v1.EnvironmentMatrix.android_device_list:type_name -> google.devtools.testing.v1.AndroidDeviceList
	33, // 62: google.devtools.testing.v1.EnvironmentMatrix.ios_device_list:type_name -> google.devtools.testing.v1.IosDeviceList
	44, // 63: google.devtools.testing.v1.AndroidDeviceList.android_devices:type_name -> google.devtools.testing.v1.AndroidDevice
	45, // 64: google.devtools.testing.v1.IosDeviceList.ios_devices:type_name -> google.devtools.testing.v1.IosDevice
	36, // 65: google.devtools.testing.v1.ClientInfo.client_info_details:type_name -> google.devtools.testing.v1.ClientInfoDetail
	41, // 66: google.devtools.testing.v1.ResultStorage.google_cloud_storage:type_name -> google.devtools.testing.v1.GoogleCloudStorage
	38, // 67: google.devtools.testing.v1.ResultStorage.tool_results_history:type_name -> google.devtools.testing.v1.ToolResultsHistory
	39, // 68: google.devtools.testing.v1.ResultStorage.tool_results_execution:type_name -> google.devtools.testing.v1.ToolResultsExecution
	44, // 69: google.devtools.testing.v1.Environment.android_device:type_name -> google.devtools.testing.v1.AndroidDevice
	45, // 70: google.devtools.testing.v1.Environment.ios_device:type_name -> google.devtools.testing.v1.IosDevice
	6,  // 71: google.devtools.testing.v1.InvalidRequestDetail.reason:type_name -> google.devtools.testing.v1.InvalidRequestDetail.Reason
	49, // 72: google.devtools.testing.v1.ShardingOption.uniform_sharding:type_name -> google.devtools.testing.v1.UniformSharding
	50, // 73: google.devtools.testing.v1.ShardingOption.manual_sharding:type_name -> google.devtools.testing.v1.ManualSharding
	51, // 74: google.devtools.testing.v1.ManualSharding.test_targets_for_shard:type_name -> google.devtools.testing.v1.TestTargetsForShard
	51, // 75: google.devtools.testing.v1.Shard.test_targets_for_shard:type_name -> google.devtools.testing.v1.TestTargetsForShard
	7,  // 76: google.devtools.testing.v1.CreateTestMatrixRequest.test_matrix:type_name -> google.devtools.testing.v1.TestMatrix
	4,  // 77: google.devtools.testing.v1.CancelTestMatrixResponse.test_state:type_name -> google.devtools.testing.v1.TestState
	53, // 78: google.devtools.testing.v1.TestExecutionService.CreateTestMatrix:input_type -> google.devtools.testing.v1.CreateTestMatrixRequest
	54, // 79: google.devtools.testing.v1.TestExecutionService.GetTestMatrix:input_type -> google.devtools.testing.v1.GetTestMatrixRequest
	55, // 80: google.devtools.testing.v1.TestExecutionService.CancelTestMatrix:input_type -> google.devtools.testing.v1.CancelTestMatrixRequest
	7,  // 81: google.devtools.testing.v1.TestExecutionService.CreateTestMatrix:output_type -> google.devtools.testing.v1.TestMatrix
	7,  // 82: google.devtools.testing.v1.TestExecutionService.GetTestMatrix:output_type -> google.devtools.testing.v1.TestMatrix
	56, // 83: google.devtools.testing.v1.TestExecutionService.CancelTestMatrix:output_type -> google.devtools.testing.v1.CancelTestMatrixResponse
	81, // [81:84] is the sub-list for method output_type
	78, // [78:81] is the sub-list for method input_type
	78, // [78:78] is the sub-list for extension type_name
	78, // [78:78] is the sub-list for extension extendee
	0,  // [0:78] is the sub-list for field type_name
}

func init() { file_google_devtools_testing_v1_test_execution_proto_init() }
func file_google_devtools_testing_v1_test_execution_proto_init() {
	if File_google_devtools_testing_v1_test_execution_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestMatrix); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestExecution); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestSpecification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SystraceSetup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestSetup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IosTestSetup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnvironmentVariable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Account); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GoogleAuto); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Apk); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppBundle); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeviceFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObbFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegularFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IosDeviceFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AndroidTestLoop); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IosXcTest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IosTestLoop); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AndroidInstrumentationTest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AndroidRoboTest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RoboDirective); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RoboStartingIntent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LauncherActivityIntent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartActivityIntent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnvironmentMatrix); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AndroidDeviceList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IosDeviceList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AndroidMatrix); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientInfoDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResultStorage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ToolResultsHistory); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ToolResultsExecution); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ToolResultsStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GoogleCloudStorage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FileReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Environment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AndroidDevice); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IosDevice); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InvalidRequestDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShardingOption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UniformSharding); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManualSharding); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestTargetsForShard); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Shard); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTestMatrixRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTestMatrixRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelTestMatrixRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_execution_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelTestMatrixResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_devtools_testing_v1_test_execution_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*TestSpecification_TestSetup)(nil),
		(*TestSpecification_IosTestSetup)(nil),
		(*TestSpecification_AndroidInstrumentationTest)(nil),
		(*TestSpecification_AndroidRoboTest)(nil),
		(*TestSpecification_AndroidTestLoop)(nil),
		(*TestSpecification_IosXcTest)(nil),
		(*TestSpecification_IosTestLoop)(nil),
	}
	file_google_devtools_testing_v1_test_execution_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*Account_GoogleAuto)(nil),
	}
	file_google_devtools_testing_v1_test_execution_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*AppBundle_BundleLocation)(nil),
	}
	file_google_devtools_testing_v1_test_execution_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*DeviceFile_ObbFile)(nil),
		(*DeviceFile_RegularFile)(nil),
	}
	file_google_devtools_testing_v1_test_execution_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*AndroidTestLoop_AppApk)(nil),
		(*AndroidTestLoop_AppBundle)(nil),
	}
	file_google_devtools_testing_v1_test_execution_proto_msgTypes[18].OneofWrappers = []interface{}{
		(*AndroidInstrumentationTest_AppApk)(nil),
		(*AndroidInstrumentationTest_AppBundle)(nil),
	}
	file_google_devtools_testing_v1_test_execution_proto_msgTypes[19].OneofWrappers = []interface{}{
		(*AndroidRoboTest_AppApk)(nil),
		(*AndroidRoboTest_AppBundle)(nil),
	}
	file_google_devtools_testing_v1_test_execution_proto_msgTypes[21].OneofWrappers = []interface{}{
		(*RoboStartingIntent_LauncherActivity)(nil),
		(*RoboStartingIntent_StartActivity)(nil),
	}
	file_google_devtools_testing_v1_test_execution_proto_msgTypes[24].OneofWrappers = []interface{}{
		(*EnvironmentMatrix_AndroidMatrix)(nil),
		(*EnvironmentMatrix_AndroidDeviceList)(nil),
		(*EnvironmentMatrix_IosDeviceList)(nil),
	}
	file_google_devtools_testing_v1_test_execution_proto_msgTypes[35].OneofWrappers = []interface{}{
		(*FileReference_GcsPath)(nil),
	}
	file_google_devtools_testing_v1_test_execution_proto_msgTypes[36].OneofWrappers = []interface{}{
		(*Environment_AndroidDevice)(nil),
		(*Environment_IosDevice)(nil),
	}
	file_google_devtools_testing_v1_test_execution_proto_msgTypes[41].OneofWrappers = []interface{}{
		(*ShardingOption_UniformSharding)(nil),
		(*ShardingOption_ManualSharding)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_testing_v1_test_execution_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   50,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_devtools_testing_v1_test_execution_proto_goTypes,
		DependencyIndexes: file_google_devtools_testing_v1_test_execution_proto_depIdxs,
		EnumInfos:         file_google_devtools_testing_v1_test_execution_proto_enumTypes,
		MessageInfos:      file_google_devtools_testing_v1_test_execution_proto_msgTypes,
	}.Build()
	File_google_devtools_testing_v1_test_execution_proto = out.File
	file_google_devtools_testing_v1_test_execution_proto_rawDesc = nil
	file_google_devtools_testing_v1_test_execution_proto_goTypes = nil
	file_google_devtools_testing_v1_test_execution_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// TestExecutionServiceClient is the client API for TestExecutionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TestExecutionServiceClient interface {
	// Creates and runs a matrix of tests according to the given specifications.
	// Unsupported environments will be returned in the state UNSUPPORTED.
	// A test matrix is limited to use at most 2000 devices in parallel.
	//
	// May return any of the following canonical error codes:
	//
	//   - PERMISSION_DENIED - if the user is not authorized to write to project
	//   - INVALID_ARGUMENT - if the request is malformed or if the matrix tries
	//     to use too many simultaneous devices.
	CreateTestMatrix(ctx context.Context, in *CreateTestMatrixRequest, opts ...grpc.CallOption) (*TestMatrix, error)
	// Checks the status of a test matrix.
	//
	// May return any of the following canonical error codes:
	//
	// - PERMISSION_DENIED - if the user is not authorized to read project
	// - INVALID_ARGUMENT - if the request is malformed
	// - NOT_FOUND - if the Test Matrix does not exist
	GetTestMatrix(ctx context.Context, in *GetTestMatrixRequest, opts ...grpc.CallOption) (*TestMatrix, error)
	// Cancels unfinished test executions in a test matrix.
	// This call returns immediately and cancellation proceeds asynchronously.
	// If the matrix is already final, this operation will have no effect.
	//
	// May return any of the following canonical error codes:
	//
	// - PERMISSION_DENIED - if the user is not authorized to read project
	// - INVALID_ARGUMENT - if the request is malformed
	// - NOT_FOUND - if the Test Matrix does not exist
	CancelTestMatrix(ctx context.Context, in *CancelTestMatrixRequest, opts ...grpc.CallOption) (*CancelTestMatrixResponse, error)
}

type testExecutionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewTestExecutionServiceClient(cc grpc.ClientConnInterface) TestExecutionServiceClient {
	return &testExecutionServiceClient{cc}
}

func (c *testExecutionServiceClient) CreateTestMatrix(ctx context.Context, in *CreateTestMatrixRequest, opts ...grpc.CallOption) (*TestMatrix, error) {
	out := new(TestMatrix)
	err := c.cc.Invoke(ctx, "/google.devtools.testing.v1.TestExecutionService/CreateTestMatrix", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testExecutionServiceClient) GetTestMatrix(ctx context.Context, in *GetTestMatrixRequest, opts ...grpc.CallOption) (*TestMatrix, error) {
	out := new(TestMatrix)
	err := c.cc.Invoke(ctx, "/google.devtools.testing.v1.TestExecutionService/GetTestMatrix", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testExecutionServiceClient) CancelTestMatrix(ctx context.Context, in *CancelTestMatrixRequest, opts ...grpc.CallOption) (*CancelTestMatrixResponse, error) {
	out := new(CancelTestMatrixResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.testing.v1.TestExecutionService/CancelTestMatrix", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TestExecutionServiceServer is the server API for TestExecutionService service.
type TestExecutionServiceServer interface {
	// Creates and runs a matrix of tests according to the given specifications.
	// Unsupported environments will be returned in the state UNSUPPORTED.
	// A test matrix is limited to use at most 2000 devices in parallel.
	//
	// May return any of the following canonical error codes:
	//
	//   - PERMISSION_DENIED - if the user is not authorized to write to project
	//   - INVALID_ARGUMENT - if the request is malformed or if the matrix tries
	//     to use too many simultaneous devices.
	CreateTestMatrix(context.Context, *CreateTestMatrixRequest) (*TestMatrix, error)
	// Checks the status of a test matrix.
	//
	// May return any of the following canonical error codes:
	//
	// - PERMISSION_DENIED - if the user is not authorized to read project
	// - INVALID_ARGUMENT - if the request is malformed
	// - NOT_FOUND - if the Test Matrix does not exist
	GetTestMatrix(context.Context, *GetTestMatrixRequest) (*TestMatrix, error)
	// Cancels unfinished test executions in a test matrix.
	// This call returns immediately and cancellation proceeds asynchronously.
	// If the matrix is already final, this operation will have no effect.
	//
	// May return any of the following canonical error codes:
	//
	// - PERMISSION_DENIED - if the user is not authorized to read project
	// - INVALID_ARGUMENT - if the request is malformed
	// - NOT_FOUND - if the Test Matrix does not exist
	CancelTestMatrix(context.Context, *CancelTestMatrixRequest) (*CancelTestMatrixResponse, error)
}

// UnimplementedTestExecutionServiceServer can be embedded to have forward compatible implementations.
type UnimplementedTestExecutionServiceServer struct {
}

func (*UnimplementedTestExecutionServiceServer) CreateTestMatrix(context.Context, *CreateTestMatrixRequest) (*TestMatrix, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTestMatrix not implemented")
}
func (*UnimplementedTestExecutionServiceServer) GetTestMatrix(context.Context, *GetTestMatrixRequest) (*TestMatrix, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTestMatrix not implemented")
}
func (*UnimplementedTestExecutionServiceServer) CancelTestMatrix(context.Context, *CancelTestMatrixRequest) (*CancelTestMatrixResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelTestMatrix not implemented")
}

func RegisterTestExecutionServiceServer(s *grpc.Server, srv TestExecutionServiceServer) {
	s.RegisterService(&_TestExecutionService_serviceDesc, srv)
}

func _TestExecutionService_CreateTestMatrix_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTestMatrixRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestExecutionServiceServer).CreateTestMatrix(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.testing.v1.TestExecutionService/CreateTestMatrix",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestExecutionServiceServer).CreateTestMatrix(ctx, req.(*CreateTestMatrixRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestExecutionService_GetTestMatrix_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTestMatrixRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestExecutionServiceServer).GetTestMatrix(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.testing.v1.TestExecutionService/GetTestMatrix",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestExecutionServiceServer).GetTestMatrix(ctx, req.(*GetTestMatrixRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestExecutionService_CancelTestMatrix_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelTestMatrixRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestExecutionServiceServer).CancelTestMatrix(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.testing.v1.TestExecutionService/CancelTestMatrix",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestExecutionServiceServer).CancelTestMatrix(ctx, req.(*CancelTestMatrixRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TestExecutionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.testing.v1.TestExecutionService",
	HandlerType: (*TestExecutionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTestMatrix",
			Handler:    _TestExecutionService_CreateTestMatrix_Handler,
		},
		{
			MethodName: "GetTestMatrix",
			Handler:    _TestExecutionService_GetTestMatrix_Handler,
		},
		{
			MethodName: "CancelTestMatrix",
			Handler:    _TestExecutionService_CancelTestMatrix_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/testing/v1/test_execution.proto",
}
