// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package eks

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateEncryptionConfig = "AssociateEncryptionConfig"

// AssociateEncryptionConfigRequest generates a "aws/request.Request" representing the
// client's request for the AssociateEncryptionConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateEncryptionConfig for more information on using the AssociateEncryptionConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateEncryptionConfigRequest method.
//    req, resp := client.AssociateEncryptionConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/AssociateEncryptionConfig
func (c *EKS) AssociateEncryptionConfigRequest(input *AssociateEncryptionConfigInput) (req *request.Request, output *AssociateEncryptionConfigOutput) {
	op := &request.Operation{
		Name:       opAssociateEncryptionConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/encryption-config/associate",
	}

	if input == nil {
		input = &AssociateEncryptionConfigInput{}
	}

	output = &AssociateEncryptionConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateEncryptionConfig API operation for Amazon Elastic Kubernetes Service.
//
// Associate encryption configuration to an existing cluster.
//
// You can use this API to enable encryption on existing clusters which do not
// have encryption already enabled. This allows you to implement a defense-in-depth
// security strategy without migrating applications to new Amazon EKS clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation AssociateEncryptionConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * InvalidRequestException
//   The request is invalid given the state of the cluster. Check the state of
//   the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/AssociateEncryptionConfig
func (c *EKS) AssociateEncryptionConfig(input *AssociateEncryptionConfigInput) (*AssociateEncryptionConfigOutput, error) {
	req, out := c.AssociateEncryptionConfigRequest(input)
	return out, req.Send()
}

// AssociateEncryptionConfigWithContext is the same as AssociateEncryptionConfig with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateEncryptionConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) AssociateEncryptionConfigWithContext(ctx aws.Context, input *AssociateEncryptionConfigInput, opts ...request.Option) (*AssociateEncryptionConfigOutput, error) {
	req, out := c.AssociateEncryptionConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateIdentityProviderConfig = "AssociateIdentityProviderConfig"

// AssociateIdentityProviderConfigRequest generates a "aws/request.Request" representing the
// client's request for the AssociateIdentityProviderConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateIdentityProviderConfig for more information on using the AssociateIdentityProviderConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateIdentityProviderConfigRequest method.
//    req, resp := client.AssociateIdentityProviderConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/AssociateIdentityProviderConfig
func (c *EKS) AssociateIdentityProviderConfigRequest(input *AssociateIdentityProviderConfigInput) (req *request.Request, output *AssociateIdentityProviderConfigOutput) {
	op := &request.Operation{
		Name:       opAssociateIdentityProviderConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/identity-provider-configs/associate",
	}

	if input == nil {
		input = &AssociateIdentityProviderConfigInput{}
	}

	output = &AssociateIdentityProviderConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateIdentityProviderConfig API operation for Amazon Elastic Kubernetes Service.
//
// Associate an identity provider configuration to a cluster.
//
// If you want to authenticate identities using an identity provider, you can
// create an identity provider configuration and associate it to your cluster.
// After configuring authentication to your cluster you can create Kubernetes
// roles and clusterroles to assign permissions to the roles, and then bind
// the roles to the identities using Kubernetes rolebindings and clusterrolebindings.
// For more information see Using RBAC Authorization (https://kubernetes.io/docs/reference/access-authn-authz/rbac/)
// in the Kubernetes documentation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation AssociateIdentityProviderConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * InvalidRequestException
//   The request is invalid given the state of the cluster. Check the state of
//   the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/AssociateIdentityProviderConfig
func (c *EKS) AssociateIdentityProviderConfig(input *AssociateIdentityProviderConfigInput) (*AssociateIdentityProviderConfigOutput, error) {
	req, out := c.AssociateIdentityProviderConfigRequest(input)
	return out, req.Send()
}

// AssociateIdentityProviderConfigWithContext is the same as AssociateIdentityProviderConfig with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateIdentityProviderConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) AssociateIdentityProviderConfigWithContext(ctx aws.Context, input *AssociateIdentityProviderConfigInput, opts ...request.Option) (*AssociateIdentityProviderConfigOutput, error) {
	req, out := c.AssociateIdentityProviderConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAddon = "CreateAddon"

// CreateAddonRequest generates a "aws/request.Request" representing the
// client's request for the CreateAddon operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAddon for more information on using the CreateAddon
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAddonRequest method.
//    req, resp := client.CreateAddonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateAddon
func (c *EKS) CreateAddonRequest(input *CreateAddonInput) (req *request.Request, output *CreateAddonOutput) {
	op := &request.Operation{
		Name:       opCreateAddon,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/addons",
	}

	if input == nil {
		input = &CreateAddonInput{}
	}

	output = &CreateAddonOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAddon API operation for Amazon Elastic Kubernetes Service.
//
// Creates an Amazon EKS add-on.
//
// Amazon EKS add-ons help to automate the provisioning and lifecycle management
// of common operational software for Amazon EKS clusters. Amazon EKS add-ons
// can only be used with Amazon EKS clusters running version 1.18 with platform
// version eks.3 or later because add-ons rely on the Server-side Apply Kubernetes
// feature, which is only available in Kubernetes 1.18 and later.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation CreateAddon for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * InvalidRequestException
//   The request is invalid given the state of the cluster. Check the state of
//   the cluster and the associated operations.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateAddon
func (c *EKS) CreateAddon(input *CreateAddonInput) (*CreateAddonOutput, error) {
	req, out := c.CreateAddonRequest(input)
	return out, req.Send()
}

// CreateAddonWithContext is the same as CreateAddon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAddon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) CreateAddonWithContext(ctx aws.Context, input *CreateAddonInput, opts ...request.Option) (*CreateAddonOutput, error) {
	req, out := c.CreateAddonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCluster = "CreateCluster"

// CreateClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCluster for more information on using the CreateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateClusterRequest method.
//    req, resp := client.CreateClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateCluster
func (c *EKS) CreateClusterRequest(input *CreateClusterInput) (req *request.Request, output *CreateClusterOutput) {
	op := &request.Operation{
		Name:       opCreateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters",
	}

	if input == nil {
		input = &CreateClusterInput{}
	}

	output = &CreateClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCluster API operation for Amazon Elastic Kubernetes Service.
//
// Creates an Amazon EKS control plane.
//
// The Amazon EKS control plane consists of control plane instances that run
// the Kubernetes software, such as etcd and the API server. The control plane
// runs in an account managed by Amazon Web Services, and the Kubernetes API
// is exposed via the Amazon EKS API server endpoint. Each Amazon EKS cluster
// control plane is single-tenant and unique and runs on its own set of Amazon
// EC2 instances.
//
// The cluster control plane is provisioned across multiple Availability Zones
// and fronted by an Elastic Load Balancing Network Load Balancer. Amazon EKS
// also provisions elastic network interfaces in your VPC subnets to provide
// connectivity from the control plane instances to the nodes (for example,
// to support kubectl exec, logs, and proxy data flows).
//
// Amazon EKS nodes run in your Amazon Web Services account and connect to your
// cluster's control plane via the Kubernetes API server endpoint and a certificate
// file that is created for your cluster.
//
// Cluster creation typically takes several minutes. After you create an Amazon
// EKS cluster, you must configure your Kubernetes tooling to communicate with
// the API server and launch nodes into your cluster. For more information,
// see Managing Cluster Authentication (https://docs.aws.amazon.com/eks/latest/userguide/managing-auth.html)
// and Launching Amazon EKS nodes (https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html)
// in the Amazon EKS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation CreateCluster for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceLimitExceededException
//   You have encountered a service limit on the specified resource.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ServiceUnavailableException
//   The service is unavailable. Back off and retry the operation.
//
//   * UnsupportedAvailabilityZoneException
//   At least one of your specified cluster subnets is in an Availability Zone
//   that does not support Amazon EKS. The exception output specifies the supported
//   Availability Zones for your account, from which you can choose subnets for
//   your cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateCluster
func (c *EKS) CreateCluster(input *CreateClusterInput) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	return out, req.Send()
}

// CreateClusterWithContext is the same as CreateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) CreateClusterWithContext(ctx aws.Context, input *CreateClusterInput, opts ...request.Option) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFargateProfile = "CreateFargateProfile"

// CreateFargateProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateFargateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFargateProfile for more information on using the CreateFargateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFargateProfileRequest method.
//    req, resp := client.CreateFargateProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateFargateProfile
func (c *EKS) CreateFargateProfileRequest(input *CreateFargateProfileInput) (req *request.Request, output *CreateFargateProfileOutput) {
	op := &request.Operation{
		Name:       opCreateFargateProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/fargate-profiles",
	}

	if input == nil {
		input = &CreateFargateProfileInput{}
	}

	output = &CreateFargateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFargateProfile API operation for Amazon Elastic Kubernetes Service.
//
// Creates an Fargate profile for your Amazon EKS cluster. You must have at
// least one Fargate profile in a cluster to be able to run pods on Fargate.
//
// The Fargate profile allows an administrator to declare which pods run on
// Fargate and specify which pods run on which Fargate profile. This declaration
// is done through the profile’s selectors. Each profile can have up to five
// selectors that contain a namespace and labels. A namespace is required for
// every selector. The label field consists of multiple optional key-value pairs.
// Pods that match the selectors are scheduled on Fargate. If a to-be-scheduled
// pod matches any of the selectors in the Fargate profile, then that pod is
// run on Fargate.
//
// When you create a Fargate profile, you must specify a pod execution role
// to use with the pods that are scheduled with the profile. This role is added
// to the cluster's Kubernetes Role Based Access Control (https://kubernetes.io/docs/admin/authorization/rbac/)
// (RBAC) for authorization so that the kubelet that is running on the Fargate
// infrastructure can register with your Amazon EKS cluster so that it can appear
// in your cluster as a node. The pod execution role also provides IAM permissions
// to the Fargate infrastructure to allow read access to Amazon ECR image repositories.
// For more information, see Pod Execution Role (https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html)
// in the Amazon EKS User Guide.
//
// Fargate profiles are immutable. However, you can create a new updated profile
// to replace an existing profile and then delete the original after the updated
// profile has finished creating.
//
// If any Fargate profiles in a cluster are in the DELETING status, you must
// wait for that Fargate profile to finish deleting before you can create any
// other profiles in that cluster.
//
// For more information, see Fargate Profile (https://docs.aws.amazon.com/eks/latest/userguide/fargate-profile.html)
// in the Amazon EKS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation CreateFargateProfile for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * InvalidRequestException
//   The request is invalid given the state of the cluster. Check the state of
//   the cluster and the associated operations.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceLimitExceededException
//   You have encountered a service limit on the specified resource.
//
//   * UnsupportedAvailabilityZoneException
//   At least one of your specified cluster subnets is in an Availability Zone
//   that does not support Amazon EKS. The exception output specifies the supported
//   Availability Zones for your account, from which you can choose subnets for
//   your cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateFargateProfile
func (c *EKS) CreateFargateProfile(input *CreateFargateProfileInput) (*CreateFargateProfileOutput, error) {
	req, out := c.CreateFargateProfileRequest(input)
	return out, req.Send()
}

// CreateFargateProfileWithContext is the same as CreateFargateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFargateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) CreateFargateProfileWithContext(ctx aws.Context, input *CreateFargateProfileInput, opts ...request.Option) (*CreateFargateProfileOutput, error) {
	req, out := c.CreateFargateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNodegroup = "CreateNodegroup"

// CreateNodegroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateNodegroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNodegroup for more information on using the CreateNodegroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNodegroupRequest method.
//    req, resp := client.CreateNodegroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateNodegroup
func (c *EKS) CreateNodegroupRequest(input *CreateNodegroupInput) (req *request.Request, output *CreateNodegroupOutput) {
	op := &request.Operation{
		Name:       opCreateNodegroup,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/node-groups",
	}

	if input == nil {
		input = &CreateNodegroupInput{}
	}

	output = &CreateNodegroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNodegroup API operation for Amazon Elastic Kubernetes Service.
//
// Creates a managed node group for an Amazon EKS cluster. You can only create
// a node group for your cluster that is equal to the current Kubernetes version
// for the cluster. All node groups are created with the latest AMI release
// version for the respective minor Kubernetes version of the cluster, unless
// you deploy a custom AMI using a launch template. For more information about
// using launch templates, see Launch template support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html).
//
// An Amazon EKS managed node group is an Amazon EC2 Auto Scaling group and
// associated Amazon EC2 instances that are managed by Amazon Web Services for
// an Amazon EKS cluster. Each node group uses a version of the Amazon EKS optimized
// Amazon Linux 2 AMI. For more information, see Managed Node Groups (https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html)
// in the Amazon EKS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation CreateNodegroup for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceLimitExceededException
//   You have encountered a service limit on the specified resource.
//
//   * InvalidRequestException
//   The request is invalid given the state of the cluster. Check the state of
//   the cluster and the associated operations.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ServiceUnavailableException
//   The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateNodegroup
func (c *EKS) CreateNodegroup(input *CreateNodegroupInput) (*CreateNodegroupOutput, error) {
	req, out := c.CreateNodegroupRequest(input)
	return out, req.Send()
}

// CreateNodegroupWithContext is the same as CreateNodegroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNodegroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) CreateNodegroupWithContext(ctx aws.Context, input *CreateNodegroupInput, opts ...request.Option) (*CreateNodegroupOutput, error) {
	req, out := c.CreateNodegroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAddon = "DeleteAddon"

// DeleteAddonRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAddon operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAddon for more information on using the DeleteAddon
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAddonRequest method.
//    req, resp := client.DeleteAddonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteAddon
func (c *EKS) DeleteAddonRequest(input *DeleteAddonInput) (req *request.Request, output *DeleteAddonOutput) {
	op := &request.Operation{
		Name:       opDeleteAddon,
		HTTPMethod: "DELETE",
		HTTPPath:   "/clusters/{name}/addons/{addonName}",
	}

	if input == nil {
		input = &DeleteAddonInput{}
	}

	output = &DeleteAddonOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAddon API operation for Amazon Elastic Kubernetes Service.
//
// Delete an Amazon EKS add-on.
//
// When you remove the add-on, it will also be deleted from the cluster. You
// can always manually start an add-on on the cluster using the Kubernetes API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DeleteAddon for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * InvalidRequestException
//   The request is invalid given the state of the cluster. Check the state of
//   the cluster and the associated operations.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteAddon
func (c *EKS) DeleteAddon(input *DeleteAddonInput) (*DeleteAddonOutput, error) {
	req, out := c.DeleteAddonRequest(input)
	return out, req.Send()
}

// DeleteAddonWithContext is the same as DeleteAddon with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAddon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DeleteAddonWithContext(ctx aws.Context, input *DeleteAddonInput, opts ...request.Option) (*DeleteAddonOutput, error) {
	req, out := c.DeleteAddonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCluster = "DeleteCluster"

// DeleteClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCluster for more information on using the DeleteCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteClusterRequest method.
//    req, resp := client.DeleteClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteCluster
func (c *EKS) DeleteClusterRequest(input *DeleteClusterInput) (req *request.Request, output *DeleteClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteCluster,
		HTTPMethod: "DELETE",
		HTTPPath:   "/clusters/{name}",
	}

	if input == nil {
		input = &DeleteClusterInput{}
	}

	output = &DeleteClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCluster API operation for Amazon Elastic Kubernetes Service.
//
// Deletes the Amazon EKS cluster control plane.
//
// If you have active services in your cluster that are associated with a load
// balancer, you must delete those services before deleting the cluster so that
// the load balancers are deleted properly. Otherwise, you can have orphaned
// resources in your VPC that prevent you from being able to delete the VPC.
// For more information, see Deleting a Cluster (https://docs.aws.amazon.com/eks/latest/userguide/delete-cluster.html)
// in the Amazon EKS User Guide.
//
// If you have managed node groups or Fargate profiles attached to the cluster,
// you must delete them first. For more information, see DeleteNodegroup and
// DeleteFargateProfile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DeleteCluster for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ServiceUnavailableException
//   The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteCluster
func (c *EKS) DeleteCluster(input *DeleteClusterInput) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	return out, req.Send()
}

// DeleteClusterWithContext is the same as DeleteCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DeleteClusterWithContext(ctx aws.Context, input *DeleteClusterInput, opts ...request.Option) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFargateProfile = "DeleteFargateProfile"

// DeleteFargateProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFargateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFargateProfile for more information on using the DeleteFargateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFargateProfileRequest method.
//    req, resp := client.DeleteFargateProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteFargateProfile
func (c *EKS) DeleteFargateProfileRequest(input *DeleteFargateProfileInput) (req *request.Request, output *DeleteFargateProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteFargateProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/clusters/{name}/fargate-profiles/{fargateProfileName}",
	}

	if input == nil {
		input = &DeleteFargateProfileInput{}
	}

	output = &DeleteFargateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFargateProfile API operation for Amazon Elastic Kubernetes Service.
//
// Deletes an Fargate profile.
//
// When you delete a Fargate profile, any pods running on Fargate that were
// created with the profile are deleted. If those pods match another Fargate
// profile, then they are scheduled on Fargate with that profile. If they no
// longer match any Fargate profiles, then they are not scheduled on Fargate
// and they may remain in a pending state.
//
// Only one Fargate profile in a cluster can be in the DELETING status at a
// time. You must wait for a Fargate profile to finish deleting before you can
// delete any other profiles in that cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DeleteFargateProfile for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteFargateProfile
func (c *EKS) DeleteFargateProfile(input *DeleteFargateProfileInput) (*DeleteFargateProfileOutput, error) {
	req, out := c.DeleteFargateProfileRequest(input)
	return out, req.Send()
}

// DeleteFargateProfileWithContext is the same as DeleteFargateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFargateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DeleteFargateProfileWithContext(ctx aws.Context, input *DeleteFargateProfileInput, opts ...request.Option) (*DeleteFargateProfileOutput, error) {
	req, out := c.DeleteFargateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNodegroup = "DeleteNodegroup"

// DeleteNodegroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNodegroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNodegroup for more information on using the DeleteNodegroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNodegroupRequest method.
//    req, resp := client.DeleteNodegroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteNodegroup
func (c *EKS) DeleteNodegroupRequest(input *DeleteNodegroupInput) (req *request.Request, output *DeleteNodegroupOutput) {
	op := &request.Operation{
		Name:       opDeleteNodegroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/clusters/{name}/node-groups/{nodegroupName}",
	}

	if input == nil {
		input = &DeleteNodegroupInput{}
	}

	output = &DeleteNodegroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNodegroup API operation for Amazon Elastic Kubernetes Service.
//
// Deletes an Amazon EKS node group for a cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DeleteNodegroup for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ServiceUnavailableException
//   The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteNodegroup
func (c *EKS) DeleteNodegroup(input *DeleteNodegroupInput) (*DeleteNodegroupOutput, error) {
	req, out := c.DeleteNodegroupRequest(input)
	return out, req.Send()
}

// DeleteNodegroupWithContext is the same as DeleteNodegroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNodegroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DeleteNodegroupWithContext(ctx aws.Context, input *DeleteNodegroupInput, opts ...request.Option) (*DeleteNodegroupOutput, error) {
	req, out := c.DeleteNodegroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterCluster = "DeregisterCluster"

// DeregisterClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterCluster for more information on using the DeregisterCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterClusterRequest method.
//    req, resp := client.DeregisterClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeregisterCluster
func (c *EKS) DeregisterClusterRequest(input *DeregisterClusterInput) (req *request.Request, output *DeregisterClusterOutput) {
	op := &request.Operation{
		Name:       opDeregisterCluster,
		HTTPMethod: "DELETE",
		HTTPPath:   "/cluster-registrations/{name}",
	}

	if input == nil {
		input = &DeregisterClusterInput{}
	}

	output = &DeregisterClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterCluster API operation for Amazon Elastic Kubernetes Service.
//
// Deregisters a connected cluster to remove it from the Amazon EKS control
// plane.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DeregisterCluster for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ServiceUnavailableException
//   The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeregisterCluster
func (c *EKS) DeregisterCluster(input *DeregisterClusterInput) (*DeregisterClusterOutput, error) {
	req, out := c.DeregisterClusterRequest(input)
	return out, req.Send()
}

// DeregisterClusterWithContext is the same as DeregisterCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DeregisterClusterWithContext(ctx aws.Context, input *DeregisterClusterInput, opts ...request.Option) (*DeregisterClusterOutput, error) {
	req, out := c.DeregisterClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAddon = "DescribeAddon"

// DescribeAddonRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAddon operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAddon for more information on using the DescribeAddon
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAddonRequest method.
//    req, resp := client.DescribeAddonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeAddon
func (c *EKS) DescribeAddonRequest(input *DescribeAddonInput) (req *request.Request, output *DescribeAddonOutput) {
	op := &request.Operation{
		Name:       opDescribeAddon,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/addons/{addonName}",
	}

	if input == nil {
		input = &DescribeAddonInput{}
	}

	output = &DescribeAddonOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAddon API operation for Amazon Elastic Kubernetes Service.
//
// Describes an Amazon EKS add-on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeAddon for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * InvalidRequestException
//   The request is invalid given the state of the cluster. Check the state of
//   the cluster and the associated operations.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeAddon
func (c *EKS) DescribeAddon(input *DescribeAddonInput) (*DescribeAddonOutput, error) {
	req, out := c.DescribeAddonRequest(input)
	return out, req.Send()
}

// DescribeAddonWithContext is the same as DescribeAddon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAddon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeAddonWithContext(ctx aws.Context, input *DescribeAddonInput, opts ...request.Option) (*DescribeAddonOutput, error) {
	req, out := c.DescribeAddonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAddonVersions = "DescribeAddonVersions"

// DescribeAddonVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAddonVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAddonVersions for more information on using the DescribeAddonVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAddonVersionsRequest method.
//    req, resp := client.DescribeAddonVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeAddonVersions
func (c *EKS) DescribeAddonVersionsRequest(input *DescribeAddonVersionsInput) (req *request.Request, output *DescribeAddonVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeAddonVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/addons/supported-versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAddonVersionsInput{}
	}

	output = &DescribeAddonVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAddonVersions API operation for Amazon Elastic Kubernetes Service.
//
// Describes the Kubernetes versions that the add-on can be used with.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeAddonVersions for usage and error information.
//
// Returned Error Types:
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeAddonVersions
func (c *EKS) DescribeAddonVersions(input *DescribeAddonVersionsInput) (*DescribeAddonVersionsOutput, error) {
	req, out := c.DescribeAddonVersionsRequest(input)
	return out, req.Send()
}

// DescribeAddonVersionsWithContext is the same as DescribeAddonVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAddonVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeAddonVersionsWithContext(ctx aws.Context, input *DescribeAddonVersionsInput, opts ...request.Option) (*DescribeAddonVersionsOutput, error) {
	req, out := c.DescribeAddonVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAddonVersionsPages iterates over the pages of a DescribeAddonVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAddonVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAddonVersions operation.
//    pageNum := 0
//    err := client.DescribeAddonVersionsPages(params,
//        func(page *eks.DescribeAddonVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EKS) DescribeAddonVersionsPages(input *DescribeAddonVersionsInput, fn func(*DescribeAddonVersionsOutput, bool) bool) error {
	return c.DescribeAddonVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAddonVersionsPagesWithContext same as DescribeAddonVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeAddonVersionsPagesWithContext(ctx aws.Context, input *DescribeAddonVersionsInput, fn func(*DescribeAddonVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAddonVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAddonVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAddonVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeCluster = "DescribeCluster"

// DescribeClusterRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCluster for more information on using the DescribeCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClusterRequest method.
//    req, resp := client.DescribeClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeCluster
func (c *EKS) DescribeClusterRequest(input *DescribeClusterInput) (req *request.Request, output *DescribeClusterOutput) {
	op := &request.Operation{
		Name:       opDescribeCluster,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}",
	}

	if input == nil {
		input = &DescribeClusterInput{}
	}

	output = &DescribeClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCluster API operation for Amazon Elastic Kubernetes Service.
//
// Returns descriptive information about an Amazon EKS cluster.
//
// The API server endpoint and certificate authority data returned by this operation
// are required for kubelet and kubectl to communicate with your Kubernetes
// API server. For more information, see Create a kubeconfig for Amazon EKS
// (https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html).
//
// The API server endpoint and certificate authority data aren't available until
// the cluster reaches the ACTIVE state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeCluster for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ServiceUnavailableException
//   The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeCluster
func (c *EKS) DescribeCluster(input *DescribeClusterInput) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	return out, req.Send()
}

// DescribeClusterWithContext is the same as DescribeCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeClusterWithContext(ctx aws.Context, input *DescribeClusterInput, opts ...request.Option) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFargateProfile = "DescribeFargateProfile"

// DescribeFargateProfileRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFargateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFargateProfile for more information on using the DescribeFargateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFargateProfileRequest method.
//    req, resp := client.DescribeFargateProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeFargateProfile
func (c *EKS) DescribeFargateProfileRequest(input *DescribeFargateProfileInput) (req *request.Request, output *DescribeFargateProfileOutput) {
	op := &request.Operation{
		Name:       opDescribeFargateProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/fargate-profiles/{fargateProfileName}",
	}

	if input == nil {
		input = &DescribeFargateProfileInput{}
	}

	output = &DescribeFargateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFargateProfile API operation for Amazon Elastic Kubernetes Service.
//
// Returns descriptive information about an Fargate profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeFargateProfile for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeFargateProfile
func (c *EKS) DescribeFargateProfile(input *DescribeFargateProfileInput) (*DescribeFargateProfileOutput, error) {
	req, out := c.DescribeFargateProfileRequest(input)
	return out, req.Send()
}

// DescribeFargateProfileWithContext is the same as DescribeFargateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFargateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeFargateProfileWithContext(ctx aws.Context, input *DescribeFargateProfileInput, opts ...request.Option) (*DescribeFargateProfileOutput, error) {
	req, out := c.DescribeFargateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIdentityProviderConfig = "DescribeIdentityProviderConfig"

// DescribeIdentityProviderConfigRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIdentityProviderConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIdentityProviderConfig for more information on using the DescribeIdentityProviderConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIdentityProviderConfigRequest method.
//    req, resp := client.DescribeIdentityProviderConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeIdentityProviderConfig
func (c *EKS) DescribeIdentityProviderConfigRequest(input *DescribeIdentityProviderConfigInput) (req *request.Request, output *DescribeIdentityProviderConfigOutput) {
	op := &request.Operation{
		Name:       opDescribeIdentityProviderConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/identity-provider-configs/describe",
	}

	if input == nil {
		input = &DescribeIdentityProviderConfigInput{}
	}

	output = &DescribeIdentityProviderConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIdentityProviderConfig API operation for Amazon Elastic Kubernetes Service.
//
// Returns descriptive information about an identity provider configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeIdentityProviderConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ServiceUnavailableException
//   The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeIdentityProviderConfig
func (c *EKS) DescribeIdentityProviderConfig(input *DescribeIdentityProviderConfigInput) (*DescribeIdentityProviderConfigOutput, error) {
	req, out := c.DescribeIdentityProviderConfigRequest(input)
	return out, req.Send()
}

// DescribeIdentityProviderConfigWithContext is the same as DescribeIdentityProviderConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIdentityProviderConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeIdentityProviderConfigWithContext(ctx aws.Context, input *DescribeIdentityProviderConfigInput, opts ...request.Option) (*DescribeIdentityProviderConfigOutput, error) {
	req, out := c.DescribeIdentityProviderConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNodegroup = "DescribeNodegroup"

// DescribeNodegroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNodegroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNodegroup for more information on using the DescribeNodegroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNodegroupRequest method.
//    req, resp := client.DescribeNodegroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeNodegroup
func (c *EKS) DescribeNodegroupRequest(input *DescribeNodegroupInput) (req *request.Request, output *DescribeNodegroupOutput) {
	op := &request.Operation{
		Name:       opDescribeNodegroup,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/node-groups/{nodegroupName}",
	}

	if input == nil {
		input = &DescribeNodegroupInput{}
	}

	output = &DescribeNodegroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNodegroup API operation for Amazon Elastic Kubernetes Service.
//
// Returns descriptive information about an Amazon EKS node group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeNodegroup for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ServiceUnavailableException
//   The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeNodegroup
func (c *EKS) DescribeNodegroup(input *DescribeNodegroupInput) (*DescribeNodegroupOutput, error) {
	req, out := c.DescribeNodegroupRequest(input)
	return out, req.Send()
}

// DescribeNodegroupWithContext is the same as DescribeNodegroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNodegroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeNodegroupWithContext(ctx aws.Context, input *DescribeNodegroupInput, opts ...request.Option) (*DescribeNodegroupOutput, error) {
	req, out := c.DescribeNodegroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUpdate = "DescribeUpdate"

// DescribeUpdateRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUpdate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUpdate for more information on using the DescribeUpdate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUpdateRequest method.
//    req, resp := client.DescribeUpdateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeUpdate
func (c *EKS) DescribeUpdateRequest(input *DescribeUpdateInput) (req *request.Request, output *DescribeUpdateOutput) {
	op := &request.Operation{
		Name:       opDescribeUpdate,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/updates/{updateId}",
	}

	if input == nil {
		input = &DescribeUpdateInput{}
	}

	output = &DescribeUpdateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUpdate API operation for Amazon Elastic Kubernetes Service.
//
// Returns descriptive information about an update against your Amazon EKS cluster
// or associated managed node group.
//
// When the status of the update is Succeeded, the update is complete. If an
// update fails, the status is Failed, and an error detail explains the reason
// for the failure.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeUpdate for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeUpdate
func (c *EKS) DescribeUpdate(input *DescribeUpdateInput) (*DescribeUpdateOutput, error) {
	req, out := c.DescribeUpdateRequest(input)
	return out, req.Send()
}

// DescribeUpdateWithContext is the same as DescribeUpdate with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUpdate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeUpdateWithContext(ctx aws.Context, input *DescribeUpdateInput, opts ...request.Option) (*DescribeUpdateOutput, error) {
	req, out := c.DescribeUpdateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateIdentityProviderConfig = "DisassociateIdentityProviderConfig"

// DisassociateIdentityProviderConfigRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateIdentityProviderConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateIdentityProviderConfig for more information on using the DisassociateIdentityProviderConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateIdentityProviderConfigRequest method.
//    req, resp := client.DisassociateIdentityProviderConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DisassociateIdentityProviderConfig
func (c *EKS) DisassociateIdentityProviderConfigRequest(input *DisassociateIdentityProviderConfigInput) (req *request.Request, output *DisassociateIdentityProviderConfigOutput) {
	op := &request.Operation{
		Name:       opDisassociateIdentityProviderConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/identity-provider-configs/disassociate",
	}

	if input == nil {
		input = &DisassociateIdentityProviderConfigInput{}
	}

	output = &DisassociateIdentityProviderConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateIdentityProviderConfig API operation for Amazon Elastic Kubernetes Service.
//
// Disassociates an identity provider configuration from a cluster. If you disassociate
// an identity provider from your cluster, users included in the provider can
// no longer access the cluster. However, you can still access the cluster with
// Amazon Web Services IAM users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DisassociateIdentityProviderConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * InvalidRequestException
//   The request is invalid given the state of the cluster. Check the state of
//   the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DisassociateIdentityProviderConfig
func (c *EKS) DisassociateIdentityProviderConfig(input *DisassociateIdentityProviderConfigInput) (*DisassociateIdentityProviderConfigOutput, error) {
	req, out := c.DisassociateIdentityProviderConfigRequest(input)
	return out, req.Send()
}

// DisassociateIdentityProviderConfigWithContext is the same as DisassociateIdentityProviderConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateIdentityProviderConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DisassociateIdentityProviderConfigWithContext(ctx aws.Context, input *DisassociateIdentityProviderConfigInput, opts ...request.Option) (*DisassociateIdentityProviderConfigOutput, error) {
	req, out := c.DisassociateIdentityProviderConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAddons = "ListAddons"

// ListAddonsRequest generates a "aws/request.Request" representing the
// client's request for the ListAddons operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAddons for more information on using the ListAddons
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAddonsRequest method.
//    req, resp := client.ListAddonsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListAddons
func (c *EKS) ListAddonsRequest(input *ListAddonsInput) (req *request.Request, output *ListAddonsOutput) {
	op := &request.Operation{
		Name:       opListAddons,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/addons",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAddonsInput{}
	}

	output = &ListAddonsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAddons API operation for Amazon Elastic Kubernetes Service.
//
// Lists the available add-ons.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListAddons for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * InvalidRequestException
//   The request is invalid given the state of the cluster. Check the state of
//   the cluster and the associated operations.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListAddons
func (c *EKS) ListAddons(input *ListAddonsInput) (*ListAddonsOutput, error) {
	req, out := c.ListAddonsRequest(input)
	return out, req.Send()
}

// ListAddonsWithContext is the same as ListAddons with the addition of
// the ability to pass a context and additional request options.
//
// See ListAddons for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListAddonsWithContext(ctx aws.Context, input *ListAddonsInput, opts ...request.Option) (*ListAddonsOutput, error) {
	req, out := c.ListAddonsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAddonsPages iterates over the pages of a ListAddons operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAddons method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAddons operation.
//    pageNum := 0
//    err := client.ListAddonsPages(params,
//        func(page *eks.ListAddonsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EKS) ListAddonsPages(input *ListAddonsInput, fn func(*ListAddonsOutput, bool) bool) error {
	return c.ListAddonsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAddonsPagesWithContext same as ListAddonsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListAddonsPagesWithContext(ctx aws.Context, input *ListAddonsInput, fn func(*ListAddonsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAddonsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAddonsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAddonsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListClusters = "ListClusters"

// ListClustersRequest generates a "aws/request.Request" representing the
// client's request for the ListClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClusters for more information on using the ListClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListClustersRequest method.
//    req, resp := client.ListClustersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListClusters
func (c *EKS) ListClustersRequest(input *ListClustersInput) (req *request.Request, output *ListClustersOutput) {
	op := &request.Operation{
		Name:       opListClusters,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClustersInput{}
	}

	output = &ListClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListClusters API operation for Amazon Elastic Kubernetes Service.
//
// Lists the Amazon EKS clusters in your Amazon Web Services account in the
// specified Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListClusters for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ServiceUnavailableException
//   The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListClusters
func (c *EKS) ListClusters(input *ListClustersInput) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	return out, req.Send()
}

// ListClustersWithContext is the same as ListClusters with the addition of
// the ability to pass a context and additional request options.
//
// See ListClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListClustersWithContext(ctx aws.Context, input *ListClustersInput, opts ...request.Option) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListClustersPages iterates over the pages of a ListClusters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListClusters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListClusters operation.
//    pageNum := 0
//    err := client.ListClustersPages(params,
//        func(page *eks.ListClustersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EKS) ListClustersPages(input *ListClustersInput, fn func(*ListClustersOutput, bool) bool) error {
	return c.ListClustersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListClustersPagesWithContext same as ListClustersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListClustersPagesWithContext(ctx aws.Context, input *ListClustersInput, fn func(*ListClustersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListClustersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListClustersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListClustersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFargateProfiles = "ListFargateProfiles"

// ListFargateProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListFargateProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFargateProfiles for more information on using the ListFargateProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFargateProfilesRequest method.
//    req, resp := client.ListFargateProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListFargateProfiles
func (c *EKS) ListFargateProfilesRequest(input *ListFargateProfilesInput) (req *request.Request, output *ListFargateProfilesOutput) {
	op := &request.Operation{
		Name:       opListFargateProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/fargate-profiles",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFargateProfilesInput{}
	}

	output = &ListFargateProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFargateProfiles API operation for Amazon Elastic Kubernetes Service.
//
// Lists the Fargate profiles associated with the specified cluster in your
// Amazon Web Services account in the specified Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListFargateProfiles for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListFargateProfiles
func (c *EKS) ListFargateProfiles(input *ListFargateProfilesInput) (*ListFargateProfilesOutput, error) {
	req, out := c.ListFargateProfilesRequest(input)
	return out, req.Send()
}

// ListFargateProfilesWithContext is the same as ListFargateProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListFargateProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListFargateProfilesWithContext(ctx aws.Context, input *ListFargateProfilesInput, opts ...request.Option) (*ListFargateProfilesOutput, error) {
	req, out := c.ListFargateProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFargateProfilesPages iterates over the pages of a ListFargateProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFargateProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFargateProfiles operation.
//    pageNum := 0
//    err := client.ListFargateProfilesPages(params,
//        func(page *eks.ListFargateProfilesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EKS) ListFargateProfilesPages(input *ListFargateProfilesInput, fn func(*ListFargateProfilesOutput, bool) bool) error {
	return c.ListFargateProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFargateProfilesPagesWithContext same as ListFargateProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListFargateProfilesPagesWithContext(ctx aws.Context, input *ListFargateProfilesInput, fn func(*ListFargateProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFargateProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFargateProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFargateProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIdentityProviderConfigs = "ListIdentityProviderConfigs"

// ListIdentityProviderConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListIdentityProviderConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIdentityProviderConfigs for more information on using the ListIdentityProviderConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIdentityProviderConfigsRequest method.
//    req, resp := client.ListIdentityProviderConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListIdentityProviderConfigs
func (c *EKS) ListIdentityProviderConfigsRequest(input *ListIdentityProviderConfigsInput) (req *request.Request, output *ListIdentityProviderConfigsOutput) {
	op := &request.Operation{
		Name:       opListIdentityProviderConfigs,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/identity-provider-configs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIdentityProviderConfigsInput{}
	}

	output = &ListIdentityProviderConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIdentityProviderConfigs API operation for Amazon Elastic Kubernetes Service.
//
// A list of identity provider configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListIdentityProviderConfigs for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ServiceUnavailableException
//   The service is unavailable. Back off and retry the operation.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListIdentityProviderConfigs
func (c *EKS) ListIdentityProviderConfigs(input *ListIdentityProviderConfigsInput) (*ListIdentityProviderConfigsOutput, error) {
	req, out := c.ListIdentityProviderConfigsRequest(input)
	return out, req.Send()
}

// ListIdentityProviderConfigsWithContext is the same as ListIdentityProviderConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListIdentityProviderConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListIdentityProviderConfigsWithContext(ctx aws.Context, input *ListIdentityProviderConfigsInput, opts ...request.Option) (*ListIdentityProviderConfigsOutput, error) {
	req, out := c.ListIdentityProviderConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIdentityProviderConfigsPages iterates over the pages of a ListIdentityProviderConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIdentityProviderConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListIdentityProviderConfigs operation.
//    pageNum := 0
//    err := client.ListIdentityProviderConfigsPages(params,
//        func(page *eks.ListIdentityProviderConfigsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EKS) ListIdentityProviderConfigsPages(input *ListIdentityProviderConfigsInput, fn func(*ListIdentityProviderConfigsOutput, bool) bool) error {
	return c.ListIdentityProviderConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIdentityProviderConfigsPagesWithContext same as ListIdentityProviderConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListIdentityProviderConfigsPagesWithContext(ctx aws.Context, input *ListIdentityProviderConfigsInput, fn func(*ListIdentityProviderConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIdentityProviderConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIdentityProviderConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIdentityProviderConfigsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNodegroups = "ListNodegroups"

// ListNodegroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListNodegroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNodegroups for more information on using the ListNodegroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNodegroupsRequest method.
//    req, resp := client.ListNodegroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListNodegroups
func (c *EKS) ListNodegroupsRequest(input *ListNodegroupsInput) (req *request.Request, output *ListNodegroupsOutput) {
	op := &request.Operation{
		Name:       opListNodegroups,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/node-groups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNodegroupsInput{}
	}

	output = &ListNodegroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNodegroups API operation for Amazon Elastic Kubernetes Service.
//
// Lists the Amazon EKS managed node groups associated with the specified cluster
// in your Amazon Web Services account in the specified Region. Self-managed
// node groups are not listed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListNodegroups for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ServiceUnavailableException
//   The service is unavailable. Back off and retry the operation.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListNodegroups
func (c *EKS) ListNodegroups(input *ListNodegroupsInput) (*ListNodegroupsOutput, error) {
	req, out := c.ListNodegroupsRequest(input)
	return out, req.Send()
}

// ListNodegroupsWithContext is the same as ListNodegroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListNodegroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListNodegroupsWithContext(ctx aws.Context, input *ListNodegroupsInput, opts ...request.Option) (*ListNodegroupsOutput, error) {
	req, out := c.ListNodegroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNodegroupsPages iterates over the pages of a ListNodegroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNodegroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNodegroups operation.
//    pageNum := 0
//    err := client.ListNodegroupsPages(params,
//        func(page *eks.ListNodegroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EKS) ListNodegroupsPages(input *ListNodegroupsInput, fn func(*ListNodegroupsOutput, bool) bool) error {
	return c.ListNodegroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNodegroupsPagesWithContext same as ListNodegroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListNodegroupsPagesWithContext(ctx aws.Context, input *ListNodegroupsInput, fn func(*ListNodegroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNodegroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNodegroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNodegroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListTagsForResource
func (c *EKS) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Elastic Kubernetes Service.
//
// List the tags for an Amazon EKS resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   This exception is thrown if the request contains a semantic error. The precise
//   meaning will depend on the API, and will be documented in the error message.
//
//   * NotFoundException
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListTagsForResource
func (c *EKS) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUpdates = "ListUpdates"

// ListUpdatesRequest generates a "aws/request.Request" representing the
// client's request for the ListUpdates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUpdates for more information on using the ListUpdates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUpdatesRequest method.
//    req, resp := client.ListUpdatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListUpdates
func (c *EKS) ListUpdatesRequest(input *ListUpdatesInput) (req *request.Request, output *ListUpdatesOutput) {
	op := &request.Operation{
		Name:       opListUpdates,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/updates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUpdatesInput{}
	}

	output = &ListUpdatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUpdates API operation for Amazon Elastic Kubernetes Service.
//
// Lists the updates associated with an Amazon EKS cluster or managed node group
// in your Amazon Web Services account, in the specified Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListUpdates for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListUpdates
func (c *EKS) ListUpdates(input *ListUpdatesInput) (*ListUpdatesOutput, error) {
	req, out := c.ListUpdatesRequest(input)
	return out, req.Send()
}

// ListUpdatesWithContext is the same as ListUpdates with the addition of
// the ability to pass a context and additional request options.
//
// See ListUpdates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListUpdatesWithContext(ctx aws.Context, input *ListUpdatesInput, opts ...request.Option) (*ListUpdatesOutput, error) {
	req, out := c.ListUpdatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUpdatesPages iterates over the pages of a ListUpdates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUpdates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListUpdates operation.
//    pageNum := 0
//    err := client.ListUpdatesPages(params,
//        func(page *eks.ListUpdatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EKS) ListUpdatesPages(input *ListUpdatesInput, fn func(*ListUpdatesOutput, bool) bool) error {
	return c.ListUpdatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUpdatesPagesWithContext same as ListUpdatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListUpdatesPagesWithContext(ctx aws.Context, input *ListUpdatesInput, fn func(*ListUpdatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUpdatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUpdatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUpdatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opRegisterCluster = "RegisterCluster"

// RegisterClusterRequest generates a "aws/request.Request" representing the
// client's request for the RegisterCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterCluster for more information on using the RegisterCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterClusterRequest method.
//    req, resp := client.RegisterClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/RegisterCluster
func (c *EKS) RegisterClusterRequest(input *RegisterClusterInput) (req *request.Request, output *RegisterClusterOutput) {
	op := &request.Operation{
		Name:       opRegisterCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/cluster-registrations",
	}

	if input == nil {
		input = &RegisterClusterInput{}
	}

	output = &RegisterClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterCluster API operation for Amazon Elastic Kubernetes Service.
//
// Connects a Kubernetes cluster to the Amazon EKS control plane.
//
// Any Kubernetes cluster can be connected to the Amazon EKS control plane to
// view current information about the cluster and its nodes.
//
// Cluster connection requires two steps. First, send a RegisterClusterRequest
// to add it to the Amazon EKS control plane.
//
// Second, a Manifest (https://amazon-eks.s3.us-west-2.amazonaws.com/eks-connector/manifests/eks-connector/latest/eks-connector.yaml)
// containing the activationID and activationCode must be applied to the Kubernetes
// cluster through it's native provider to provide visibility.
//
// After the Manifest is updated and applied, then the connected cluster is
// visible to the Amazon EKS control plane. If the Manifest is not applied within
// a set amount of time, then the connected cluster will no longer be visible
// and must be deregistered. See DeregisterCluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation RegisterCluster for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceededException
//   You have encountered a service limit on the specified resource.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ServiceUnavailableException
//   The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/RegisterCluster
func (c *EKS) RegisterCluster(input *RegisterClusterInput) (*RegisterClusterOutput, error) {
	req, out := c.RegisterClusterRequest(input)
	return out, req.Send()
}

// RegisterClusterWithContext is the same as RegisterCluster with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) RegisterClusterWithContext(ctx aws.Context, input *RegisterClusterInput, opts ...request.Option) (*RegisterClusterOutput, error) {
	req, out := c.RegisterClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/TagResource
func (c *EKS) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Elastic Kubernetes Service.
//
// Associates the specified tags to a resource with the specified resourceArn.
// If existing tags on a resource are not specified in the request parameters,
// they are not changed. When a resource is deleted, the tags associated with
// that resource are deleted as well. Tags that you create for Amazon EKS resources
// do not propagate to any other resources associated with the cluster. For
// example, if you tag a cluster with this operation, that tag does not automatically
// propagate to the subnets and nodes associated with the cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   This exception is thrown if the request contains a semantic error. The precise
//   meaning will depend on the API, and will be documented in the error message.
//
//   * NotFoundException
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/TagResource
func (c *EKS) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UntagResource
func (c *EKS) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Elastic Kubernetes Service.
//
// Deletes specified tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   This exception is thrown if the request contains a semantic error. The precise
//   meaning will depend on the API, and will be documented in the error message.
//
//   * NotFoundException
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UntagResource
func (c *EKS) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAddon = "UpdateAddon"

// UpdateAddonRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAddon operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAddon for more information on using the UpdateAddon
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAddonRequest method.
//    req, resp := client.UpdateAddonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateAddon
func (c *EKS) UpdateAddonRequest(input *UpdateAddonInput) (req *request.Request, output *UpdateAddonOutput) {
	op := &request.Operation{
		Name:       opUpdateAddon,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/addons/{addonName}/update",
	}

	if input == nil {
		input = &UpdateAddonInput{}
	}

	output = &UpdateAddonOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAddon API operation for Amazon Elastic Kubernetes Service.
//
// Updates an Amazon EKS add-on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation UpdateAddon for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * InvalidRequestException
//   The request is invalid given the state of the cluster. Check the state of
//   the cluster and the associated operations.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateAddon
func (c *EKS) UpdateAddon(input *UpdateAddonInput) (*UpdateAddonOutput, error) {
	req, out := c.UpdateAddonRequest(input)
	return out, req.Send()
}

// UpdateAddonWithContext is the same as UpdateAddon with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAddon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) UpdateAddonWithContext(ctx aws.Context, input *UpdateAddonInput, opts ...request.Option) (*UpdateAddonOutput, error) {
	req, out := c.UpdateAddonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateClusterConfig = "UpdateClusterConfig"

// UpdateClusterConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateClusterConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateClusterConfig for more information on using the UpdateClusterConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateClusterConfigRequest method.
//    req, resp := client.UpdateClusterConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateClusterConfig
func (c *EKS) UpdateClusterConfigRequest(input *UpdateClusterConfigInput) (req *request.Request, output *UpdateClusterConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateClusterConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/update-config",
	}

	if input == nil {
		input = &UpdateClusterConfigInput{}
	}

	output = &UpdateClusterConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateClusterConfig API operation for Amazon Elastic Kubernetes Service.
//
// Updates an Amazon EKS cluster configuration. Your cluster continues to function
// during the update. The response output includes an update ID that you can
// use to track the status of your cluster update with the DescribeUpdate API
// operation.
//
// You can use this API operation to enable or disable exporting the Kubernetes
// control plane logs for your cluster to CloudWatch Logs. By default, cluster
// control plane logs aren't exported to CloudWatch Logs. For more information,
// see Amazon EKS Cluster Control Plane Logs (https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
// in the Amazon EKS User Guide .
//
// CloudWatch Logs ingestion, archive storage, and data scanning rates apply
// to exported control plane logs. For more information, see CloudWatch Pricing
// (http://aws.amazon.com/cloudwatch/pricing/).
//
// You can also use this API operation to enable or disable public and private
// access to your cluster's Kubernetes API server endpoint. By default, public
// access is enabled, and private access is disabled. For more information,
// see Amazon EKS cluster endpoint access control (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
// in the Amazon EKS User Guide .
//
// You can't update the subnets or security group IDs for an existing cluster.
//
// Cluster updates are asynchronous, and they should finish within a few minutes.
// During an update, the cluster status moves to UPDATING (this status transition
// is eventually consistent). When the update is complete (either Failed or
// Successful), the cluster status moves to Active.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation UpdateClusterConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * InvalidRequestException
//   The request is invalid given the state of the cluster. Check the state of
//   the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateClusterConfig
func (c *EKS) UpdateClusterConfig(input *UpdateClusterConfigInput) (*UpdateClusterConfigOutput, error) {
	req, out := c.UpdateClusterConfigRequest(input)
	return out, req.Send()
}

// UpdateClusterConfigWithContext is the same as UpdateClusterConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateClusterConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) UpdateClusterConfigWithContext(ctx aws.Context, input *UpdateClusterConfigInput, opts ...request.Option) (*UpdateClusterConfigOutput, error) {
	req, out := c.UpdateClusterConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateClusterVersion = "UpdateClusterVersion"

// UpdateClusterVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateClusterVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateClusterVersion for more information on using the UpdateClusterVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateClusterVersionRequest method.
//    req, resp := client.UpdateClusterVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateClusterVersion
func (c *EKS) UpdateClusterVersionRequest(input *UpdateClusterVersionInput) (req *request.Request, output *UpdateClusterVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateClusterVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/updates",
	}

	if input == nil {
		input = &UpdateClusterVersionInput{}
	}

	output = &UpdateClusterVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateClusterVersion API operation for Amazon Elastic Kubernetes Service.
//
// Updates an Amazon EKS cluster to the specified Kubernetes version. Your cluster
// continues to function during the update. The response output includes an
// update ID that you can use to track the status of your cluster update with
// the DescribeUpdate API operation.
//
// Cluster updates are asynchronous, and they should finish within a few minutes.
// During an update, the cluster status moves to UPDATING (this status transition
// is eventually consistent). When the update is complete (either Failed or
// Successful), the cluster status moves to Active.
//
// If your cluster has managed node groups attached to it, all of your node
// groups’ Kubernetes versions must match the cluster’s Kubernetes version
// in order to update the cluster to a new Kubernetes version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation UpdateClusterVersion for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * InvalidRequestException
//   The request is invalid given the state of the cluster. Check the state of
//   the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateClusterVersion
func (c *EKS) UpdateClusterVersion(input *UpdateClusterVersionInput) (*UpdateClusterVersionOutput, error) {
	req, out := c.UpdateClusterVersionRequest(input)
	return out, req.Send()
}

// UpdateClusterVersionWithContext is the same as UpdateClusterVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateClusterVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) UpdateClusterVersionWithContext(ctx aws.Context, input *UpdateClusterVersionInput, opts ...request.Option) (*UpdateClusterVersionOutput, error) {
	req, out := c.UpdateClusterVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNodegroupConfig = "UpdateNodegroupConfig"

// UpdateNodegroupConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNodegroupConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNodegroupConfig for more information on using the UpdateNodegroupConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateNodegroupConfigRequest method.
//    req, resp := client.UpdateNodegroupConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateNodegroupConfig
func (c *EKS) UpdateNodegroupConfigRequest(input *UpdateNodegroupConfigInput) (req *request.Request, output *UpdateNodegroupConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateNodegroupConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/node-groups/{nodegroupName}/update-config",
	}

	if input == nil {
		input = &UpdateNodegroupConfigInput{}
	}

	output = &UpdateNodegroupConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateNodegroupConfig API operation for Amazon Elastic Kubernetes Service.
//
// Updates an Amazon EKS managed node group configuration. Your node group continues
// to function during the update. The response output includes an update ID
// that you can use to track the status of your node group update with the DescribeUpdate
// API operation. Currently you can update the Kubernetes labels for a node
// group or the scaling configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation UpdateNodegroupConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * InvalidRequestException
//   The request is invalid given the state of the cluster. Check the state of
//   the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateNodegroupConfig
func (c *EKS) UpdateNodegroupConfig(input *UpdateNodegroupConfigInput) (*UpdateNodegroupConfigOutput, error) {
	req, out := c.UpdateNodegroupConfigRequest(input)
	return out, req.Send()
}

// UpdateNodegroupConfigWithContext is the same as UpdateNodegroupConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNodegroupConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) UpdateNodegroupConfigWithContext(ctx aws.Context, input *UpdateNodegroupConfigInput, opts ...request.Option) (*UpdateNodegroupConfigOutput, error) {
	req, out := c.UpdateNodegroupConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNodegroupVersion = "UpdateNodegroupVersion"

// UpdateNodegroupVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNodegroupVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNodegroupVersion for more information on using the UpdateNodegroupVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateNodegroupVersionRequest method.
//    req, resp := client.UpdateNodegroupVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateNodegroupVersion
func (c *EKS) UpdateNodegroupVersionRequest(input *UpdateNodegroupVersionInput) (req *request.Request, output *UpdateNodegroupVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateNodegroupVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/node-groups/{nodegroupName}/update-version",
	}

	if input == nil {
		input = &UpdateNodegroupVersionInput{}
	}

	output = &UpdateNodegroupVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateNodegroupVersion API operation for Amazon Elastic Kubernetes Service.
//
// Updates the Kubernetes version or AMI version of an Amazon EKS managed node
// group.
//
// You can update a node group using a launch template only if the node group
// was originally deployed with a launch template. If you need to update a custom
// AMI in a node group that was deployed with a launch template, then update
// your custom AMI, specify the new ID in a new version of the launch template,
// and then update the node group to the new version of the launch template.
//
// If you update without a launch template, then you can update to the latest
// available AMI version of a node group's current Kubernetes version by not
// specifying a Kubernetes version in the request. You can update to the latest
// AMI version of your cluster's current Kubernetes version by specifying your
// cluster's Kubernetes version in the request. For more information, see Amazon
// EKS optimized Amazon Linux 2 AMI versions (https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html)
// in the Amazon EKS User Guide.
//
// You cannot roll back a node group to an earlier Kubernetes version or AMI
// version.
//
// When a node in a managed node group is terminated due to a scaling action
// or update, the pods in that node are drained first. Amazon EKS attempts to
// drain the nodes gracefully and will fail if it is unable to do so. You can
// force the update if Amazon EKS is unable to drain the nodes as a result of
// a pod disruption budget issue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation UpdateNodegroupVersion for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * InvalidRequestException
//   The request is invalid given the state of the cluster. Check the state of
//   the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateNodegroupVersion
func (c *EKS) UpdateNodegroupVersion(input *UpdateNodegroupVersionInput) (*UpdateNodegroupVersionOutput, error) {
	req, out := c.UpdateNodegroupVersionRequest(input)
	return out, req.Send()
}

// UpdateNodegroupVersionWithContext is the same as UpdateNodegroupVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNodegroupVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) UpdateNodegroupVersionWithContext(ctx aws.Context, input *UpdateNodegroupVersionInput, opts ...request.Option) (*UpdateNodegroupVersionOutput, error) {
	req, out := c.UpdateNodegroupVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An Amazon EKS add-on.
type Addon struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the add-on.
	AddonArn *string `locationName:"addonArn" type:"string"`

	// The name of the add-on.
	AddonName *string `locationName:"addonName" type:"string"`

	// The version of the add-on.
	AddonVersion *string `locationName:"addonVersion" type:"string"`

	// The name of the cluster.
	ClusterName *string `locationName:"clusterName" min:"1" type:"string"`

	// The date and time that the add-on was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// An object that represents the health of the add-on.
	Health *AddonHealth `locationName:"health" type:"structure"`

	// The date and time that the add-on was last modified.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the IAM role that is bound to the Kubernetes
	// service account used by the add-on.
	ServiceAccountRoleArn *string `locationName:"serviceAccountRoleArn" type:"string"`

	// The status of the add-on.
	Status *string `locationName:"status" type:"string" enum:"AddonStatus"`

	// The metadata that you apply to the add-on to assist with categorization and
	// organization. Each tag consists of a key and an optional value, both of which
	// you define. Add-on tags do not propagate to any other resources associated
	// with the cluster.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Addon) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Addon) GoString() string {
	return s.String()
}

// SetAddonArn sets the AddonArn field's value.
func (s *Addon) SetAddonArn(v string) *Addon {
	s.AddonArn = &v
	return s
}

// SetAddonName sets the AddonName field's value.
func (s *Addon) SetAddonName(v string) *Addon {
	s.AddonName = &v
	return s
}

// SetAddonVersion sets the AddonVersion field's value.
func (s *Addon) SetAddonVersion(v string) *Addon {
	s.AddonVersion = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *Addon) SetClusterName(v string) *Addon {
	s.ClusterName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Addon) SetCreatedAt(v time.Time) *Addon {
	s.CreatedAt = &v
	return s
}

// SetHealth sets the Health field's value.
func (s *Addon) SetHealth(v *AddonHealth) *Addon {
	s.Health = v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *Addon) SetModifiedAt(v time.Time) *Addon {
	s.ModifiedAt = &v
	return s
}

// SetServiceAccountRoleArn sets the ServiceAccountRoleArn field's value.
func (s *Addon) SetServiceAccountRoleArn(v string) *Addon {
	s.ServiceAccountRoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Addon) SetStatus(v string) *Addon {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Addon) SetTags(v map[string]*string) *Addon {
	s.Tags = v
	return s
}

// The health of the add-on.
type AddonHealth struct {
	_ struct{} `type:"structure"`

	// An object that represents the add-on's health issues.
	Issues []*AddonIssue `locationName:"issues" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonHealth) GoString() string {
	return s.String()
}

// SetIssues sets the Issues field's value.
func (s *AddonHealth) SetIssues(v []*AddonIssue) *AddonHealth {
	s.Issues = v
	return s
}

// Information about an add-on.
type AddonInfo struct {
	_ struct{} `type:"structure"`

	// The name of the add-on.
	AddonName *string `locationName:"addonName" type:"string"`

	// An object that represents information about available add-on versions and
	// compatible Kubernetes versions.
	AddonVersions []*AddonVersionInfo `locationName:"addonVersions" type:"list"`

	// The type of the add-on.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonInfo) GoString() string {
	return s.String()
}

// SetAddonName sets the AddonName field's value.
func (s *AddonInfo) SetAddonName(v string) *AddonInfo {
	s.AddonName = &v
	return s
}

// SetAddonVersions sets the AddonVersions field's value.
func (s *AddonInfo) SetAddonVersions(v []*AddonVersionInfo) *AddonInfo {
	s.AddonVersions = v
	return s
}

// SetType sets the Type field's value.
func (s *AddonInfo) SetType(v string) *AddonInfo {
	s.Type = &v
	return s
}

// An issue related to an add-on.
type AddonIssue struct {
	_ struct{} `type:"structure"`

	// A code that describes the type of issue.
	Code *string `locationName:"code" type:"string" enum:"AddonIssueCode"`

	// A message that provides details about the issue and what might cause it.
	Message *string `locationName:"message" type:"string"`

	// The resource IDs of the issue.
	ResourceIds []*string `locationName:"resourceIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonIssue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonIssue) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *AddonIssue) SetCode(v string) *AddonIssue {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AddonIssue) SetMessage(v string) *AddonIssue {
	s.Message = &v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *AddonIssue) SetResourceIds(v []*string) *AddonIssue {
	s.ResourceIds = v
	return s
}

// Information about an add-on version.
type AddonVersionInfo struct {
	_ struct{} `type:"structure"`

	// The version of the add-on.
	AddonVersion *string `locationName:"addonVersion" type:"string"`

	// The architectures that the version supports.
	Architecture []*string `locationName:"architecture" type:"list"`

	// An object that represents the compatibilities of a version.
	Compatibilities []*Compatibility `locationName:"compatibilities" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonVersionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonVersionInfo) GoString() string {
	return s.String()
}

// SetAddonVersion sets the AddonVersion field's value.
func (s *AddonVersionInfo) SetAddonVersion(v string) *AddonVersionInfo {
	s.AddonVersion = &v
	return s
}

// SetArchitecture sets the Architecture field's value.
func (s *AddonVersionInfo) SetArchitecture(v []*string) *AddonVersionInfo {
	s.Architecture = v
	return s
}

// SetCompatibilities sets the Compatibilities field's value.
func (s *AddonVersionInfo) SetCompatibilities(v []*Compatibility) *AddonVersionInfo {
	s.Compatibilities = v
	return s
}

type AssociateEncryptionConfigInput struct {
	_ struct{} `type:"structure"`

	// The client request token you are using with the encryption configuration.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the cluster that you are associating with encryption configuration.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The configuration you are using for encryption.
	//
	// EncryptionConfig is a required field
	EncryptionConfig []*EncryptionConfig `locationName:"encryptionConfig" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateEncryptionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateEncryptionConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateEncryptionConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateEncryptionConfigInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.EncryptionConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionConfig"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *AssociateEncryptionConfigInput) SetClientRequestToken(v string) *AssociateEncryptionConfigInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *AssociateEncryptionConfigInput) SetClusterName(v string) *AssociateEncryptionConfigInput {
	s.ClusterName = &v
	return s
}

// SetEncryptionConfig sets the EncryptionConfig field's value.
func (s *AssociateEncryptionConfigInput) SetEncryptionConfig(v []*EncryptionConfig) *AssociateEncryptionConfigInput {
	s.EncryptionConfig = v
	return s
}

type AssociateEncryptionConfigOutput struct {
	_ struct{} `type:"structure"`

	// An object representing an asynchronous update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateEncryptionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateEncryptionConfigOutput) GoString() string {
	return s.String()
}

// SetUpdate sets the Update field's value.
func (s *AssociateEncryptionConfigOutput) SetUpdate(v *Update) *AssociateEncryptionConfigOutput {
	s.Update = v
	return s
}

type AssociateIdentityProviderConfigInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the cluster to associate the configuration to.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// An object that represents an OpenID Connect (OIDC) identity provider configuration.
	//
	// Oidc is a required field
	Oidc *OidcIdentityProviderConfigRequest `locationName:"oidc" type:"structure" required:"true"`

	// The metadata to apply to the configuration to assist with categorization
	// and organization. Each tag consists of a key and an optional value, both
	// of which you define.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateIdentityProviderConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateIdentityProviderConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateIdentityProviderConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateIdentityProviderConfigInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.Oidc == nil {
		invalidParams.Add(request.NewErrParamRequired("Oidc"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Oidc != nil {
		if err := s.Oidc.Validate(); err != nil {
			invalidParams.AddNested("Oidc", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *AssociateIdentityProviderConfigInput) SetClientRequestToken(v string) *AssociateIdentityProviderConfigInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *AssociateIdentityProviderConfigInput) SetClusterName(v string) *AssociateIdentityProviderConfigInput {
	s.ClusterName = &v
	return s
}

// SetOidc sets the Oidc field's value.
func (s *AssociateIdentityProviderConfigInput) SetOidc(v *OidcIdentityProviderConfigRequest) *AssociateIdentityProviderConfigInput {
	s.Oidc = v
	return s
}

// SetTags sets the Tags field's value.
func (s *AssociateIdentityProviderConfigInput) SetTags(v map[string]*string) *AssociateIdentityProviderConfigInput {
	s.Tags = v
	return s
}

type AssociateIdentityProviderConfigOutput struct {
	_ struct{} `type:"structure"`

	// The tags for the resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// An object representing an asynchronous update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateIdentityProviderConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateIdentityProviderConfigOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *AssociateIdentityProviderConfigOutput) SetTags(v map[string]*string) *AssociateIdentityProviderConfigOutput {
	s.Tags = v
	return s
}

// SetUpdate sets the Update field's value.
func (s *AssociateIdentityProviderConfigOutput) SetUpdate(v *Update) *AssociateIdentityProviderConfigOutput {
	s.Update = v
	return s
}

// An Auto Scaling group that is associated with an Amazon EKS managed node
// group.
type AutoScalingGroup struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group associated with an Amazon EKS managed
	// node group.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoScalingGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoScalingGroup) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AutoScalingGroup) SetName(v string) *AutoScalingGroup {
	s.Name = &v
	return s
}

// This exception is thrown if the request contains a semantic error. The precise
// meaning will depend on the API, and will be documented in the error message.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object representing the certificate-authority-data for your cluster.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The Base64-encoded certificate data required to communicate with your cluster.
	// Add this to the certificate-authority-data section of the kubeconfig file
	// for your cluster.
	Data *string `locationName:"data" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Certificate) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *Certificate) SetData(v string) *Certificate {
	s.Data = &v
	return s
}

// These errors are usually caused by a client action. Actions can include using
// an action or resource on behalf of a user that doesn't have permissions to
// use the action or resource or specifying an identifier that is not valid.
type ClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	AddonName *string `locationName:"addonName" type:"string"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientException) GoString() string {
	return s.String()
}

func newErrorClientException(v protocol.ResponseMetadata) error {
	return &ClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ClientException) Code() string {
	return "ClientException"
}

// Message returns the exception's message.
func (s *ClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ClientException) OrigErr() error {
	return nil
}

func (s *ClientException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object representing an Amazon EKS cluster.
type Cluster struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	Arn *string `locationName:"arn" type:"string"`

	// The certificate-authority-data for your cluster.
	CertificateAuthority *Certificate `locationName:"certificateAuthority" type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string"`

	// The configuration used to connect to a cluster for registration.
	ConnectorConfig *ConnectorConfigResponse `locationName:"connectorConfig" type:"structure"`

	// The Unix epoch timestamp in seconds for when the cluster was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The encryption configuration for the cluster.
	EncryptionConfig []*EncryptionConfig `locationName:"encryptionConfig" type:"list"`

	// The endpoint for your Kubernetes API server.
	Endpoint *string `locationName:"endpoint" type:"string"`

	// The identity provider information for the cluster.
	Identity *Identity `locationName:"identity" type:"structure"`

	// The Kubernetes network configuration for the cluster.
	KubernetesNetworkConfig *KubernetesNetworkConfigResponse `locationName:"kubernetesNetworkConfig" type:"structure"`

	// The logging configuration for your cluster.
	Logging *Logging `locationName:"logging" type:"structure"`

	// The name of the cluster.
	Name *string `locationName:"name" type:"string"`

	// The platform version of your Amazon EKS cluster. For more information, see
	// Platform Versions (https://docs.aws.amazon.com/eks/latest/userguide/platform-versions.html)
	// in the Amazon EKS User Guide .
	PlatformVersion *string `locationName:"platformVersion" type:"string"`

	// The VPC configuration used by the cluster control plane. Amazon EKS VPC resources
	// have specific requirements to work properly with Kubernetes. For more information,
	// see Cluster VPC Considerations (https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html)
	// and Cluster Security Group Considerations (https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html)
	// in the Amazon EKS User Guide.
	ResourcesVpcConfig *VpcConfigResponse `locationName:"resourcesVpcConfig" type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that provides permissions
	// for the Kubernetes control plane to make calls to Amazon Web Services API
	// operations on your behalf.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The current status of the cluster.
	Status *string `locationName:"status" type:"string" enum:"ClusterStatus"`

	// The metadata that you apply to the cluster to assist with categorization
	// and organization. Each tag consists of a key and an optional value, both
	// of which you define. Cluster tags do not propagate to any other resources
	// associated with the cluster.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The Kubernetes server version for the cluster.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cluster) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Cluster) SetArn(v string) *Cluster {
	s.Arn = &v
	return s
}

// SetCertificateAuthority sets the CertificateAuthority field's value.
func (s *Cluster) SetCertificateAuthority(v *Certificate) *Cluster {
	s.CertificateAuthority = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *Cluster) SetClientRequestToken(v string) *Cluster {
	s.ClientRequestToken = &v
	return s
}

// SetConnectorConfig sets the ConnectorConfig field's value.
func (s *Cluster) SetConnectorConfig(v *ConnectorConfigResponse) *Cluster {
	s.ConnectorConfig = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Cluster) SetCreatedAt(v time.Time) *Cluster {
	s.CreatedAt = &v
	return s
}

// SetEncryptionConfig sets the EncryptionConfig field's value.
func (s *Cluster) SetEncryptionConfig(v []*EncryptionConfig) *Cluster {
	s.EncryptionConfig = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *Cluster) SetEndpoint(v string) *Cluster {
	s.Endpoint = &v
	return s
}

// SetIdentity sets the Identity field's value.
func (s *Cluster) SetIdentity(v *Identity) *Cluster {
	s.Identity = v
	return s
}

// SetKubernetesNetworkConfig sets the KubernetesNetworkConfig field's value.
func (s *Cluster) SetKubernetesNetworkConfig(v *KubernetesNetworkConfigResponse) *Cluster {
	s.KubernetesNetworkConfig = v
	return s
}

// SetLogging sets the Logging field's value.
func (s *Cluster) SetLogging(v *Logging) *Cluster {
	s.Logging = v
	return s
}

// SetName sets the Name field's value.
func (s *Cluster) SetName(v string) *Cluster {
	s.Name = &v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *Cluster) SetPlatformVersion(v string) *Cluster {
	s.PlatformVersion = &v
	return s
}

// SetResourcesVpcConfig sets the ResourcesVpcConfig field's value.
func (s *Cluster) SetResourcesVpcConfig(v *VpcConfigResponse) *Cluster {
	s.ResourcesVpcConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Cluster) SetRoleArn(v string) *Cluster {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Cluster) SetStatus(v string) *Cluster {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Cluster) SetTags(v map[string]*string) *Cluster {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *Cluster) SetVersion(v string) *Cluster {
	s.Version = &v
	return s
}

// Compatibility information.
type Compatibility struct {
	_ struct{} `type:"structure"`

	// The supported Kubernetes version of the cluster.
	ClusterVersion *string `locationName:"clusterVersion" type:"string"`

	// The supported default version.
	DefaultVersion *bool `locationName:"defaultVersion" type:"boolean"`

	// The supported compute platform.
	PlatformVersions []*string `locationName:"platformVersions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Compatibility) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Compatibility) GoString() string {
	return s.String()
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *Compatibility) SetClusterVersion(v string) *Compatibility {
	s.ClusterVersion = &v
	return s
}

// SetDefaultVersion sets the DefaultVersion field's value.
func (s *Compatibility) SetDefaultVersion(v bool) *Compatibility {
	s.DefaultVersion = &v
	return s
}

// SetPlatformVersions sets the PlatformVersions field's value.
func (s *Compatibility) SetPlatformVersions(v []*string) *Compatibility {
	s.PlatformVersions = v
	return s
}

// The configuration sent to a cluster for configuration.
type ConnectorConfigRequest struct {
	_ struct{} `type:"structure"`

	// The cloud provider for the target cluster to connect.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" type:"string" required:"true" enum:"ConnectorConfigProvider"`

	// The Amazon Resource Name (ARN) of the role that is authorized to request
	// the connector configuration.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectorConfigRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectorConfigRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectorConfigRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConnectorConfigRequest"}
	if s.Provider == nil {
		invalidParams.Add(request.NewErrParamRequired("Provider"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProvider sets the Provider field's value.
func (s *ConnectorConfigRequest) SetProvider(v string) *ConnectorConfigRequest {
	s.Provider = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ConnectorConfigRequest) SetRoleArn(v string) *ConnectorConfigRequest {
	s.RoleArn = &v
	return s
}

// The full description of your connected cluster.
type ConnectorConfigResponse struct {
	_ struct{} `type:"structure"`

	// A unique code associated with the cluster for registration purposes.
	ActivationCode *string `locationName:"activationCode" type:"string"`

	// The expiration time of the connected cluster. The cluster's YAML file must
	// be applied through the native provider.
	ActivationExpiry *time.Time `locationName:"activationExpiry" type:"timestamp"`

	// A unique ID associated with the cluster for registration purposes.
	ActivationId *string `locationName:"activationId" type:"string"`

	// The cluster's cloud service provider.
	Provider *string `locationName:"provider" type:"string"`

	// The Amazon Resource Name (ARN) of the role that is used by the EKS connector
	// to communicate with AWS services from the connected Kubernetes cluster.
	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectorConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectorConfigResponse) GoString() string {
	return s.String()
}

// SetActivationCode sets the ActivationCode field's value.
func (s *ConnectorConfigResponse) SetActivationCode(v string) *ConnectorConfigResponse {
	s.ActivationCode = &v
	return s
}

// SetActivationExpiry sets the ActivationExpiry field's value.
func (s *ConnectorConfigResponse) SetActivationExpiry(v time.Time) *ConnectorConfigResponse {
	s.ActivationExpiry = &v
	return s
}

// SetActivationId sets the ActivationId field's value.
func (s *ConnectorConfigResponse) SetActivationId(v string) *ConnectorConfigResponse {
	s.ActivationId = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *ConnectorConfigResponse) SetProvider(v string) *ConnectorConfigResponse {
	s.Provider = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ConnectorConfigResponse) SetRoleArn(v string) *ConnectorConfigResponse {
	s.RoleArn = &v
	return s
}

type CreateAddonInput struct {
	_ struct{} `type:"structure"`

	// The name of the add-on. The name must match one of the names returned by
	// DescribeAddonVersions (https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html).
	//
	// AddonName is a required field
	AddonName *string `locationName:"addonName" type:"string" required:"true"`

	// The version of the add-on. The version must match one of the versions returned
	// by DescribeAddonVersions (https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html).
	AddonVersion *string `locationName:"addonVersion" type:"string"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the cluster to create the add-on for.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// How to resolve parameter value conflicts when migrating an existing add-on
	// to an Amazon EKS add-on.
	ResolveConflicts *string `locationName:"resolveConflicts" type:"string" enum:"ResolveConflicts"`

	// The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's
	// service account. The role must be assigned the IAM permissions required by
	// the add-on. If you don't specify an existing IAM role, then the add-on uses
	// the permissions assigned to the node IAM role. For more information, see
	// Amazon EKS node IAM role (https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
	// in the Amazon EKS User Guide.
	//
	// To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC)
	// provider created for your cluster. For more information, see Enabling IAM
	// roles for service accounts on your cluster (https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
	// in the Amazon EKS User Guide.
	ServiceAccountRoleArn *string `locationName:"serviceAccountRoleArn" min:"1" type:"string"`

	// The metadata to apply to the cluster to assist with categorization and organization.
	// Each tag consists of a key and an optional value, both of which you define.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddonInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddonInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAddonInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAddonInput"}
	if s.AddonName == nil {
		invalidParams.Add(request.NewErrParamRequired("AddonName"))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.ServiceAccountRoleArn != nil && len(*s.ServiceAccountRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceAccountRoleArn", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddonName sets the AddonName field's value.
func (s *CreateAddonInput) SetAddonName(v string) *CreateAddonInput {
	s.AddonName = &v
	return s
}

// SetAddonVersion sets the AddonVersion field's value.
func (s *CreateAddonInput) SetAddonVersion(v string) *CreateAddonInput {
	s.AddonVersion = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateAddonInput) SetClientRequestToken(v string) *CreateAddonInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateAddonInput) SetClusterName(v string) *CreateAddonInput {
	s.ClusterName = &v
	return s
}

// SetResolveConflicts sets the ResolveConflicts field's value.
func (s *CreateAddonInput) SetResolveConflicts(v string) *CreateAddonInput {
	s.ResolveConflicts = &v
	return s
}

// SetServiceAccountRoleArn sets the ServiceAccountRoleArn field's value.
func (s *CreateAddonInput) SetServiceAccountRoleArn(v string) *CreateAddonInput {
	s.ServiceAccountRoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAddonInput) SetTags(v map[string]*string) *CreateAddonInput {
	s.Tags = v
	return s
}

type CreateAddonOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon EKS add-on.
	Addon *Addon `locationName:"addon" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddonOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddonOutput) GoString() string {
	return s.String()
}

// SetAddon sets the Addon field's value.
func (s *CreateAddonOutput) SetAddon(v *Addon) *CreateAddonOutput {
	s.Addon = v
	return s
}

type CreateClusterInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The encryption configuration for the cluster.
	EncryptionConfig []*EncryptionConfig `locationName:"encryptionConfig" type:"list"`

	// The Kubernetes network configuration for the cluster.
	KubernetesNetworkConfig *KubernetesNetworkConfigRequest `locationName:"kubernetesNetworkConfig" type:"structure"`

	// Enable or disable exporting the Kubernetes control plane logs for your cluster
	// to CloudWatch Logs. By default, cluster control plane logs aren't exported
	// to CloudWatch Logs. For more information, see Amazon EKS Cluster control
	// plane logs (https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
	// in the Amazon EKS User Guide .
	//
	// CloudWatch Logs ingestion, archive storage, and data scanning rates apply
	// to exported control plane logs. For more information, see CloudWatch Pricing
	// (http://aws.amazon.com/cloudwatch/pricing/).
	Logging *Logging `locationName:"logging" type:"structure"`

	// The unique name to give to your cluster.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The VPC configuration used by the cluster control plane. Amazon EKS VPC resources
	// have specific requirements to work properly with Kubernetes. For more information,
	// see Cluster VPC Considerations (https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html)
	// and Cluster Security Group Considerations (https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html)
	// in the Amazon EKS User Guide. You must specify at least two subnets. You
	// can specify up to five security groups, but we recommend that you use a dedicated
	// security group for your cluster control plane.
	//
	// ResourcesVpcConfig is a required field
	ResourcesVpcConfig *VpcConfigRequest `locationName:"resourcesVpcConfig" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that provides permissions
	// for the Kubernetes control plane to make calls to Amazon Web Services API
	// operations on your behalf. For more information, see Amazon EKS Service IAM
	// Role (https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html)
	// in the Amazon EKS User Guide .
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The metadata to apply to the cluster to assist with categorization and organization.
	// Each tag consists of a key and an optional value, both of which you define.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The desired Kubernetes version for your cluster. If you don't specify a value
	// here, the latest version available in Amazon EKS is used.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ResourcesVpcConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourcesVpcConfig"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateClusterInput) SetClientRequestToken(v string) *CreateClusterInput {
	s.ClientRequestToken = &v
	return s
}

// SetEncryptionConfig sets the EncryptionConfig field's value.
func (s *CreateClusterInput) SetEncryptionConfig(v []*EncryptionConfig) *CreateClusterInput {
	s.EncryptionConfig = v
	return s
}

// SetKubernetesNetworkConfig sets the KubernetesNetworkConfig field's value.
func (s *CreateClusterInput) SetKubernetesNetworkConfig(v *KubernetesNetworkConfigRequest) *CreateClusterInput {
	s.KubernetesNetworkConfig = v
	return s
}

// SetLogging sets the Logging field's value.
func (s *CreateClusterInput) SetLogging(v *Logging) *CreateClusterInput {
	s.Logging = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateClusterInput) SetName(v string) *CreateClusterInput {
	s.Name = &v
	return s
}

// SetResourcesVpcConfig sets the ResourcesVpcConfig field's value.
func (s *CreateClusterInput) SetResourcesVpcConfig(v *VpcConfigRequest) *CreateClusterInput {
	s.ResourcesVpcConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateClusterInput) SetRoleArn(v string) *CreateClusterInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterInput) SetTags(v map[string]*string) *CreateClusterInput {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateClusterInput) SetVersion(v string) *CreateClusterInput {
	s.Version = &v
	return s
}

type CreateClusterOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your new cluster.
	Cluster *Cluster `locationName:"cluster" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *CreateClusterOutput) SetCluster(v *Cluster) *CreateClusterOutput {
	s.Cluster = v
	return s
}

type CreateFargateProfileInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the Amazon EKS cluster to apply the Fargate profile to.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the Fargate profile.
	//
	// FargateProfileName is a required field
	FargateProfileName *string `locationName:"fargateProfileName" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the pod execution role to use for pods
	// that match the selectors in the Fargate profile. The pod execution role allows
	// Fargate infrastructure to register with your cluster as a node, and it provides
	// read access to Amazon ECR image repositories. For more information, see Pod
	// Execution Role (https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html)
	// in the Amazon EKS User Guide.
	//
	// PodExecutionRoleArn is a required field
	PodExecutionRoleArn *string `locationName:"podExecutionRoleArn" type:"string" required:"true"`

	// The selectors to match for pods to use this Fargate profile. Each selector
	// must have an associated namespace. Optionally, you can also specify labels
	// for a namespace. You may specify up to five selectors in a Fargate profile.
	Selectors []*FargateProfileSelector `locationName:"selectors" type:"list"`

	// The IDs of subnets to launch your pods into. At this time, pods running on
	// Fargate are not assigned public IP addresses, so only private subnets (with
	// no direct route to an Internet Gateway) are accepted for this parameter.
	Subnets []*string `locationName:"subnets" type:"list"`

	// The metadata to apply to the Fargate profile to assist with categorization
	// and organization. Each tag consists of a key and an optional value, both
	// of which you define. Fargate profile tags do not propagate to any other resources
	// associated with the Fargate profile, such as the pods that are scheduled
	// with it.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFargateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFargateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFargateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFargateProfileInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.FargateProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("FargateProfileName"))
	}
	if s.PodExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PodExecutionRoleArn"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateFargateProfileInput) SetClientRequestToken(v string) *CreateFargateProfileInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateFargateProfileInput) SetClusterName(v string) *CreateFargateProfileInput {
	s.ClusterName = &v
	return s
}

// SetFargateProfileName sets the FargateProfileName field's value.
func (s *CreateFargateProfileInput) SetFargateProfileName(v string) *CreateFargateProfileInput {
	s.FargateProfileName = &v
	return s
}

// SetPodExecutionRoleArn sets the PodExecutionRoleArn field's value.
func (s *CreateFargateProfileInput) SetPodExecutionRoleArn(v string) *CreateFargateProfileInput {
	s.PodExecutionRoleArn = &v
	return s
}

// SetSelectors sets the Selectors field's value.
func (s *CreateFargateProfileInput) SetSelectors(v []*FargateProfileSelector) *CreateFargateProfileInput {
	s.Selectors = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *CreateFargateProfileInput) SetSubnets(v []*string) *CreateFargateProfileInput {
	s.Subnets = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFargateProfileInput) SetTags(v map[string]*string) *CreateFargateProfileInput {
	s.Tags = v
	return s
}

type CreateFargateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your new Fargate profile.
	FargateProfile *FargateProfile `locationName:"fargateProfile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFargateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFargateProfileOutput) GoString() string {
	return s.String()
}

// SetFargateProfile sets the FargateProfile field's value.
func (s *CreateFargateProfileOutput) SetFargateProfile(v *FargateProfile) *CreateFargateProfileOutput {
	s.FargateProfile = v
	return s
}

type CreateNodegroupInput struct {
	_ struct{} `type:"structure"`

	// The AMI type for your node group. GPU instance types should use the AL2_x86_64_GPU
	// AMI type. Non-GPU instances should use the AL2_x86_64 AMI type. Arm instances
	// should use the AL2_ARM_64 AMI type. All types use the Amazon EKS optimized
	// Amazon Linux 2 AMI. If you specify launchTemplate, and your launch template
	// uses a custom AMI, then don't specify amiType, or the node group deployment
	// will fail. For more information about using launch templates with Amazon
	// EKS, see Launch template support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	AmiType *string `locationName:"amiType" type:"string" enum:"AMITypes"`

	// The capacity type for your node group.
	CapacityType *string `locationName:"capacityType" type:"string" enum:"CapacityTypes"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the cluster to create the node group in.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The root device disk size (in GiB) for your node group instances. The default
	// disk size is 20 GiB. If you specify launchTemplate, then don't specify diskSize,
	// or the node group deployment will fail. For more information about using
	// launch templates with Amazon EKS, see Launch template support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	DiskSize *int64 `locationName:"diskSize" type:"integer"`

	// Specify the instance types for a node group. If you specify a GPU instance
	// type, be sure to specify AL2_x86_64_GPU with the amiType parameter. If you
	// specify launchTemplate, then you can specify zero or one instance type in
	// your launch template or you can specify 0-20 instance types for instanceTypes.
	// If however, you specify an instance type in your launch template and specify
	// any instanceTypes, the node group deployment will fail. If you don't specify
	// an instance type in a launch template or for instanceTypes, then t3.medium
	// is used, by default. If you specify Spot for capacityType, then we recommend
	// specifying multiple values for instanceTypes. For more information, see Managed
	// node group capacity types (https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html#managed-node-group-capacity-types)
	// and Launch template support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	InstanceTypes []*string `locationName:"instanceTypes" type:"list"`

	// The Kubernetes labels to be applied to the nodes in the node group when they
	// are created.
	Labels map[string]*string `locationName:"labels" type:"map"`

	// An object representing a node group's launch template specification. If specified,
	// then do not specify instanceTypes, diskSize, or remoteAccess and make sure
	// that the launch template meets the requirements in launchTemplateSpecification.
	LaunchTemplate *LaunchTemplateSpecification `locationName:"launchTemplate" type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role to associate with your node
	// group. The Amazon EKS worker node kubelet daemon makes calls to Amazon Web
	// Services APIs on your behalf. Nodes receive permissions for these API calls
	// through an IAM instance profile and associated policies. Before you can launch
	// nodes and register them into a cluster, you must create an IAM role for those
	// nodes to use when they are launched. For more information, see Amazon EKS
	// node IAM role (https://docs.aws.amazon.com/eks/latest/userguide/worker_node_IAM_role.html)
	// in the Amazon EKS User Guide . If you specify launchTemplate, then don't
	// specify IamInstanceProfile (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html)
	// in your launch template, or the node group deployment will fail. For more
	// information about using launch templates with Amazon EKS, see Launch template
	// support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	//
	// NodeRole is a required field
	NodeRole *string `locationName:"nodeRole" type:"string" required:"true"`

	// The unique name to give your node group.
	//
	// NodegroupName is a required field
	NodegroupName *string `locationName:"nodegroupName" type:"string" required:"true"`

	// The AMI version of the Amazon EKS optimized AMI to use with your node group.
	// By default, the latest available AMI version for the node group's current
	// Kubernetes version is used. For more information, see Amazon EKS optimized
	// Amazon Linux 2 AMI versions (https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html)
	// in the Amazon EKS User Guide. If you specify launchTemplate, and your launch
	// template uses a custom AMI, then don't specify releaseVersion, or the node
	// group deployment will fail. For more information about using launch templates
	// with Amazon EKS, see Launch template support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	ReleaseVersion *string `locationName:"releaseVersion" type:"string"`

	// The remote access (SSH) configuration to use with your node group. If you
	// specify launchTemplate, then don't specify remoteAccess, or the node group
	// deployment will fail. For more information about using launch templates with
	// Amazon EKS, see Launch template support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	RemoteAccess *RemoteAccessConfig `locationName:"remoteAccess" type:"structure"`

	// The scaling configuration details for the Auto Scaling group that is created
	// for your node group.
	ScalingConfig *NodegroupScalingConfig `locationName:"scalingConfig" type:"structure"`

	// The subnets to use for the Auto Scaling group that is created for your node
	// group. If you specify launchTemplate, then don't specify SubnetId (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html)
	// in your launch template, or the node group deployment will fail. For more
	// information about using launch templates with Amazon EKS, see Launch template
	// support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	//
	// Subnets is a required field
	Subnets []*string `locationName:"subnets" type:"list" required:"true"`

	// The metadata to apply to the node group to assist with categorization and
	// organization. Each tag consists of a key and an optional value, both of which
	// you define. Node group tags do not propagate to any other resources associated
	// with the node group, such as the Amazon EC2 instances or subnets.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The Kubernetes taints to be applied to the nodes in the node group.
	Taints []*Taint `locationName:"taints" type:"list"`

	// The node group update configuration.
	UpdateConfig *NodegroupUpdateConfig `locationName:"updateConfig" type:"structure"`

	// The Kubernetes version to use for your managed nodes. By default, the Kubernetes
	// version of the cluster is used, and this is the only accepted specified value.
	// If you specify launchTemplate, and your launch template uses a custom AMI,
	// then don't specify version, or the node group deployment will fail. For more
	// information about using launch templates with Amazon EKS, see Launch template
	// support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNodegroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNodegroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNodegroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNodegroupInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.NodeRole == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeRole"))
	}
	if s.NodegroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("NodegroupName"))
	}
	if s.Subnets == nil {
		invalidParams.Add(request.NewErrParamRequired("Subnets"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ScalingConfig != nil {
		if err := s.ScalingConfig.Validate(); err != nil {
			invalidParams.AddNested("ScalingConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Taints != nil {
		for i, v := range s.Taints {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Taints", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.UpdateConfig != nil {
		if err := s.UpdateConfig.Validate(); err != nil {
			invalidParams.AddNested("UpdateConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmiType sets the AmiType field's value.
func (s *CreateNodegroupInput) SetAmiType(v string) *CreateNodegroupInput {
	s.AmiType = &v
	return s
}

// SetCapacityType sets the CapacityType field's value.
func (s *CreateNodegroupInput) SetCapacityType(v string) *CreateNodegroupInput {
	s.CapacityType = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateNodegroupInput) SetClientRequestToken(v string) *CreateNodegroupInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateNodegroupInput) SetClusterName(v string) *CreateNodegroupInput {
	s.ClusterName = &v
	return s
}

// SetDiskSize sets the DiskSize field's value.
func (s *CreateNodegroupInput) SetDiskSize(v int64) *CreateNodegroupInput {
	s.DiskSize = &v
	return s
}

// SetInstanceTypes sets the InstanceTypes field's value.
func (s *CreateNodegroupInput) SetInstanceTypes(v []*string) *CreateNodegroupInput {
	s.InstanceTypes = v
	return s
}

// SetLabels sets the Labels field's value.
func (s *CreateNodegroupInput) SetLabels(v map[string]*string) *CreateNodegroupInput {
	s.Labels = v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *CreateNodegroupInput) SetLaunchTemplate(v *LaunchTemplateSpecification) *CreateNodegroupInput {
	s.LaunchTemplate = v
	return s
}

// SetNodeRole sets the NodeRole field's value.
func (s *CreateNodegroupInput) SetNodeRole(v string) *CreateNodegroupInput {
	s.NodeRole = &v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *CreateNodegroupInput) SetNodegroupName(v string) *CreateNodegroupInput {
	s.NodegroupName = &v
	return s
}

// SetReleaseVersion sets the ReleaseVersion field's value.
func (s *CreateNodegroupInput) SetReleaseVersion(v string) *CreateNodegroupInput {
	s.ReleaseVersion = &v
	return s
}

// SetRemoteAccess sets the RemoteAccess field's value.
func (s *CreateNodegroupInput) SetRemoteAccess(v *RemoteAccessConfig) *CreateNodegroupInput {
	s.RemoteAccess = v
	return s
}

// SetScalingConfig sets the ScalingConfig field's value.
func (s *CreateNodegroupInput) SetScalingConfig(v *NodegroupScalingConfig) *CreateNodegroupInput {
	s.ScalingConfig = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *CreateNodegroupInput) SetSubnets(v []*string) *CreateNodegroupInput {
	s.Subnets = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNodegroupInput) SetTags(v map[string]*string) *CreateNodegroupInput {
	s.Tags = v
	return s
}

// SetTaints sets the Taints field's value.
func (s *CreateNodegroupInput) SetTaints(v []*Taint) *CreateNodegroupInput {
	s.Taints = v
	return s
}

// SetUpdateConfig sets the UpdateConfig field's value.
func (s *CreateNodegroupInput) SetUpdateConfig(v *NodegroupUpdateConfig) *CreateNodegroupInput {
	s.UpdateConfig = v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateNodegroupInput) SetVersion(v string) *CreateNodegroupInput {
	s.Version = &v
	return s
}

type CreateNodegroupOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your new node group.
	Nodegroup *Nodegroup `locationName:"nodegroup" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNodegroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNodegroupOutput) GoString() string {
	return s.String()
}

// SetNodegroup sets the Nodegroup field's value.
func (s *CreateNodegroupOutput) SetNodegroup(v *Nodegroup) *CreateNodegroupOutput {
	s.Nodegroup = v
	return s
}

type DeleteAddonInput struct {
	_ struct{} `type:"structure"`

	// The name of the add-on. The name must match one of the names returned by
	// ListAddons (https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html).
	//
	// AddonName is a required field
	AddonName *string `location:"uri" locationName:"addonName" type:"string" required:"true"`

	// The name of the cluster to delete the add-on from.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// Specifying this option preserves the add-on software on your cluster but
	// Amazon EKS stops managing any settings for the add-on. If an IAM account
	// is associated with the add-on, it is not removed.
	Preserve *bool `location:"querystring" locationName:"preserve" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAddonInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAddonInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAddonInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAddonInput"}
	if s.AddonName == nil {
		invalidParams.Add(request.NewErrParamRequired("AddonName"))
	}
	if s.AddonName != nil && len(*s.AddonName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AddonName", 1))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddonName sets the AddonName field's value.
func (s *DeleteAddonInput) SetAddonName(v string) *DeleteAddonInput {
	s.AddonName = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *DeleteAddonInput) SetClusterName(v string) *DeleteAddonInput {
	s.ClusterName = &v
	return s
}

// SetPreserve sets the Preserve field's value.
func (s *DeleteAddonInput) SetPreserve(v bool) *DeleteAddonInput {
	s.Preserve = &v
	return s
}

type DeleteAddonOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon EKS add-on.
	Addon *Addon `locationName:"addon" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAddonOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAddonOutput) GoString() string {
	return s.String()
}

// SetAddon sets the Addon field's value.
func (s *DeleteAddonOutput) SetAddon(v *Addon) *DeleteAddonOutput {
	s.Addon = v
	return s
}

type DeleteClusterInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster to delete.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteClusterInput) SetName(v string) *DeleteClusterInput {
	s.Name = &v
	return s
}

type DeleteClusterOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the cluster to delete.
	Cluster *Cluster `locationName:"cluster" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *DeleteClusterOutput) SetCluster(v *Cluster) *DeleteClusterOutput {
	s.Cluster = v
	return s
}

type DeleteFargateProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EKS cluster associated with the Fargate profile to
	// delete.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the Fargate profile to delete.
	//
	// FargateProfileName is a required field
	FargateProfileName *string `location:"uri" locationName:"fargateProfileName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFargateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFargateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFargateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFargateProfileInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.FargateProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("FargateProfileName"))
	}
	if s.FargateProfileName != nil && len(*s.FargateProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FargateProfileName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *DeleteFargateProfileInput) SetClusterName(v string) *DeleteFargateProfileInput {
	s.ClusterName = &v
	return s
}

// SetFargateProfileName sets the FargateProfileName field's value.
func (s *DeleteFargateProfileInput) SetFargateProfileName(v string) *DeleteFargateProfileInput {
	s.FargateProfileName = &v
	return s
}

type DeleteFargateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The deleted Fargate profile.
	FargateProfile *FargateProfile `locationName:"fargateProfile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFargateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFargateProfileOutput) GoString() string {
	return s.String()
}

// SetFargateProfile sets the FargateProfile field's value.
func (s *DeleteFargateProfileOutput) SetFargateProfile(v *FargateProfile) *DeleteFargateProfileOutput {
	s.FargateProfile = v
	return s
}

type DeleteNodegroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EKS cluster that is associated with your node group.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the node group to delete.
	//
	// NodegroupName is a required field
	NodegroupName *string `location:"uri" locationName:"nodegroupName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNodegroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNodegroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNodegroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNodegroupInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.NodegroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("NodegroupName"))
	}
	if s.NodegroupName != nil && len(*s.NodegroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodegroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *DeleteNodegroupInput) SetClusterName(v string) *DeleteNodegroupInput {
	s.ClusterName = &v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *DeleteNodegroupInput) SetNodegroupName(v string) *DeleteNodegroupInput {
	s.NodegroupName = &v
	return s
}

type DeleteNodegroupOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your deleted node group.
	Nodegroup *Nodegroup `locationName:"nodegroup" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNodegroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNodegroupOutput) GoString() string {
	return s.String()
}

// SetNodegroup sets the Nodegroup field's value.
func (s *DeleteNodegroupOutput) SetNodegroup(v *Nodegroup) *DeleteNodegroupOutput {
	s.Nodegroup = v
	return s
}

type DeregisterClusterInput struct {
	_ struct{} `type:"structure"`

	// The name of the connected cluster to deregister.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterClusterInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeregisterClusterInput) SetName(v string) *DeregisterClusterInput {
	s.Name = &v
	return s
}

type DeregisterClusterOutput struct {
	_ struct{} `type:"structure"`

	// An object representing an Amazon EKS cluster.
	Cluster *Cluster `locationName:"cluster" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *DeregisterClusterOutput) SetCluster(v *Cluster) *DeregisterClusterOutput {
	s.Cluster = v
	return s
}

type DescribeAddonInput struct {
	_ struct{} `type:"structure"`

	// The name of the add-on. The name must match one of the names returned by
	// ListAddons (https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html).
	//
	// AddonName is a required field
	AddonName *string `location:"uri" locationName:"addonName" type:"string" required:"true"`

	// The name of the cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddonInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddonInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAddonInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAddonInput"}
	if s.AddonName == nil {
		invalidParams.Add(request.NewErrParamRequired("AddonName"))
	}
	if s.AddonName != nil && len(*s.AddonName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AddonName", 1))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddonName sets the AddonName field's value.
func (s *DescribeAddonInput) SetAddonName(v string) *DescribeAddonInput {
	s.AddonName = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *DescribeAddonInput) SetClusterName(v string) *DescribeAddonInput {
	s.ClusterName = &v
	return s
}

type DescribeAddonOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon EKS add-on.
	Addon *Addon `locationName:"addon" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddonOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddonOutput) GoString() string {
	return s.String()
}

// SetAddon sets the Addon field's value.
func (s *DescribeAddonOutput) SetAddon(v *Addon) *DescribeAddonOutput {
	s.Addon = v
	return s
}

type DescribeAddonVersionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the add-on. The name must match one of the names returned by
	// ListAddons (https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html).
	AddonName *string `location:"querystring" locationName:"addonName" type:"string"`

	// The Kubernetes versions that the add-on can be used with.
	KubernetesVersion *string `location:"querystring" locationName:"kubernetesVersion" type:"string"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated DescribeAddonVersionsRequest
	// where maxResults was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddonVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddonVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAddonVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAddonVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddonName sets the AddonName field's value.
func (s *DescribeAddonVersionsInput) SetAddonName(v string) *DescribeAddonVersionsInput {
	s.AddonName = &v
	return s
}

// SetKubernetesVersion sets the KubernetesVersion field's value.
func (s *DescribeAddonVersionsInput) SetKubernetesVersion(v string) *DescribeAddonVersionsInput {
	s.KubernetesVersion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeAddonVersionsInput) SetMaxResults(v int64) *DescribeAddonVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAddonVersionsInput) SetNextToken(v string) *DescribeAddonVersionsInput {
	s.NextToken = &v
	return s
}

type DescribeAddonVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The list of available versions with Kubernetes version compatibility.
	Addons []*AddonInfo `locationName:"addons" type:"list"`

	// The nextToken value returned from a previous paginated DescribeAddonVersionsResponse
	// where maxResults was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddonVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddonVersionsOutput) GoString() string {
	return s.String()
}

// SetAddons sets the Addons field's value.
func (s *DescribeAddonVersionsOutput) SetAddons(v []*AddonInfo) *DescribeAddonVersionsOutput {
	s.Addons = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAddonVersionsOutput) SetNextToken(v string) *DescribeAddonVersionsOutput {
	s.NextToken = &v
	return s
}

type DescribeClusterInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster to describe.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClusterInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeClusterInput) SetName(v string) *DescribeClusterInput {
	s.Name = &v
	return s
}

type DescribeClusterOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your specified cluster.
	Cluster *Cluster `locationName:"cluster" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *DescribeClusterOutput) SetCluster(v *Cluster) *DescribeClusterOutput {
	s.Cluster = v
	return s
}

type DescribeFargateProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EKS cluster associated with the Fargate profile.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the Fargate profile to describe.
	//
	// FargateProfileName is a required field
	FargateProfileName *string `location:"uri" locationName:"fargateProfileName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFargateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFargateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFargateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFargateProfileInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.FargateProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("FargateProfileName"))
	}
	if s.FargateProfileName != nil && len(*s.FargateProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FargateProfileName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *DescribeFargateProfileInput) SetClusterName(v string) *DescribeFargateProfileInput {
	s.ClusterName = &v
	return s
}

// SetFargateProfileName sets the FargateProfileName field's value.
func (s *DescribeFargateProfileInput) SetFargateProfileName(v string) *DescribeFargateProfileInput {
	s.FargateProfileName = &v
	return s
}

type DescribeFargateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your Fargate profile.
	FargateProfile *FargateProfile `locationName:"fargateProfile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFargateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFargateProfileOutput) GoString() string {
	return s.String()
}

// SetFargateProfile sets the FargateProfile field's value.
func (s *DescribeFargateProfileOutput) SetFargateProfile(v *FargateProfile) *DescribeFargateProfileOutput {
	s.FargateProfile = v
	return s
}

type DescribeIdentityProviderConfigInput struct {
	_ struct{} `type:"structure"`

	// The cluster name that the identity provider configuration is associated to.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// An object that represents an identity provider configuration.
	//
	// IdentityProviderConfig is a required field
	IdentityProviderConfig *IdentityProviderConfig `locationName:"identityProviderConfig" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIdentityProviderConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIdentityProviderConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIdentityProviderConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIdentityProviderConfigInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.IdentityProviderConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProviderConfig"))
	}
	if s.IdentityProviderConfig != nil {
		if err := s.IdentityProviderConfig.Validate(); err != nil {
			invalidParams.AddNested("IdentityProviderConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *DescribeIdentityProviderConfigInput) SetClusterName(v string) *DescribeIdentityProviderConfigInput {
	s.ClusterName = &v
	return s
}

// SetIdentityProviderConfig sets the IdentityProviderConfig field's value.
func (s *DescribeIdentityProviderConfigInput) SetIdentityProviderConfig(v *IdentityProviderConfig) *DescribeIdentityProviderConfigInput {
	s.IdentityProviderConfig = v
	return s
}

type DescribeIdentityProviderConfigOutput struct {
	_ struct{} `type:"structure"`

	// The object that represents an OpenID Connect (OIDC) identity provider configuration.
	IdentityProviderConfig *IdentityProviderConfigResponse `locationName:"identityProviderConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIdentityProviderConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIdentityProviderConfigOutput) GoString() string {
	return s.String()
}

// SetIdentityProviderConfig sets the IdentityProviderConfig field's value.
func (s *DescribeIdentityProviderConfigOutput) SetIdentityProviderConfig(v *IdentityProviderConfigResponse) *DescribeIdentityProviderConfigOutput {
	s.IdentityProviderConfig = v
	return s
}

type DescribeNodegroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EKS cluster associated with the node group.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the node group to describe.
	//
	// NodegroupName is a required field
	NodegroupName *string `location:"uri" locationName:"nodegroupName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNodegroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNodegroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNodegroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeNodegroupInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.NodegroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("NodegroupName"))
	}
	if s.NodegroupName != nil && len(*s.NodegroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodegroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *DescribeNodegroupInput) SetClusterName(v string) *DescribeNodegroupInput {
	s.ClusterName = &v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *DescribeNodegroupInput) SetNodegroupName(v string) *DescribeNodegroupInput {
	s.NodegroupName = &v
	return s
}

type DescribeNodegroupOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your node group.
	Nodegroup *Nodegroup `locationName:"nodegroup" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNodegroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNodegroupOutput) GoString() string {
	return s.String()
}

// SetNodegroup sets the Nodegroup field's value.
func (s *DescribeNodegroupOutput) SetNodegroup(v *Nodegroup) *DescribeNodegroupOutput {
	s.Nodegroup = v
	return s
}

type DescribeUpdateInput struct {
	_ struct{} `type:"structure"`

	// The name of the add-on. The name must match one of the names returned by
	// ListAddons (https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html).
	AddonName *string `location:"querystring" locationName:"addonName" type:"string"`

	// The name of the Amazon EKS cluster associated with the update.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the Amazon EKS node group associated with the update.
	NodegroupName *string `location:"querystring" locationName:"nodegroupName" type:"string"`

	// The ID of the update to describe.
	//
	// UpdateId is a required field
	UpdateId *string `location:"uri" locationName:"updateId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUpdateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUpdateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUpdateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUpdateInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.UpdateId == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateId"))
	}
	if s.UpdateId != nil && len(*s.UpdateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddonName sets the AddonName field's value.
func (s *DescribeUpdateInput) SetAddonName(v string) *DescribeUpdateInput {
	s.AddonName = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeUpdateInput) SetName(v string) *DescribeUpdateInput {
	s.Name = &v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *DescribeUpdateInput) SetNodegroupName(v string) *DescribeUpdateInput {
	s.NodegroupName = &v
	return s
}

// SetUpdateId sets the UpdateId field's value.
func (s *DescribeUpdateInput) SetUpdateId(v string) *DescribeUpdateInput {
	s.UpdateId = &v
	return s
}

type DescribeUpdateOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the specified update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUpdateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUpdateOutput) GoString() string {
	return s.String()
}

// SetUpdate sets the Update field's value.
func (s *DescribeUpdateOutput) SetUpdate(v *Update) *DescribeUpdateOutput {
	s.Update = v
	return s
}

type DisassociateIdentityProviderConfigInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the cluster to disassociate an identity provider from.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// An object that represents an identity provider configuration.
	//
	// IdentityProviderConfig is a required field
	IdentityProviderConfig *IdentityProviderConfig `locationName:"identityProviderConfig" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateIdentityProviderConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateIdentityProviderConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateIdentityProviderConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateIdentityProviderConfigInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.IdentityProviderConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProviderConfig"))
	}
	if s.IdentityProviderConfig != nil {
		if err := s.IdentityProviderConfig.Validate(); err != nil {
			invalidParams.AddNested("IdentityProviderConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DisassociateIdentityProviderConfigInput) SetClientRequestToken(v string) *DisassociateIdentityProviderConfigInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *DisassociateIdentityProviderConfigInput) SetClusterName(v string) *DisassociateIdentityProviderConfigInput {
	s.ClusterName = &v
	return s
}

// SetIdentityProviderConfig sets the IdentityProviderConfig field's value.
func (s *DisassociateIdentityProviderConfigInput) SetIdentityProviderConfig(v *IdentityProviderConfig) *DisassociateIdentityProviderConfigInput {
	s.IdentityProviderConfig = v
	return s
}

type DisassociateIdentityProviderConfigOutput struct {
	_ struct{} `type:"structure"`

	// An object representing an asynchronous update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateIdentityProviderConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateIdentityProviderConfigOutput) GoString() string {
	return s.String()
}

// SetUpdate sets the Update field's value.
func (s *DisassociateIdentityProviderConfigOutput) SetUpdate(v *Update) *DisassociateIdentityProviderConfigOutput {
	s.Update = v
	return s
}

// The encryption configuration for the cluster.
type EncryptionConfig struct {
	_ struct{} `type:"structure"`

	// Key Management Service (KMS) key. Either the ARN or the alias can be used.
	Provider *Provider `locationName:"provider" type:"structure"`

	// Specifies the resources to be encrypted. The only supported value is "secrets".
	Resources []*string `locationName:"resources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionConfig) GoString() string {
	return s.String()
}

// SetProvider sets the Provider field's value.
func (s *EncryptionConfig) SetProvider(v *Provider) *EncryptionConfig {
	s.Provider = v
	return s
}

// SetResources sets the Resources field's value.
func (s *EncryptionConfig) SetResources(v []*string) *EncryptionConfig {
	s.Resources = v
	return s
}

// An object representing an error when an asynchronous operation fails.
type ErrorDetail struct {
	_ struct{} `type:"structure"`

	// A brief description of the error.
	//
	//    * SubnetNotFound: We couldn't find one of the subnets associated with
	//    the cluster.
	//
	//    * SecurityGroupNotFound: We couldn't find one of the security groups associated
	//    with the cluster.
	//
	//    * EniLimitReached: You have reached the elastic network interface limit
	//    for your account.
	//
	//    * IpNotAvailable: A subnet associated with the cluster doesn't have any
	//    free IP addresses.
	//
	//    * AccessDenied: You don't have permissions to perform the specified operation.
	//
	//    * OperationNotPermitted: The service role associated with the cluster
	//    doesn't have the required access permissions for Amazon EKS.
	//
	//    * VpcIdNotFound: We couldn't find the VPC associated with the cluster.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"ErrorCode"`

	// A more complete description of the error.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// An optional field that contains the resource IDs associated with the error.
	ResourceIds []*string `locationName:"resourceIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetail) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ErrorDetail) SetErrorCode(v string) *ErrorDetail {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ErrorDetail) SetErrorMessage(v string) *ErrorDetail {
	s.ErrorMessage = &v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *ErrorDetail) SetResourceIds(v []*string) *ErrorDetail {
	s.ResourceIds = v
	return s
}

// An object representing an Fargate profile.
type FargateProfile struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EKS cluster that the Fargate profile belongs to.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The Unix epoch timestamp in seconds for when the Fargate profile was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The full Amazon Resource Name (ARN) of the Fargate profile.
	FargateProfileArn *string `locationName:"fargateProfileArn" type:"string"`

	// The name of the Fargate profile.
	FargateProfileName *string `locationName:"fargateProfileName" type:"string"`

	// The Amazon Resource Name (ARN) of the pod execution role to use for pods
	// that match the selectors in the Fargate profile. For more information, see
	// Pod Execution Role (https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html)
	// in the Amazon EKS User Guide.
	PodExecutionRoleArn *string `locationName:"podExecutionRoleArn" type:"string"`

	// The selectors to match for pods to use this Fargate profile.
	Selectors []*FargateProfileSelector `locationName:"selectors" type:"list"`

	// The current status of the Fargate profile.
	Status *string `locationName:"status" type:"string" enum:"FargateProfileStatus"`

	// The IDs of subnets to launch pods into.
	Subnets []*string `locationName:"subnets" type:"list"`

	// The metadata applied to the Fargate profile to assist with categorization
	// and organization. Each tag consists of a key and an optional value, both
	// of which you define. Fargate profile tags do not propagate to any other resources
	// associated with the Fargate profile, such as the pods that are scheduled
	// with it.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FargateProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FargateProfile) GoString() string {
	return s.String()
}

// SetClusterName sets the ClusterName field's value.
func (s *FargateProfile) SetClusterName(v string) *FargateProfile {
	s.ClusterName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *FargateProfile) SetCreatedAt(v time.Time) *FargateProfile {
	s.CreatedAt = &v
	return s
}

// SetFargateProfileArn sets the FargateProfileArn field's value.
func (s *FargateProfile) SetFargateProfileArn(v string) *FargateProfile {
	s.FargateProfileArn = &v
	return s
}

// SetFargateProfileName sets the FargateProfileName field's value.
func (s *FargateProfile) SetFargateProfileName(v string) *FargateProfile {
	s.FargateProfileName = &v
	return s
}

// SetPodExecutionRoleArn sets the PodExecutionRoleArn field's value.
func (s *FargateProfile) SetPodExecutionRoleArn(v string) *FargateProfile {
	s.PodExecutionRoleArn = &v
	return s
}

// SetSelectors sets the Selectors field's value.
func (s *FargateProfile) SetSelectors(v []*FargateProfileSelector) *FargateProfile {
	s.Selectors = v
	return s
}

// SetStatus sets the Status field's value.
func (s *FargateProfile) SetStatus(v string) *FargateProfile {
	s.Status = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *FargateProfile) SetSubnets(v []*string) *FargateProfile {
	s.Subnets = v
	return s
}

// SetTags sets the Tags field's value.
func (s *FargateProfile) SetTags(v map[string]*string) *FargateProfile {
	s.Tags = v
	return s
}

// An object representing an Fargate profile selector.
type FargateProfileSelector struct {
	_ struct{} `type:"structure"`

	// The Kubernetes labels that the selector should match. A pod must contain
	// all of the labels that are specified in the selector for it to be considered
	// a match.
	Labels map[string]*string `locationName:"labels" type:"map"`

	// The Kubernetes namespace that the selector should match.
	Namespace *string `locationName:"namespace" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FargateProfileSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FargateProfileSelector) GoString() string {
	return s.String()
}

// SetLabels sets the Labels field's value.
func (s *FargateProfileSelector) SetLabels(v map[string]*string) *FargateProfileSelector {
	s.Labels = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *FargateProfileSelector) SetNamespace(v string) *FargateProfileSelector {
	s.Namespace = &v
	return s
}

// An object representing an identity provider.
type Identity struct {
	_ struct{} `type:"structure"`

	// An object representing the OpenID Connect (https://openid.net/connect/) identity
	// provider information.
	Oidc *OIDC `locationName:"oidc" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Identity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Identity) GoString() string {
	return s.String()
}

// SetOidc sets the Oidc field's value.
func (s *Identity) SetOidc(v *OIDC) *Identity {
	s.Oidc = v
	return s
}

// An object representing an identity provider configuration.
type IdentityProviderConfig struct {
	_ struct{} `type:"structure"`

	// The name of the identity provider configuration.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The type of the identity provider configuration.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProviderConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProviderConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IdentityProviderConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IdentityProviderConfig"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *IdentityProviderConfig) SetName(v string) *IdentityProviderConfig {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *IdentityProviderConfig) SetType(v string) *IdentityProviderConfig {
	s.Type = &v
	return s
}

// The full description of your identity configuration.
type IdentityProviderConfigResponse struct {
	_ struct{} `type:"structure"`

	// An object that represents an OpenID Connect (OIDC) identity provider configuration.
	Oidc *OidcIdentityProviderConfig `locationName:"oidc" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProviderConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProviderConfigResponse) GoString() string {
	return s.String()
}

// SetOidc sets the Oidc field's value.
func (s *IdentityProviderConfigResponse) SetOidc(v *OidcIdentityProviderConfig) *IdentityProviderConfigResponse {
	s.Oidc = v
	return s
}

// The specified parameter is invalid. Review the available parameters for the
// API request.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	AddonName *string `locationName:"addonName" type:"string"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The Fargate profile associated with the exception.
	FargateProfileName *string `locationName:"fargateProfileName" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request is invalid given the state of the cluster. Check the state of
// the cluster and the associated operations.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	AddonName *string `locationName:"addonName" type:"string"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object representing an issue with an Amazon EKS resource.
type Issue struct {
	_ struct{} `type:"structure"`

	// A brief description of the error.
	//
	//    * AccessDenied: Amazon EKS or one or more of your managed nodes is failing
	//    to authenticate or authorize with your Kubernetes cluster API server.
	//
	//    * AsgInstanceLaunchFailures: Your Auto Scaling group is experiencing failures
	//    while attempting to launch instances.
	//
	//    * AutoScalingGroupNotFound: We couldn't find the Auto Scaling group associated
	//    with the managed node group. You may be able to recreate an Auto Scaling
	//    group with the same settings to recover.
	//
	//    * ClusterUnreachable: Amazon EKS or one or more of your managed nodes
	//    is unable to to communicate with your Kubernetes cluster API server. This
	//    can happen if there are network disruptions or if API servers are timing
	//    out processing requests.
	//
	//    * Ec2LaunchTemplateNotFound: We couldn't find the Amazon EC2 launch template
	//    for your managed node group. You may be able to recreate a launch template
	//    with the same settings to recover.
	//
	//    * Ec2LaunchTemplateVersionMismatch: The Amazon EC2 launch template version
	//    for your managed node group does not match the version that Amazon EKS
	//    created. You may be able to revert to the version that Amazon EKS created
	//    to recover.
	//
	//    * Ec2SecurityGroupDeletionFailure: We could not delete the remote access
	//    security group for your managed node group. Remove any dependencies from
	//    the security group.
	//
	//    * Ec2SecurityGroupNotFound: We couldn't find the cluster security group
	//    for the cluster. You must recreate your cluster.
	//
	//    * Ec2SubnetInvalidConfiguration: One or more Amazon EC2 subnets specified
	//    for a node group do not automatically assign public IP addresses to instances
	//    launched into it. If you want your instances to be assigned a public IP
	//    address, then you need to enable the auto-assign public IP address setting
	//    for the subnet. See Modifying the public IPv4 addressing attribute for
	//    your subnet (https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html#subnet-public-ip)
	//    in the Amazon VPC User Guide.
	//
	//    * IamInstanceProfileNotFound: We couldn't find the IAM instance profile
	//    for your managed node group. You may be able to recreate an instance profile
	//    with the same settings to recover.
	//
	//    * IamNodeRoleNotFound: We couldn't find the IAM role for your managed
	//    node group. You may be able to recreate an IAM role with the same settings
	//    to recover.
	//
	//    * InstanceLimitExceeded: Your Amazon Web Services account is unable to
	//    launch any more instances of the specified instance type. You may be able
	//    to request an Amazon EC2 instance limit increase to recover.
	//
	//    * InsufficientFreeAddresses: One or more of the subnets associated with
	//    your managed node group does not have enough available IP addresses for
	//    new nodes.
	//
	//    * InternalFailure: These errors are usually caused by an Amazon EKS server-side
	//    issue.
	//
	//    * NodeCreationFailure: Your launched instances are unable to register
	//    with your Amazon EKS cluster. Common causes of this failure are insufficient
	//    node IAM role (https://docs.aws.amazon.com/eks/latest/userguide/worker_node_IAM_role.html)
	//    permissions or lack of outbound internet access for the nodes.
	Code *string `locationName:"code" type:"string" enum:"NodegroupIssueCode"`

	// The error message associated with the issue.
	Message *string `locationName:"message" type:"string"`

	// The Amazon Web Services resources that are afflicted by this issue.
	ResourceIds []*string `locationName:"resourceIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Issue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Issue) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *Issue) SetCode(v string) *Issue {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *Issue) SetMessage(v string) *Issue {
	s.Message = &v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *Issue) SetResourceIds(v []*string) *Issue {
	s.ResourceIds = v
	return s
}

// The Kubernetes network configuration for the cluster.
type KubernetesNetworkConfigRequest struct {
	_ struct{} `type:"structure"`

	// The CIDR block to assign Kubernetes service IP addresses from. If you don't
	// specify a block, Kubernetes assigns addresses from either the 10.100.0.0/16
	// or 172.20.0.0/16 CIDR blocks. We recommend that you specify a block that
	// does not overlap with resources in other networks that are peered or connected
	// to your VPC. The block must meet the following requirements:
	//
	//    * Within one of the following private IP address blocks: 10.0.0.0/8, 172.16.0.0.0/12,
	//    or 192.168.0.0/16.
	//
	//    * Doesn't overlap with any CIDR block assigned to the VPC that you selected
	//    for VPC.
	//
	//    * Between /24 and /12.
	//
	// You can only specify a custom CIDR block when you create a cluster and can't
	// change this value once the cluster is created.
	ServiceIpv4Cidr *string `locationName:"serviceIpv4Cidr" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KubernetesNetworkConfigRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KubernetesNetworkConfigRequest) GoString() string {
	return s.String()
}

// SetServiceIpv4Cidr sets the ServiceIpv4Cidr field's value.
func (s *KubernetesNetworkConfigRequest) SetServiceIpv4Cidr(v string) *KubernetesNetworkConfigRequest {
	s.ServiceIpv4Cidr = &v
	return s
}

// The Kubernetes network configuration for the cluster.
type KubernetesNetworkConfigResponse struct {
	_ struct{} `type:"structure"`

	// The CIDR block that Kubernetes service IP addresses are assigned from. If
	// you didn't specify a CIDR block when you created the cluster, then Kubernetes
	// assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR blocks.
	// If this was specified, then it was specified when the cluster was created
	// and it cannot be changed.
	ServiceIpv4Cidr *string `locationName:"serviceIpv4Cidr" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KubernetesNetworkConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KubernetesNetworkConfigResponse) GoString() string {
	return s.String()
}

// SetServiceIpv4Cidr sets the ServiceIpv4Cidr field's value.
func (s *KubernetesNetworkConfigResponse) SetServiceIpv4Cidr(v string) *KubernetesNetworkConfigResponse {
	s.ServiceIpv4Cidr = &v
	return s
}

// An object representing a node group launch template specification. The launch
// template cannot include SubnetId (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html),
// IamInstanceProfile (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html),
// RequestSpotInstances (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html),
// HibernationOptions (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_HibernationOptionsRequest.html),
// or TerminateInstances (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TerminateInstances.html),
// or the node group deployment or update will fail. For more information about
// launch templates, see CreateLaunchTemplate (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html)
// in the Amazon EC2 API Reference. For more information about using launch
// templates with Amazon EKS, see Launch template support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
// in the Amazon EKS User Guide.
//
// Specify either name or id, but not both.
type LaunchTemplateSpecification struct {
	_ struct{} `type:"structure"`

	// The ID of the launch template.
	Id *string `locationName:"id" type:"string"`

	// The name of the launch template.
	Name *string `locationName:"name" type:"string"`

	// The version of the launch template to use. If no version is specified, then
	// the template's default version is used.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchTemplateSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchTemplateSpecification) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *LaunchTemplateSpecification) SetId(v string) *LaunchTemplateSpecification {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *LaunchTemplateSpecification) SetName(v string) *LaunchTemplateSpecification {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *LaunchTemplateSpecification) SetVersion(v string) *LaunchTemplateSpecification {
	s.Version = &v
	return s
}

type ListAddonsInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The maximum number of add-on results returned by ListAddonsRequest in paginated
	// output. When you use this parameter, ListAddonsRequest returns only maxResults
	// results in a single page along with a nextToken response element. You can
	// see the remaining results of the initial request by sending another ListAddonsRequest
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If you don't use this parameter, ListAddonsRequest returns up to 100
	// results and a nextToken value, if applicable.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated ListAddonsRequest
	// where maxResults was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAddonsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAddonsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAddonsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAddonsInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *ListAddonsInput) SetClusterName(v string) *ListAddonsInput {
	s.ClusterName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAddonsInput) SetMaxResults(v int64) *ListAddonsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAddonsInput) SetNextToken(v string) *ListAddonsInput {
	s.NextToken = &v
	return s
}

type ListAddonsOutput struct {
	_ struct{} `type:"structure"`

	// A list of available add-ons.
	Addons []*string `locationName:"addons" type:"list"`

	// The nextToken value returned from a previous paginated ListAddonsResponse
	// where maxResults was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAddonsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAddonsOutput) GoString() string {
	return s.String()
}

// SetAddons sets the Addons field's value.
func (s *ListAddonsOutput) SetAddons(v []*string) *ListAddonsOutput {
	s.Addons = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAddonsOutput) SetNextToken(v string) *ListAddonsOutput {
	s.NextToken = &v
	return s
}

type ListClustersInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether connected clusters are included in the returned list. Default
	// value is 'ALL'.
	Include []*string `location:"querystring" locationName:"include" type:"list"`

	// The maximum number of cluster results returned by ListClusters in paginated
	// output. When you use this parameter, ListClusters returns only maxResults
	// results in a single page along with a nextToken response element. You can
	// see the remaining results of the initial request by sending another ListClusters
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If you don't use this parameter, ListClusters returns up to 100 results
	// and a nextToken value if applicable.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated ListClusters request
	// where maxResults was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClustersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListClustersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInclude sets the Include field's value.
func (s *ListClustersInput) SetInclude(v []*string) *ListClustersInput {
	s.Include = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListClustersInput) SetMaxResults(v int64) *ListClustersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersInput) SetNextToken(v string) *ListClustersInput {
	s.NextToken = &v
	return s
}

type ListClustersOutput struct {
	_ struct{} `type:"structure"`

	// A list of all of the clusters for your account in the specified Region.
	Clusters []*string `locationName:"clusters" type:"list"`

	// The nextToken value to include in a future ListClusters request. When the
	// results of a ListClusters request exceed maxResults, you can use this value
	// to retrieve the next page of results. This value is null when there are no
	// more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersOutput) GoString() string {
	return s.String()
}

// SetClusters sets the Clusters field's value.
func (s *ListClustersOutput) SetClusters(v []*string) *ListClustersOutput {
	s.Clusters = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersOutput) SetNextToken(v string) *ListClustersOutput {
	s.NextToken = &v
	return s
}

type ListFargateProfilesInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EKS cluster that you would like to list Fargate profiles
	// in.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The maximum number of Fargate profile results returned by ListFargateProfiles
	// in paginated output. When you use this parameter, ListFargateProfiles returns
	// only maxResults results in a single page along with a nextToken response
	// element. You can see the remaining results of the initial request by sending
	// another ListFargateProfiles request with the returned nextToken value. This
	// value can be between 1 and 100. If you don't use this parameter, ListFargateProfiles
	// returns up to 100 results and a nextToken value if applicable.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated ListFargateProfiles
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFargateProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFargateProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFargateProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFargateProfilesInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *ListFargateProfilesInput) SetClusterName(v string) *ListFargateProfilesInput {
	s.ClusterName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFargateProfilesInput) SetMaxResults(v int64) *ListFargateProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFargateProfilesInput) SetNextToken(v string) *ListFargateProfilesInput {
	s.NextToken = &v
	return s
}

type ListFargateProfilesOutput struct {
	_ struct{} `type:"structure"`

	// A list of all of the Fargate profiles associated with the specified cluster.
	FargateProfileNames []*string `locationName:"fargateProfileNames" type:"list"`

	// The nextToken value to include in a future ListFargateProfiles request. When
	// the results of a ListFargateProfiles request exceed maxResults, you can use
	// this value to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFargateProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFargateProfilesOutput) GoString() string {
	return s.String()
}

// SetFargateProfileNames sets the FargateProfileNames field's value.
func (s *ListFargateProfilesOutput) SetFargateProfileNames(v []*string) *ListFargateProfilesOutput {
	s.FargateProfileNames = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFargateProfilesOutput) SetNextToken(v string) *ListFargateProfilesOutput {
	s.NextToken = &v
	return s
}

type ListIdentityProviderConfigsInput struct {
	_ struct{} `type:"structure"`

	// The cluster name that you want to list identity provider configurations for.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The maximum number of identity provider configurations returned by ListIdentityProviderConfigs
	// in paginated output. When you use this parameter, ListIdentityProviderConfigs
	// returns only maxResults results in a single page along with a nextToken response
	// element. You can see the remaining results of the initial request by sending
	// another ListIdentityProviderConfigs request with the returned nextToken value.
	// This value can be between 1 and 100. If you don't use this parameter, ListIdentityProviderConfigs
	// returns up to 100 results and a nextToken value, if applicable.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated IdentityProviderConfigsRequest
	// where maxResults was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityProviderConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityProviderConfigsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIdentityProviderConfigsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIdentityProviderConfigsInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *ListIdentityProviderConfigsInput) SetClusterName(v string) *ListIdentityProviderConfigsInput {
	s.ClusterName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIdentityProviderConfigsInput) SetMaxResults(v int64) *ListIdentityProviderConfigsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentityProviderConfigsInput) SetNextToken(v string) *ListIdentityProviderConfigsInput {
	s.NextToken = &v
	return s
}

type ListIdentityProviderConfigsOutput struct {
	_ struct{} `type:"structure"`

	// The identity provider configurations for the cluster.
	IdentityProviderConfigs []*IdentityProviderConfig `locationName:"identityProviderConfigs" type:"list"`

	// The nextToken value returned from a previous paginated ListIdentityProviderConfigsResponse
	// where maxResults was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityProviderConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityProviderConfigsOutput) GoString() string {
	return s.String()
}

// SetIdentityProviderConfigs sets the IdentityProviderConfigs field's value.
func (s *ListIdentityProviderConfigsOutput) SetIdentityProviderConfigs(v []*IdentityProviderConfig) *ListIdentityProviderConfigsOutput {
	s.IdentityProviderConfigs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentityProviderConfigsOutput) SetNextToken(v string) *ListIdentityProviderConfigsOutput {
	s.NextToken = &v
	return s
}

type ListNodegroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EKS cluster that you would like to list node groups
	// in.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The maximum number of node group results returned by ListNodegroups in paginated
	// output. When you use this parameter, ListNodegroups returns only maxResults
	// results in a single page along with a nextToken response element. You can
	// see the remaining results of the initial request by sending another ListNodegroups
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If you don't use this parameter, ListNodegroups returns up to 100 results
	// and a nextToken value if applicable.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated ListNodegroups request
	// where maxResults was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNodegroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNodegroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNodegroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNodegroupsInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *ListNodegroupsInput) SetClusterName(v string) *ListNodegroupsInput {
	s.ClusterName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNodegroupsInput) SetMaxResults(v int64) *ListNodegroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNodegroupsInput) SetNextToken(v string) *ListNodegroupsInput {
	s.NextToken = &v
	return s
}

type ListNodegroupsOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListNodegroups request. When the
	// results of a ListNodegroups request exceed maxResults, you can use this value
	// to retrieve the next page of results. This value is null when there are no
	// more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of all of the node groups associated with the specified cluster.
	Nodegroups []*string `locationName:"nodegroups" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNodegroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNodegroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListNodegroupsOutput) SetNextToken(v string) *ListNodegroupsOutput {
	s.NextToken = &v
	return s
}

// SetNodegroups sets the Nodegroups field's value.
func (s *ListNodegroupsOutput) SetNodegroups(v []*string) *ListNodegroupsOutput {
	s.Nodegroups = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the resource for which to
	// list the tags. Currently, the supported resources are Amazon EKS clusters
	// and managed node groups.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags for the resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListUpdatesInput struct {
	_ struct{} `type:"structure"`

	// The names of the installed add-ons that have available updates.
	AddonName *string `location:"querystring" locationName:"addonName" type:"string"`

	// The maximum number of update results returned by ListUpdates in paginated
	// output. When you use this parameter, ListUpdates returns only maxResults
	// results in a single page along with a nextToken response element. You can
	// see the remaining results of the initial request by sending another ListUpdates
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If you don't use this parameter, ListUpdates returns up to 100 results
	// and a nextToken value if applicable.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The name of the Amazon EKS cluster to list updates for.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The nextToken value returned from a previous paginated ListUpdates request
	// where maxResults was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The name of the Amazon EKS managed node group to list updates for.
	NodegroupName *string `location:"querystring" locationName:"nodegroupName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUpdatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUpdatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUpdatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUpdatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddonName sets the AddonName field's value.
func (s *ListUpdatesInput) SetAddonName(v string) *ListUpdatesInput {
	s.AddonName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUpdatesInput) SetMaxResults(v int64) *ListUpdatesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListUpdatesInput) SetName(v string) *ListUpdatesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUpdatesInput) SetNextToken(v string) *ListUpdatesInput {
	s.NextToken = &v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *ListUpdatesInput) SetNodegroupName(v string) *ListUpdatesInput {
	s.NodegroupName = &v
	return s
}

type ListUpdatesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListUpdates request. When the
	// results of a ListUpdates request exceed maxResults, you can use this value
	// to retrieve the next page of results. This value is null when there are no
	// more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of all the updates for the specified cluster and Region.
	UpdateIds []*string `locationName:"updateIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUpdatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUpdatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUpdatesOutput) SetNextToken(v string) *ListUpdatesOutput {
	s.NextToken = &v
	return s
}

// SetUpdateIds sets the UpdateIds field's value.
func (s *ListUpdatesOutput) SetUpdateIds(v []*string) *ListUpdatesOutput {
	s.UpdateIds = v
	return s
}

// An object representing the enabled or disabled Kubernetes control plane logs
// for your cluster.
type LogSetup struct {
	_ struct{} `type:"structure"`

	// If a log type is enabled, that log type exports its control plane logs to
	// CloudWatch Logs. If a log type isn't enabled, that log type doesn't export
	// its control plane logs. Each individual log type can be enabled or disabled
	// independently.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The available cluster control plane log types.
	Types []*string `locationName:"types" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogSetup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogSetup) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *LogSetup) SetEnabled(v bool) *LogSetup {
	s.Enabled = &v
	return s
}

// SetTypes sets the Types field's value.
func (s *LogSetup) SetTypes(v []*string) *LogSetup {
	s.Types = v
	return s
}

// An object representing the logging configuration for resources in your cluster.
type Logging struct {
	_ struct{} `type:"structure"`

	// The cluster control plane logging configuration for your cluster.
	ClusterLogging []*LogSetup `locationName:"clusterLogging" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Logging) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Logging) GoString() string {
	return s.String()
}

// SetClusterLogging sets the ClusterLogging field's value.
func (s *Logging) SetClusterLogging(v []*LogSetup) *Logging {
	s.ClusterLogging = v
	return s
}

// An object representing an Amazon EKS managed node group.
type Nodegroup struct {
	_ struct{} `type:"structure"`

	// If the node group was deployed using a launch template with a custom AMI,
	// then this is CUSTOM. For node groups that weren't deployed using a launch
	// template, this is the AMI type that was specified in the node group configuration.
	AmiType *string `locationName:"amiType" type:"string" enum:"AMITypes"`

	// The capacity type of your managed node group.
	CapacityType *string `locationName:"capacityType" type:"string" enum:"CapacityTypes"`

	// The name of the cluster that the managed node group resides in.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The Unix epoch timestamp in seconds for when the managed node group was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// If the node group wasn't deployed with a launch template, then this is the
	// disk size in the node group configuration. If the node group was deployed
	// with a launch template, then this is null.
	DiskSize *int64 `locationName:"diskSize" type:"integer"`

	// The health status of the node group. If there are issues with your node group's
	// health, they are listed here.
	Health *NodegroupHealth `locationName:"health" type:"structure"`

	// If the node group wasn't deployed with a launch template, then this is the
	// instance type that is associated with the node group. If the node group was
	// deployed with a launch template, then this is null.
	InstanceTypes []*string `locationName:"instanceTypes" type:"list"`

	// The Kubernetes labels applied to the nodes in the node group.
	//
	// Only labels that are applied with the Amazon EKS API are shown here. There
	// may be other Kubernetes labels applied to the nodes in this group.
	Labels map[string]*string `locationName:"labels" type:"map"`

	// If a launch template was used to create the node group, then this is the
	// launch template that was used.
	LaunchTemplate *LaunchTemplateSpecification `locationName:"launchTemplate" type:"structure"`

	// The Unix epoch timestamp in seconds for when the managed node group was last
	// modified.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp"`

	// The IAM role associated with your node group. The Amazon EKS node kubelet
	// daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive
	// permissions for these API calls through an IAM instance profile and associated
	// policies.
	NodeRole *string `locationName:"nodeRole" type:"string"`

	// The Amazon Resource Name (ARN) associated with the managed node group.
	NodegroupArn *string `locationName:"nodegroupArn" type:"string"`

	// The name associated with an Amazon EKS managed node group.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`

	// If the node group was deployed using a launch template with a custom AMI,
	// then this is the AMI ID that was specified in the launch template. For node
	// groups that weren't deployed using a launch template, this is the version
	// of the Amazon EKS optimized AMI that the node group was deployed with.
	ReleaseVersion *string `locationName:"releaseVersion" type:"string"`

	// If the node group wasn't deployed with a launch template, then this is the
	// remote access configuration that is associated with the node group. If the
	// node group was deployed with a launch template, then this is null.
	RemoteAccess *RemoteAccessConfig `locationName:"remoteAccess" type:"structure"`

	// The resources associated with the node group, such as Auto Scaling groups
	// and security groups for remote access.
	Resources *NodegroupResources `locationName:"resources" type:"structure"`

	// The scaling configuration details for the Auto Scaling group that is associated
	// with your node group.
	ScalingConfig *NodegroupScalingConfig `locationName:"scalingConfig" type:"structure"`

	// The current status of the managed node group.
	Status *string `locationName:"status" type:"string" enum:"NodegroupStatus"`

	// The subnets that were specified for the Auto Scaling group that is associated
	// with your node group.
	Subnets []*string `locationName:"subnets" type:"list"`

	// The metadata applied to the node group to assist with categorization and
	// organization. Each tag consists of a key and an optional value, both of which
	// you define. Node group tags do not propagate to any other resources associated
	// with the node group, such as the Amazon EC2 instances or subnets.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The Kubernetes taints to be applied to the nodes in the node group when they
	// are created. Effect is one of No_Schedule, Prefer_No_Schedule, or No_Execute.
	// Kubernetes taints can be used together with tolerations to control how workloads
	// are scheduled to your nodes.
	Taints []*Taint `locationName:"taints" type:"list"`

	// The node group update configuration.
	UpdateConfig *NodegroupUpdateConfig `locationName:"updateConfig" type:"structure"`

	// The Kubernetes version of the managed node group.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Nodegroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Nodegroup) GoString() string {
	return s.String()
}

// SetAmiType sets the AmiType field's value.
func (s *Nodegroup) SetAmiType(v string) *Nodegroup {
	s.AmiType = &v
	return s
}

// SetCapacityType sets the CapacityType field's value.
func (s *Nodegroup) SetCapacityType(v string) *Nodegroup {
	s.CapacityType = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *Nodegroup) SetClusterName(v string) *Nodegroup {
	s.ClusterName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Nodegroup) SetCreatedAt(v time.Time) *Nodegroup {
	s.CreatedAt = &v
	return s
}

// SetDiskSize sets the DiskSize field's value.
func (s *Nodegroup) SetDiskSize(v int64) *Nodegroup {
	s.DiskSize = &v
	return s
}

// SetHealth sets the Health field's value.
func (s *Nodegroup) SetHealth(v *NodegroupHealth) *Nodegroup {
	s.Health = v
	return s
}

// SetInstanceTypes sets the InstanceTypes field's value.
func (s *Nodegroup) SetInstanceTypes(v []*string) *Nodegroup {
	s.InstanceTypes = v
	return s
}

// SetLabels sets the Labels field's value.
func (s *Nodegroup) SetLabels(v map[string]*string) *Nodegroup {
	s.Labels = v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *Nodegroup) SetLaunchTemplate(v *LaunchTemplateSpecification) *Nodegroup {
	s.LaunchTemplate = v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *Nodegroup) SetModifiedAt(v time.Time) *Nodegroup {
	s.ModifiedAt = &v
	return s
}

// SetNodeRole sets the NodeRole field's value.
func (s *Nodegroup) SetNodeRole(v string) *Nodegroup {
	s.NodeRole = &v
	return s
}

// SetNodegroupArn sets the NodegroupArn field's value.
func (s *Nodegroup) SetNodegroupArn(v string) *Nodegroup {
	s.NodegroupArn = &v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *Nodegroup) SetNodegroupName(v string) *Nodegroup {
	s.NodegroupName = &v
	return s
}

// SetReleaseVersion sets the ReleaseVersion field's value.
func (s *Nodegroup) SetReleaseVersion(v string) *Nodegroup {
	s.ReleaseVersion = &v
	return s
}

// SetRemoteAccess sets the RemoteAccess field's value.
func (s *Nodegroup) SetRemoteAccess(v *RemoteAccessConfig) *Nodegroup {
	s.RemoteAccess = v
	return s
}

// SetResources sets the Resources field's value.
func (s *Nodegroup) SetResources(v *NodegroupResources) *Nodegroup {
	s.Resources = v
	return s
}

// SetScalingConfig sets the ScalingConfig field's value.
func (s *Nodegroup) SetScalingConfig(v *NodegroupScalingConfig) *Nodegroup {
	s.ScalingConfig = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Nodegroup) SetStatus(v string) *Nodegroup {
	s.Status = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *Nodegroup) SetSubnets(v []*string) *Nodegroup {
	s.Subnets = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Nodegroup) SetTags(v map[string]*string) *Nodegroup {
	s.Tags = v
	return s
}

// SetTaints sets the Taints field's value.
func (s *Nodegroup) SetTaints(v []*Taint) *Nodegroup {
	s.Taints = v
	return s
}

// SetUpdateConfig sets the UpdateConfig field's value.
func (s *Nodegroup) SetUpdateConfig(v *NodegroupUpdateConfig) *Nodegroup {
	s.UpdateConfig = v
	return s
}

// SetVersion sets the Version field's value.
func (s *Nodegroup) SetVersion(v string) *Nodegroup {
	s.Version = &v
	return s
}

// An object representing the health status of the node group.
type NodegroupHealth struct {
	_ struct{} `type:"structure"`

	// Any issues that are associated with the node group.
	Issues []*Issue `locationName:"issues" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodegroupHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodegroupHealth) GoString() string {
	return s.String()
}

// SetIssues sets the Issues field's value.
func (s *NodegroupHealth) SetIssues(v []*Issue) *NodegroupHealth {
	s.Issues = v
	return s
}

// An object representing the resources associated with the node group, such
// as Auto Scaling groups and security groups for remote access.
type NodegroupResources struct {
	_ struct{} `type:"structure"`

	// The Auto Scaling groups associated with the node group.
	AutoScalingGroups []*AutoScalingGroup `locationName:"autoScalingGroups" type:"list"`

	// The remote access security group associated with the node group. This security
	// group controls SSH access to the nodes.
	RemoteAccessSecurityGroup *string `locationName:"remoteAccessSecurityGroup" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodegroupResources) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodegroupResources) GoString() string {
	return s.String()
}

// SetAutoScalingGroups sets the AutoScalingGroups field's value.
func (s *NodegroupResources) SetAutoScalingGroups(v []*AutoScalingGroup) *NodegroupResources {
	s.AutoScalingGroups = v
	return s
}

// SetRemoteAccessSecurityGroup sets the RemoteAccessSecurityGroup field's value.
func (s *NodegroupResources) SetRemoteAccessSecurityGroup(v string) *NodegroupResources {
	s.RemoteAccessSecurityGroup = &v
	return s
}

// An object representing the scaling configuration details for the Auto Scaling
// group that is associated with your node group. When creating a node group,
// you must specify all or none of the properties. When updating a node group,
// you can specify any or none of the properties.
type NodegroupScalingConfig struct {
	_ struct{} `type:"structure"`

	// The current number of nodes that the managed node group should maintain.
	DesiredSize *int64 `locationName:"desiredSize" type:"integer"`

	// The maximum number of nodes that the managed node group can scale out to.
	// For information about the maximum number that you can specify, see Amazon
	// EKS service quotas (https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html)
	// in the Amazon EKS User Guide.
	MaxSize *int64 `locationName:"maxSize" min:"1" type:"integer"`

	// The minimum number of nodes that the managed node group can scale in to.
	MinSize *int64 `locationName:"minSize" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodegroupScalingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodegroupScalingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NodegroupScalingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NodegroupScalingConfig"}
	if s.MaxSize != nil && *s.MaxSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredSize sets the DesiredSize field's value.
func (s *NodegroupScalingConfig) SetDesiredSize(v int64) *NodegroupScalingConfig {
	s.DesiredSize = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *NodegroupScalingConfig) SetMaxSize(v int64) *NodegroupScalingConfig {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *NodegroupScalingConfig) SetMinSize(v int64) *NodegroupScalingConfig {
	s.MinSize = &v
	return s
}

// The node group update configuration.
type NodegroupUpdateConfig struct {
	_ struct{} `type:"structure"`

	// The maximum number of nodes unavailable at once during a version update.
	// Nodes will be updated in parallel. This value or maxUnavailablePercentage
	// is required to have a value.The maximum number is 100.
	MaxUnavailable *int64 `locationName:"maxUnavailable" min:"1" type:"integer"`

	// The maximum percentage of nodes unavailable during a version update. This
	// percentage of nodes will be updated in parallel, up to 100 nodes at once.
	// This value or maxUnavailable is required to have a value.
	MaxUnavailablePercentage *int64 `locationName:"maxUnavailablePercentage" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodegroupUpdateConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodegroupUpdateConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NodegroupUpdateConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NodegroupUpdateConfig"}
	if s.MaxUnavailable != nil && *s.MaxUnavailable < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxUnavailable", 1))
	}
	if s.MaxUnavailablePercentage != nil && *s.MaxUnavailablePercentage < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxUnavailablePercentage", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxUnavailable sets the MaxUnavailable field's value.
func (s *NodegroupUpdateConfig) SetMaxUnavailable(v int64) *NodegroupUpdateConfig {
	s.MaxUnavailable = &v
	return s
}

// SetMaxUnavailablePercentage sets the MaxUnavailablePercentage field's value.
func (s *NodegroupUpdateConfig) SetMaxUnavailablePercentage(v int64) *NodegroupUpdateConfig {
	s.MaxUnavailablePercentage = &v
	return s
}

// A service resource associated with the request could not be found. Clients
// should not retry such requests.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object representing the OpenID Connect (https://openid.net/connect/) (OIDC)
// identity provider information for the cluster.
type OIDC struct {
	_ struct{} `type:"structure"`

	// The issuer URL for the OIDC identity provider.
	Issuer *string `locationName:"issuer" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OIDC) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OIDC) GoString() string {
	return s.String()
}

// SetIssuer sets the Issuer field's value.
func (s *OIDC) SetIssuer(v string) *OIDC {
	s.Issuer = &v
	return s
}

// An object that represents the configuration for an OpenID Connect (OIDC)
// identity provider.
type OidcIdentityProviderConfig struct {
	_ struct{} `type:"structure"`

	// This is also known as audience. The ID of the client application that makes
	// authentication requests to the OIDC identity provider.
	ClientId *string `locationName:"clientId" type:"string"`

	// The cluster that the configuration is associated to.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The JSON web token (JWT) claim that the provider uses to return your groups.
	GroupsClaim *string `locationName:"groupsClaim" type:"string"`

	// The prefix that is prepended to group claims to prevent clashes with existing
	// names (such as system: groups). For example, the valueoidc: creates group
	// names like oidc:engineering and oidc:infra. The prefix can't contain system:
	GroupsPrefix *string `locationName:"groupsPrefix" type:"string"`

	// The ARN of the configuration.
	IdentityProviderConfigArn *string `locationName:"identityProviderConfigArn" type:"string"`

	// The name of the configuration.
	IdentityProviderConfigName *string `locationName:"identityProviderConfigName" type:"string"`

	// The URL of the OIDC identity provider that allows the API server to discover
	// public signing keys for verifying tokens.
	IssuerUrl *string `locationName:"issuerUrl" type:"string"`

	// The key-value pairs that describe required claims in the identity token.
	// If set, each claim is verified to be present in the token with a matching
	// value.
	RequiredClaims map[string]*string `locationName:"requiredClaims" type:"map"`

	// The status of the OIDC identity provider.
	Status *string `locationName:"status" type:"string" enum:"ConfigStatus"`

	// The metadata to apply to the provider configuration to assist with categorization
	// and organization. Each tag consists of a key and an optional value, both
	// of which you defined.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The JSON Web token (JWT) claim that is used as the username.
	UsernameClaim *string `locationName:"usernameClaim" type:"string"`

	// The prefix that is prepended to username claims to prevent clashes with existing
	// names. The prefix can't contain system:
	UsernamePrefix *string `locationName:"usernamePrefix" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OidcIdentityProviderConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OidcIdentityProviderConfig) GoString() string {
	return s.String()
}

// SetClientId sets the ClientId field's value.
func (s *OidcIdentityProviderConfig) SetClientId(v string) *OidcIdentityProviderConfig {
	s.ClientId = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *OidcIdentityProviderConfig) SetClusterName(v string) *OidcIdentityProviderConfig {
	s.ClusterName = &v
	return s
}

// SetGroupsClaim sets the GroupsClaim field's value.
func (s *OidcIdentityProviderConfig) SetGroupsClaim(v string) *OidcIdentityProviderConfig {
	s.GroupsClaim = &v
	return s
}

// SetGroupsPrefix sets the GroupsPrefix field's value.
func (s *OidcIdentityProviderConfig) SetGroupsPrefix(v string) *OidcIdentityProviderConfig {
	s.GroupsPrefix = &v
	return s
}

// SetIdentityProviderConfigArn sets the IdentityProviderConfigArn field's value.
func (s *OidcIdentityProviderConfig) SetIdentityProviderConfigArn(v string) *OidcIdentityProviderConfig {
	s.IdentityProviderConfigArn = &v
	return s
}

// SetIdentityProviderConfigName sets the IdentityProviderConfigName field's value.
func (s *OidcIdentityProviderConfig) SetIdentityProviderConfigName(v string) *OidcIdentityProviderConfig {
	s.IdentityProviderConfigName = &v
	return s
}

// SetIssuerUrl sets the IssuerUrl field's value.
func (s *OidcIdentityProviderConfig) SetIssuerUrl(v string) *OidcIdentityProviderConfig {
	s.IssuerUrl = &v
	return s
}

// SetRequiredClaims sets the RequiredClaims field's value.
func (s *OidcIdentityProviderConfig) SetRequiredClaims(v map[string]*string) *OidcIdentityProviderConfig {
	s.RequiredClaims = v
	return s
}

// SetStatus sets the Status field's value.
func (s *OidcIdentityProviderConfig) SetStatus(v string) *OidcIdentityProviderConfig {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *OidcIdentityProviderConfig) SetTags(v map[string]*string) *OidcIdentityProviderConfig {
	s.Tags = v
	return s
}

// SetUsernameClaim sets the UsernameClaim field's value.
func (s *OidcIdentityProviderConfig) SetUsernameClaim(v string) *OidcIdentityProviderConfig {
	s.UsernameClaim = &v
	return s
}

// SetUsernamePrefix sets the UsernamePrefix field's value.
func (s *OidcIdentityProviderConfig) SetUsernamePrefix(v string) *OidcIdentityProviderConfig {
	s.UsernamePrefix = &v
	return s
}

// An object representing an OpenID Connect (OIDC) configuration. Before associating
// an OIDC identity provider to your cluster, review the considerations in Authenticating
// users for your cluster from an OpenID Connect identity provider (https://docs.aws.amazon.com/eks/latest/userguide/authenticate-oidc-identity-provider.html)
// in the Amazon EKS User Guide.
type OidcIdentityProviderConfigRequest struct {
	_ struct{} `type:"structure"`

	// This is also known as audience. The ID for the client application that makes
	// authentication requests to the OpenID identity provider.
	//
	// ClientId is a required field
	ClientId *string `locationName:"clientId" type:"string" required:"true"`

	// The JWT claim that the provider uses to return your groups.
	GroupsClaim *string `locationName:"groupsClaim" type:"string"`

	// The prefix that is prepended to group claims to prevent clashes with existing
	// names (such as system: groups). For example, the valueoidc: will create group
	// names like oidc:engineering and oidc:infra.
	GroupsPrefix *string `locationName:"groupsPrefix" type:"string"`

	// The name of the OIDC provider configuration.
	//
	// IdentityProviderConfigName is a required field
	IdentityProviderConfigName *string `locationName:"identityProviderConfigName" type:"string" required:"true"`

	// The URL of the OpenID identity provider that allows the API server to discover
	// public signing keys for verifying tokens. The URL must begin with https://
	// and should correspond to the iss claim in the provider's OIDC ID tokens.
	// Per the OIDC standard, path components are allowed but query parameters are
	// not. Typically the URL consists of only a hostname, like https://server.example.org
	// or https://example.com. This URL should point to the level below .well-known/openid-configuration
	// and must be publicly accessible over the internet.
	//
	// IssuerUrl is a required field
	IssuerUrl *string `locationName:"issuerUrl" type:"string" required:"true"`

	// The key value pairs that describe required claims in the identity token.
	// If set, each claim is verified to be present in the token with a matching
	// value. For the maximum number of claims that you can require, see Amazon
	// EKS service quotas (https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html)
	// in the Amazon EKS User Guide.
	RequiredClaims map[string]*string `locationName:"requiredClaims" type:"map"`

	// The JSON Web Token (JWT) claim to use as the username. The default is sub,
	// which is expected to be a unique identifier of the end user. You can choose
	// other claims, such as email or name, depending on the OpenID identity provider.
	// Claims other than email are prefixed with the issuer URL to prevent naming
	// clashes with other plug-ins.
	UsernameClaim *string `locationName:"usernameClaim" type:"string"`

	// The prefix that is prepended to username claims to prevent clashes with existing
	// names. If you do not provide this field, and username is a value other than
	// email, the prefix defaults to issuerurl#. You can use the value - to disable
	// all prefixing.
	UsernamePrefix *string `locationName:"usernamePrefix" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OidcIdentityProviderConfigRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OidcIdentityProviderConfigRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OidcIdentityProviderConfigRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OidcIdentityProviderConfigRequest"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.IdentityProviderConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProviderConfigName"))
	}
	if s.IssuerUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("IssuerUrl"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientId sets the ClientId field's value.
func (s *OidcIdentityProviderConfigRequest) SetClientId(v string) *OidcIdentityProviderConfigRequest {
	s.ClientId = &v
	return s
}

// SetGroupsClaim sets the GroupsClaim field's value.
func (s *OidcIdentityProviderConfigRequest) SetGroupsClaim(v string) *OidcIdentityProviderConfigRequest {
	s.GroupsClaim = &v
	return s
}

// SetGroupsPrefix sets the GroupsPrefix field's value.
func (s *OidcIdentityProviderConfigRequest) SetGroupsPrefix(v string) *OidcIdentityProviderConfigRequest {
	s.GroupsPrefix = &v
	return s
}

// SetIdentityProviderConfigName sets the IdentityProviderConfigName field's value.
func (s *OidcIdentityProviderConfigRequest) SetIdentityProviderConfigName(v string) *OidcIdentityProviderConfigRequest {
	s.IdentityProviderConfigName = &v
	return s
}

// SetIssuerUrl sets the IssuerUrl field's value.
func (s *OidcIdentityProviderConfigRequest) SetIssuerUrl(v string) *OidcIdentityProviderConfigRequest {
	s.IssuerUrl = &v
	return s
}

// SetRequiredClaims sets the RequiredClaims field's value.
func (s *OidcIdentityProviderConfigRequest) SetRequiredClaims(v map[string]*string) *OidcIdentityProviderConfigRequest {
	s.RequiredClaims = v
	return s
}

// SetUsernameClaim sets the UsernameClaim field's value.
func (s *OidcIdentityProviderConfigRequest) SetUsernameClaim(v string) *OidcIdentityProviderConfigRequest {
	s.UsernameClaim = &v
	return s
}

// SetUsernamePrefix sets the UsernamePrefix field's value.
func (s *OidcIdentityProviderConfigRequest) SetUsernamePrefix(v string) *OidcIdentityProviderConfigRequest {
	s.UsernamePrefix = &v
	return s
}

// Identifies the Key Management Service (KMS) key used to encrypt the secrets.
type Provider struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) or alias of the KMS key. The KMS key must be symmetric,
	// created in the same region as the cluster, and if the KMS key was created
	// in a different account, the user must have access to the KMS key. For more
	// information, see Allowing Users in Other Accounts to Use a KMS key (https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html)
	// in the Key Management Service Developer Guide.
	KeyArn *string `locationName:"keyArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Provider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Provider) GoString() string {
	return s.String()
}

// SetKeyArn sets the KeyArn field's value.
func (s *Provider) SetKeyArn(v string) *Provider {
	s.KeyArn = &v
	return s
}

type RegisterClusterInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The configuration settings required to connect the Kubernetes cluster to
	// the Amazon EKS control plane.
	//
	// ConnectorConfig is a required field
	ConnectorConfig *ConnectorConfigRequest `locationName:"connectorConfig" type:"structure" required:"true"`

	// Define a unique name for this cluster within your AWS account.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterClusterInput"}
	if s.ConnectorConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorConfig"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ConnectorConfig != nil {
		if err := s.ConnectorConfig.Validate(); err != nil {
			invalidParams.AddNested("ConnectorConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *RegisterClusterInput) SetClientRequestToken(v string) *RegisterClusterInput {
	s.ClientRequestToken = &v
	return s
}

// SetConnectorConfig sets the ConnectorConfig field's value.
func (s *RegisterClusterInput) SetConnectorConfig(v *ConnectorConfigRequest) *RegisterClusterInput {
	s.ConnectorConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *RegisterClusterInput) SetName(v string) *RegisterClusterInput {
	s.Name = &v
	return s
}

type RegisterClusterOutput struct {
	_ struct{} `type:"structure"`

	// An object representing an Amazon EKS cluster.
	Cluster *Cluster `locationName:"cluster" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *RegisterClusterOutput) SetCluster(v *Cluster) *RegisterClusterOutput {
	s.Cluster = v
	return s
}

// An object representing the remote access configuration for the managed node
// group.
type RemoteAccessConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon EC2 SSH key that provides access for SSH communication with the
	// nodes in the managed node group. For more information, see Amazon EC2 key
	// pairs and Linux instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
	// in the Amazon Elastic Compute Cloud User Guide for Linux Instances.
	Ec2SshKey *string `locationName:"ec2SshKey" type:"string"`

	// The security groups that are allowed SSH access (port 22) to the nodes. If
	// you specify an Amazon EC2 SSH key but do not specify a source security group
	// when you create a managed node group, then port 22 on the nodes is opened
	// to the internet (0.0.0.0/0). For more information, see Security Groups for
	// Your VPC (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html)
	// in the Amazon Virtual Private Cloud User Guide.
	SourceSecurityGroups []*string `locationName:"sourceSecurityGroups" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoteAccessConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoteAccessConfig) GoString() string {
	return s.String()
}

// SetEc2SshKey sets the Ec2SshKey field's value.
func (s *RemoteAccessConfig) SetEc2SshKey(v string) *RemoteAccessConfig {
	s.Ec2SshKey = &v
	return s
}

// SetSourceSecurityGroups sets the SourceSecurityGroups field's value.
func (s *RemoteAccessConfig) SetSourceSecurityGroups(v []*string) *RemoteAccessConfig {
	s.SourceSecurityGroups = v
	return s
}

// The specified resource is in use.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	AddonName *string `locationName:"addonName" type:"string"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have encountered a service limit on the specified resource.
type ResourceLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceLimitExceededException) Code() string {
	return "ResourceLimitExceededException"
}

// Message returns the exception's message.
func (s *ResourceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceLimitExceededException) OrigErr() error {
	return nil
}

func (s *ResourceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource could not be found. You can view your available clusters
// with ListClusters. You can view your available managed node groups with ListNodegroups.
// Amazon EKS clusters and node groups are Region-specific.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	AddonName *string `locationName:"addonName" type:"string"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The Fargate profile associated with the exception.
	FargateProfileName *string `locationName:"fargateProfileName" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// These errors are usually caused by a server-side issue.
type ServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	AddonName *string `locationName:"addonName" type:"string"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerException) GoString() string {
	return s.String()
}

func newErrorServerException(v protocol.ResponseMetadata) error {
	return &ServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServerException) Code() string {
	return "ServerException"
}

// Message returns the exception's message.
func (s *ServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServerException) OrigErr() error {
	return nil
}

func (s *ServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service is unavailable. Back off and retry the operation.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to which to add tags. Currently,
	// the supported resources are Amazon EKS clusters and managed node groups.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tags to add to the resource. A tag is an array of key-value pairs.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// A property that allows a node to repel a set of pods.
type Taint struct {
	_ struct{} `type:"structure"`

	// The effect of the taint.
	Effect *string `locationName:"effect" type:"string" enum:"TaintEffect"`

	// The key of the taint.
	Key *string `locationName:"key" min:"1" type:"string"`

	// The value of the taint.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Taint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Taint) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Taint) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Taint"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEffect sets the Effect field's value.
func (s *Taint) SetEffect(v string) *Taint {
	s.Effect = &v
	return s
}

// SetKey sets the Key field's value.
func (s *Taint) SetKey(v string) *Taint {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Taint) SetValue(v string) *Taint {
	s.Value = &v
	return s
}

// At least one of your specified cluster subnets is in an Availability Zone
// that does not support Amazon EKS. The exception output specifies the supported
// Availability Zones for your account, from which you can choose subnets for
// your cluster.
type UnsupportedAvailabilityZoneException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`

	// The supported Availability Zones for your account. Choose subnets in these
	// Availability Zones for your cluster.
	ValidZones []*string `locationName:"validZones" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedAvailabilityZoneException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedAvailabilityZoneException) GoString() string {
	return s.String()
}

func newErrorUnsupportedAvailabilityZoneException(v protocol.ResponseMetadata) error {
	return &UnsupportedAvailabilityZoneException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedAvailabilityZoneException) Code() string {
	return "UnsupportedAvailabilityZoneException"
}

// Message returns the exception's message.
func (s *UnsupportedAvailabilityZoneException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedAvailabilityZoneException) OrigErr() error {
	return nil
}

func (s *UnsupportedAvailabilityZoneException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedAvailabilityZoneException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedAvailabilityZoneException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource from which to delete tags.
	// Currently, the supported resources are Amazon EKS clusters and managed node
	// groups.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The keys of the tags to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// An object representing an asynchronous update.
type Update struct {
	_ struct{} `type:"structure"`

	// The Unix epoch timestamp in seconds for when the update was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// Any errors associated with a Failed update.
	Errors []*ErrorDetail `locationName:"errors" type:"list"`

	// A UUID that is used to track the update.
	Id *string `locationName:"id" type:"string"`

	// A key-value map that contains the parameters associated with the update.
	Params []*UpdateParam `locationName:"params" type:"list"`

	// The current status of the update.
	Status *string `locationName:"status" type:"string" enum:"UpdateStatus"`

	// The type of the update.
	Type *string `locationName:"type" type:"string" enum:"UpdateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Update) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Update) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Update) SetCreatedAt(v time.Time) *Update {
	s.CreatedAt = &v
	return s
}

// SetErrors sets the Errors field's value.
func (s *Update) SetErrors(v []*ErrorDetail) *Update {
	s.Errors = v
	return s
}

// SetId sets the Id field's value.
func (s *Update) SetId(v string) *Update {
	s.Id = &v
	return s
}

// SetParams sets the Params field's value.
func (s *Update) SetParams(v []*UpdateParam) *Update {
	s.Params = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Update) SetStatus(v string) *Update {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *Update) SetType(v string) *Update {
	s.Type = &v
	return s
}

type UpdateAddonInput struct {
	_ struct{} `type:"structure"`

	// The name of the add-on. The name must match one of the names returned by
	// ListAddons (https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html).
	//
	// AddonName is a required field
	AddonName *string `location:"uri" locationName:"addonName" type:"string" required:"true"`

	// The version of the add-on. The version must match one of the versions returned
	// by DescribeAddonVersions (https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html).
	AddonVersion *string `locationName:"addonVersion" type:"string"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// How to resolve parameter value conflicts when applying the new version of
	// the add-on to the cluster.
	ResolveConflicts *string `locationName:"resolveConflicts" type:"string" enum:"ResolveConflicts"`

	// The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's
	// service account. The role must be assigned the IAM permissions required by
	// the add-on. If you don't specify an existing IAM role, then the add-on uses
	// the permissions assigned to the node IAM role. For more information, see
	// Amazon EKS node IAM role (https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
	// in the Amazon EKS User Guide.
	//
	// To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC)
	// provider created for your cluster. For more information, see Enabling IAM
	// roles for service accounts on your cluster (https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
	// in the Amazon EKS User Guide.
	ServiceAccountRoleArn *string `locationName:"serviceAccountRoleArn" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAddonInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAddonInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAddonInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAddonInput"}
	if s.AddonName == nil {
		invalidParams.Add(request.NewErrParamRequired("AddonName"))
	}
	if s.AddonName != nil && len(*s.AddonName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AddonName", 1))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.ServiceAccountRoleArn != nil && len(*s.ServiceAccountRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceAccountRoleArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddonName sets the AddonName field's value.
func (s *UpdateAddonInput) SetAddonName(v string) *UpdateAddonInput {
	s.AddonName = &v
	return s
}

// SetAddonVersion sets the AddonVersion field's value.
func (s *UpdateAddonInput) SetAddonVersion(v string) *UpdateAddonInput {
	s.AddonVersion = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateAddonInput) SetClientRequestToken(v string) *UpdateAddonInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *UpdateAddonInput) SetClusterName(v string) *UpdateAddonInput {
	s.ClusterName = &v
	return s
}

// SetResolveConflicts sets the ResolveConflicts field's value.
func (s *UpdateAddonInput) SetResolveConflicts(v string) *UpdateAddonInput {
	s.ResolveConflicts = &v
	return s
}

// SetServiceAccountRoleArn sets the ServiceAccountRoleArn field's value.
func (s *UpdateAddonInput) SetServiceAccountRoleArn(v string) *UpdateAddonInput {
	s.ServiceAccountRoleArn = &v
	return s
}

type UpdateAddonOutput struct {
	_ struct{} `type:"structure"`

	// An object representing an asynchronous update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAddonOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAddonOutput) GoString() string {
	return s.String()
}

// SetUpdate sets the Update field's value.
func (s *UpdateAddonOutput) SetUpdate(v *Update) *UpdateAddonOutput {
	s.Update = v
	return s
}

type UpdateClusterConfigInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// Enable or disable exporting the Kubernetes control plane logs for your cluster
	// to CloudWatch Logs. By default, cluster control plane logs aren't exported
	// to CloudWatch Logs. For more information, see Amazon EKS cluster control
	// plane logs (https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
	// in the Amazon EKS User Guide .
	//
	// CloudWatch Logs ingestion, archive storage, and data scanning rates apply
	// to exported control plane logs. For more information, see CloudWatch Pricing
	// (http://aws.amazon.com/cloudwatch/pricing/).
	Logging *Logging `locationName:"logging" type:"structure"`

	// The name of the Amazon EKS cluster to update.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// An object representing the VPC configuration to use for an Amazon EKS cluster.
	ResourcesVpcConfig *VpcConfigRequest `locationName:"resourcesVpcConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClusterConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateClusterConfigInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateClusterConfigInput) SetClientRequestToken(v string) *UpdateClusterConfigInput {
	s.ClientRequestToken = &v
	return s
}

// SetLogging sets the Logging field's value.
func (s *UpdateClusterConfigInput) SetLogging(v *Logging) *UpdateClusterConfigInput {
	s.Logging = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateClusterConfigInput) SetName(v string) *UpdateClusterConfigInput {
	s.Name = &v
	return s
}

// SetResourcesVpcConfig sets the ResourcesVpcConfig field's value.
func (s *UpdateClusterConfigInput) SetResourcesVpcConfig(v *VpcConfigRequest) *UpdateClusterConfigInput {
	s.ResourcesVpcConfig = v
	return s
}

type UpdateClusterConfigOutput struct {
	_ struct{} `type:"structure"`

	// An object representing an asynchronous update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterConfigOutput) GoString() string {
	return s.String()
}

// SetUpdate sets the Update field's value.
func (s *UpdateClusterConfigOutput) SetUpdate(v *Update) *UpdateClusterConfigOutput {
	s.Update = v
	return s
}

type UpdateClusterVersionInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the Amazon EKS cluster to update.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The desired Kubernetes version following a successful update.
	//
	// Version is a required field
	Version *string `locationName:"version" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClusterVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateClusterVersionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateClusterVersionInput) SetClientRequestToken(v string) *UpdateClusterVersionInput {
	s.ClientRequestToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateClusterVersionInput) SetName(v string) *UpdateClusterVersionInput {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *UpdateClusterVersionInput) SetVersion(v string) *UpdateClusterVersionInput {
	s.Version = &v
	return s
}

type UpdateClusterVersionOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the specified update
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterVersionOutput) GoString() string {
	return s.String()
}

// SetUpdate sets the Update field's value.
func (s *UpdateClusterVersionOutput) SetUpdate(v *Update) *UpdateClusterVersionOutput {
	s.Update = v
	return s
}

// An object representing a Kubernetes label change for a managed node group.
type UpdateLabelsPayload struct {
	_ struct{} `type:"structure"`

	// Kubernetes labels to be added or updated.
	AddOrUpdateLabels map[string]*string `locationName:"addOrUpdateLabels" type:"map"`

	// Kubernetes labels to be removed.
	RemoveLabels []*string `locationName:"removeLabels" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLabelsPayload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLabelsPayload) GoString() string {
	return s.String()
}

// SetAddOrUpdateLabels sets the AddOrUpdateLabels field's value.
func (s *UpdateLabelsPayload) SetAddOrUpdateLabels(v map[string]*string) *UpdateLabelsPayload {
	s.AddOrUpdateLabels = v
	return s
}

// SetRemoveLabels sets the RemoveLabels field's value.
func (s *UpdateLabelsPayload) SetRemoveLabels(v []*string) *UpdateLabelsPayload {
	s.RemoveLabels = v
	return s
}

type UpdateNodegroupConfigInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the Amazon EKS cluster that the managed node group resides in.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The Kubernetes labels to be applied to the nodes in the node group after
	// the update.
	Labels *UpdateLabelsPayload `locationName:"labels" type:"structure"`

	// The name of the managed node group to update.
	//
	// NodegroupName is a required field
	NodegroupName *string `location:"uri" locationName:"nodegroupName" type:"string" required:"true"`

	// The scaling configuration details for the Auto Scaling group after the update.
	ScalingConfig *NodegroupScalingConfig `locationName:"scalingConfig" type:"structure"`

	// The Kubernetes taints to be applied to the nodes in the node group after
	// the update.
	Taints *UpdateTaintsPayload `locationName:"taints" type:"structure"`

	// The node group update configuration.
	UpdateConfig *NodegroupUpdateConfig `locationName:"updateConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNodegroupConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNodegroupConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNodegroupConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNodegroupConfigInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.NodegroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("NodegroupName"))
	}
	if s.NodegroupName != nil && len(*s.NodegroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodegroupName", 1))
	}
	if s.ScalingConfig != nil {
		if err := s.ScalingConfig.Validate(); err != nil {
			invalidParams.AddNested("ScalingConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Taints != nil {
		if err := s.Taints.Validate(); err != nil {
			invalidParams.AddNested("Taints", err.(request.ErrInvalidParams))
		}
	}
	if s.UpdateConfig != nil {
		if err := s.UpdateConfig.Validate(); err != nil {
			invalidParams.AddNested("UpdateConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateNodegroupConfigInput) SetClientRequestToken(v string) *UpdateNodegroupConfigInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *UpdateNodegroupConfigInput) SetClusterName(v string) *UpdateNodegroupConfigInput {
	s.ClusterName = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *UpdateNodegroupConfigInput) SetLabels(v *UpdateLabelsPayload) *UpdateNodegroupConfigInput {
	s.Labels = v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *UpdateNodegroupConfigInput) SetNodegroupName(v string) *UpdateNodegroupConfigInput {
	s.NodegroupName = &v
	return s
}

// SetScalingConfig sets the ScalingConfig field's value.
func (s *UpdateNodegroupConfigInput) SetScalingConfig(v *NodegroupScalingConfig) *UpdateNodegroupConfigInput {
	s.ScalingConfig = v
	return s
}

// SetTaints sets the Taints field's value.
func (s *UpdateNodegroupConfigInput) SetTaints(v *UpdateTaintsPayload) *UpdateNodegroupConfigInput {
	s.Taints = v
	return s
}

// SetUpdateConfig sets the UpdateConfig field's value.
func (s *UpdateNodegroupConfigInput) SetUpdateConfig(v *NodegroupUpdateConfig) *UpdateNodegroupConfigInput {
	s.UpdateConfig = v
	return s
}

type UpdateNodegroupConfigOutput struct {
	_ struct{} `type:"structure"`

	// An object representing an asynchronous update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNodegroupConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNodegroupConfigOutput) GoString() string {
	return s.String()
}

// SetUpdate sets the Update field's value.
func (s *UpdateNodegroupConfigOutput) SetUpdate(v *Update) *UpdateNodegroupConfigOutput {
	s.Update = v
	return s
}

type UpdateNodegroupVersionInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the Amazon EKS cluster that is associated with the managed node
	// group to update.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// Force the update if the existing node group's pods are unable to be drained
	// due to a pod disruption budget issue. If an update fails because pods could
	// not be drained, you can force the update after it fails to terminate the
	// old node whether or not any pods are running on the node.
	Force *bool `locationName:"force" type:"boolean"`

	// An object representing a node group's launch template specification. You
	// can only update a node group using a launch template if the node group was
	// originally deployed with a launch template.
	LaunchTemplate *LaunchTemplateSpecification `locationName:"launchTemplate" type:"structure"`

	// The name of the managed node group to update.
	//
	// NodegroupName is a required field
	NodegroupName *string `location:"uri" locationName:"nodegroupName" type:"string" required:"true"`

	// The AMI version of the Amazon EKS optimized AMI to use for the update. By
	// default, the latest available AMI version for the node group's Kubernetes
	// version is used. For more information, see Amazon EKS optimized Amazon Linux
	// 2 AMI versions (https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html)
	// in the Amazon EKS User Guide. If you specify launchTemplate, and your launch
	// template uses a custom AMI, then don't specify releaseVersion, or the node
	// group update will fail. For more information about using launch templates
	// with Amazon EKS, see Launch template support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	ReleaseVersion *string `locationName:"releaseVersion" type:"string"`

	// The Kubernetes version to update to. If no version is specified, then the
	// Kubernetes version of the node group does not change. You can specify the
	// Kubernetes version of the cluster to update the node group to the latest
	// AMI version of the cluster's Kubernetes version. If you specify launchTemplate,
	// and your launch template uses a custom AMI, then don't specify version, or
	// the node group update will fail. For more information about using launch
	// templates with Amazon EKS, see Launch template support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNodegroupVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNodegroupVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNodegroupVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNodegroupVersionInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.NodegroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("NodegroupName"))
	}
	if s.NodegroupName != nil && len(*s.NodegroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodegroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateNodegroupVersionInput) SetClientRequestToken(v string) *UpdateNodegroupVersionInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *UpdateNodegroupVersionInput) SetClusterName(v string) *UpdateNodegroupVersionInput {
	s.ClusterName = &v
	return s
}

// SetForce sets the Force field's value.
func (s *UpdateNodegroupVersionInput) SetForce(v bool) *UpdateNodegroupVersionInput {
	s.Force = &v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *UpdateNodegroupVersionInput) SetLaunchTemplate(v *LaunchTemplateSpecification) *UpdateNodegroupVersionInput {
	s.LaunchTemplate = v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *UpdateNodegroupVersionInput) SetNodegroupName(v string) *UpdateNodegroupVersionInput {
	s.NodegroupName = &v
	return s
}

// SetReleaseVersion sets the ReleaseVersion field's value.
func (s *UpdateNodegroupVersionInput) SetReleaseVersion(v string) *UpdateNodegroupVersionInput {
	s.ReleaseVersion = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *UpdateNodegroupVersionInput) SetVersion(v string) *UpdateNodegroupVersionInput {
	s.Version = &v
	return s
}

type UpdateNodegroupVersionOutput struct {
	_ struct{} `type:"structure"`

	// An object representing an asynchronous update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNodegroupVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNodegroupVersionOutput) GoString() string {
	return s.String()
}

// SetUpdate sets the Update field's value.
func (s *UpdateNodegroupVersionOutput) SetUpdate(v *Update) *UpdateNodegroupVersionOutput {
	s.Update = v
	return s
}

// An object representing the details of an update request.
type UpdateParam struct {
	_ struct{} `type:"structure"`

	// The keys associated with an update request.
	Type *string `locationName:"type" type:"string" enum:"UpdateParamType"`

	// The value of the keys submitted as part of an update request.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateParam) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateParam) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *UpdateParam) SetType(v string) *UpdateParam {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *UpdateParam) SetValue(v string) *UpdateParam {
	s.Value = &v
	return s
}

// An object representing the details of an update to a taints payload.
type UpdateTaintsPayload struct {
	_ struct{} `type:"structure"`

	// Kubernetes taints to be added or updated.
	AddOrUpdateTaints []*Taint `locationName:"addOrUpdateTaints" type:"list"`

	// Kubernetes taints to be removed.
	RemoveTaints []*Taint `locationName:"removeTaints" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTaintsPayload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTaintsPayload) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTaintsPayload) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTaintsPayload"}
	if s.AddOrUpdateTaints != nil {
		for i, v := range s.AddOrUpdateTaints {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AddOrUpdateTaints", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RemoveTaints != nil {
		for i, v := range s.RemoveTaints {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RemoveTaints", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddOrUpdateTaints sets the AddOrUpdateTaints field's value.
func (s *UpdateTaintsPayload) SetAddOrUpdateTaints(v []*Taint) *UpdateTaintsPayload {
	s.AddOrUpdateTaints = v
	return s
}

// SetRemoveTaints sets the RemoveTaints field's value.
func (s *UpdateTaintsPayload) SetRemoveTaints(v []*Taint) *UpdateTaintsPayload {
	s.RemoveTaints = v
	return s
}

// An object representing the VPC configuration to use for an Amazon EKS cluster.
type VpcConfigRequest struct {
	_ struct{} `type:"structure"`

	// Set this value to true to enable private access for your cluster's Kubernetes
	// API server endpoint. If you enable private access, Kubernetes API requests
	// from within your cluster's VPC use the private VPC endpoint. The default
	// value for this parameter is false, which disables private access for your
	// Kubernetes API server. If you disable private access and you have nodes or
	// Fargate pods in the cluster, then ensure that publicAccessCidrs includes
	// the necessary CIDR blocks for communication with the nodes or Fargate pods.
	// For more information, see Amazon EKS cluster endpoint access control (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
	// in the Amazon EKS User Guide .
	EndpointPrivateAccess *bool `locationName:"endpointPrivateAccess" type:"boolean"`

	// Set this value to false to disable public access to your cluster's Kubernetes
	// API server endpoint. If you disable public access, your cluster's Kubernetes
	// API server can only receive requests from within the cluster VPC. The default
	// value for this parameter is true, which enables public access for your Kubernetes
	// API server. For more information, see Amazon EKS cluster endpoint access
	// control (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
	// in the Amazon EKS User Guide .
	EndpointPublicAccess *bool `locationName:"endpointPublicAccess" type:"boolean"`

	// The CIDR blocks that are allowed access to your cluster's public Kubernetes
	// API server endpoint. Communication to the endpoint from addresses outside
	// of the CIDR blocks that you specify is denied. The default value is 0.0.0.0/0.
	// If you've disabled private endpoint access and you have nodes or Fargate
	// pods in the cluster, then ensure that you specify the necessary CIDR blocks.
	// For more information, see Amazon EKS cluster endpoint access control (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
	// in the Amazon EKS User Guide .
	PublicAccessCidrs []*string `locationName:"publicAccessCidrs" type:"list"`

	// Specify one or more security groups for the cross-account elastic network
	// interfaces that Amazon EKS creates to use that allow communication between
	// your nodes and the Kubernetes control plane. If you don't specify any security
	// groups, then familiarize yourself with the difference between Amazon EKS
	// defaults for clusters deployed with Kubernetes:
	//
	//    * 1.14 Amazon EKS platform version eks.2 and earlier
	//
	//    * 1.14 Amazon EKS platform version eks.3 and later
	//
	// For more information, see Amazon EKS security group considerations (https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html)
	// in the Amazon EKS User Guide .
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// Specify subnets for your Amazon EKS nodes. Amazon EKS creates cross-account
	// elastic network interfaces in these subnets to allow communication between
	// your nodes and the Kubernetes control plane.
	SubnetIds []*string `locationName:"subnetIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfigRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfigRequest) GoString() string {
	return s.String()
}

// SetEndpointPrivateAccess sets the EndpointPrivateAccess field's value.
func (s *VpcConfigRequest) SetEndpointPrivateAccess(v bool) *VpcConfigRequest {
	s.EndpointPrivateAccess = &v
	return s
}

// SetEndpointPublicAccess sets the EndpointPublicAccess field's value.
func (s *VpcConfigRequest) SetEndpointPublicAccess(v bool) *VpcConfigRequest {
	s.EndpointPublicAccess = &v
	return s
}

// SetPublicAccessCidrs sets the PublicAccessCidrs field's value.
func (s *VpcConfigRequest) SetPublicAccessCidrs(v []*string) *VpcConfigRequest {
	s.PublicAccessCidrs = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfigRequest) SetSecurityGroupIds(v []*string) *VpcConfigRequest {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfigRequest) SetSubnetIds(v []*string) *VpcConfigRequest {
	s.SubnetIds = v
	return s
}

// An object representing an Amazon EKS cluster VPC configuration response.
type VpcConfigResponse struct {
	_ struct{} `type:"structure"`

	// The cluster security group that was created by Amazon EKS for the cluster.
	// Managed node groups use this security group for control-plane-to-data-plane
	// communication.
	ClusterSecurityGroupId *string `locationName:"clusterSecurityGroupId" type:"string"`

	// This parameter indicates whether the Amazon EKS private API server endpoint
	// is enabled. If the Amazon EKS private API server endpoint is enabled, Kubernetes
	// API requests that originate from within your cluster's VPC use the private
	// VPC endpoint instead of traversing the internet. If this value is disabled
	// and you have nodes or Fargate pods in the cluster, then ensure that publicAccessCidrs
	// includes the necessary CIDR blocks for communication with the nodes or Fargate
	// pods. For more information, see Amazon EKS cluster endpoint access control
	// (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
	// in the Amazon EKS User Guide .
	EndpointPrivateAccess *bool `locationName:"endpointPrivateAccess" type:"boolean"`

	// This parameter indicates whether the Amazon EKS public API server endpoint
	// is enabled. If the Amazon EKS public API server endpoint is disabled, your
	// cluster's Kubernetes API server can only receive requests that originate
	// from within the cluster VPC.
	EndpointPublicAccess *bool `locationName:"endpointPublicAccess" type:"boolean"`

	// The CIDR blocks that are allowed access to your cluster's public Kubernetes
	// API server endpoint. Communication to the endpoint from addresses outside
	// of the listed CIDR blocks is denied. The default value is 0.0.0.0/0. If you've
	// disabled private endpoint access and you have nodes or Fargate pods in the
	// cluster, then ensure that the necessary CIDR blocks are listed. For more
	// information, see Amazon EKS cluster endpoint access control (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
	// in the Amazon EKS User Guide .
	PublicAccessCidrs []*string `locationName:"publicAccessCidrs" type:"list"`

	// The security groups associated with the cross-account elastic network interfaces
	// that are used to allow communication between your nodes and the Kubernetes
	// control plane.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// The subnets associated with your cluster.
	SubnetIds []*string `locationName:"subnetIds" type:"list"`

	// The VPC associated with your cluster.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfigResponse) GoString() string {
	return s.String()
}

// SetClusterSecurityGroupId sets the ClusterSecurityGroupId field's value.
func (s *VpcConfigResponse) SetClusterSecurityGroupId(v string) *VpcConfigResponse {
	s.ClusterSecurityGroupId = &v
	return s
}

// SetEndpointPrivateAccess sets the EndpointPrivateAccess field's value.
func (s *VpcConfigResponse) SetEndpointPrivateAccess(v bool) *VpcConfigResponse {
	s.EndpointPrivateAccess = &v
	return s
}

// SetEndpointPublicAccess sets the EndpointPublicAccess field's value.
func (s *VpcConfigResponse) SetEndpointPublicAccess(v bool) *VpcConfigResponse {
	s.EndpointPublicAccess = &v
	return s
}

// SetPublicAccessCidrs sets the PublicAccessCidrs field's value.
func (s *VpcConfigResponse) SetPublicAccessCidrs(v []*string) *VpcConfigResponse {
	s.PublicAccessCidrs = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfigResponse) SetSecurityGroupIds(v []*string) *VpcConfigResponse {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfigResponse) SetSubnetIds(v []*string) *VpcConfigResponse {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *VpcConfigResponse) SetVpcId(v string) *VpcConfigResponse {
	s.VpcId = &v
	return s
}

const (
	// AMITypesAl2X8664 is a AMITypes enum value
	AMITypesAl2X8664 = "AL2_x86_64"

	// AMITypesAl2X8664Gpu is a AMITypes enum value
	AMITypesAl2X8664Gpu = "AL2_x86_64_GPU"

	// AMITypesAl2Arm64 is a AMITypes enum value
	AMITypesAl2Arm64 = "AL2_ARM_64"

	// AMITypesCustom is a AMITypes enum value
	AMITypesCustom = "CUSTOM"
)

// AMITypes_Values returns all elements of the AMITypes enum
func AMITypes_Values() []string {
	return []string{
		AMITypesAl2X8664,
		AMITypesAl2X8664Gpu,
		AMITypesAl2Arm64,
		AMITypesCustom,
	}
}

const (
	// AddonIssueCodeAccessDenied is a AddonIssueCode enum value
	AddonIssueCodeAccessDenied = "AccessDenied"

	// AddonIssueCodeInternalFailure is a AddonIssueCode enum value
	AddonIssueCodeInternalFailure = "InternalFailure"

	// AddonIssueCodeClusterUnreachable is a AddonIssueCode enum value
	AddonIssueCodeClusterUnreachable = "ClusterUnreachable"

	// AddonIssueCodeInsufficientNumberOfReplicas is a AddonIssueCode enum value
	AddonIssueCodeInsufficientNumberOfReplicas = "InsufficientNumberOfReplicas"

	// AddonIssueCodeConfigurationConflict is a AddonIssueCode enum value
	AddonIssueCodeConfigurationConflict = "ConfigurationConflict"

	// AddonIssueCodeAdmissionRequestDenied is a AddonIssueCode enum value
	AddonIssueCodeAdmissionRequestDenied = "AdmissionRequestDenied"

	// AddonIssueCodeUnsupportedAddonModification is a AddonIssueCode enum value
	AddonIssueCodeUnsupportedAddonModification = "UnsupportedAddonModification"

	// AddonIssueCodeK8sResourceNotFound is a AddonIssueCode enum value
	AddonIssueCodeK8sResourceNotFound = "K8sResourceNotFound"
)

// AddonIssueCode_Values returns all elements of the AddonIssueCode enum
func AddonIssueCode_Values() []string {
	return []string{
		AddonIssueCodeAccessDenied,
		AddonIssueCodeInternalFailure,
		AddonIssueCodeClusterUnreachable,
		AddonIssueCodeInsufficientNumberOfReplicas,
		AddonIssueCodeConfigurationConflict,
		AddonIssueCodeAdmissionRequestDenied,
		AddonIssueCodeUnsupportedAddonModification,
		AddonIssueCodeK8sResourceNotFound,
	}
}

const (
	// AddonStatusCreating is a AddonStatus enum value
	AddonStatusCreating = "CREATING"

	// AddonStatusActive is a AddonStatus enum value
	AddonStatusActive = "ACTIVE"

	// AddonStatusCreateFailed is a AddonStatus enum value
	AddonStatusCreateFailed = "CREATE_FAILED"

	// AddonStatusUpdating is a AddonStatus enum value
	AddonStatusUpdating = "UPDATING"

	// AddonStatusDeleting is a AddonStatus enum value
	AddonStatusDeleting = "DELETING"

	// AddonStatusDeleteFailed is a AddonStatus enum value
	AddonStatusDeleteFailed = "DELETE_FAILED"

	// AddonStatusDegraded is a AddonStatus enum value
	AddonStatusDegraded = "DEGRADED"
)

// AddonStatus_Values returns all elements of the AddonStatus enum
func AddonStatus_Values() []string {
	return []string{
		AddonStatusCreating,
		AddonStatusActive,
		AddonStatusCreateFailed,
		AddonStatusUpdating,
		AddonStatusDeleting,
		AddonStatusDeleteFailed,
		AddonStatusDegraded,
	}
}

const (
	// CapacityTypesOnDemand is a CapacityTypes enum value
	CapacityTypesOnDemand = "ON_DEMAND"

	// CapacityTypesSpot is a CapacityTypes enum value
	CapacityTypesSpot = "SPOT"
)

// CapacityTypes_Values returns all elements of the CapacityTypes enum
func CapacityTypes_Values() []string {
	return []string{
		CapacityTypesOnDemand,
		CapacityTypesSpot,
	}
}

const (
	// ClusterStatusCreating is a ClusterStatus enum value
	ClusterStatusCreating = "CREATING"

	// ClusterStatusActive is a ClusterStatus enum value
	ClusterStatusActive = "ACTIVE"

	// ClusterStatusDeleting is a ClusterStatus enum value
	ClusterStatusDeleting = "DELETING"

	// ClusterStatusFailed is a ClusterStatus enum value
	ClusterStatusFailed = "FAILED"

	// ClusterStatusUpdating is a ClusterStatus enum value
	ClusterStatusUpdating = "UPDATING"

	// ClusterStatusPending is a ClusterStatus enum value
	ClusterStatusPending = "PENDING"
)

// ClusterStatus_Values returns all elements of the ClusterStatus enum
func ClusterStatus_Values() []string {
	return []string{
		ClusterStatusCreating,
		ClusterStatusActive,
		ClusterStatusDeleting,
		ClusterStatusFailed,
		ClusterStatusUpdating,
		ClusterStatusPending,
	}
}

const (
	// ConfigStatusCreating is a ConfigStatus enum value
	ConfigStatusCreating = "CREATING"

	// ConfigStatusDeleting is a ConfigStatus enum value
	ConfigStatusDeleting = "DELETING"

	// ConfigStatusActive is a ConfigStatus enum value
	ConfigStatusActive = "ACTIVE"
)

// ConfigStatus_Values returns all elements of the ConfigStatus enum
func ConfigStatus_Values() []string {
	return []string{
		ConfigStatusCreating,
		ConfigStatusDeleting,
		ConfigStatusActive,
	}
}

const (
	// ConnectorConfigProviderEksAnywhere is a ConnectorConfigProvider enum value
	ConnectorConfigProviderEksAnywhere = "EKS_ANYWHERE"

	// ConnectorConfigProviderAnthos is a ConnectorConfigProvider enum value
	ConnectorConfigProviderAnthos = "ANTHOS"

	// ConnectorConfigProviderGke is a ConnectorConfigProvider enum value
	ConnectorConfigProviderGke = "GKE"

	// ConnectorConfigProviderAks is a ConnectorConfigProvider enum value
	ConnectorConfigProviderAks = "AKS"

	// ConnectorConfigProviderOpenshift is a ConnectorConfigProvider enum value
	ConnectorConfigProviderOpenshift = "OPENSHIFT"

	// ConnectorConfigProviderTanzu is a ConnectorConfigProvider enum value
	ConnectorConfigProviderTanzu = "TANZU"

	// ConnectorConfigProviderRancher is a ConnectorConfigProvider enum value
	ConnectorConfigProviderRancher = "RANCHER"

	// ConnectorConfigProviderEc2 is a ConnectorConfigProvider enum value
	ConnectorConfigProviderEc2 = "EC2"

	// ConnectorConfigProviderOther is a ConnectorConfigProvider enum value
	ConnectorConfigProviderOther = "OTHER"
)

// ConnectorConfigProvider_Values returns all elements of the ConnectorConfigProvider enum
func ConnectorConfigProvider_Values() []string {
	return []string{
		ConnectorConfigProviderEksAnywhere,
		ConnectorConfigProviderAnthos,
		ConnectorConfigProviderGke,
		ConnectorConfigProviderAks,
		ConnectorConfigProviderOpenshift,
		ConnectorConfigProviderTanzu,
		ConnectorConfigProviderRancher,
		ConnectorConfigProviderEc2,
		ConnectorConfigProviderOther,
	}
}

const (
	// ErrorCodeSubnetNotFound is a ErrorCode enum value
	ErrorCodeSubnetNotFound = "SubnetNotFound"

	// ErrorCodeSecurityGroupNotFound is a ErrorCode enum value
	ErrorCodeSecurityGroupNotFound = "SecurityGroupNotFound"

	// ErrorCodeEniLimitReached is a ErrorCode enum value
	ErrorCodeEniLimitReached = "EniLimitReached"

	// ErrorCodeIpNotAvailable is a ErrorCode enum value
	ErrorCodeIpNotAvailable = "IpNotAvailable"

	// ErrorCodeAccessDenied is a ErrorCode enum value
	ErrorCodeAccessDenied = "AccessDenied"

	// ErrorCodeOperationNotPermitted is a ErrorCode enum value
	ErrorCodeOperationNotPermitted = "OperationNotPermitted"

	// ErrorCodeVpcIdNotFound is a ErrorCode enum value
	ErrorCodeVpcIdNotFound = "VpcIdNotFound"

	// ErrorCodeUnknown is a ErrorCode enum value
	ErrorCodeUnknown = "Unknown"

	// ErrorCodeNodeCreationFailure is a ErrorCode enum value
	ErrorCodeNodeCreationFailure = "NodeCreationFailure"

	// ErrorCodePodEvictionFailure is a ErrorCode enum value
	ErrorCodePodEvictionFailure = "PodEvictionFailure"

	// ErrorCodeInsufficientFreeAddresses is a ErrorCode enum value
	ErrorCodeInsufficientFreeAddresses = "InsufficientFreeAddresses"

	// ErrorCodeClusterUnreachable is a ErrorCode enum value
	ErrorCodeClusterUnreachable = "ClusterUnreachable"

	// ErrorCodeInsufficientNumberOfReplicas is a ErrorCode enum value
	ErrorCodeInsufficientNumberOfReplicas = "InsufficientNumberOfReplicas"

	// ErrorCodeConfigurationConflict is a ErrorCode enum value
	ErrorCodeConfigurationConflict = "ConfigurationConflict"

	// ErrorCodeAdmissionRequestDenied is a ErrorCode enum value
	ErrorCodeAdmissionRequestDenied = "AdmissionRequestDenied"

	// ErrorCodeUnsupportedAddonModification is a ErrorCode enum value
	ErrorCodeUnsupportedAddonModification = "UnsupportedAddonModification"

	// ErrorCodeK8sResourceNotFound is a ErrorCode enum value
	ErrorCodeK8sResourceNotFound = "K8sResourceNotFound"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeSubnetNotFound,
		ErrorCodeSecurityGroupNotFound,
		ErrorCodeEniLimitReached,
		ErrorCodeIpNotAvailable,
		ErrorCodeAccessDenied,
		ErrorCodeOperationNotPermitted,
		ErrorCodeVpcIdNotFound,
		ErrorCodeUnknown,
		ErrorCodeNodeCreationFailure,
		ErrorCodePodEvictionFailure,
		ErrorCodeInsufficientFreeAddresses,
		ErrorCodeClusterUnreachable,
		ErrorCodeInsufficientNumberOfReplicas,
		ErrorCodeConfigurationConflict,
		ErrorCodeAdmissionRequestDenied,
		ErrorCodeUnsupportedAddonModification,
		ErrorCodeK8sResourceNotFound,
	}
}

const (
	// FargateProfileStatusCreating is a FargateProfileStatus enum value
	FargateProfileStatusCreating = "CREATING"

	// FargateProfileStatusActive is a FargateProfileStatus enum value
	FargateProfileStatusActive = "ACTIVE"

	// FargateProfileStatusDeleting is a FargateProfileStatus enum value
	FargateProfileStatusDeleting = "DELETING"

	// FargateProfileStatusCreateFailed is a FargateProfileStatus enum value
	FargateProfileStatusCreateFailed = "CREATE_FAILED"

	// FargateProfileStatusDeleteFailed is a FargateProfileStatus enum value
	FargateProfileStatusDeleteFailed = "DELETE_FAILED"
)

// FargateProfileStatus_Values returns all elements of the FargateProfileStatus enum
func FargateProfileStatus_Values() []string {
	return []string{
		FargateProfileStatusCreating,
		FargateProfileStatusActive,
		FargateProfileStatusDeleting,
		FargateProfileStatusCreateFailed,
		FargateProfileStatusDeleteFailed,
	}
}

const (
	// LogTypeApi is a LogType enum value
	LogTypeApi = "api"

	// LogTypeAudit is a LogType enum value
	LogTypeAudit = "audit"

	// LogTypeAuthenticator is a LogType enum value
	LogTypeAuthenticator = "authenticator"

	// LogTypeControllerManager is a LogType enum value
	LogTypeControllerManager = "controllerManager"

	// LogTypeScheduler is a LogType enum value
	LogTypeScheduler = "scheduler"
)

// LogType_Values returns all elements of the LogType enum
func LogType_Values() []string {
	return []string{
		LogTypeApi,
		LogTypeAudit,
		LogTypeAuthenticator,
		LogTypeControllerManager,
		LogTypeScheduler,
	}
}

const (
	// NodegroupIssueCodeAutoScalingGroupNotFound is a NodegroupIssueCode enum value
	NodegroupIssueCodeAutoScalingGroupNotFound = "AutoScalingGroupNotFound"

	// NodegroupIssueCodeAutoScalingGroupInvalidConfiguration is a NodegroupIssueCode enum value
	NodegroupIssueCodeAutoScalingGroupInvalidConfiguration = "AutoScalingGroupInvalidConfiguration"

	// NodegroupIssueCodeEc2securityGroupNotFound is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2securityGroupNotFound = "Ec2SecurityGroupNotFound"

	// NodegroupIssueCodeEc2securityGroupDeletionFailure is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2securityGroupDeletionFailure = "Ec2SecurityGroupDeletionFailure"

	// NodegroupIssueCodeEc2launchTemplateNotFound is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2launchTemplateNotFound = "Ec2LaunchTemplateNotFound"

	// NodegroupIssueCodeEc2launchTemplateVersionMismatch is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2launchTemplateVersionMismatch = "Ec2LaunchTemplateVersionMismatch"

	// NodegroupIssueCodeEc2subnetNotFound is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2subnetNotFound = "Ec2SubnetNotFound"

	// NodegroupIssueCodeEc2subnetInvalidConfiguration is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2subnetInvalidConfiguration = "Ec2SubnetInvalidConfiguration"

	// NodegroupIssueCodeIamInstanceProfileNotFound is a NodegroupIssueCode enum value
	NodegroupIssueCodeIamInstanceProfileNotFound = "IamInstanceProfileNotFound"

	// NodegroupIssueCodeIamLimitExceeded is a NodegroupIssueCode enum value
	NodegroupIssueCodeIamLimitExceeded = "IamLimitExceeded"

	// NodegroupIssueCodeIamNodeRoleNotFound is a NodegroupIssueCode enum value
	NodegroupIssueCodeIamNodeRoleNotFound = "IamNodeRoleNotFound"

	// NodegroupIssueCodeNodeCreationFailure is a NodegroupIssueCode enum value
	NodegroupIssueCodeNodeCreationFailure = "NodeCreationFailure"

	// NodegroupIssueCodeAsgInstanceLaunchFailures is a NodegroupIssueCode enum value
	NodegroupIssueCodeAsgInstanceLaunchFailures = "AsgInstanceLaunchFailures"

	// NodegroupIssueCodeInstanceLimitExceeded is a NodegroupIssueCode enum value
	NodegroupIssueCodeInstanceLimitExceeded = "InstanceLimitExceeded"

	// NodegroupIssueCodeInsufficientFreeAddresses is a NodegroupIssueCode enum value
	NodegroupIssueCodeInsufficientFreeAddresses = "InsufficientFreeAddresses"

	// NodegroupIssueCodeAccessDenied is a NodegroupIssueCode enum value
	NodegroupIssueCodeAccessDenied = "AccessDenied"

	// NodegroupIssueCodeInternalFailure is a NodegroupIssueCode enum value
	NodegroupIssueCodeInternalFailure = "InternalFailure"

	// NodegroupIssueCodeClusterUnreachable is a NodegroupIssueCode enum value
	NodegroupIssueCodeClusterUnreachable = "ClusterUnreachable"
)

// NodegroupIssueCode_Values returns all elements of the NodegroupIssueCode enum
func NodegroupIssueCode_Values() []string {
	return []string{
		NodegroupIssueCodeAutoScalingGroupNotFound,
		NodegroupIssueCodeAutoScalingGroupInvalidConfiguration,
		NodegroupIssueCodeEc2securityGroupNotFound,
		NodegroupIssueCodeEc2securityGroupDeletionFailure,
		NodegroupIssueCodeEc2launchTemplateNotFound,
		NodegroupIssueCodeEc2launchTemplateVersionMismatch,
		NodegroupIssueCodeEc2subnetNotFound,
		NodegroupIssueCodeEc2subnetInvalidConfiguration,
		NodegroupIssueCodeIamInstanceProfileNotFound,
		NodegroupIssueCodeIamLimitExceeded,
		NodegroupIssueCodeIamNodeRoleNotFound,
		NodegroupIssueCodeNodeCreationFailure,
		NodegroupIssueCodeAsgInstanceLaunchFailures,
		NodegroupIssueCodeInstanceLimitExceeded,
		NodegroupIssueCodeInsufficientFreeAddresses,
		NodegroupIssueCodeAccessDenied,
		NodegroupIssueCodeInternalFailure,
		NodegroupIssueCodeClusterUnreachable,
	}
}

const (
	// NodegroupStatusCreating is a NodegroupStatus enum value
	NodegroupStatusCreating = "CREATING"

	// NodegroupStatusActive is a NodegroupStatus enum value
	NodegroupStatusActive = "ACTIVE"

	// NodegroupStatusUpdating is a NodegroupStatus enum value
	NodegroupStatusUpdating = "UPDATING"

	// NodegroupStatusDeleting is a NodegroupStatus enum value
	NodegroupStatusDeleting = "DELETING"

	// NodegroupStatusCreateFailed is a NodegroupStatus enum value
	NodegroupStatusCreateFailed = "CREATE_FAILED"

	// NodegroupStatusDeleteFailed is a NodegroupStatus enum value
	NodegroupStatusDeleteFailed = "DELETE_FAILED"

	// NodegroupStatusDegraded is a NodegroupStatus enum value
	NodegroupStatusDegraded = "DEGRADED"
)

// NodegroupStatus_Values returns all elements of the NodegroupStatus enum
func NodegroupStatus_Values() []string {
	return []string{
		NodegroupStatusCreating,
		NodegroupStatusActive,
		NodegroupStatusUpdating,
		NodegroupStatusDeleting,
		NodegroupStatusCreateFailed,
		NodegroupStatusDeleteFailed,
		NodegroupStatusDegraded,
	}
}

const (
	// ResolveConflictsOverwrite is a ResolveConflicts enum value
	ResolveConflictsOverwrite = "OVERWRITE"

	// ResolveConflictsNone is a ResolveConflicts enum value
	ResolveConflictsNone = "NONE"
)

// ResolveConflicts_Values returns all elements of the ResolveConflicts enum
func ResolveConflicts_Values() []string {
	return []string{
		ResolveConflictsOverwrite,
		ResolveConflictsNone,
	}
}

const (
	// TaintEffectNoSchedule is a TaintEffect enum value
	TaintEffectNoSchedule = "NO_SCHEDULE"

	// TaintEffectNoExecute is a TaintEffect enum value
	TaintEffectNoExecute = "NO_EXECUTE"

	// TaintEffectPreferNoSchedule is a TaintEffect enum value
	TaintEffectPreferNoSchedule = "PREFER_NO_SCHEDULE"
)

// TaintEffect_Values returns all elements of the TaintEffect enum
func TaintEffect_Values() []string {
	return []string{
		TaintEffectNoSchedule,
		TaintEffectNoExecute,
		TaintEffectPreferNoSchedule,
	}
}

const (
	// UpdateParamTypeVersion is a UpdateParamType enum value
	UpdateParamTypeVersion = "Version"

	// UpdateParamTypePlatformVersion is a UpdateParamType enum value
	UpdateParamTypePlatformVersion = "PlatformVersion"

	// UpdateParamTypeEndpointPrivateAccess is a UpdateParamType enum value
	UpdateParamTypeEndpointPrivateAccess = "EndpointPrivateAccess"

	// UpdateParamTypeEndpointPublicAccess is a UpdateParamType enum value
	UpdateParamTypeEndpointPublicAccess = "EndpointPublicAccess"

	// UpdateParamTypeClusterLogging is a UpdateParamType enum value
	UpdateParamTypeClusterLogging = "ClusterLogging"

	// UpdateParamTypeDesiredSize is a UpdateParamType enum value
	UpdateParamTypeDesiredSize = "DesiredSize"

	// UpdateParamTypeLabelsToAdd is a UpdateParamType enum value
	UpdateParamTypeLabelsToAdd = "LabelsToAdd"

	// UpdateParamTypeLabelsToRemove is a UpdateParamType enum value
	UpdateParamTypeLabelsToRemove = "LabelsToRemove"

	// UpdateParamTypeTaintsToAdd is a UpdateParamType enum value
	UpdateParamTypeTaintsToAdd = "TaintsToAdd"

	// UpdateParamTypeTaintsToRemove is a UpdateParamType enum value
	UpdateParamTypeTaintsToRemove = "TaintsToRemove"

	// UpdateParamTypeMaxSize is a UpdateParamType enum value
	UpdateParamTypeMaxSize = "MaxSize"

	// UpdateParamTypeMinSize is a UpdateParamType enum value
	UpdateParamTypeMinSize = "MinSize"

	// UpdateParamTypeReleaseVersion is a UpdateParamType enum value
	UpdateParamTypeReleaseVersion = "ReleaseVersion"

	// UpdateParamTypePublicAccessCidrs is a UpdateParamType enum value
	UpdateParamTypePublicAccessCidrs = "PublicAccessCidrs"

	// UpdateParamTypeLaunchTemplateName is a UpdateParamType enum value
	UpdateParamTypeLaunchTemplateName = "LaunchTemplateName"

	// UpdateParamTypeLaunchTemplateVersion is a UpdateParamType enum value
	UpdateParamTypeLaunchTemplateVersion = "LaunchTemplateVersion"

	// UpdateParamTypeIdentityProviderConfig is a UpdateParamType enum value
	UpdateParamTypeIdentityProviderConfig = "IdentityProviderConfig"

	// UpdateParamTypeEncryptionConfig is a UpdateParamType enum value
	UpdateParamTypeEncryptionConfig = "EncryptionConfig"

	// UpdateParamTypeAddonVersion is a UpdateParamType enum value
	UpdateParamTypeAddonVersion = "AddonVersion"

	// UpdateParamTypeServiceAccountRoleArn is a UpdateParamType enum value
	UpdateParamTypeServiceAccountRoleArn = "ServiceAccountRoleArn"

	// UpdateParamTypeResolveConflicts is a UpdateParamType enum value
	UpdateParamTypeResolveConflicts = "ResolveConflicts"

	// UpdateParamTypeMaxUnavailable is a UpdateParamType enum value
	UpdateParamTypeMaxUnavailable = "MaxUnavailable"

	// UpdateParamTypeMaxUnavailablePercentage is a UpdateParamType enum value
	UpdateParamTypeMaxUnavailablePercentage = "MaxUnavailablePercentage"
)

// UpdateParamType_Values returns all elements of the UpdateParamType enum
func UpdateParamType_Values() []string {
	return []string{
		UpdateParamTypeVersion,
		UpdateParamTypePlatformVersion,
		UpdateParamTypeEndpointPrivateAccess,
		UpdateParamTypeEndpointPublicAccess,
		UpdateParamTypeClusterLogging,
		UpdateParamTypeDesiredSize,
		UpdateParamTypeLabelsToAdd,
		UpdateParamTypeLabelsToRemove,
		UpdateParamTypeTaintsToAdd,
		UpdateParamTypeTaintsToRemove,
		UpdateParamTypeMaxSize,
		UpdateParamTypeMinSize,
		UpdateParamTypeReleaseVersion,
		UpdateParamTypePublicAccessCidrs,
		UpdateParamTypeLaunchTemplateName,
		UpdateParamTypeLaunchTemplateVersion,
		UpdateParamTypeIdentityProviderConfig,
		UpdateParamTypeEncryptionConfig,
		UpdateParamTypeAddonVersion,
		UpdateParamTypeServiceAccountRoleArn,
		UpdateParamTypeResolveConflicts,
		UpdateParamTypeMaxUnavailable,
		UpdateParamTypeMaxUnavailablePercentage,
	}
}

const (
	// UpdateStatusInProgress is a UpdateStatus enum value
	UpdateStatusInProgress = "InProgress"

	// UpdateStatusFailed is a UpdateStatus enum value
	UpdateStatusFailed = "Failed"

	// UpdateStatusCancelled is a UpdateStatus enum value
	UpdateStatusCancelled = "Cancelled"

	// UpdateStatusSuccessful is a UpdateStatus enum value
	UpdateStatusSuccessful = "Successful"
)

// UpdateStatus_Values returns all elements of the UpdateStatus enum
func UpdateStatus_Values() []string {
	return []string{
		UpdateStatusInProgress,
		UpdateStatusFailed,
		UpdateStatusCancelled,
		UpdateStatusSuccessful,
	}
}

const (
	// UpdateTypeVersionUpdate is a UpdateType enum value
	UpdateTypeVersionUpdate = "VersionUpdate"

	// UpdateTypeEndpointAccessUpdate is a UpdateType enum value
	UpdateTypeEndpointAccessUpdate = "EndpointAccessUpdate"

	// UpdateTypeLoggingUpdate is a UpdateType enum value
	UpdateTypeLoggingUpdate = "LoggingUpdate"

	// UpdateTypeConfigUpdate is a UpdateType enum value
	UpdateTypeConfigUpdate = "ConfigUpdate"

	// UpdateTypeAssociateIdentityProviderConfig is a UpdateType enum value
	UpdateTypeAssociateIdentityProviderConfig = "AssociateIdentityProviderConfig"

	// UpdateTypeDisassociateIdentityProviderConfig is a UpdateType enum value
	UpdateTypeDisassociateIdentityProviderConfig = "DisassociateIdentityProviderConfig"

	// UpdateTypeAssociateEncryptionConfig is a UpdateType enum value
	UpdateTypeAssociateEncryptionConfig = "AssociateEncryptionConfig"

	// UpdateTypeAddonUpdate is a UpdateType enum value
	UpdateTypeAddonUpdate = "AddonUpdate"
)

// UpdateType_Values returns all elements of the UpdateType enum
func UpdateType_Values() []string {
	return []string{
		UpdateTypeVersionUpdate,
		UpdateTypeEndpointAccessUpdate,
		UpdateTypeLoggingUpdate,
		UpdateTypeConfigUpdate,
		UpdateTypeAssociateIdentityProviderConfig,
		UpdateTypeDisassociateIdentityProviderConfig,
		UpdateTypeAssociateEncryptionConfig,
		UpdateTypeAddonUpdate,
	}
}
