package acme

import (
	"strconv"

	"github.com/coredns/coredns/plugin"
	"github.com/miekg/dns"
	"github.com/prometheus/client_golang/prometheus"
	"github.com/prometheus/client_golang/prometheus/promauto"
)

var (
	dns01ResponseCount = promauto.NewCounterVec(prometheus.CounterOpts{
		Namespace: plugin.Namespace,
		Subsystem: "forge_" + pluginName,
		Name:      "dns01_responses_total",
		Help:      "The count of DNS-01 TXT responses generated by p2p-forge plugin.",
	}, []string{"type"})
	peerProbeCount = promauto.NewCounterVec(prometheus.CounterOpts{
		Namespace: plugin.Namespace,
		Subsystem: "forge_" + pluginName,
		Name:      "libp2p_probe_total",
		Help:      "The count of libp2p probes performed before accepting registration by p2p-forge plugin.",
	}, []string{"result", "agent"})
)

func dnsToString(dnsType uint16) string {
	if str, ok := dns.TypeToString[dnsType]; ok {
		return str
	}
	return strconv.Itoa(int(dnsType))
}
