## p2p-forge metrics

Prometheus endpoint is exposed at `http://localhost:9253/metrics`

It includes default [Prometheus Glient metrics](https://prometheus.io/docs/guides/go-application/) + [CoreDNS](#coredns) + [p2p-forge](#forge-metrics)-specific listed below.

### Forge metrics

- `coredns_forge_info{version}` - info about p2p-forge instance, useful for tracking when version update occured on each box

#### `ipparser` plugin (DNS A/AAAA)

- `coredns_forge_ipparser_responses_total{type}` - dynamic DNS `A`/`AAAA` responses generated by `ipparser` plugin for `ip.peerid.domain` and `peerid.domain`, including `NODATA-*` ones.

#### `acme` plugin (HTTP/ACME registration)

- `coredns_forge_acme_http_request_duration_seconds{code, handler}` - Histogram with the status, count and latency of the HTTP requests sent to path specified in `handler` (like `/v1/_acme-challenge`).
- `coredns_forge_acme_http_requests_inflight{handler}` - The number of inflight requests being handled by `handler`.
- `coredns_forge_acme_dns01_responses_total{type}` - DNS `TXT` responses generated by `acme` plugin for DNS-01 challenge at `_acme-challenge.peerid.domain`, including `NODATA-*` ones.
- `coredns_forge_acme_libp2p_probe_total{result, agent}` - libp2p probe results `acme` plugin when testing connectivity before accepting DNS-01 challenge for a PeerID. `status` is either `ok` or `error` and `agent` value is limited to well known agents, `other` and `unknown`.

### CoreDNS metrics

In addition to the default Go metrics exported by the [Prometheus Go client](https://prometheus.io/docs/guides/go-application/), the following metrics are exported:

- `coredns_build_info{version, revision, goversion}` - info about CoreDNS itself.
- `coredns_panics_total{}` - total number of panics.
- `coredns_dns_requests_total{server, zone, view, proto, family, type}` - total query count.
- `coredns_dns_request_duration_seconds{server, zone, view, type}` - duration to process each query.
- `coredns_dns_request_size_bytes{server, zone, view, proto}` - size of the request in bytes.
- `coredns_dns_do_requests_total{server, view, zone}` - queries that have the DO bit set
- `coredns_dns_response_size_bytes{server, zone, view, proto}` - response size in bytes.
- `coredns_dns_responses_total{server, zone, view, rcode, plugin}` - response per zone, rcode and plugin.
- `coredns_dns_https_responses_total{server, status}` - responses per server and http status code.
- `coredns_dns_quic_responses_total{server, status}` - responses per server and QUIC application code.
- `coredns_plugin_enabled{server, zone, view, name}` - indicates whether a plugin is enabled on per server, zone and view basis.
