// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1beta1/specialist_pool_service.proto

package aiplatformpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	SpecialistPoolService_CreateSpecialistPool_FullMethodName = "/google.cloud.aiplatform.v1beta1.SpecialistPoolService/CreateSpecialistPool"
	SpecialistPoolService_GetSpecialistPool_FullMethodName    = "/google.cloud.aiplatform.v1beta1.SpecialistPoolService/GetSpecialistPool"
	SpecialistPoolService_ListSpecialistPools_FullMethodName  = "/google.cloud.aiplatform.v1beta1.SpecialistPoolService/ListSpecialistPools"
	SpecialistPoolService_DeleteSpecialistPool_FullMethodName = "/google.cloud.aiplatform.v1beta1.SpecialistPoolService/DeleteSpecialistPool"
	SpecialistPoolService_UpdateSpecialistPool_FullMethodName = "/google.cloud.aiplatform.v1beta1.SpecialistPoolService/UpdateSpecialistPool"
)

// SpecialistPoolServiceClient is the client API for SpecialistPoolService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SpecialistPoolServiceClient interface {
	// Creates a SpecialistPool.
	CreateSpecialistPool(ctx context.Context, in *CreateSpecialistPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a SpecialistPool.
	GetSpecialistPool(ctx context.Context, in *GetSpecialistPoolRequest, opts ...grpc.CallOption) (*SpecialistPool, error)
	// Lists SpecialistPools in a Location.
	ListSpecialistPools(ctx context.Context, in *ListSpecialistPoolsRequest, opts ...grpc.CallOption) (*ListSpecialistPoolsResponse, error)
	// Deletes a SpecialistPool as well as all Specialists in the pool.
	DeleteSpecialistPool(ctx context.Context, in *DeleteSpecialistPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a SpecialistPool.
	UpdateSpecialistPool(ctx context.Context, in *UpdateSpecialistPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type specialistPoolServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSpecialistPoolServiceClient(cc grpc.ClientConnInterface) SpecialistPoolServiceClient {
	return &specialistPoolServiceClient{cc}
}

func (c *specialistPoolServiceClient) CreateSpecialistPool(ctx context.Context, in *CreateSpecialistPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, SpecialistPoolService_CreateSpecialistPool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *specialistPoolServiceClient) GetSpecialistPool(ctx context.Context, in *GetSpecialistPoolRequest, opts ...grpc.CallOption) (*SpecialistPool, error) {
	out := new(SpecialistPool)
	err := c.cc.Invoke(ctx, SpecialistPoolService_GetSpecialistPool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *specialistPoolServiceClient) ListSpecialistPools(ctx context.Context, in *ListSpecialistPoolsRequest, opts ...grpc.CallOption) (*ListSpecialistPoolsResponse, error) {
	out := new(ListSpecialistPoolsResponse)
	err := c.cc.Invoke(ctx, SpecialistPoolService_ListSpecialistPools_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *specialistPoolServiceClient) DeleteSpecialistPool(ctx context.Context, in *DeleteSpecialistPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, SpecialistPoolService_DeleteSpecialistPool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *specialistPoolServiceClient) UpdateSpecialistPool(ctx context.Context, in *UpdateSpecialistPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, SpecialistPoolService_UpdateSpecialistPool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SpecialistPoolServiceServer is the server API for SpecialistPoolService service.
// All implementations should embed UnimplementedSpecialistPoolServiceServer
// for forward compatibility
type SpecialistPoolServiceServer interface {
	// Creates a SpecialistPool.
	CreateSpecialistPool(context.Context, *CreateSpecialistPoolRequest) (*longrunningpb.Operation, error)
	// Gets a SpecialistPool.
	GetSpecialistPool(context.Context, *GetSpecialistPoolRequest) (*SpecialistPool, error)
	// Lists SpecialistPools in a Location.
	ListSpecialistPools(context.Context, *ListSpecialistPoolsRequest) (*ListSpecialistPoolsResponse, error)
	// Deletes a SpecialistPool as well as all Specialists in the pool.
	DeleteSpecialistPool(context.Context, *DeleteSpecialistPoolRequest) (*longrunningpb.Operation, error)
	// Updates a SpecialistPool.
	UpdateSpecialistPool(context.Context, *UpdateSpecialistPoolRequest) (*longrunningpb.Operation, error)
}

// UnimplementedSpecialistPoolServiceServer should be embedded to have forward compatible implementations.
type UnimplementedSpecialistPoolServiceServer struct {
}

func (UnimplementedSpecialistPoolServiceServer) CreateSpecialistPool(context.Context, *CreateSpecialistPoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSpecialistPool not implemented")
}
func (UnimplementedSpecialistPoolServiceServer) GetSpecialistPool(context.Context, *GetSpecialistPoolRequest) (*SpecialistPool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSpecialistPool not implemented")
}
func (UnimplementedSpecialistPoolServiceServer) ListSpecialistPools(context.Context, *ListSpecialistPoolsRequest) (*ListSpecialistPoolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSpecialistPools not implemented")
}
func (UnimplementedSpecialistPoolServiceServer) DeleteSpecialistPool(context.Context, *DeleteSpecialistPoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSpecialistPool not implemented")
}
func (UnimplementedSpecialistPoolServiceServer) UpdateSpecialistPool(context.Context, *UpdateSpecialistPoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSpecialistPool not implemented")
}

// UnsafeSpecialistPoolServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SpecialistPoolServiceServer will
// result in compilation errors.
type UnsafeSpecialistPoolServiceServer interface {
	mustEmbedUnimplementedSpecialistPoolServiceServer()
}

func RegisterSpecialistPoolServiceServer(s grpc.ServiceRegistrar, srv SpecialistPoolServiceServer) {
	s.RegisterService(&SpecialistPoolService_ServiceDesc, srv)
}

func _SpecialistPoolService_CreateSpecialistPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSpecialistPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpecialistPoolServiceServer).CreateSpecialistPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SpecialistPoolService_CreateSpecialistPool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpecialistPoolServiceServer).CreateSpecialistPool(ctx, req.(*CreateSpecialistPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SpecialistPoolService_GetSpecialistPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSpecialistPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpecialistPoolServiceServer).GetSpecialistPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SpecialistPoolService_GetSpecialistPool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpecialistPoolServiceServer).GetSpecialistPool(ctx, req.(*GetSpecialistPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SpecialistPoolService_ListSpecialistPools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSpecialistPoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpecialistPoolServiceServer).ListSpecialistPools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SpecialistPoolService_ListSpecialistPools_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpecialistPoolServiceServer).ListSpecialistPools(ctx, req.(*ListSpecialistPoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SpecialistPoolService_DeleteSpecialistPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSpecialistPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpecialistPoolServiceServer).DeleteSpecialistPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SpecialistPoolService_DeleteSpecialistPool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpecialistPoolServiceServer).DeleteSpecialistPool(ctx, req.(*DeleteSpecialistPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SpecialistPoolService_UpdateSpecialistPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSpecialistPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpecialistPoolServiceServer).UpdateSpecialistPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SpecialistPoolService_UpdateSpecialistPool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpecialistPoolServiceServer).UpdateSpecialistPool(ctx, req.(*UpdateSpecialistPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// SpecialistPoolService_ServiceDesc is the grpc.ServiceDesc for SpecialistPoolService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SpecialistPoolService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.SpecialistPoolService",
	HandlerType: (*SpecialistPoolServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSpecialistPool",
			Handler:    _SpecialistPoolService_CreateSpecialistPool_Handler,
		},
		{
			MethodName: "GetSpecialistPool",
			Handler:    _SpecialistPoolService_GetSpecialistPool_Handler,
		},
		{
			MethodName: "ListSpecialistPools",
			Handler:    _SpecialistPoolService_ListSpecialistPools_Handler,
		},
		{
			MethodName: "DeleteSpecialistPool",
			Handler:    _SpecialistPoolService_DeleteSpecialistPool_Handler,
		},
		{
			MethodName: "UpdateSpecialistPool",
			Handler:    _SpecialistPoolService_UpdateSpecialistPool_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/specialist_pool_service.proto",
}
