// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1beta1/extension_execution_service.proto

package aiplatformpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ExtensionExecutionService_ExecuteExtension_FullMethodName = "/google.cloud.aiplatform.v1beta1.ExtensionExecutionService/ExecuteExtension"
	ExtensionExecutionService_QueryExtension_FullMethodName   = "/google.cloud.aiplatform.v1beta1.ExtensionExecutionService/QueryExtension"
)

// ExtensionExecutionServiceClient is the client API for ExtensionExecutionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ExtensionExecutionServiceClient interface {
	// Executes the request against a given extension.
	ExecuteExtension(ctx context.Context, in *ExecuteExtensionRequest, opts ...grpc.CallOption) (*ExecuteExtensionResponse, error)
	// Queries an extension with a default controller.
	QueryExtension(ctx context.Context, in *QueryExtensionRequest, opts ...grpc.CallOption) (*QueryExtensionResponse, error)
}

type extensionExecutionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewExtensionExecutionServiceClient(cc grpc.ClientConnInterface) ExtensionExecutionServiceClient {
	return &extensionExecutionServiceClient{cc}
}

func (c *extensionExecutionServiceClient) ExecuteExtension(ctx context.Context, in *ExecuteExtensionRequest, opts ...grpc.CallOption) (*ExecuteExtensionResponse, error) {
	out := new(ExecuteExtensionResponse)
	err := c.cc.Invoke(ctx, ExtensionExecutionService_ExecuteExtension_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *extensionExecutionServiceClient) QueryExtension(ctx context.Context, in *QueryExtensionRequest, opts ...grpc.CallOption) (*QueryExtensionResponse, error) {
	out := new(QueryExtensionResponse)
	err := c.cc.Invoke(ctx, ExtensionExecutionService_QueryExtension_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ExtensionExecutionServiceServer is the server API for ExtensionExecutionService service.
// All implementations should embed UnimplementedExtensionExecutionServiceServer
// for forward compatibility
type ExtensionExecutionServiceServer interface {
	// Executes the request against a given extension.
	ExecuteExtension(context.Context, *ExecuteExtensionRequest) (*ExecuteExtensionResponse, error)
	// Queries an extension with a default controller.
	QueryExtension(context.Context, *QueryExtensionRequest) (*QueryExtensionResponse, error)
}

// UnimplementedExtensionExecutionServiceServer should be embedded to have forward compatible implementations.
type UnimplementedExtensionExecutionServiceServer struct {
}

func (UnimplementedExtensionExecutionServiceServer) ExecuteExtension(context.Context, *ExecuteExtensionRequest) (*ExecuteExtensionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExecuteExtension not implemented")
}
func (UnimplementedExtensionExecutionServiceServer) QueryExtension(context.Context, *QueryExtensionRequest) (*QueryExtensionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryExtension not implemented")
}

// UnsafeExtensionExecutionServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ExtensionExecutionServiceServer will
// result in compilation errors.
type UnsafeExtensionExecutionServiceServer interface {
	mustEmbedUnimplementedExtensionExecutionServiceServer()
}

func RegisterExtensionExecutionServiceServer(s grpc.ServiceRegistrar, srv ExtensionExecutionServiceServer) {
	s.RegisterService(&ExtensionExecutionService_ServiceDesc, srv)
}

func _ExtensionExecutionService_ExecuteExtension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecuteExtensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExtensionExecutionServiceServer).ExecuteExtension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ExtensionExecutionService_ExecuteExtension_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExtensionExecutionServiceServer).ExecuteExtension(ctx, req.(*ExecuteExtensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExtensionExecutionService_QueryExtension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryExtensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExtensionExecutionServiceServer).QueryExtension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ExtensionExecutionService_QueryExtension_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExtensionExecutionServiceServer).QueryExtension(ctx, req.(*QueryExtensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ExtensionExecutionService_ServiceDesc is the grpc.ServiceDesc for ExtensionExecutionService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ExtensionExecutionService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.ExtensionExecutionService",
	HandlerType: (*ExtensionExecutionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ExecuteExtension",
			Handler:    _ExtensionExecutionService_ExecuteExtension_Handler,
		},
		{
			MethodName: "QueryExtension",
			Handler:    _ExtensionExecutionService_QueryExtension_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/extension_execution_service.proto",
}
