// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1beta1/job_service.proto

package aiplatformpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	JobService_CreateCustomJob_FullMethodName                               = "/google.cloud.aiplatform.v1beta1.JobService/CreateCustomJob"
	JobService_GetCustomJob_FullMethodName                                  = "/google.cloud.aiplatform.v1beta1.JobService/GetCustomJob"
	JobService_ListCustomJobs_FullMethodName                                = "/google.cloud.aiplatform.v1beta1.JobService/ListCustomJobs"
	JobService_DeleteCustomJob_FullMethodName                               = "/google.cloud.aiplatform.v1beta1.JobService/DeleteCustomJob"
	JobService_CancelCustomJob_FullMethodName                               = "/google.cloud.aiplatform.v1beta1.JobService/CancelCustomJob"
	JobService_CreateDataLabelingJob_FullMethodName                         = "/google.cloud.aiplatform.v1beta1.JobService/CreateDataLabelingJob"
	JobService_GetDataLabelingJob_FullMethodName                            = "/google.cloud.aiplatform.v1beta1.JobService/GetDataLabelingJob"
	JobService_ListDataLabelingJobs_FullMethodName                          = "/google.cloud.aiplatform.v1beta1.JobService/ListDataLabelingJobs"
	JobService_DeleteDataLabelingJob_FullMethodName                         = "/google.cloud.aiplatform.v1beta1.JobService/DeleteDataLabelingJob"
	JobService_CancelDataLabelingJob_FullMethodName                         = "/google.cloud.aiplatform.v1beta1.JobService/CancelDataLabelingJob"
	JobService_CreateHyperparameterTuningJob_FullMethodName                 = "/google.cloud.aiplatform.v1beta1.JobService/CreateHyperparameterTuningJob"
	JobService_GetHyperparameterTuningJob_FullMethodName                    = "/google.cloud.aiplatform.v1beta1.JobService/GetHyperparameterTuningJob"
	JobService_ListHyperparameterTuningJobs_FullMethodName                  = "/google.cloud.aiplatform.v1beta1.JobService/ListHyperparameterTuningJobs"
	JobService_DeleteHyperparameterTuningJob_FullMethodName                 = "/google.cloud.aiplatform.v1beta1.JobService/DeleteHyperparameterTuningJob"
	JobService_CancelHyperparameterTuningJob_FullMethodName                 = "/google.cloud.aiplatform.v1beta1.JobService/CancelHyperparameterTuningJob"
	JobService_CreateNasJob_FullMethodName                                  = "/google.cloud.aiplatform.v1beta1.JobService/CreateNasJob"
	JobService_GetNasJob_FullMethodName                                     = "/google.cloud.aiplatform.v1beta1.JobService/GetNasJob"
	JobService_ListNasJobs_FullMethodName                                   = "/google.cloud.aiplatform.v1beta1.JobService/ListNasJobs"
	JobService_DeleteNasJob_FullMethodName                                  = "/google.cloud.aiplatform.v1beta1.JobService/DeleteNasJob"
	JobService_CancelNasJob_FullMethodName                                  = "/google.cloud.aiplatform.v1beta1.JobService/CancelNasJob"
	JobService_GetNasTrialDetail_FullMethodName                             = "/google.cloud.aiplatform.v1beta1.JobService/GetNasTrialDetail"
	JobService_ListNasTrialDetails_FullMethodName                           = "/google.cloud.aiplatform.v1beta1.JobService/ListNasTrialDetails"
	JobService_CreateBatchPredictionJob_FullMethodName                      = "/google.cloud.aiplatform.v1beta1.JobService/CreateBatchPredictionJob"
	JobService_GetBatchPredictionJob_FullMethodName                         = "/google.cloud.aiplatform.v1beta1.JobService/GetBatchPredictionJob"
	JobService_ListBatchPredictionJobs_FullMethodName                       = "/google.cloud.aiplatform.v1beta1.JobService/ListBatchPredictionJobs"
	JobService_DeleteBatchPredictionJob_FullMethodName                      = "/google.cloud.aiplatform.v1beta1.JobService/DeleteBatchPredictionJob"
	JobService_CancelBatchPredictionJob_FullMethodName                      = "/google.cloud.aiplatform.v1beta1.JobService/CancelBatchPredictionJob"
	JobService_CreateModelDeploymentMonitoringJob_FullMethodName            = "/google.cloud.aiplatform.v1beta1.JobService/CreateModelDeploymentMonitoringJob"
	JobService_SearchModelDeploymentMonitoringStatsAnomalies_FullMethodName = "/google.cloud.aiplatform.v1beta1.JobService/SearchModelDeploymentMonitoringStatsAnomalies"
	JobService_GetModelDeploymentMonitoringJob_FullMethodName               = "/google.cloud.aiplatform.v1beta1.JobService/GetModelDeploymentMonitoringJob"
	JobService_ListModelDeploymentMonitoringJobs_FullMethodName             = "/google.cloud.aiplatform.v1beta1.JobService/ListModelDeploymentMonitoringJobs"
	JobService_UpdateModelDeploymentMonitoringJob_FullMethodName            = "/google.cloud.aiplatform.v1beta1.JobService/UpdateModelDeploymentMonitoringJob"
	JobService_DeleteModelDeploymentMonitoringJob_FullMethodName            = "/google.cloud.aiplatform.v1beta1.JobService/DeleteModelDeploymentMonitoringJob"
	JobService_PauseModelDeploymentMonitoringJob_FullMethodName             = "/google.cloud.aiplatform.v1beta1.JobService/PauseModelDeploymentMonitoringJob"
	JobService_ResumeModelDeploymentMonitoringJob_FullMethodName            = "/google.cloud.aiplatform.v1beta1.JobService/ResumeModelDeploymentMonitoringJob"
)

// JobServiceClient is the client API for JobService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type JobServiceClient interface {
	// Creates a CustomJob. A created CustomJob right away
	// will be attempted to be run.
	CreateCustomJob(ctx context.Context, in *CreateCustomJobRequest, opts ...grpc.CallOption) (*CustomJob, error)
	// Gets a CustomJob.
	GetCustomJob(ctx context.Context, in *GetCustomJobRequest, opts ...grpc.CallOption) (*CustomJob, error)
	// Lists CustomJobs in a Location.
	ListCustomJobs(ctx context.Context, in *ListCustomJobsRequest, opts ...grpc.CallOption) (*ListCustomJobsResponse, error)
	// Deletes a CustomJob.
	DeleteCustomJob(ctx context.Context, in *DeleteCustomJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Cancels a CustomJob.
	// Starts asynchronous cancellation on the CustomJob. The server
	// makes a best effort to cancel the job, but success is not
	// guaranteed. Clients can use
	// [JobService.GetCustomJob][google.cloud.aiplatform.v1beta1.JobService.GetCustomJob]
	// or other methods to check whether the cancellation succeeded or whether the
	// job completed despite cancellation. On successful cancellation,
	// the CustomJob is not deleted; instead it becomes a job with
	// a [CustomJob.error][google.cloud.aiplatform.v1beta1.CustomJob.error] value
	// with a [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding
	// to `Code.CANCELLED`, and
	// [CustomJob.state][google.cloud.aiplatform.v1beta1.CustomJob.state] is set
	// to `CANCELLED`.
	CancelCustomJob(ctx context.Context, in *CancelCustomJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a DataLabelingJob.
	CreateDataLabelingJob(ctx context.Context, in *CreateDataLabelingJobRequest, opts ...grpc.CallOption) (*DataLabelingJob, error)
	// Gets a DataLabelingJob.
	GetDataLabelingJob(ctx context.Context, in *GetDataLabelingJobRequest, opts ...grpc.CallOption) (*DataLabelingJob, error)
	// Lists DataLabelingJobs in a Location.
	ListDataLabelingJobs(ctx context.Context, in *ListDataLabelingJobsRequest, opts ...grpc.CallOption) (*ListDataLabelingJobsResponse, error)
	// Deletes a DataLabelingJob.
	DeleteDataLabelingJob(ctx context.Context, in *DeleteDataLabelingJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Cancels a DataLabelingJob. Success of cancellation is not guaranteed.
	CancelDataLabelingJob(ctx context.Context, in *CancelDataLabelingJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a HyperparameterTuningJob
	CreateHyperparameterTuningJob(ctx context.Context, in *CreateHyperparameterTuningJobRequest, opts ...grpc.CallOption) (*HyperparameterTuningJob, error)
	// Gets a HyperparameterTuningJob
	GetHyperparameterTuningJob(ctx context.Context, in *GetHyperparameterTuningJobRequest, opts ...grpc.CallOption) (*HyperparameterTuningJob, error)
	// Lists HyperparameterTuningJobs in a Location.
	ListHyperparameterTuningJobs(ctx context.Context, in *ListHyperparameterTuningJobsRequest, opts ...grpc.CallOption) (*ListHyperparameterTuningJobsResponse, error)
	// Deletes a HyperparameterTuningJob.
	DeleteHyperparameterTuningJob(ctx context.Context, in *DeleteHyperparameterTuningJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Cancels a HyperparameterTuningJob.
	// Starts asynchronous cancellation on the HyperparameterTuningJob. The server
	// makes a best effort to cancel the job, but success is not
	// guaranteed. Clients can use
	// [JobService.GetHyperparameterTuningJob][google.cloud.aiplatform.v1beta1.JobService.GetHyperparameterTuningJob]
	// or other methods to check whether the cancellation succeeded or whether the
	// job completed despite cancellation. On successful cancellation,
	// the HyperparameterTuningJob is not deleted; instead it becomes a job with
	// a
	// [HyperparameterTuningJob.error][google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.error]
	// value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`, and
	// [HyperparameterTuningJob.state][google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.state]
	// is set to `CANCELLED`.
	CancelHyperparameterTuningJob(ctx context.Context, in *CancelHyperparameterTuningJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a NasJob
	CreateNasJob(ctx context.Context, in *CreateNasJobRequest, opts ...grpc.CallOption) (*NasJob, error)
	// Gets a NasJob
	GetNasJob(ctx context.Context, in *GetNasJobRequest, opts ...grpc.CallOption) (*NasJob, error)
	// Lists NasJobs in a Location.
	ListNasJobs(ctx context.Context, in *ListNasJobsRequest, opts ...grpc.CallOption) (*ListNasJobsResponse, error)
	// Deletes a NasJob.
	DeleteNasJob(ctx context.Context, in *DeleteNasJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Cancels a NasJob.
	// Starts asynchronous cancellation on the NasJob. The server
	// makes a best effort to cancel the job, but success is not
	// guaranteed. Clients can use
	// [JobService.GetNasJob][google.cloud.aiplatform.v1beta1.JobService.GetNasJob]
	// or other methods to check whether the cancellation succeeded or whether the
	// job completed despite cancellation. On successful cancellation,
	// the NasJob is not deleted; instead it becomes a job with
	// a [NasJob.error][google.cloud.aiplatform.v1beta1.NasJob.error] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`, and
	// [NasJob.state][google.cloud.aiplatform.v1beta1.NasJob.state] is set to
	// `CANCELLED`.
	CancelNasJob(ctx context.Context, in *CancelNasJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets a NasTrialDetail.
	GetNasTrialDetail(ctx context.Context, in *GetNasTrialDetailRequest, opts ...grpc.CallOption) (*NasTrialDetail, error)
	// List top NasTrialDetails of a NasJob.
	ListNasTrialDetails(ctx context.Context, in *ListNasTrialDetailsRequest, opts ...grpc.CallOption) (*ListNasTrialDetailsResponse, error)
	// Creates a BatchPredictionJob. A BatchPredictionJob once created will
	// right away be attempted to start.
	CreateBatchPredictionJob(ctx context.Context, in *CreateBatchPredictionJobRequest, opts ...grpc.CallOption) (*BatchPredictionJob, error)
	// Gets a BatchPredictionJob
	GetBatchPredictionJob(ctx context.Context, in *GetBatchPredictionJobRequest, opts ...grpc.CallOption) (*BatchPredictionJob, error)
	// Lists BatchPredictionJobs in a Location.
	ListBatchPredictionJobs(ctx context.Context, in *ListBatchPredictionJobsRequest, opts ...grpc.CallOption) (*ListBatchPredictionJobsResponse, error)
	// Deletes a BatchPredictionJob. Can only be called on jobs that already
	// finished.
	DeleteBatchPredictionJob(ctx context.Context, in *DeleteBatchPredictionJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Cancels a BatchPredictionJob.
	//
	// Starts asynchronous cancellation on the BatchPredictionJob. The server
	// makes the best effort to cancel the job, but success is not
	// guaranteed. Clients can use
	// [JobService.GetBatchPredictionJob][google.cloud.aiplatform.v1beta1.JobService.GetBatchPredictionJob]
	// or other methods to check whether the cancellation succeeded or whether the
	// job completed despite cancellation. On a successful cancellation,
	// the BatchPredictionJob is not deleted;instead its
	// [BatchPredictionJob.state][google.cloud.aiplatform.v1beta1.BatchPredictionJob.state]
	// is set to `CANCELLED`. Any files already outputted by the job are not
	// deleted.
	CancelBatchPredictionJob(ctx context.Context, in *CancelBatchPredictionJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a ModelDeploymentMonitoringJob. It will run periodically on a
	// configured interval.
	CreateModelDeploymentMonitoringJob(ctx context.Context, in *CreateModelDeploymentMonitoringJobRequest, opts ...grpc.CallOption) (*ModelDeploymentMonitoringJob, error)
	// Searches Model Monitoring Statistics generated within a given time window.
	SearchModelDeploymentMonitoringStatsAnomalies(ctx context.Context, in *SearchModelDeploymentMonitoringStatsAnomaliesRequest, opts ...grpc.CallOption) (*SearchModelDeploymentMonitoringStatsAnomaliesResponse, error)
	// Gets a ModelDeploymentMonitoringJob.
	GetModelDeploymentMonitoringJob(ctx context.Context, in *GetModelDeploymentMonitoringJobRequest, opts ...grpc.CallOption) (*ModelDeploymentMonitoringJob, error)
	// Lists ModelDeploymentMonitoringJobs in a Location.
	ListModelDeploymentMonitoringJobs(ctx context.Context, in *ListModelDeploymentMonitoringJobsRequest, opts ...grpc.CallOption) (*ListModelDeploymentMonitoringJobsResponse, error)
	// Updates a ModelDeploymentMonitoringJob.
	UpdateModelDeploymentMonitoringJob(ctx context.Context, in *UpdateModelDeploymentMonitoringJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a ModelDeploymentMonitoringJob.
	DeleteModelDeploymentMonitoringJob(ctx context.Context, in *DeleteModelDeploymentMonitoringJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Pauses a ModelDeploymentMonitoringJob. If the job is running, the server
	// makes a best effort to cancel the job. Will mark
	// [ModelDeploymentMonitoringJob.state][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.state]
	// to 'PAUSED'.
	PauseModelDeploymentMonitoringJob(ctx context.Context, in *PauseModelDeploymentMonitoringJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Resumes a paused ModelDeploymentMonitoringJob. It will start to run from
	// next scheduled time. A deleted ModelDeploymentMonitoringJob can't be
	// resumed.
	ResumeModelDeploymentMonitoringJob(ctx context.Context, in *ResumeModelDeploymentMonitoringJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type jobServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewJobServiceClient(cc grpc.ClientConnInterface) JobServiceClient {
	return &jobServiceClient{cc}
}

func (c *jobServiceClient) CreateCustomJob(ctx context.Context, in *CreateCustomJobRequest, opts ...grpc.CallOption) (*CustomJob, error) {
	out := new(CustomJob)
	err := c.cc.Invoke(ctx, JobService_CreateCustomJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetCustomJob(ctx context.Context, in *GetCustomJobRequest, opts ...grpc.CallOption) (*CustomJob, error) {
	out := new(CustomJob)
	err := c.cc.Invoke(ctx, JobService_GetCustomJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) ListCustomJobs(ctx context.Context, in *ListCustomJobsRequest, opts ...grpc.CallOption) (*ListCustomJobsResponse, error) {
	out := new(ListCustomJobsResponse)
	err := c.cc.Invoke(ctx, JobService_ListCustomJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) DeleteCustomJob(ctx context.Context, in *DeleteCustomJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, JobService_DeleteCustomJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) CancelCustomJob(ctx context.Context, in *CancelCustomJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, JobService_CancelCustomJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) CreateDataLabelingJob(ctx context.Context, in *CreateDataLabelingJobRequest, opts ...grpc.CallOption) (*DataLabelingJob, error) {
	out := new(DataLabelingJob)
	err := c.cc.Invoke(ctx, JobService_CreateDataLabelingJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetDataLabelingJob(ctx context.Context, in *GetDataLabelingJobRequest, opts ...grpc.CallOption) (*DataLabelingJob, error) {
	out := new(DataLabelingJob)
	err := c.cc.Invoke(ctx, JobService_GetDataLabelingJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) ListDataLabelingJobs(ctx context.Context, in *ListDataLabelingJobsRequest, opts ...grpc.CallOption) (*ListDataLabelingJobsResponse, error) {
	out := new(ListDataLabelingJobsResponse)
	err := c.cc.Invoke(ctx, JobService_ListDataLabelingJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) DeleteDataLabelingJob(ctx context.Context, in *DeleteDataLabelingJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, JobService_DeleteDataLabelingJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) CancelDataLabelingJob(ctx context.Context, in *CancelDataLabelingJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, JobService_CancelDataLabelingJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) CreateHyperparameterTuningJob(ctx context.Context, in *CreateHyperparameterTuningJobRequest, opts ...grpc.CallOption) (*HyperparameterTuningJob, error) {
	out := new(HyperparameterTuningJob)
	err := c.cc.Invoke(ctx, JobService_CreateHyperparameterTuningJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetHyperparameterTuningJob(ctx context.Context, in *GetHyperparameterTuningJobRequest, opts ...grpc.CallOption) (*HyperparameterTuningJob, error) {
	out := new(HyperparameterTuningJob)
	err := c.cc.Invoke(ctx, JobService_GetHyperparameterTuningJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) ListHyperparameterTuningJobs(ctx context.Context, in *ListHyperparameterTuningJobsRequest, opts ...grpc.CallOption) (*ListHyperparameterTuningJobsResponse, error) {
	out := new(ListHyperparameterTuningJobsResponse)
	err := c.cc.Invoke(ctx, JobService_ListHyperparameterTuningJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) DeleteHyperparameterTuningJob(ctx context.Context, in *DeleteHyperparameterTuningJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, JobService_DeleteHyperparameterTuningJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) CancelHyperparameterTuningJob(ctx context.Context, in *CancelHyperparameterTuningJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, JobService_CancelHyperparameterTuningJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) CreateNasJob(ctx context.Context, in *CreateNasJobRequest, opts ...grpc.CallOption) (*NasJob, error) {
	out := new(NasJob)
	err := c.cc.Invoke(ctx, JobService_CreateNasJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetNasJob(ctx context.Context, in *GetNasJobRequest, opts ...grpc.CallOption) (*NasJob, error) {
	out := new(NasJob)
	err := c.cc.Invoke(ctx, JobService_GetNasJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) ListNasJobs(ctx context.Context, in *ListNasJobsRequest, opts ...grpc.CallOption) (*ListNasJobsResponse, error) {
	out := new(ListNasJobsResponse)
	err := c.cc.Invoke(ctx, JobService_ListNasJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) DeleteNasJob(ctx context.Context, in *DeleteNasJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, JobService_DeleteNasJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) CancelNasJob(ctx context.Context, in *CancelNasJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, JobService_CancelNasJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetNasTrialDetail(ctx context.Context, in *GetNasTrialDetailRequest, opts ...grpc.CallOption) (*NasTrialDetail, error) {
	out := new(NasTrialDetail)
	err := c.cc.Invoke(ctx, JobService_GetNasTrialDetail_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) ListNasTrialDetails(ctx context.Context, in *ListNasTrialDetailsRequest, opts ...grpc.CallOption) (*ListNasTrialDetailsResponse, error) {
	out := new(ListNasTrialDetailsResponse)
	err := c.cc.Invoke(ctx, JobService_ListNasTrialDetails_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) CreateBatchPredictionJob(ctx context.Context, in *CreateBatchPredictionJobRequest, opts ...grpc.CallOption) (*BatchPredictionJob, error) {
	out := new(BatchPredictionJob)
	err := c.cc.Invoke(ctx, JobService_CreateBatchPredictionJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetBatchPredictionJob(ctx context.Context, in *GetBatchPredictionJobRequest, opts ...grpc.CallOption) (*BatchPredictionJob, error) {
	out := new(BatchPredictionJob)
	err := c.cc.Invoke(ctx, JobService_GetBatchPredictionJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) ListBatchPredictionJobs(ctx context.Context, in *ListBatchPredictionJobsRequest, opts ...grpc.CallOption) (*ListBatchPredictionJobsResponse, error) {
	out := new(ListBatchPredictionJobsResponse)
	err := c.cc.Invoke(ctx, JobService_ListBatchPredictionJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) DeleteBatchPredictionJob(ctx context.Context, in *DeleteBatchPredictionJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, JobService_DeleteBatchPredictionJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) CancelBatchPredictionJob(ctx context.Context, in *CancelBatchPredictionJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, JobService_CancelBatchPredictionJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) CreateModelDeploymentMonitoringJob(ctx context.Context, in *CreateModelDeploymentMonitoringJobRequest, opts ...grpc.CallOption) (*ModelDeploymentMonitoringJob, error) {
	out := new(ModelDeploymentMonitoringJob)
	err := c.cc.Invoke(ctx, JobService_CreateModelDeploymentMonitoringJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) SearchModelDeploymentMonitoringStatsAnomalies(ctx context.Context, in *SearchModelDeploymentMonitoringStatsAnomaliesRequest, opts ...grpc.CallOption) (*SearchModelDeploymentMonitoringStatsAnomaliesResponse, error) {
	out := new(SearchModelDeploymentMonitoringStatsAnomaliesResponse)
	err := c.cc.Invoke(ctx, JobService_SearchModelDeploymentMonitoringStatsAnomalies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetModelDeploymentMonitoringJob(ctx context.Context, in *GetModelDeploymentMonitoringJobRequest, opts ...grpc.CallOption) (*ModelDeploymentMonitoringJob, error) {
	out := new(ModelDeploymentMonitoringJob)
	err := c.cc.Invoke(ctx, JobService_GetModelDeploymentMonitoringJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) ListModelDeploymentMonitoringJobs(ctx context.Context, in *ListModelDeploymentMonitoringJobsRequest, opts ...grpc.CallOption) (*ListModelDeploymentMonitoringJobsResponse, error) {
	out := new(ListModelDeploymentMonitoringJobsResponse)
	err := c.cc.Invoke(ctx, JobService_ListModelDeploymentMonitoringJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) UpdateModelDeploymentMonitoringJob(ctx context.Context, in *UpdateModelDeploymentMonitoringJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, JobService_UpdateModelDeploymentMonitoringJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) DeleteModelDeploymentMonitoringJob(ctx context.Context, in *DeleteModelDeploymentMonitoringJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, JobService_DeleteModelDeploymentMonitoringJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) PauseModelDeploymentMonitoringJob(ctx context.Context, in *PauseModelDeploymentMonitoringJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, JobService_PauseModelDeploymentMonitoringJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) ResumeModelDeploymentMonitoringJob(ctx context.Context, in *ResumeModelDeploymentMonitoringJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, JobService_ResumeModelDeploymentMonitoringJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// JobServiceServer is the server API for JobService service.
// All implementations should embed UnimplementedJobServiceServer
// for forward compatibility
type JobServiceServer interface {
	// Creates a CustomJob. A created CustomJob right away
	// will be attempted to be run.
	CreateCustomJob(context.Context, *CreateCustomJobRequest) (*CustomJob, error)
	// Gets a CustomJob.
	GetCustomJob(context.Context, *GetCustomJobRequest) (*CustomJob, error)
	// Lists CustomJobs in a Location.
	ListCustomJobs(context.Context, *ListCustomJobsRequest) (*ListCustomJobsResponse, error)
	// Deletes a CustomJob.
	DeleteCustomJob(context.Context, *DeleteCustomJobRequest) (*longrunningpb.Operation, error)
	// Cancels a CustomJob.
	// Starts asynchronous cancellation on the CustomJob. The server
	// makes a best effort to cancel the job, but success is not
	// guaranteed. Clients can use
	// [JobService.GetCustomJob][google.cloud.aiplatform.v1beta1.JobService.GetCustomJob]
	// or other methods to check whether the cancellation succeeded or whether the
	// job completed despite cancellation. On successful cancellation,
	// the CustomJob is not deleted; instead it becomes a job with
	// a [CustomJob.error][google.cloud.aiplatform.v1beta1.CustomJob.error] value
	// with a [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding
	// to `Code.CANCELLED`, and
	// [CustomJob.state][google.cloud.aiplatform.v1beta1.CustomJob.state] is set
	// to `CANCELLED`.
	CancelCustomJob(context.Context, *CancelCustomJobRequest) (*emptypb.Empty, error)
	// Creates a DataLabelingJob.
	CreateDataLabelingJob(context.Context, *CreateDataLabelingJobRequest) (*DataLabelingJob, error)
	// Gets a DataLabelingJob.
	GetDataLabelingJob(context.Context, *GetDataLabelingJobRequest) (*DataLabelingJob, error)
	// Lists DataLabelingJobs in a Location.
	ListDataLabelingJobs(context.Context, *ListDataLabelingJobsRequest) (*ListDataLabelingJobsResponse, error)
	// Deletes a DataLabelingJob.
	DeleteDataLabelingJob(context.Context, *DeleteDataLabelingJobRequest) (*longrunningpb.Operation, error)
	// Cancels a DataLabelingJob. Success of cancellation is not guaranteed.
	CancelDataLabelingJob(context.Context, *CancelDataLabelingJobRequest) (*emptypb.Empty, error)
	// Creates a HyperparameterTuningJob
	CreateHyperparameterTuningJob(context.Context, *CreateHyperparameterTuningJobRequest) (*HyperparameterTuningJob, error)
	// Gets a HyperparameterTuningJob
	GetHyperparameterTuningJob(context.Context, *GetHyperparameterTuningJobRequest) (*HyperparameterTuningJob, error)
	// Lists HyperparameterTuningJobs in a Location.
	ListHyperparameterTuningJobs(context.Context, *ListHyperparameterTuningJobsRequest) (*ListHyperparameterTuningJobsResponse, error)
	// Deletes a HyperparameterTuningJob.
	DeleteHyperparameterTuningJob(context.Context, *DeleteHyperparameterTuningJobRequest) (*longrunningpb.Operation, error)
	// Cancels a HyperparameterTuningJob.
	// Starts asynchronous cancellation on the HyperparameterTuningJob. The server
	// makes a best effort to cancel the job, but success is not
	// guaranteed. Clients can use
	// [JobService.GetHyperparameterTuningJob][google.cloud.aiplatform.v1beta1.JobService.GetHyperparameterTuningJob]
	// or other methods to check whether the cancellation succeeded or whether the
	// job completed despite cancellation. On successful cancellation,
	// the HyperparameterTuningJob is not deleted; instead it becomes a job with
	// a
	// [HyperparameterTuningJob.error][google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.error]
	// value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`, and
	// [HyperparameterTuningJob.state][google.cloud.aiplatform.v1beta1.HyperparameterTuningJob.state]
	// is set to `CANCELLED`.
	CancelHyperparameterTuningJob(context.Context, *CancelHyperparameterTuningJobRequest) (*emptypb.Empty, error)
	// Creates a NasJob
	CreateNasJob(context.Context, *CreateNasJobRequest) (*NasJob, error)
	// Gets a NasJob
	GetNasJob(context.Context, *GetNasJobRequest) (*NasJob, error)
	// Lists NasJobs in a Location.
	ListNasJobs(context.Context, *ListNasJobsRequest) (*ListNasJobsResponse, error)
	// Deletes a NasJob.
	DeleteNasJob(context.Context, *DeleteNasJobRequest) (*longrunningpb.Operation, error)
	// Cancels a NasJob.
	// Starts asynchronous cancellation on the NasJob. The server
	// makes a best effort to cancel the job, but success is not
	// guaranteed. Clients can use
	// [JobService.GetNasJob][google.cloud.aiplatform.v1beta1.JobService.GetNasJob]
	// or other methods to check whether the cancellation succeeded or whether the
	// job completed despite cancellation. On successful cancellation,
	// the NasJob is not deleted; instead it becomes a job with
	// a [NasJob.error][google.cloud.aiplatform.v1beta1.NasJob.error] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`, and
	// [NasJob.state][google.cloud.aiplatform.v1beta1.NasJob.state] is set to
	// `CANCELLED`.
	CancelNasJob(context.Context, *CancelNasJobRequest) (*emptypb.Empty, error)
	// Gets a NasTrialDetail.
	GetNasTrialDetail(context.Context, *GetNasTrialDetailRequest) (*NasTrialDetail, error)
	// List top NasTrialDetails of a NasJob.
	ListNasTrialDetails(context.Context, *ListNasTrialDetailsRequest) (*ListNasTrialDetailsResponse, error)
	// Creates a BatchPredictionJob. A BatchPredictionJob once created will
	// right away be attempted to start.
	CreateBatchPredictionJob(context.Context, *CreateBatchPredictionJobRequest) (*BatchPredictionJob, error)
	// Gets a BatchPredictionJob
	GetBatchPredictionJob(context.Context, *GetBatchPredictionJobRequest) (*BatchPredictionJob, error)
	// Lists BatchPredictionJobs in a Location.
	ListBatchPredictionJobs(context.Context, *ListBatchPredictionJobsRequest) (*ListBatchPredictionJobsResponse, error)
	// Deletes a BatchPredictionJob. Can only be called on jobs that already
	// finished.
	DeleteBatchPredictionJob(context.Context, *DeleteBatchPredictionJobRequest) (*longrunningpb.Operation, error)
	// Cancels a BatchPredictionJob.
	//
	// Starts asynchronous cancellation on the BatchPredictionJob. The server
	// makes the best effort to cancel the job, but success is not
	// guaranteed. Clients can use
	// [JobService.GetBatchPredictionJob][google.cloud.aiplatform.v1beta1.JobService.GetBatchPredictionJob]
	// or other methods to check whether the cancellation succeeded or whether the
	// job completed despite cancellation. On a successful cancellation,
	// the BatchPredictionJob is not deleted;instead its
	// [BatchPredictionJob.state][google.cloud.aiplatform.v1beta1.BatchPredictionJob.state]
	// is set to `CANCELLED`. Any files already outputted by the job are not
	// deleted.
	CancelBatchPredictionJob(context.Context, *CancelBatchPredictionJobRequest) (*emptypb.Empty, error)
	// Creates a ModelDeploymentMonitoringJob. It will run periodically on a
	// configured interval.
	CreateModelDeploymentMonitoringJob(context.Context, *CreateModelDeploymentMonitoringJobRequest) (*ModelDeploymentMonitoringJob, error)
	// Searches Model Monitoring Statistics generated within a given time window.
	SearchModelDeploymentMonitoringStatsAnomalies(context.Context, *SearchModelDeploymentMonitoringStatsAnomaliesRequest) (*SearchModelDeploymentMonitoringStatsAnomaliesResponse, error)
	// Gets a ModelDeploymentMonitoringJob.
	GetModelDeploymentMonitoringJob(context.Context, *GetModelDeploymentMonitoringJobRequest) (*ModelDeploymentMonitoringJob, error)
	// Lists ModelDeploymentMonitoringJobs in a Location.
	ListModelDeploymentMonitoringJobs(context.Context, *ListModelDeploymentMonitoringJobsRequest) (*ListModelDeploymentMonitoringJobsResponse, error)
	// Updates a ModelDeploymentMonitoringJob.
	UpdateModelDeploymentMonitoringJob(context.Context, *UpdateModelDeploymentMonitoringJobRequest) (*longrunningpb.Operation, error)
	// Deletes a ModelDeploymentMonitoringJob.
	DeleteModelDeploymentMonitoringJob(context.Context, *DeleteModelDeploymentMonitoringJobRequest) (*longrunningpb.Operation, error)
	// Pauses a ModelDeploymentMonitoringJob. If the job is running, the server
	// makes a best effort to cancel the job. Will mark
	// [ModelDeploymentMonitoringJob.state][google.cloud.aiplatform.v1beta1.ModelDeploymentMonitoringJob.state]
	// to 'PAUSED'.
	PauseModelDeploymentMonitoringJob(context.Context, *PauseModelDeploymentMonitoringJobRequest) (*emptypb.Empty, error)
	// Resumes a paused ModelDeploymentMonitoringJob. It will start to run from
	// next scheduled time. A deleted ModelDeploymentMonitoringJob can't be
	// resumed.
	ResumeModelDeploymentMonitoringJob(context.Context, *ResumeModelDeploymentMonitoringJobRequest) (*emptypb.Empty, error)
}

// UnimplementedJobServiceServer should be embedded to have forward compatible implementations.
type UnimplementedJobServiceServer struct {
}

func (UnimplementedJobServiceServer) CreateCustomJob(context.Context, *CreateCustomJobRequest) (*CustomJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomJob not implemented")
}
func (UnimplementedJobServiceServer) GetCustomJob(context.Context, *GetCustomJobRequest) (*CustomJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomJob not implemented")
}
func (UnimplementedJobServiceServer) ListCustomJobs(context.Context, *ListCustomJobsRequest) (*ListCustomJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomJobs not implemented")
}
func (UnimplementedJobServiceServer) DeleteCustomJob(context.Context, *DeleteCustomJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCustomJob not implemented")
}
func (UnimplementedJobServiceServer) CancelCustomJob(context.Context, *CancelCustomJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelCustomJob not implemented")
}
func (UnimplementedJobServiceServer) CreateDataLabelingJob(context.Context, *CreateDataLabelingJobRequest) (*DataLabelingJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataLabelingJob not implemented")
}
func (UnimplementedJobServiceServer) GetDataLabelingJob(context.Context, *GetDataLabelingJobRequest) (*DataLabelingJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataLabelingJob not implemented")
}
func (UnimplementedJobServiceServer) ListDataLabelingJobs(context.Context, *ListDataLabelingJobsRequest) (*ListDataLabelingJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDataLabelingJobs not implemented")
}
func (UnimplementedJobServiceServer) DeleteDataLabelingJob(context.Context, *DeleteDataLabelingJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataLabelingJob not implemented")
}
func (UnimplementedJobServiceServer) CancelDataLabelingJob(context.Context, *CancelDataLabelingJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelDataLabelingJob not implemented")
}
func (UnimplementedJobServiceServer) CreateHyperparameterTuningJob(context.Context, *CreateHyperparameterTuningJobRequest) (*HyperparameterTuningJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateHyperparameterTuningJob not implemented")
}
func (UnimplementedJobServiceServer) GetHyperparameterTuningJob(context.Context, *GetHyperparameterTuningJobRequest) (*HyperparameterTuningJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHyperparameterTuningJob not implemented")
}
func (UnimplementedJobServiceServer) ListHyperparameterTuningJobs(context.Context, *ListHyperparameterTuningJobsRequest) (*ListHyperparameterTuningJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHyperparameterTuningJobs not implemented")
}
func (UnimplementedJobServiceServer) DeleteHyperparameterTuningJob(context.Context, *DeleteHyperparameterTuningJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteHyperparameterTuningJob not implemented")
}
func (UnimplementedJobServiceServer) CancelHyperparameterTuningJob(context.Context, *CancelHyperparameterTuningJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelHyperparameterTuningJob not implemented")
}
func (UnimplementedJobServiceServer) CreateNasJob(context.Context, *CreateNasJobRequest) (*NasJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNasJob not implemented")
}
func (UnimplementedJobServiceServer) GetNasJob(context.Context, *GetNasJobRequest) (*NasJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNasJob not implemented")
}
func (UnimplementedJobServiceServer) ListNasJobs(context.Context, *ListNasJobsRequest) (*ListNasJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNasJobs not implemented")
}
func (UnimplementedJobServiceServer) DeleteNasJob(context.Context, *DeleteNasJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNasJob not implemented")
}
func (UnimplementedJobServiceServer) CancelNasJob(context.Context, *CancelNasJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelNasJob not implemented")
}
func (UnimplementedJobServiceServer) GetNasTrialDetail(context.Context, *GetNasTrialDetailRequest) (*NasTrialDetail, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNasTrialDetail not implemented")
}
func (UnimplementedJobServiceServer) ListNasTrialDetails(context.Context, *ListNasTrialDetailsRequest) (*ListNasTrialDetailsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNasTrialDetails not implemented")
}
func (UnimplementedJobServiceServer) CreateBatchPredictionJob(context.Context, *CreateBatchPredictionJobRequest) (*BatchPredictionJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBatchPredictionJob not implemented")
}
func (UnimplementedJobServiceServer) GetBatchPredictionJob(context.Context, *GetBatchPredictionJobRequest) (*BatchPredictionJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBatchPredictionJob not implemented")
}
func (UnimplementedJobServiceServer) ListBatchPredictionJobs(context.Context, *ListBatchPredictionJobsRequest) (*ListBatchPredictionJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBatchPredictionJobs not implemented")
}
func (UnimplementedJobServiceServer) DeleteBatchPredictionJob(context.Context, *DeleteBatchPredictionJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBatchPredictionJob not implemented")
}
func (UnimplementedJobServiceServer) CancelBatchPredictionJob(context.Context, *CancelBatchPredictionJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelBatchPredictionJob not implemented")
}
func (UnimplementedJobServiceServer) CreateModelDeploymentMonitoringJob(context.Context, *CreateModelDeploymentMonitoringJobRequest) (*ModelDeploymentMonitoringJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateModelDeploymentMonitoringJob not implemented")
}
func (UnimplementedJobServiceServer) SearchModelDeploymentMonitoringStatsAnomalies(context.Context, *SearchModelDeploymentMonitoringStatsAnomaliesRequest) (*SearchModelDeploymentMonitoringStatsAnomaliesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchModelDeploymentMonitoringStatsAnomalies not implemented")
}
func (UnimplementedJobServiceServer) GetModelDeploymentMonitoringJob(context.Context, *GetModelDeploymentMonitoringJobRequest) (*ModelDeploymentMonitoringJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModelDeploymentMonitoringJob not implemented")
}
func (UnimplementedJobServiceServer) ListModelDeploymentMonitoringJobs(context.Context, *ListModelDeploymentMonitoringJobsRequest) (*ListModelDeploymentMonitoringJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModelDeploymentMonitoringJobs not implemented")
}
func (UnimplementedJobServiceServer) UpdateModelDeploymentMonitoringJob(context.Context, *UpdateModelDeploymentMonitoringJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateModelDeploymentMonitoringJob not implemented")
}
func (UnimplementedJobServiceServer) DeleteModelDeploymentMonitoringJob(context.Context, *DeleteModelDeploymentMonitoringJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteModelDeploymentMonitoringJob not implemented")
}
func (UnimplementedJobServiceServer) PauseModelDeploymentMonitoringJob(context.Context, *PauseModelDeploymentMonitoringJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PauseModelDeploymentMonitoringJob not implemented")
}
func (UnimplementedJobServiceServer) ResumeModelDeploymentMonitoringJob(context.Context, *ResumeModelDeploymentMonitoringJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResumeModelDeploymentMonitoringJob not implemented")
}

// UnsafeJobServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to JobServiceServer will
// result in compilation errors.
type UnsafeJobServiceServer interface {
	mustEmbedUnimplementedJobServiceServer()
}

func RegisterJobServiceServer(s grpc.ServiceRegistrar, srv JobServiceServer) {
	s.RegisterService(&JobService_ServiceDesc, srv)
}

func _JobService_CreateCustomJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCustomJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).CreateCustomJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_CreateCustomJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).CreateCustomJob(ctx, req.(*CreateCustomJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetCustomJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetCustomJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_GetCustomJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetCustomJob(ctx, req.(*GetCustomJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_ListCustomJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCustomJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).ListCustomJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_ListCustomJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).ListCustomJobs(ctx, req.(*ListCustomJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_DeleteCustomJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCustomJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).DeleteCustomJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_DeleteCustomJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).DeleteCustomJob(ctx, req.(*DeleteCustomJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_CancelCustomJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelCustomJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).CancelCustomJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_CancelCustomJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).CancelCustomJob(ctx, req.(*CancelCustomJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_CreateDataLabelingJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDataLabelingJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).CreateDataLabelingJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_CreateDataLabelingJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).CreateDataLabelingJob(ctx, req.(*CreateDataLabelingJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetDataLabelingJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataLabelingJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetDataLabelingJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_GetDataLabelingJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetDataLabelingJob(ctx, req.(*GetDataLabelingJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_ListDataLabelingJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataLabelingJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).ListDataLabelingJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_ListDataLabelingJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).ListDataLabelingJobs(ctx, req.(*ListDataLabelingJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_DeleteDataLabelingJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDataLabelingJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).DeleteDataLabelingJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_DeleteDataLabelingJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).DeleteDataLabelingJob(ctx, req.(*DeleteDataLabelingJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_CancelDataLabelingJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelDataLabelingJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).CancelDataLabelingJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_CancelDataLabelingJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).CancelDataLabelingJob(ctx, req.(*CancelDataLabelingJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_CreateHyperparameterTuningJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateHyperparameterTuningJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).CreateHyperparameterTuningJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_CreateHyperparameterTuningJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).CreateHyperparameterTuningJob(ctx, req.(*CreateHyperparameterTuningJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetHyperparameterTuningJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetHyperparameterTuningJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetHyperparameterTuningJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_GetHyperparameterTuningJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetHyperparameterTuningJob(ctx, req.(*GetHyperparameterTuningJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_ListHyperparameterTuningJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListHyperparameterTuningJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).ListHyperparameterTuningJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_ListHyperparameterTuningJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).ListHyperparameterTuningJobs(ctx, req.(*ListHyperparameterTuningJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_DeleteHyperparameterTuningJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteHyperparameterTuningJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).DeleteHyperparameterTuningJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_DeleteHyperparameterTuningJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).DeleteHyperparameterTuningJob(ctx, req.(*DeleteHyperparameterTuningJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_CancelHyperparameterTuningJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelHyperparameterTuningJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).CancelHyperparameterTuningJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_CancelHyperparameterTuningJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).CancelHyperparameterTuningJob(ctx, req.(*CancelHyperparameterTuningJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_CreateNasJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNasJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).CreateNasJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_CreateNasJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).CreateNasJob(ctx, req.(*CreateNasJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetNasJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNasJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetNasJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_GetNasJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetNasJob(ctx, req.(*GetNasJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_ListNasJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNasJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).ListNasJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_ListNasJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).ListNasJobs(ctx, req.(*ListNasJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_DeleteNasJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNasJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).DeleteNasJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_DeleteNasJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).DeleteNasJob(ctx, req.(*DeleteNasJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_CancelNasJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelNasJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).CancelNasJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_CancelNasJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).CancelNasJob(ctx, req.(*CancelNasJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetNasTrialDetail_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNasTrialDetailRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetNasTrialDetail(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_GetNasTrialDetail_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetNasTrialDetail(ctx, req.(*GetNasTrialDetailRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_ListNasTrialDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNasTrialDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).ListNasTrialDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_ListNasTrialDetails_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).ListNasTrialDetails(ctx, req.(*ListNasTrialDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_CreateBatchPredictionJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBatchPredictionJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).CreateBatchPredictionJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_CreateBatchPredictionJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).CreateBatchPredictionJob(ctx, req.(*CreateBatchPredictionJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetBatchPredictionJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBatchPredictionJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetBatchPredictionJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_GetBatchPredictionJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetBatchPredictionJob(ctx, req.(*GetBatchPredictionJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_ListBatchPredictionJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBatchPredictionJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).ListBatchPredictionJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_ListBatchPredictionJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).ListBatchPredictionJobs(ctx, req.(*ListBatchPredictionJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_DeleteBatchPredictionJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBatchPredictionJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).DeleteBatchPredictionJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_DeleteBatchPredictionJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).DeleteBatchPredictionJob(ctx, req.(*DeleteBatchPredictionJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_CancelBatchPredictionJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelBatchPredictionJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).CancelBatchPredictionJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_CancelBatchPredictionJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).CancelBatchPredictionJob(ctx, req.(*CancelBatchPredictionJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_CreateModelDeploymentMonitoringJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateModelDeploymentMonitoringJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).CreateModelDeploymentMonitoringJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_CreateModelDeploymentMonitoringJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).CreateModelDeploymentMonitoringJob(ctx, req.(*CreateModelDeploymentMonitoringJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_SearchModelDeploymentMonitoringStatsAnomalies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchModelDeploymentMonitoringStatsAnomaliesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).SearchModelDeploymentMonitoringStatsAnomalies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_SearchModelDeploymentMonitoringStatsAnomalies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).SearchModelDeploymentMonitoringStatsAnomalies(ctx, req.(*SearchModelDeploymentMonitoringStatsAnomaliesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetModelDeploymentMonitoringJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelDeploymentMonitoringJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetModelDeploymentMonitoringJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_GetModelDeploymentMonitoringJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetModelDeploymentMonitoringJob(ctx, req.(*GetModelDeploymentMonitoringJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_ListModelDeploymentMonitoringJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelDeploymentMonitoringJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).ListModelDeploymentMonitoringJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_ListModelDeploymentMonitoringJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).ListModelDeploymentMonitoringJobs(ctx, req.(*ListModelDeploymentMonitoringJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_UpdateModelDeploymentMonitoringJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateModelDeploymentMonitoringJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).UpdateModelDeploymentMonitoringJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_UpdateModelDeploymentMonitoringJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).UpdateModelDeploymentMonitoringJob(ctx, req.(*UpdateModelDeploymentMonitoringJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_DeleteModelDeploymentMonitoringJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteModelDeploymentMonitoringJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).DeleteModelDeploymentMonitoringJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_DeleteModelDeploymentMonitoringJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).DeleteModelDeploymentMonitoringJob(ctx, req.(*DeleteModelDeploymentMonitoringJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_PauseModelDeploymentMonitoringJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PauseModelDeploymentMonitoringJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).PauseModelDeploymentMonitoringJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_PauseModelDeploymentMonitoringJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).PauseModelDeploymentMonitoringJob(ctx, req.(*PauseModelDeploymentMonitoringJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_ResumeModelDeploymentMonitoringJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeModelDeploymentMonitoringJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).ResumeModelDeploymentMonitoringJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: JobService_ResumeModelDeploymentMonitoringJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).ResumeModelDeploymentMonitoringJob(ctx, req.(*ResumeModelDeploymentMonitoringJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// JobService_ServiceDesc is the grpc.ServiceDesc for JobService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var JobService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.JobService",
	HandlerType: (*JobServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateCustomJob",
			Handler:    _JobService_CreateCustomJob_Handler,
		},
		{
			MethodName: "GetCustomJob",
			Handler:    _JobService_GetCustomJob_Handler,
		},
		{
			MethodName: "ListCustomJobs",
			Handler:    _JobService_ListCustomJobs_Handler,
		},
		{
			MethodName: "DeleteCustomJob",
			Handler:    _JobService_DeleteCustomJob_Handler,
		},
		{
			MethodName: "CancelCustomJob",
			Handler:    _JobService_CancelCustomJob_Handler,
		},
		{
			MethodName: "CreateDataLabelingJob",
			Handler:    _JobService_CreateDataLabelingJob_Handler,
		},
		{
			MethodName: "GetDataLabelingJob",
			Handler:    _JobService_GetDataLabelingJob_Handler,
		},
		{
			MethodName: "ListDataLabelingJobs",
			Handler:    _JobService_ListDataLabelingJobs_Handler,
		},
		{
			MethodName: "DeleteDataLabelingJob",
			Handler:    _JobService_DeleteDataLabelingJob_Handler,
		},
		{
			MethodName: "CancelDataLabelingJob",
			Handler:    _JobService_CancelDataLabelingJob_Handler,
		},
		{
			MethodName: "CreateHyperparameterTuningJob",
			Handler:    _JobService_CreateHyperparameterTuningJob_Handler,
		},
		{
			MethodName: "GetHyperparameterTuningJob",
			Handler:    _JobService_GetHyperparameterTuningJob_Handler,
		},
		{
			MethodName: "ListHyperparameterTuningJobs",
			Handler:    _JobService_ListHyperparameterTuningJobs_Handler,
		},
		{
			MethodName: "DeleteHyperparameterTuningJob",
			Handler:    _JobService_DeleteHyperparameterTuningJob_Handler,
		},
		{
			MethodName: "CancelHyperparameterTuningJob",
			Handler:    _JobService_CancelHyperparameterTuningJob_Handler,
		},
		{
			MethodName: "CreateNasJob",
			Handler:    _JobService_CreateNasJob_Handler,
		},
		{
			MethodName: "GetNasJob",
			Handler:    _JobService_GetNasJob_Handler,
		},
		{
			MethodName: "ListNasJobs",
			Handler:    _JobService_ListNasJobs_Handler,
		},
		{
			MethodName: "DeleteNasJob",
			Handler:    _JobService_DeleteNasJob_Handler,
		},
		{
			MethodName: "CancelNasJob",
			Handler:    _JobService_CancelNasJob_Handler,
		},
		{
			MethodName: "GetNasTrialDetail",
			Handler:    _JobService_GetNasTrialDetail_Handler,
		},
		{
			MethodName: "ListNasTrialDetails",
			Handler:    _JobService_ListNasTrialDetails_Handler,
		},
		{
			MethodName: "CreateBatchPredictionJob",
			Handler:    _JobService_CreateBatchPredictionJob_Handler,
		},
		{
			MethodName: "GetBatchPredictionJob",
			Handler:    _JobService_GetBatchPredictionJob_Handler,
		},
		{
			MethodName: "ListBatchPredictionJobs",
			Handler:    _JobService_ListBatchPredictionJobs_Handler,
		},
		{
			MethodName: "DeleteBatchPredictionJob",
			Handler:    _JobService_DeleteBatchPredictionJob_Handler,
		},
		{
			MethodName: "CancelBatchPredictionJob",
			Handler:    _JobService_CancelBatchPredictionJob_Handler,
		},
		{
			MethodName: "CreateModelDeploymentMonitoringJob",
			Handler:    _JobService_CreateModelDeploymentMonitoringJob_Handler,
		},
		{
			MethodName: "SearchModelDeploymentMonitoringStatsAnomalies",
			Handler:    _JobService_SearchModelDeploymentMonitoringStatsAnomalies_Handler,
		},
		{
			MethodName: "GetModelDeploymentMonitoringJob",
			Handler:    _JobService_GetModelDeploymentMonitoringJob_Handler,
		},
		{
			MethodName: "ListModelDeploymentMonitoringJobs",
			Handler:    _JobService_ListModelDeploymentMonitoringJobs_Handler,
		},
		{
			MethodName: "UpdateModelDeploymentMonitoringJob",
			Handler:    _JobService_UpdateModelDeploymentMonitoringJob_Handler,
		},
		{
			MethodName: "DeleteModelDeploymentMonitoringJob",
			Handler:    _JobService_DeleteModelDeploymentMonitoringJob_Handler,
		},
		{
			MethodName: "PauseModelDeploymentMonitoringJob",
			Handler:    _JobService_PauseModelDeploymentMonitoringJob_Handler,
		},
		{
			MethodName: "ResumeModelDeploymentMonitoringJob",
			Handler:    _JobService_ResumeModelDeploymentMonitoringJob_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/job_service.proto",
}
